---
generated_at: 2026-02-01 10:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：15-fetch_them_macos_headers

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：明示的な根拠なし（推定値）
  2. **なし**
  3. **なし**

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tools/fetch_them_macos_headers.zig` 行12-17（Arch列挙型）
- E-02: `tools/fetch_them_macos_headers.zig` 行19-27（OsVer列挙型）
- E-03: `tools/fetch_them_macos_headers.zig` 行29-51（Target構造体）
- E-04: `tools/fetch_them_macos_headers.zig` 行53（headers_source_prefix）
- E-05: `tools/fetch_them_macos_headers.zig` 行55-63（usage文字列）
- E-06: `tools/fetch_them_macos_headers.zig` 行65-112（main関数）
- E-07: `tools/fetch_them_macos_headers.zig` 行114-214（fetchTarget関数）
- E-08: `tools/fetch_them_macos_headers.zig` 行234-261（Version構造体）
- E-09: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行16

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | macOSヘッダーを取得し処理 | E-06, E-07, E-09 | ○ |
| C-02 | 複数のmacOSバージョンをサポート（Catalina〜Tahoe） | E-02 | ○ |
| C-03 | aarch64とx86_64アーキテクチャをサポート | E-01, E-06 | ○ |
| C-04 | SDKSettings.jsonからバージョン情報を取得 | E-06 | ○ |
| C-05 | --sysrootオプションでSDKパスを指定 | E-05, E-06 | ○ |
| C-06 | ccコマンドでヘッダー依存関係を取得 | E-07 | ○ |
| C-07 | -MD -MV -MFオプションで依存ファイル生成 | E-07 | ○ |
| C-08 | /usr/includeプレフィックスでフィルタリング | E-07 | ○ |
| C-09 | headersディレクトリに出力 | E-04, E-07 | ○ |
| C-10 | Target.fullNameで出力ディレクトリ名生成 | E-03, E-07 | ○ |
| C-11 | Version.parseでバージョン文字列解析 | E-08 | ○ |
| C-12 | macos-headers.cを入力として使用 | E-07 | ○ |
| C-13 | deleteTreeで既存ディレクトリを削除 | E-07 | ○ |
| C-14 | clangパスを含む行をスキップ | E-07 | ○ |
| C-15 | ArgsIteratorで引数解析 | E-06 | ○ |
| C-16 | -mmacosx-version-minオプションを設定 | E-07 | ○ |
| C-17 | -isysroot, -iwithsysrootオプション | E-07 | ○ |
| C-18 | 目標処理時間 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18 目標処理時間について
  - 明示的なパフォーマンス要件はソースコードに記載されていない
  - ccコマンドの実行時間に依存するため、環境によって大きく異なる
  - 候補：実際の実行時間計測 / ベンチマークテスト / 開発者へのヒアリング

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接読み取れる情報が大半
- 1: 中リスク - 新しいmacOSバージョンがリリースされた際のOsVer列挙型の更新
- 1: 中リスク - macos-headers.cファイルが存在することが前提

## 6) レビュアーチェックリスト（最小）
- [ ] OsVerに最新のmacOSバージョンが含まれているか確認
- [ ] Archに必要なアーキテクチャがすべて含まれているか確認
- [ ] macos-headers.cファイルの存在と内容を確認
- [ ] 目標処理時間の妥当性を実測で検証
