---
generated_at: 2026-02-01 10:25:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：17-docgen

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：明示的な根拠なし（推定値）
  2. **なし**
  3. **なし**

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tools/docgen.zig` 行16（max_doc_file_size定数）
- E-02: `tools/docgen.zig` 行20-29（usage文字列）
- E-03: `tools/docgen.zig` 行31-87（main関数）
- E-04: `tools/docgen.zig` 行89-103（Token構造体）
- E-05: `tools/docgen.zig` 行105-243（Tokenizer構造体）
- E-06: `tools/docgen.zig` 行281-328（HeaderOpen, SeeAlsoItem, Code, Link, SyntaxBlock構造体）
- E-07: `tools/docgen.zig` 行329-334（Toc構造体）
- E-08: `tools/docgen.zig` 行340-600（genToc関数）
- E-09: `tools/docgen.zig` 行602-618（urlize関数）
- E-10: `tools/docgen.zig` 行982-1052（genHtml関数）
- E-11: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行18

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | docgenテンプレートからHTMLドキュメントを生成 | E-02, E-03, E-11 | ○ |
| C-02 | 入力と出力のパスを指定して実行 | E-02, E-03 | ○ |
| C-03 | --code-dirオプションでコード例出力ディレクトリを指定 | E-02, E-03 | ○ |
| C-04 | Tokenizer構造体でテンプレートを解析 | E-05 | ○ |
| C-05 | {#tag#}形式のタグをサポート | E-05 | ○ |
| C-06 | header_open/header_closeでセクション構造 | E-08 | ○ |
| C-07 | navタグでナビゲーション生成 | E-08 | ○ |
| C-08 | builtinタグでbuiltin情報を埋め込み | E-10 | ○ |
| C-09 | see_alsoタグで関連リンク生成 | E-08, E-10 | ○ |
| C-10 | codeタグでコード例を埋め込み | E-08, E-10 | ○ |
| C-11 | linkタグでページ内リンク生成 | E-08, E-10 | ○ |
| C-12 | syntaxタグでインラインコード | E-08, E-10 | ○ |
| C-13 | shell_sampタグでシェルサンプル | E-08, E-10 | ○ |
| C-14 | syntax_blockタグでコードブロック | E-08, E-10 | ○ |
| C-15 | Toc構造体でTOC生成 | E-07, E-08 | ○ |
| C-16 | urlize関数でURL生成 | E-09 | ○ |
| C-17 | escapeHtml関数でHTMLエスケープ | E-10 | ○ |
| C-18 | 10MB最大ファイルサイズ | E-01 | ○ |
| C-19 | 重複URLの検出 | E-08 | ○ |
| C-20 | 2列レイアウトオプション | E-08 | ○ |
| C-21 | Zigコードのシンタックスハイライト | E-10 | ○ |
| C-22 | 目標処理時間 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-22 目標処理時間について
  - 明示的なパフォーマンス要件はソースコードに記載されていない
  - 入力ファイルのサイズに依存
  - 候補：実際の実行時間計測 / ベンチマークテスト / 開発者へのヒアリング

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接読み取れる情報が大半
- 1: 中リスク - テンプレートタグの形式が変更された場合の追従

## 6) レビュアーチェックリスト（最小）
- [ ] 全てのタグ形式がドキュメント化されているか確認
- [ ] シンタックスハイライト対応言語が正確か確認
- [ ] URLの重複検出が正しく動作するか確認
- [ ] 目標処理時間の妥当性を実測で検証
