---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：18-doctest

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：明示的な根拠なし（推定値）
  2. **なし**
  3. **なし**

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tools/doctest.zig` 行14（max_doc_file_size定数）
- E-02: `tools/doctest.zig` 行16-30（usage文字列）
- E-03: `tools/doctest.zig` 行32-115（main関数）
- E-04: `tools/doctest.zig` 行117-604（printOutput関数）
- E-05: `tools/doctest.zig` 行853-880（Code構造体）
- E-06: `tools/doctest.zig` 行882-968（parseManifest関数）
- E-07: `tools/doctest.zig` 行994-1117（termColor関数）
- E-08: `tools/doctest.zig` 行1159-1204（printShell関数）
- E-09: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行19

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コード例をコンパイル・実行し出力をHTMLにレンダリング | E-02, E-03, E-04, E-09 | ○ |
| C-02 | --zigオプションでZigコンパイラパスを指定 | E-02, E-03 | ○ |
| C-03 | --zig-lib-dirオプションでライブラリパスを指定 | E-02, E-03 | ○ |
| C-04 | --cache-rootオプションでキャッシュパスを指定 | E-02, E-03 | ○ |
| C-05 | -iオプションで入力ファイル指定 | E-02, E-03 | ○ |
| C-06 | -oオプションで出力ファイル指定 | E-02, E-03 | ○ |
| C-07 | Code.Id種別（test, test_error, test_safety, exe, obj, lib） | E-05 | ○ |
| C-08 | parseManifestでマニフェストコメント解析 | E-06 | ○ |
| C-09 | optimize, link_mode, target等のマニフェストオプション | E-06 | ○ |
| C-10 | termColorでANSIカラーコードをHTMLに変換 | E-07 | ○ |
| C-11 | printShellでシェル出力をHTML形式に変換 | E-08 | ○ |
| C-12 | build-exe, build-obj, build-lib, testサブコマンド対応 | E-04 | ○ |
| C-13 | ExpectedOutcome（succeed, fail, build_fail） | E-05 | ○ |
| C-14 | link_objects, additional_options対応 | E-05, E-06 | ○ |
| C-15 | use_llvmオプション（true/false） | E-05, E-06 | ○ |
| C-16 | verbose_cimportオプション | E-05, E-06 | ○ |
| C-17 | CLICOLOR_FORCE=1環境変数設定 | E-03 | ○ |
| C-18 | 一時ディレクトリの作成と削除 | E-03 | ○ |
| C-19 | wasm32, riscv64-linux等のターゲット対応 | E-04 | ○ |
| C-20 | getExternalExecutorでクロスコンパイル判定 | E-04 | ○ |
| C-21 | escapeHtmlでHTMLエスケープ | E-04 | ○ |
| C-22 | シンタックスハイライト（tok-kw, tok-str等） | E-04 | ○ |
| C-23 | just_check_syntaxオプション | E-05, E-06 | ○ |
| C-24 | 10MB最大ファイルサイズ | E-01 | ○ |
| C-25 | 目標処理時間 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-25 目標処理時間について
  - 明示的なパフォーマンス要件はソースコードに記載されていない
  - コンパイル・実行時間に依存するため、コード例によって大きく異なる
  - 候補：実際の実行時間計測 / ベンチマークテスト / 開発者へのヒアリング

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接読み取れる情報が大半
- 1: 中リスク - Zigコンパイラのオプション変更に追従が必要
- 1: 中リスク - マニフェスト形式の変更に追従が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Code.Id種別が全てドキュメント化されているか確認
- [ ] マニフェストオプションの一覧が完全か確認
- [ ] termColorのSGRコード対応が正確か確認
- [ ] 目標処理時間の妥当性を実測で検証
