---
generated_at: 2026-02-01 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：19-migrate_langref

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：明示的な根拠なし（推定値）
  2. **なし**
  3. **なし**

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tools/migrate_langref.zig` 行14-41（main関数）
- E-02: `tools/migrate_langref.zig` 行43-57（Token構造体）
- E-03: `tools/migrate_langref.zig` 行59-197（Tokenizer構造体）
- E-04: `tools/migrate_langref.zig` 行199-227（parseError, assertToken, eatToken関数）
- E-05: `tools/migrate_langref.zig` 行241-263（Code構造体）
- E-06: `tools/migrate_langref.zig` 行265-443（walk関数）
- E-07: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行20

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 言語リファレンスドキュメントをマイグレーション | E-01, E-07 | ○ |
| C-02 | 入力ファイルを解析し出力ファイルに変換 | E-01 | ○ |
| C-03 | 位置引数で入力・出力ファイルを指定 | E-01 | ○ |
| C-04 | Tokenizer構造体でテンプレート解析 | E-03 | ○ |
| C-05 | {#tag#}形式のタグを認識 | E-03 | ○ |
| C-06 | code_beginタグでコードブロック開始 | E-06 | ○ |
| C-07 | Code.Id種別（test, test_err, obj, lib等） | E-05 | ○ |
| C-08 | walk関数でファイルを走査・変換 | E-06 | ○ |
| C-09 | code_end, code_release_fast等のタグ | E-06 | ○ |
| C-10 | target_windows, target_linux_*等のタグ | E-06 | ○ |
| C-11 | link_libc, link_mode_dynamicタグ | E-06 | ○ |
| C-12 | 出力ディレクトリに.zigファイルを生成 | E-06 | ○ |
| C-13 | マニフェストコメント形式での出力 | E-06 | ○ |
| C-14 | parseError関数でエラー位置を表示 | E-04 | ○ |
| C-15 | 目標処理時間 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15 目標処理時間について
  - 明示的なパフォーマンス要件はソースコードに記載されていない
  - 入力ファイルサイズに依存
  - 候補：実際の実行時間計測 / ベンチマークテスト / 開発者へのヒアリング

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接読み取れる情報が大半
- 1: 中リスク - タグ形式の変更に追従が必要
- 1: 中リスク - Code.Id種別の追加・変更に追従が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Code.Id種別が全てドキュメント化されているか確認
- [ ] 全てのタグ形式がドキュメント化されているか確認
- [ ] target_*タグの一覧が完全か確認
- [ ] 目標処理時間の妥当性を実測で検証
