---
generated_at: 2026-02-01 10:40:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：20-incr-check

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：明示的な根拠なし（テストケース依存）
  2. **なし**
  3. **なし**

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tools/incr-check.zig` 行7（usage文字列）
- E-02: `tools/incr-check.zig` 行30-86（main関数、引数解析）
- E-03: `tools/incr-check.zig` 行91-98（cbeバックエンドのlib-dir検証）
- E-04: `tools/incr-check.zig` 行100-113（一時ディレクトリ作成・削除）
- E-05: `tools/incr-check.zig` 行126-172（ターゲットごとのコンパイラ引数構築）
- E-06: `tools/incr-check.zig` 行176-196（cbeバックエンド用のcc引数）
- E-07: `tools/incr-check.zig` 行198-252（子プロセス起動とEval構造体）
- E-08: `tools/incr-check.zig` 行255-276（Eval構造体定義）
- E-09: `tools/incr-check.zig` 行279-294（write関数：ファイル変更適用）
- E-10: `tools/incr-check.zig` 行296-371（check関数：結果検証）
- E-11: `tools/incr-check.zig` 行373-408（checkErrorOutcome関数）
- E-12: `tools/incr-check.zig` 行445-577（checkSuccessOutcome関数）
- E-13: `tools/incr-check.zig` 行469-525（getExternalExecutor使用）
- E-14: `tools/incr-check.zig` 行657-716（Case構造体、Target、Backend列挙型）
- E-15: `tools/incr-check.zig` 行688-708（Update、Outcome定義）
- E-16: `tools/incr-check.zig` 行718-886（Case.parse関数）
- E-17: `tools/incr-check.zig` 行920-958（parseExpectedError関数）
- E-18: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行21

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | インクリメンタルコンパイルのチェックを行う | E-01, E-02, E-18 | ○ |
| C-02 | zig binary pathパラメータ（必須） | E-01, E-02 | ○ |
| C-03 | input fileパラメータ（必須） | E-01, E-02 | ○ |
| C-04 | --zig-lib-dirオプション | E-01, E-02 | ○ |
| C-05 | --debug-logオプション | E-01, E-02 | ○ |
| C-06 | --preserve-tmpオプション | E-01, E-02, E-04 | ○ |
| C-07 | --zig-cc-binaryオプション | E-01, E-02, E-06 | ○ |
| C-08 | -fqemu、-fwine、-fwasmtime、-fdarlingオプション | E-02, E-13 | ○ |
| C-09 | semaバックエンド（-fno-emit-bin） | E-05, E-14 | ○ |
| C-10 | selfhostedバックエンド（-fno-llvm -fno-lld） | E-05, E-14 | ○ |
| C-11 | llvmバックエンド（-fllvm -flld） | E-05, E-14 | ○ |
| C-12 | cbeバックエンド（-ofmt=c -lc） | E-05, E-06, E-14 | ○ |
| C-13 | cbeバックエンド使用時はlib-dir必須 | E-03 | ○ |
| C-14 | 一時ディレクトリtmp_{ランダム}形式で作成 | E-04 | ○ |
| C-15 | テスト完了後に一時ディレクトリ削除 | E-04 | ○ |
| C-16 | #targetディレクティブ | E-16 | ○ |
| C-17 | #moduleディレクティブ | E-16 | ○ |
| C-18 | #updateディレクティブ | E-16 | ○ |
| C-19 | #fileディレクティブ | E-16 | ○ |
| C-20 | #rm_fileディレクティブ | E-16 | ○ |
| C-21 | #expect_stdoutディレクティブ | E-16 | ○ |
| C-22 | #expect_errorディレクティブ | E-16, E-17 | ○ |
| C-23 | #expect_compile_logディレクティブ | E-16 | ○ |
| C-24 | ファイル変更適用（write関数） | E-09 | ○ |
| C-25 | コンパイルエラー検証（checkErrorOutcome） | E-10, E-11 | ○ |
| C-26 | 成功時のバイナリ実行・出力検証 | E-12 | ○ |
| C-27 | 外部エミュレータ対応（QEMU、Wine、wasmtime、darling） | E-13 | ○ |
| C-28 | 目標処理時間 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-28 目標処理時間について
  - 明示的なパフォーマンス要件はソースコードに記載されていない
  - テストケースの複雑さ、ターゲット数、更新ステップ数に大きく依存
  - コンパイル時間はバックエンド（sema/selfhosted/llvm/cbe）によっても異なる
  - 候補：実際の実行時間計測 / ベンチマークテスト / 開発者へのヒアリング

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接読み取れる情報が大半
- 1: 中リスク - テストケースファイル形式の変更に追従が必要
- 1: 中リスク - Zigコンパイラのインクリメンタルコンパイルプロトコルの変更に追従が必要
- 1: 中リスク - Backend列挙型の追加・変更に追従が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Backend種別（sema、selfhosted、llvm、cbe）が全てドキュメント化されているか確認
- [ ] テストケースファイルのディレクティブ一覧が完全か確認
- [ ] 外部エミュレータオプション（-fqemu等）の動作が正確か確認
- [ ] Outcome種別（unknown、compile_errors、stdout、exit_code）が正確か確認
- [ ] 目標処理時間の妥当性を実測で検証
