---
generated_at: 2026-02-01 17:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：23-dump-cov.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **想定処理件数（数千〜数万PC）**：実際のカバレッジ計測結果による検証が必要
  2. **パフォーマンス要件（目標処理時間）**：実測値による検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tools/dump-cov.zig` 行1-2（ファイルヘッダーコメント）
- E-02: `tools/dump-cov.zig` 行11-25（main関数・引数処理）
- E-03: `tools/dump-cov.zig` 行27-29（ターゲット解析処理）
- E-04: `tools/dump-cov.zig` 行43-49（デバッグ情報読み込み）
- E-05: `tools/dump-cov.zig` 行51-60（カバレッジファイル読み込み）
- E-06: `tools/dump-cov.zig` 行66-76（PCアドレス処理・ソート）
- E-07: `tools/dump-cov.zig` 行78-96（ソース位置解決・出力処理）
- E-08: `tools/dump-cov.zig` 行62-64（出力バッファサイズ定義）
- E-09: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行24（バッチ定義）
- E-10: `tools/dump-cov.zig` 行9（SeenPcsHeader import）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチ名はdump-covである | E-09 | ○ |
| C-02 | Zigカバレッジファイルを読み取り人間が読める情報を出力する | E-01, E-09 | ○ |
| C-03 | file:line:column情報を含むPCごとの情報を表示 | E-01, E-07 | ○ |
| C-04 | 実行ファイルパスとカバレッジファイルパスを必須引数として受け取る | E-02 | ○ |
| C-05 | ターゲットはオプション引数でデフォルトはnative | E-02 | ○ |
| C-06 | 引数不足時はfatalでエラー終了する | E-02 | ○ |
| C-07 | Target.Query.parseでターゲット情報を解析する | E-03 | ○ |
| C-08 | std.debug.Info.loadでデバッグ情報を読み込む | E-04 | ○ |
| C-09 | SeenPcsHeader形式でカバレッジデータを解析する | E-05, E-10 | ○ |
| C-10 | カバレッジファイル最大サイズは1GB | E-05 | ○ |
| C-11 | PCアドレスをソートする | E-06 | ○ |
| C-12 | AutoArrayHashMapでPCアドレスをインデックス化する | E-06 | ○ |
| C-13 | debug_info.resolveAddressesでソース位置を取得する | E-07 | ○ |
| C-14 | 実行されたPCは+、実行されなかったPCは-で表示する | E-07 | ○ |
| C-15 | ソース位置が無効な場合はinvalidと表示する | E-07 | ○ |
| C-16 | 出力バッファサイズは4000バイトである | E-08 | ○ |
| C-17 | カテゴリはデバッグ・分析である | E-09 | ○ |
| C-18 | データベース操作は行わない | E-07 | ○ |
| C-19 | std.Build.abi.fuzz.SeenPcsHeaderを使用する | E-10 | ○ |
| C-20 | 使用例はzig run tools/dump-cov.zig -- zig-out/test .zig-cache/v/xxxxxxxx | E-02 | ○ |
| C-21 | 想定処理件数は数千〜数万PCである | **根拠なし** | △ |
| C-22 | 目標処理時間は10秒以内である | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 想定処理件数（数千〜数万PC）：実際のカバレッジ計測結果に依存。ソースコードには記述なし。
  - 候補：実際のファジングテスト結果 / Zigコンパイラのカバレッジ計測結果
- 目標処理時間（10秒以内）：ソースコードには処理時間に関する記述なし。
  - 候補：パフォーマンステスト結果 / 開発者へのヒアリング

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコード解析により高い信頼度で内容を確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 想定処理件数（数千〜数万PC）の妥当性確認
- [ ] 目標処理時間（10秒以内）の妥当性確認
- [ ] SeenPcsHeader形式の最新仕様との整合性確認
