---
generated_at: 2026-02-01 16:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-gen_spirv_spec.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `tools/gen_spirv_spec.zig` 行6-13（インポートとレジストリ型）
- E-02: `tools/gen_spirv_spec.zig` 行52-56（set_names StaticStringMap）
- E-03: `tools/gen_spirv_spec.zig` 行58-112（main関数）
- E-04: `tools/gen_spirv_spec.zig` 行114-136（readExtRegistry関数）
- E-05: `tools/gen_spirv_spec.zig` 行138-152（readRegistry関数）
- E-06: `tools/gen_spirv_spec.zig` 行179-189（tagPriorityScore関数）
- E-07: `tools/gen_spirv_spec.zig` 行191-328（render関数）
- E-08: `tools/gen_spirv_spec.zig` 行330-363（renderInstructionSet関数）
- E-09: `tools/gen_spirv_spec.zig` 行533-631（renderOpcodes関数）
- E-10: `tools/gen_spirv_spec.zig` 行938-953（usageAndExit関数）
- E-11: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行9（バッチ情報）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SPIR-V仕様からZigコードを生成 | E-03, E-07, E-11 | ○ |
| C-02 | Khronosのgrammar.jsonを使用 | E-03, E-11 | ○ |
| C-03 | spirv_headers_pathとextinst_pathの2つの必須引数 | E-03, E-10 | ○ |
| C-04 | spirv.core.grammar.jsonを解析 | E-03, E-05 | ○ |
| C-05 | extinst.*.grammar.jsonを走査 | E-03, E-04 | ○ |
| C-06 | extinst.zig.grammar.jsonを読み込み | E-03 | ○ |
| C-07 | オペコード順にソート | E-03 | ○ |
| C-08 | コアと拡張のオペランド種別を統合 | E-07 | ○ |
| C-09 | Version, Word, Id, OperandKind, Opcode等を出力 | E-07 | ○ |
| C-10 | std.zig.Ast.parseで構文解析 | E-03 | ○ |
| C-11 | AstGenでコンパイルエラー検出 | E-03 | ○ |
| C-12 | フォーマット済みコードを標準出力 | E-03 | ○ |
| C-13 | OpenCL.std、GLSL.std.450、zigをサポート | E-02 | ○ |
| C-14 | set_namesで命令セット名マッピング | E-02 | ○ |
| C-15 | タグ優先度でKHR > EXT > その他 | E-06 | ○ |
| C-16 | 無視された命令セットをログ出力 | E-04 | ○ |
| C-17 | パースエラー時に行・列情報出力 | E-05 | ○ |
| C-18 | 使用方法表示でexit(1) | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] set_namesの命令セットリストが最新か確認
- [ ] 使用例のパスが正しいか確認
