---
generated_at: 2026-02-01 16:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-gen_stubs.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `tools/gen_stubs.zig` 行1-53（ドキュメントコメント、ビルド要件）
- E-02: `tools/gen_stubs.zig` 行67-130（Arch enum定義）
- E-03: `tools/gen_stubs.zig` 行132-142（Family enum定義）
- E-04: `tools/gen_stubs.zig` 行153-273（MultiSym構造体）
- E-05: `tools/gen_stubs.zig` 行275-282（Parse構造体）
- E-06: `tools/gen_stubs.zig` 行284-358（main関数前半）
- E-07: `tools/gen_stubs.zig` 行340-358（プリプロセッサマクロ出力）
- E-08: `tools/gen_stubs.zig` 行360-541（シンボル出力処理）
- E-09: `tools/gen_stubs.zig` 行543-721（parseElf関数）
- E-10: `tools/gen_stubs.zig` 行736-739（fatal関数）
- E-11: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行10（バッチ情報）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | muslのビルドからlibc.Sスタブを生成 | E-01, E-11 | ○ |
| C-02 | build_all_pathの1つの必須引数 | E-06 | ○ |
| C-03 | 14アーキテクチャをサポート | E-02 | ○ |
| C-04 | {arch}/lib/libc.soを入力 | E-01, E-06 | ○ |
| C-05 | ELFヘッダーを解析 | E-09 | ○ |
| C-06 | .dynsymセクションからシンボル抽出 | E-09 | ○ |
| C-07 | バインディング、型、可視性を解析 | E-09 | ○ |
| C-08 | セクション名、シンボル名でソート | E-06 | ○ |
| C-09 | プリプロセッサ条件付きアセンブリを出力 | E-07, E-08 | ○ |
| C-10 | -DTIME32、-DPTR64が必要 | E-01, E-07 | ○ |
| C-11 | -DARCH_{arch}、-DFAMILY_{family}が必要 | E-01 | ○ |
| C-12 | WEAK64は64ビットでweak、32ビットでglobal | E-04, E-07 | ○ |
| C-13 | WEAKTIME64はtime32でglobal、それ以外でweak | E-04, E-07 | ○ |
| C-14 | PTR_SIZE_BYTES、PTR2_SIZE_BYTESを定義 | E-07 | ○ |
| C-15 | STT_FUNC、STT_OBJECT、STT_NOTYPEをサポート | E-08, E-09 | ○ |
| C-16 | DEFAULT、PROTECTEDの可視性をサポート | E-08, E-09 | ○ |
| C-17 | INTERNAL、HIDDENはスキップ | E-09 | ○ |
| C-18 | サイズ0のシンボルで警告 | E-09 | ○ |
| C-19 | セクション不一致時はfatal | E-09 | ○ |
| C-20 | x32は現在サポート外 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 対応アーキテクチャリストが最新か確認
- [ ] ビルド要件のdefineが最新か確認
