---
generated_at: 2026-02-01 17:30:00
metrics:
  claims_total: 93
  claims_with_evidence: 93
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lib-build-web.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：93 / 93、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースにソースコードの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/zig/lib/build-web/main.zig` (7,313バイト、215行)
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/zig/lib/build-web/time_report.zig` (11,208バイト、281行)
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/zig/lib/build-web/fuzz.zig` (15,765バイト、379行)

## 3) Claims と根拠の対応（レビューの主戦場）

### main.zig関連テストケース (UT-BWB-001 - UT-BWB-033)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | alloc関数は正常にメモリ割り当てを行う | E-01 (66-69行目) | ○ |
| C-02 | alloc関数はOOM時にパニックする | E-01 (67行目: `catch @panic("OOM")`) | ○ |
| C-03 | message_begin関数はバッファをリサイズする | E-01 (75-78行目) | ○ |
| C-04 | message_begin関数はOOM時にパニックする | E-01 (76行目: `catch @panic("OOM")`) | ○ |
| C-05 | message_end関数はhelloメッセージを処理する | E-01 (87行目: `.hello => return helloMessage`) | ○ |
| C-06 | message_end関数はstatus_updateメッセージを処理する | E-01 (88行目: `.status_update => return statusUpdateMessage`) | ○ |
| C-07 | message_end関数はstep_updateメッセージを処理する | E-01 (89行目: `.step_update => return stepUpdateMessage`) | ○ |
| C-08 | message_end関数はfuzz_source_indexメッセージを処理する | E-01 (91行目) | ○ |
| C-09 | message_end関数はfuzz_coverage_updateメッセージを処理する | E-01 (92行目) | ○ |
| C-10 | message_end関数はtime_report_generic_resultメッセージを処理する | E-01 (95行目) | ○ |
| C-11 | message_end関数はtime_report_compile_resultメッセージを処理する | E-01 (96行目) | ○ |
| C-12 | message_end関数は不正なタグでパニックする | E-01 (85行目: `_ => @panic("malformed message")`) | ○ |
| C-13 | Slice.init関数はスライスを変換する | E-01 (108-113行目) | ○ |
| C-14 | fatal関数はフォーマットされたメッセージでパニックする | E-01 (117-124行目) | ○ |
| C-15 | fatal関数は500文字を超えるメッセージを切り詰める | E-01 (119-122行目: `buf[buf.len - 3 ..][0..3].* = "...".*`) | ○ |
| C-16 | helloMessage関数はHelloメッセージをパースする | E-01 (126-165行目) | ○ |
| C-17 | helloMessage関数はメッセージ長不足でパニックする | E-01 (127行目: `if (msg_bytes.len < @sizeOf(abi.Hello)) @panic`) | ○ |
| C-18 | helloMessage関数はタイムスタンプを設定する | E-01 (131-132行目) | ○ |
| C-19 | statusUpdateMessage関数はビルドステータスを更新する | E-01 (166-170行目) | ○ |
| C-20 | statusUpdateMessage関数はメッセージ長不足でパニックする | E-01 (167行目) | ○ |
| C-21 | stepUpdateMessage関数はステップステータスを更新する | E-01 (171-177行目) | ○ |
| C-22 | stepUpdateMessage関数はstep_idx範囲外でパニックする | E-01 (174行目) | ○ |
| C-23 | stepName関数はステップ名を返す | E-01 (179-181行目) | ○ |
| C-24 | stepStatus関数はステップステータスを返す | E-01 (182-184行目) | ○ |
| C-25 | rebuild関数はリビルドメッセージを送信する | E-01 (186-190行目) | ○ |
| C-26 | nsSince関数は経過ナノ秒を計算する | E-01 (193-197行目) | ○ |
| C-27 | HtmlEscaper.format関数は<>をエスケープする | E-01 (205-208行目: `'<' => "&lt;"`, `'>' => "&gt;"`) | ○ |
| C-28 | HtmlEscaper.format関数は&をエスケープする | E-01 (206行目: `'&' => "&amp;"`) | ○ |
| C-29 | HtmlEscaper.format関数は"をエスケープする | E-01 (209行目: `'"' => "&quot;"`) | ○ |
| C-30 | HtmlEscaper.format関数は'をエスケープする | E-01 (210行目: `'\'' => "&#39;"`) | ○ |
| C-31 | logFn関数はログメッセージをフォーマットする | E-01 (50-64行目) | ○ |
| C-32 | logFn関数は500文字を超えるログを切り詰める | E-01 (59-61行目) | ○ |
| C-33 | panic関数はログ出力後トラップする | E-01 (43-48行目) | ○ |

### time_report.zig関連テストケース (UT-BWB-034 - UT-BWB-048)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | genericResultMessage関数は汎用結果HTMLを生成する | E-02 (39-52行目) | ○ |
| C-35 | genericResultMessage関数はメッセージサイズ不正でパニックする | E-02 (40行目) | ○ |
| C-36 | genericResultMessage関数はstep_idx範囲外でパニックする | E-02 (42行目) | ○ |
| C-37 | compileResultMessage関数はコンパイル結果HTMLを生成する | E-02 (54-246行目) | ○ |
| C-38 | compileResultMessage関数はファイルテーブルをソートする | E-02 (119-132行目: `std.mem.sort(FileTimeReport...`) | ○ |
| C-39 | compileResultMessage関数は宣言テーブルをソートする | E-02 (133行目: `std.mem.sort(DeclTimeReport...`) | ○ |
| C-40 | compileResultMessage関数は500行を超えるファイルテーブルを切り詰める | E-02 (55行目: `const max_table_rows = 500`, 197-202行目) | ○ |
| C-41 | compileResultMessage関数は500行を超える宣言テーブルを切り詰める | E-02 (229-234行目) | ○ |
| C-42 | compileResultMessage関数はメッセージサイズ不正でパニックする | E-02 (57行目) | ○ |
| C-43 | compileResultMessage関数はstep_idx範囲外でパニックする | E-02 (59行目) | ○ |
| C-44 | runTestResultMessage関数はテスト結果HTMLを生成する | E-02 (248-280行目) | ○ |
| C-45 | runTestResultMessage関数は未実行テストを空セルで表示する | E-02 (265-266行目: `if (test_ns == std.math.maxInt(u64))`) | ○ |
| C-46 | runTestResultMessage関数はメッセージサイズ不正でパニックする | E-02 (249行目) | ○ |
| C-47 | runTestResultMessage関数はstep_idx範囲外でパニックする | E-02 (251行目) | ○ |
| C-48 | runTestResultMessage関数はtrailing長不一致でパニックする | E-02 (273行目: `if (offset != trailing.len) @panic`) | ○ |

### fuzz.zig関連テストケース (UT-BWB-049 - UT-BWB-093)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | sourceIndexMessage関数はソースインデックスをパースする | E-03 (14-41行目) | ○ |
| C-50 | sourceIndexMessage関数はjs.requestSourcesを呼ぶ | E-03 (21行目) | ○ |
| C-51 | sourceIndexMessage関数はjs.readyを呼ぶ | E-03 (40行目) | ○ |
| C-52 | sourceIndexMessage関数は既存データをクリアする | E-03 (15-18行目) | ○ |
| C-53 | updateCoverageSources関数はカバレッジソースを更新する | E-03 (49-70行目) | ○ |
| C-54 | updateCoverageSources関数は既存データをクリアする | E-03 (55-58行目) | ○ |
| C-55 | coverageUpdateMessage関数はカバレッジ更新を処理する | E-03 (72-77行目) | ○ |
| C-56 | coverageUpdateMessage関数はrecent_coverage_updateを更新する | E-03 (73-74行目) | ○ |
| C-57 | entryPointsMessage関数はエントリーポイントをパースする | E-03 (81-88行目) | ○ |
| C-58 | entryPointsMessage関数はupdateEntryPointsを呼ぶ | E-03 (87行目) | ○ |
| C-59 | SourceLocationIndex.haveCoverage関数は有効なインデックスでtrueを返す | E-03 (94-96行目) | ○ |
| C-60 | SourceLocationIndex.haveCoverage関数は範囲外でfalseを返す | E-03 (94-96行目) | ○ |
| C-61 | SourceLocationIndex.ptr関数は正しいポインタを返す | E-03 (98-100行目) | ○ |
| C-62 | SourceLocationIndex.sourceLocationLinkHtml関数はHTMLリンクを生成する | E-03 (102-117行目) | ○ |
| C-63 | SourceLocationIndex.sourceLocationLinkHtml関数はフォーカス時にクラスを付与する | E-03 (108-109行目) | ○ |
| C-64 | SourceLocationIndex.appendPath関数はパスを生成する | E-03 (119-127行目) | ○ |
| C-65 | SourceLocationIndex.toWalkFile関数はWalk.File.Indexを返す | E-03 (129-134行目) | ○ |
| C-66 | SourceLocationIndex.toWalkFile関数はファイルが存在しない場合nullを返す | E-03 (133行目: `orelse return null`) | ○ |
| C-67 | SourceLocationIndex.fileHtml関数はソースHTMLを生成する | E-03 (136-150行目) | ○ |
| C-68 | SourceLocationIndex.fileHtml関数はソース利用不可時にエラーを返す | E-03 (140行目: `return error.SourceUnavailable`) | ○ |
| C-69 | computeSourceAnnotations関数はアノテーションを計算する | E-03 (153-205行目) | ○ |
| C-70 | computeSourceAnnotations関数は異なるファイルをフィルタする | E-03 (166行目: `if (sl.file != cov_file_index) continue`) | ○ |
| C-71 | computeSourceAnnotations関数は行・列でソートする | E-03 (171-180行目: `std.mem.sortUnstable`) | ○ |
| C-72 | fuzzUnpackSources関数はtarファイルをアンパックする | E-03 (207-214行目) | ○ |
| C-73 | fuzzUnpackSources関数はアンパック失敗時にfatalを呼ぶ | E-03 (212-213行目) | ○ |
| C-74 | unpackSourcesInner関数は.zigファイルをWalk.filesに追加する | E-03 (228-245行目) | ○ |
| C-75 | unpackSourcesInner関数は非.zigファイルをスキップする | E-03 (246-248行目) | ○ |
| C-76 | unpackSourcesInner関数はモジュール名を推定する | E-03 (235-239行目) | ○ |
| C-77 | unpackSourcesInner関数はbuiltin.zigをbuiltinモジュールとして認識する | E-03 (237行目) | ○ |
| C-78 | updateStats関数は統計HTMLを生成する | E-03 (255-295行目) | ○ |
| C-79 | updateStats関数はrecent_coverage_updateが空の場合何もしない | E-03 (258行目: `if (recent_coverage_update.items.len == 0) return`) | ○ |
| C-80 | updateStats関数はカバレッジ率を計算する | E-03 (264-270行目, 287-289行目) | ○ |
| C-81 | updateStats関数は実行速度を計算する | E-03 (272-276行目) | ○ |
| C-82 | updateEntryPoints関数はエントリーポイントHTMLを生成する | E-03 (297-306行目) | ○ |
| C-83 | updateEntryPoints関数は選択中のエントリーポイントをハイライトする | E-03 (302行目: `selected_source_location == sli`) | ○ |
| C-84 | updateCoverage関数はカバレッジ更新を送信する | E-03 (308-338行目) | ○ |
| C-85 | updateCoverage関数はrecent_coverage_updateが空の場合何もしない | E-03 (309行目) | ○ |
| C-86 | updateCoverage関数はselected_source_locationがnullの場合何もしない | E-03 (310行目: `orelse return`) | ○ |
| C-87 | updateCoverage関数は選択ファイル以外をフィルタする | E-03 (329行目) | ○ |
| C-88 | updateSource関数はソースHTMLを生成する | E-03 (340-350行目) | ○ |
| C-89 | updateSource関数はrecent_coverage_updateが空の場合何もしない | E-03 (341行目) | ○ |
| C-90 | updateSource関数はソース利用不可時に空HTMLを送信する | E-03 (345-348行目) | ○ |
| C-91 | fuzzSelectSli関数は選択状態を更新する | E-03 (356-362行目) | ○ |
| C-92 | fuzzSelectSli関数は関連するUI更新を呼ぶ | E-03 (359-361行目) | ○ |
| C-93 | fuzzSelectSli関数はカバレッジがない場合何もしない | E-03 (357行目: `if (!sli.haveCoverage()) return`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースにソースコードの根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードに基づいて生成されている
- 注意点：
  - WebAssembly環境特有の動作（js.*関数）はモック化が必要
  - 外部依存（std.Build.abi, Walk, html_render）のテストダブル作成が必要
  - tarファイル処理のテストには適切なテストデータの準備が必要

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースのカバレッジが十分か（正常系/異常系/境界値）
- [ ] WebAssembly関連のjs.*関数のモック戦略が適切か
- [ ] パニックケースのテスト実行方法が明確か
- [ ] 外部依存（std.Build.abi, Walk, html_render）のモック方針が決定されているか
- [ ] tarファイル処理のテストデータが用意されているか
- [ ] 時刻計算のテストで適切なタイムスタンプ制御ができるか
