---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 195
  claims_with_evidence: 195
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: lib-c 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：195 / 195、根拠なし：0
- 優先レビュー（高）
  1. **システムコール関連テスト**：実行環境依存のためモック検討
  2. **境界値テスト**：オーバーフロー処理の正確性確認
  3. **マルチプラットフォームテスト**：Linux/WASI/MinGW固有機能

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/zig/lib/c/common.zig`
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/zig/lib/c/ctype.zig`
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/zig/lib/c/inttypes.zig`
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/zig/lib/c/math.zig`
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/zig/lib/c/stdlib.zig`
- E-06: `/Users/tomokababa/Work/reverse-engineering/sample/zig/lib/c/string.zig`
- E-07: `/Users/tomokababa/Work/reverse-engineering/sample/zig/lib/c/strings.zig`
- E-08: `/Users/tomokababa/Work/reverse-engineering/sample/zig/lib/c/wchar.zig`
- E-09: `/Users/tomokababa/Work/reverse-engineering/sample/zig/lib/c/unistd.zig`
- E-10: `/Users/tomokababa/Work/reverse-engineering/sample/zig/lib/c/sys.zig`
- E-11: `/Users/tomokababa/Work/reverse-engineering/sample/zig/lib/c/sys/mman.zig`
- E-12: `/Users/tomokababa/Work/reverse-engineering/sample/zig/lib/c/sys/file.zig`
- E-13: `/Users/tomokababa/Work/reverse-engineering/sample/zig/lib/c/sys/reboot.zig`
- E-14: `/Users/tomokababa/Work/reverse-engineering/sample/zig/lib/c/sys/capability.zig`
- E-15: `/Users/tomokababa/Work/reverse-engineering/sample/zig/lib/c/sys/utsname.zig`
- E-16: `/Users/tomokababa/Work/reverse-engineering/sample/zig/lib/c/stdlib/rand.zig`
- E-17: `/Users/tomokababa/Work/reverse-engineering/sample/zig/lib/c/stdlib/drand48.zig`

## 3) Claims と根拠の対応（レビューの主戦場）

### common.zig (UT-LIBC-001 - 003)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | errno関数がLinuxシステムコール戻り値を処理 | E-01 L19-33 | ○ |
| C-02 | 成功時は結果値をそのまま返す | E-01 L27-29 | ○ |
| C-03 | 失敗時はerrnoを設定し-1を返す | E-01 L24-27 | ○ |

### ctype.zig (UT-LIBC-004 - 023)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-04 | isalnumが英数字を判定 | E-02 L60-67 | ○ |
| C-05 | isalphaがアルファベットを判定 | E-02 L69-76 | ○ |
| C-06 | isblankが空白/タブを判定 | E-02 L78-85 | ○ |
| C-07 | iscntrlが制御文字を判定 | E-02 L87-94 | ○ |
| C-08 | isdigitが数字を判定 | E-02 L96-103 | ○ |
| C-09 | isgraphがグラフィカル文字を判定 | E-02 L105-112 | ○ |
| C-10 | islowerが小文字を判定 | E-02 L114-121 | ○ |
| C-11 | isupperが大文字を判定 | E-02 L150-157 | ○ |
| C-12 | isxdigitが16進数字を判定 | E-02 L159-166 | ○ |
| C-13 | tolowerが大文字を小文字に変換 | E-02 L168-175 | ○ |
| C-14 | toupperが小文字を大文字に変換 | E-02 L177-184 | ○ |
| C-15 | isasciiがASCII範囲を判定 | E-02 L186-188 | ○ |
| C-16 | toasciiが7ビットにマスク | E-02 L190-192 | ○ |

### inttypes.zig (UT-LIBC-024 - 028)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | imaxabsが絶対値を計算 | E-03 L15-17, テスト L26-29 | ○ |
| C-18 | imaxdivが商と剰余を計算 | E-03 L19-24, テスト L31-34 | ○ |

### math.zig (UT-LIBC-029 - 036)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | isnanがNaNを判定 | E-04 L51-53 | ○ |
| C-20 | isnanfがfloat NaNを判定 | E-04 L55-57 | ○ |
| C-21 | nanがNaN値を生成 | E-04 L63-65 | ○ |
| C-22 | nanfがfloat NaN値を生成 | E-04 L67-69 | ○ |
| C-23 | copysignが符号をコピー | E-04 L79-81 | ○ |
| C-24 | acosが逆余弦を計算 | E-04 L47-49 | ○ |

### stdlib.zig (UT-LIBC-037 - 063)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | absが整数絶対値を計算 | E-05 L48-50, テスト L296-299 | ○ |
| C-26 | labsがlong絶対値を計算 | E-05 L52-54, テスト L301-304 | ○ |
| C-27 | llabsがlong long絶対値を計算 | E-05 L56-58, テスト L306-309 | ○ |
| C-28 | divが商と剰余を計算 | E-05 L60-65, テスト L311-314 | ○ |
| C-29 | ldivがlong除算結果を計算 | E-05 L67-72, テスト L316-319 | ○ |
| C-30 | lldivがlong long除算結果を計算 | E-05 L74-79, テスト L321-324 | ○ |
| C-31 | atoiが文字列を整数に変換 | E-05 L81-83, テスト L326-339 | ○ |
| C-32 | atolが文字列をlongに変換 | E-05 L85-87, テスト L341-354 | ○ |
| C-33 | atollが文字列をlong longに変換 | E-05 L89-91, テスト L356-369 | ○ |
| C-34 | strtolが文字列をlongに変換 | E-05 L106-108, L131-198 | ○ |
| C-35 | strtoulが符号なし変換 | E-05 L114-116, L180-187 | ○ |
| C-36 | qsortがソートを実行 | E-05 L267-274 | ○ |
| C-37 | qsort_rがコンテキスト付きソート | E-05 L236-265 | ○ |
| C-38 | bsearchが二分探索 | E-05 L277-294, テスト L373-394 | ○ |

### string.zig (UT-LIBC-064 - 098)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | memchrがメモリ内文字検索 | E-06 L66-69 | ○ |
| C-40 | strcpyが文字列コピー | E-06 L71-74 | ○ |
| C-41 | strncpyが長さ制限コピー | E-06 L76-79 | ○ |
| C-42 | strcatが文字列連結 | E-06 L81-83 | ○ |
| C-43 | strncatが長さ制限連結 | E-06 L85-92 | ○ |
| C-44 | strcmpが文字列比較 | E-06 L94-96 | ○ |
| C-45 | strncmpが長さ制限比較 | E-06 L98-104, テスト L294-299 | ○ |
| C-46 | strchrが文字検索 | E-06 L127-133 | ○ |
| C-47 | strrchrが逆方向検索 | E-06 L135-139 | ○ |
| C-48 | strcspnが非包含長取得 | E-06 L141-144 | ○ |
| C-49 | strspnが包含長取得 | E-06 L146-149 | ○ |
| C-50 | strpbrkが文字セット検索 | E-06 L151-153 | ○ |
| C-51 | strstrが部分文字列検索 | E-06 L155-157 | ○ |
| C-52 | strtokがトークン分割 | E-06 L159-165 | ○ |
| C-53 | strtok_rが再入可能トークン分割 | E-06 L169-189 | ○ |
| C-54 | stpcpyが終端返却コピー | E-06 L191-195 | ○ |
| C-55 | stpncpyがパディングコピー | E-06 L197-203 | ○ |
| C-56 | strnlenが長さ制限長取得 | E-06 L205-207 | ○ |
| C-57 | memmemがバイナリ検索 | E-06 L209-214 | ○ |
| C-58 | memccpyが条件付きコピー | E-06 L256-263 | ○ |
| C-59 | strsepがトークン分離 | E-06 L216-231 | ○ |
| C-60 | strlcatが安全連結 | E-06 L233-244 | ○ |
| C-61 | strlcpyが安全コピー | E-06 L246-254 | ○ |
| C-62 | explicit_bzeroがセキュアゼロ埋め | E-06 L265-268 | ○ |
| C-63 | strchrnulが終端返却検索 | E-06 L270-276 | ○ |
| C-64 | strcasestrが大小無視検索 | E-06 L278-280 | ○ |
| C-65 | memrchrが逆方向メモリ検索 | E-06 L282-285 | ○ |
| C-66 | mempcpyが終端返却メモリコピー | E-06 L287-292 | ○ |

### strings.zig (UT-LIBC-099 - 110)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | bcopyがメモリ移動 | E-07 L28-32 | ○ |
| C-68 | bzeroがゼロ埋め | E-07 L34-37, テスト L85-91 | ○ |
| C-69 | indexが文字検索 | E-07 L39-41 | ○ |
| C-70 | rindexが逆方向検索 | E-07 L43-45 | ○ |
| C-71 | ffsが最初のセットビット検索 | E-07 L47-53, テスト L93-101 | ○ |
| C-72 | ffslがlong型ビット検索 | E-07 L55-57 | ○ |
| C-73 | ffsllがlong long型ビット検索 | E-07 L59-61 | ○ |
| C-74 | strcasecmpが大小無視比較 | E-07 L63-65, テスト L103-111 | ○ |
| C-75 | strncasecmpが長さ制限大小無視比較 | E-07 L72-78, テスト L113-121 | ○ |

### wchar.zig (UT-LIBC-111 - 133)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | wmemchrがワイド文字検索 | E-08 L45-47 | ○ |
| C-77 | wmemcmpがワイド文字列比較 | E-08 L49-55 | ○ |
| C-78 | wmemcpyがワイド文字コピー | E-08 L57-60 | ○ |
| C-79 | wmemmoveがワイド文字移動 | E-08 L67-70 | ○ |
| C-80 | wmemsetがワイド文字設定 | E-08 L72-75 | ○ |
| C-81 | wcslenがワイド文字列長取得 | E-08 L77-79 | ○ |
| C-82 | wcsnlenが長さ制限取得 | E-08 L81-83 | ○ |
| C-83 | wcscmpがワイド文字列比較 | E-08 L85-87 | ○ |
| C-84 | wcsncmpが長さ制限比較 | E-08 L89-95 | ○ |
| C-85 | wcpcpyが終端返却コピー | E-08 L97-101 | ○ |
| C-86 | wcpncpyがパディングコピー | E-08 L103-109 | ○ |
| C-87 | wcscpyがワイド文字列コピー | E-08 L111-114 | ○ |
| C-88 | wcsncpyが長さ制限コピー | E-08 L116-119 | ○ |
| C-89 | wcscatがワイド文字列連結 | E-08 L121-123 | ○ |
| C-90 | wcsncatが長さ制限連結 | E-08 L125-133 | ○ |
| C-91 | wcschrがワイド文字検索 | E-08 L135-140 | ○ |
| C-92 | wcsrchrが逆方向検索 | E-08 L142-145 | ○ |
| C-93 | wcsspnが包含長取得 | E-08 L147-150 | ○ |
| C-94 | wcscspnが非包含長取得 | E-08 L152-155 | ○ |
| C-95 | wcspbrkが文字セット検索 | E-08 L157-159 | ○ |
| C-96 | wcstokがトークン分割 | E-08 L161-181 | ○ |
| C-97 | wcsstrが部分文字列検索 | E-08 L183-185 | ○ |
| C-98 | wcswcsがwcsstrエイリアス | E-08 L187-189 | ○ |

### stdlib/rand.zig (UT-LIBC-134 - 136)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-99 | randが擬似乱数生成 | E-16 L28-30 | ○ |
| C-100 | srandがシード設定 | E-16 L24-26 | ○ |
| C-101 | rand_rが再入可能乱数 | E-16 L16-22 | ○ |

### stdlib/drand48.zig (UT-LIBC-137 - 145)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | drand48がdouble乱数生成 | E-17 L60-62 | ○ |
| C-103 | erand48が外部状態乱数 | E-17 L30-38, テスト L92-109 | ○ |
| C-104 | jrand48が符号付き乱数 | E-17 L40-48, テスト L111-128 | ○ |
| C-105 | nrand48が符号なし乱数 | E-17 L50-58, テスト L130-147 | ○ |
| C-106 | lrand48がグローバル状態乱数 | E-17 L64-66 | ○ |
| C-107 | mrand48が符号付きグローバル乱数 | E-17 L68-70 | ○ |
| C-108 | srand48がシード設定 | E-17 L87-90 | ○ |
| C-109 | seed48が完全シード設定 | E-17 L80-85 | ○ |
| C-110 | lcong48がLCGパラメータ設定 | E-17 L74-78 | ○ |

### unistd.zig (UT-LIBC-146 - 178)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | _exitがプロセス終了 | E-09 L48-50 | ○ |
| C-112 | accessがアクセス権確認 | E-09 L52-54 | ○ |
| C-113 | chdirがディレクトリ変更 | E-09 L60-62 | ○ |
| C-114 | chownが所有者変更 | E-09 L64-66 | ○ |
| C-115 | fchownatが相対所有者変更 | E-09 L68-70 | ○ |
| C-116 | lchownがリンク所有者変更 | E-09 L72-74 | ○ |
| C-117 | ctermidが制御端末名取得 | E-09 L80-87 | ○ |
| C-118 | dupがfd複製 | E-09 L89-91 | ○ |
| C-119 | getegidが実効GID取得 | E-09 L93-95 | ○ |
| C-120 | geteuidが実効UID取得 | E-09 L97-99 | ○ |
| C-121 | getgidが実GID取得 | E-09 L101-103 | ○ |
| C-122 | getuidが実UID取得 | E-09 L137-139 | ○ |
| C-123 | getpidがPID取得 | E-09 L125-127 | ○ |
| C-124 | getppidが親PID取得 | E-09 L129-131 | ○ |
| C-125 | getpgidがPGID取得 | E-09 L109-111 | ○ |
| C-126 | getpgrpが現在PGID取得 | E-09 L113-115 | ○ |
| C-127 | setpgidがPGID設定 | E-09 L117-119 | ○ |
| C-128 | getsidがSID取得 | E-09 L133-135 | ○ |
| C-129 | getgroupsが補助グループ取得 | E-09 L105-107 | ○ |
| C-130 | linkがハードリンク作成 | E-09 L141-143 | ○ |
| C-131 | linkatが相対ハードリンク作成 | E-09 L145-147 | ○ |
| C-132 | symlinkがシンボリックリンク作成 | E-09 L161-163 | ○ |
| C-133 | symlinkatが相対シンボリックリンク作成 | E-09 L165-167 | ○ |
| C-134 | unlinkがファイル削除 | E-09 L173-175 | ○ |
| C-135 | unlinkatが相対ファイル削除 | E-09 L177-179 | ○ |
| C-136 | rmdirがディレクトリ削除 | E-09 L157-159 | ○ |
| C-137 | pipeがパイプ作成 | E-09 L149-151 | ○ |
| C-138 | renameatがファイルリネーム | E-09 L153-155 | ○ |
| C-139 | syncがファイルシステム同期 | E-09 L169-171 | ○ |
| C-140 | execveがプログラム実行 | E-09 L181-183 | ○ |

### sys/mman.zig (UT-LIBC-179 - 188)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-141 | madviseがメモリアドバイス設定 | E-11 L25-27 | ○ |
| C-142 | mincoreがコア状態取得 | E-11 L29-31 | ○ |
| C-143 | mlockがメモリロック | E-11 L33-35 | ○ |
| C-144 | mlockallが全メモリロック | E-11 L37-39 | ○ |
| C-145 | mprotectがメモリ保護変更 | E-11 L41-46 | ○ |
| C-146 | munlockがメモリロック解除 | E-11 L48-50 | ○ |
| C-147 | munlockallが全メモリロック解除 | E-11 L52-54 | ○ |
| C-148 | posix_madviseがPOSIXアドバイス設定 | E-11 L56-59 | ○ |

### sys/file.zig (UT-LIBC-189 - 190)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-149 | flockがファイルロック | E-12 L11-13 | ○ |

### sys/reboot.zig (UT-LIBC-191)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-150 | rebootがシステム再起動 | E-13 L11-13 | ○ |

### sys/capability.zig (UT-LIBC-192 - 193)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-151 | capsetがケーパビリティ設定 | E-14 L12-14 | ○ |
| C-152 | capgetがケーパビリティ取得 | E-14 L16-18 | ○ |

### sys/utsname.zig (UT-LIBC-194 - 195)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-153 | unameLinuxがシステム情報取得 | E-15 L15-17 | ○ |
| C-154 | unameWasiがWASIシステム情報返却 | E-15 L19-32 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべてのテストケースはソースコードに基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースにソースコードの根拠あり
- 1: 中リスク - 一部のシステムコール関連テストは実行環境依存
  - unistd.zig のLinux固有関数（access, chdir, chown等）
  - sys/mman.zig のメモリ管理関数（madvise, mlock等）
  - sys/reboot.zig のreboot関数
- 1: 中リスク - プラットフォーム固有コード
  - musl/wasi-libc/MinGW固有のエクスポート条件

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースの期待結果がC標準ライブラリ仕様と一致しているか確認
- [ ] 境界値テストケース（最大値、最小値、空入力）の網羅性を確認
- [ ] システムコール関連テストのモック/スタブ方針を確認
- [ ] マルチプラットフォーム（Linux/WASI/MinGW）固有機能のテスト分離を確認
- [ ] セキュリティ関連関数（explicit_bzero, capset/capget等）のテスト妥当性を確認
