---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 110
  claims_with_evidence: 98
  claims_without_evidence: 12
confidence_derived: 0.89
---

# 根拠レポート：lib-compiler単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：98 / 110、根拠なし：12
- 優先レビュー（高）
  1. **resinator/parse.zig, compile.zig**：ファイル内容を詳細確認していないため、テストケースの網羅性要確認
  2. **aro/backend サブモジュール**：IRおよびオブジェクト生成の詳細実装未確認
  3. **translate-c/MacroTranslator.zig**：マクロ変換の詳細ロジック未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/compiler/build_runner.zig` - ビルドランナーのメインモジュール（1848行）
- E-02: `lib/compiler/objcopy.zig` - オブジェクトコピーツール（822行、既存テスト含む）
- E-03: `lib/compiler/reduce.zig` - コード削減ツール（420行）
- E-04: `lib/compiler/reduce/Walk.zig` - AST走査モジュール（986行）
- E-05: `lib/compiler/libc.zig` - libc検出ツール（141行）
- E-06: `lib/compiler/util.zig` - ユーティリティモジュール（83行）
- E-07: `lib/compiler/test_runner.zig` - テストランナー（459行）
- E-08: `lib/compiler/std-docs.zig` - ドキュメントサーバー（459行）
- E-09: `lib/compiler/aro/aro.zig` - aroモジュールエントリポイント（42行）
- E-10: `lib/compiler/aro/aro/Tokenizer.zig` - トークナイザー（先頭300行確認）
- E-11: `lib/compiler/aro/aro/Preprocessor.zig` - プリプロセッサ（先頭300行確認）
- E-12: `lib/compiler/translate-c/Translator.zig` - C→Zigトランスレータ（先頭500行確認）
- E-13: `lib/compiler/resinator/lex.zig` - リソースレクサー（先頭300行確認）
- E-14: `docs/code-to-docs/単体テストケース一覧/plan.md` - テスト計画（lib-compiler: 110ファイル）

## 3) Claims と根拠の対応（レビューの主戦場）

### build_runner.zig（UT-LCM-001～009）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | main関数はビルドランナーのエントリポイント | E-01: L26-636 | ○ |
| C-02 | nextArgは引数を順次取得する | E-01: L1688-1692 | ○ |
| C-03 | nextArgは範囲外でnullを返す | E-01: L1688-1692 | ○ |
| C-04 | nextArgOrFatalは欠落時にfatal | E-01: L1694-1699 | ○ |
| C-05 | prepareはステップを準備する | E-01: L679-738 | ○ |
| C-06 | constructGraphAndCheckForDependencyLoopは依存グラフを構築 | E-01: L1252-1299 | ○ |
| C-07 | 循環依存を検出するとerror.DependencyLoopDetected | E-01: L1260-1263 | ○ |
| C-08 | markFailedStepsDirtyは失敗ステップをマーク | E-01: L638-649 | ○ |
| C-09 | countSubProcessesはサブプロセス数をカウント | E-01: L651-657 | ○ |

### objcopy.zig（UT-LCM-010～022）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | mainはobjcopyのエントリポイント | E-02: L20-24 | ○ |
| C-11 | ELF→RAW変換をサポート | E-02: L178-196 | ○ |
| C-12 | ELF→HEX変換をサポート | E-02: L178-196, L329-354 | ○ |
| C-13 | emitElfはELF出力を生成 | E-02: L292-355 | ○ |
| C-14 | BinaryElfOutput.parseはELFをパース | E-02: L389-496 | ○ |
| C-15 | HexWriter.Record.checksumはチェックサムを計算 | E-02: L596-608 | ○ |
| C-16 | HexWriter.Record.Addressのテスト存在 | E-02: L674-682（test） | ○ |
| C-17 | containsValidAddressRangeのテスト存在 | E-02: L684-713（test） | ○ |
| C-18 | containsValidAddressRange境界値テスト存在 | E-02: L696-712（test） | ○ |
| C-19 | parseSectionFlagsのテスト存在 | E-02: L784-793（test） | ○ |
| C-20 | parseSectionFlags空文字列テスト | E-02: L786（test） | ○ |
| C-21 | splitOptionのテスト存在 | E-02: L809-821（test） | ○ |
| C-22 | splitOption無効形式テスト | E-02: L817-821（test） | ○ |

### reduce.zig + Walk.zig（UT-LCM-023～036）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | mainはリデュースツールのエントリポイント | E-03: L50-274 | ○ |
| C-24 | runCheckは興味深さをチェック | E-03: L301-306 | ○ |
| C-25 | termToInterestingは終了コードを変換 | E-03: L283-299 | ○ |
| C-26 | 終了コード1はunknown | E-03: L286-287 | ○ |
| C-27 | 終了コード2以上はboring | E-03: L288 | ○ |
| C-28 | transformationsToFixupsは変換を適用 | E-03: L308-391 | ○ |
| C-29 | parseはZigソースをパース | E-03: L393-414 | ○ |
| C-30 | sortTransformationsはシャッフル | E-03: L276-281 | ○ |
| C-31 | findTransformationsはAST変換候補を抽出 | E-04: L54-83 | ○ |
| C-32 | walkMembersはメンバーを走査 | E-04: L85-94 | ○ |
| C-33 | walkExpressionは式を走査 | E-04: L192-521 | ○ |
| C-34 | isFnBodyGuttedは関数本体を検査 | E-04: L881-902 | ○ |
| C-35 | isUndefinedIdentはundefinedを検出 | E-04: L954-956 | ○ |
| C-36 | isEmptyBlockは空ブロックを検出 | E-04: L977-985 | ○ |

### libc.zig（UT-LCM-037～039）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | mainはlibcツールのエントリポイント | E-05: L27-135 | ○ |
| C-38 | -includesオプションをサポート | E-05: L54-55, L72-112 | ○ |
| C-39 | 非ネイティブターゲットでfatal | E-05: L120-122 | ○ |

### util.zig（UT-LCM-040～042）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | aroDiagnosticsToErrorBundleは診断を変換 | E-06: L6-82 | ○ |
| C-41 | ソース位置は0ベースに変換 | E-06: L45-46（line-1, col-1） | ○ |
| C-42 | ノートはnotes_lenで管理 | E-06: L68-74 | ○ |

### test_runner.zig（UT-LCM-043～048）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | mainはテストランナーのエントリポイント | E-07: L32-72 | ○ |
| C-44 | mainServerはサーバーモード | E-07: L74-219 | ○ |
| C-45 | mainTerminalはターミナルモード | E-07: L221-304 | ○ |
| C-46 | logはlog_err_countをインクリメント | E-07: L306-322 | ○ |
| C-47 | fuzzはファズテストを実行 | E-07: L380-458 | ○ |
| C-48 | mainSimpleは簡易モード | E-07: L326-373 | ○ |

### std-docs.zig（UT-LCM-049～055）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | mainはドキュメントサーバーを起動 | E-08: L24-89 | ○ |
| C-50 | serveRequestはリクエストをルーティング | E-08: L134-160 | ○ |
| C-51 | serveDocsFileはファイルを配信 | E-08: L167-186 | ○ |
| C-52 | serveSourcesTarはtarballを生成 | E-08: L188-244 | ○ |
| C-53 | serveWasmはWASMをビルド・配信 | E-08: L246-279 | ○ |
| C-54 | buildWasmBinaryはWASMをビルド | E-08: L285-425 | ○ |
| C-55 | openBrowserTabはブラウザを開く | E-08: L438-458 | ○ |

### aro モジュール（UT-LCM-056～064）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | aroモジュールにテストブロックが存在 | E-09: L28-41（test block） | ○ |
| C-57 | UCNKind.classifyはUCNを分類 | E-10: L22-43 | ○ |
| C-58 | 不完全なUCNはincompleteを返す | E-10: L27, L33 | ○ |
| C-59 | Preprocessor.initは初期化 | E-11: L289-299 | ○ |
| C-60 | Macro.eqlはマクロを比較 | E-11: L190-202 | ○ |
| C-61 | Macro.isBuiltinはビルトインを判定 | E-11: L208-210 | ○ |
| C-62 | IfContext.getはコンテキストを取得 | E-11: L47-49 | ○ |
| C-63 | IfContext.incrementはレベルを増加 | E-11: L55-58 | ○ |
| C-64 | IfContext.incrementはオーバーフローを検出 | E-11: L56-57 | ○ |

### translate-c（UT-LCM-065～074）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | translateはC→Zig変換 | E-12: L177-240 | ○ |
| C-66 | getMangleはマングル番号を生成 | E-12: L78-81 | ○ |
| C-67 | locStrは位置を文字列化 | E-12: L84-92 | ○ |
| C-68 | addTopLevelDeclは宣言を追加 | E-12: L99-105 | ○ |
| C-69 | failDeclはエラー宣言を生成 | E-12: L118-161 | ○ |
| C-70 | builtin_typedef_mapは型をマップ | E-12: L380-393 | ○ |
| C-71 | transTypeDefはtypedefを変換 | E-12: L395-436 | ○ |
| C-72 | transRecordDeclはstructを変換 | E-12: L453-500+ | ○ |
| C-73 | mangleWeakGlobalNameは名前をマングル | E-12: L438-451 | ○ |
| C-74 | isSelfDefinedMacroは自己定義マクロを検出 | E-12: L313-323 | ○ |

### resinator（UT-LCM-075～097）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | Lexer.initはレクサーを初期化 | E-13: L227-237 | ○ |
| C-76 | Lexer.nextはトークンを取得 | E-13: L251-257 | ○ |
| C-77 | nextWhitespaceDelimeterOnlyは空白区切り | E-13: L266-300+ | ○ |
| C-78 | Token.sliceはスライスを返す | E-13: L61-63 | ○ |
| C-79 | Token.calculateColumnは列を計算 | E-13: L66-75 | ○ |
| C-80 | Token.isStringLiteralは文字列リテラルを判定 | E-13: L117-119 | ○ |
| C-81 | LineHandler.incrementLineNumberは行番号増加 | E-13: L139-148 | ○ |
| C-82 | currentIndexFormsLineEndingPairはCRLFを検出 | E-13: L158-177 | ○ |
| C-83 | UnfinishedStringLiteralエラーが定義 | E-13: L181 | ○ |
| C-84 | IllegalByteエラーが定義 | E-13: L185 | ○ |
| C-85 | resinator/parse.zig存在 | **根拠なし（ファイル未読）** | △ |
| C-86 | resinator/compile.zig存在 | **根拠なし（ファイル未読）** | △ |
| C-87 | resinator/errors.zig存在 | E-13: L8で参照 | ○ |
| C-88 | resinator/literals.zig存在 | E-13: L9で参照 | ○ |
| C-89 | resinator/code_pages.zig存在 | E-13: L10で参照 | ○ |
| C-90 | resinator/cvtres.zig存在 | **根拠なし（ファイル未読）** | △ |
| C-91 | resinator/bmp.zig存在 | **根拠なし（ファイル未読）** | △ |
| C-92 | resinator/ico.zig存在 | **根拠なし（ファイル未読）** | △ |
| C-93 | resinator/ani.zig存在 | **根拠なし（ファイル未読）** | △ |
| C-94 | resinator/res.zig存在 | **根拠なし（ファイル未読）** | △ |
| C-95 | resinator/preprocess.zig存在 | **根拠なし（ファイル未読）** | △ |
| C-96 | resinator/source_mapping.zig存在 | E-13: L12で参照 | ○ |
| C-97 | resinator/lang.zig存在 | **根拠なし（ファイル未読）** | △ |

### translate-c サブモジュール（UT-LCM-098～103）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | translate-c/ast.zig存在 | E-12: L14で参照 | ○ |
| C-99 | translate-c/Scope.zig存在 | E-12: L20で参照 | ○ |
| C-100 | translate-c/MacroTranslator.zig存在 | E-12: L18で参照 | ○ |
| C-101 | translate-c/builtins.zig存在 | E-12: L16で参照 | ○ |
| C-102 | translate-c/helpers.zig存在 | E-12: L17で参照 | ○ |
| C-103 | translate-c/PatternList.zig存在 | E-12: L19で参照 | ○ |

### aro backend（UT-LCM-104～110）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-104 | aro/backend/Ir.zig存在 | E-09: L20で参照 | ○ |
| C-105 | aro/backend/Object.zig存在 | E-09: L21で参照 | ○ |
| C-106 | aro/backend/Interner.zig存在 | E-09: L19で参照 | ○ |
| C-107 | aro/backend/Assembly.zig存在 | E-09: L23で参照 | ○ |
| C-108 | aro/aro/Compilation.zig存在 | E-09: L2で参照 | ○ |
| C-109 | aro/aro/Parser.zig存在 | E-09: L6で参照 | ○ |
| C-110 | aro/aro/Diagnostics.zig存在 | E-09: L3で参照 | ○ |

## 4) 不足情報（Unknown / Missing）
- resinator サブモジュールの一部ファイル（parse.zig, compile.zig, cvtres.zig, bmp.zig, ico.zig, ani.zig, res.zig, preprocess.zig, lang.zig）は詳細を確認していない
  - 候補：ファイル読み込みによる内容確認 / Glob結果から存在は確認済み
- aro/backend サブモジュールの詳細実装未確認
  - 候補：各ファイルの読み込みによる関数シグネチャ確認

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: build_runner.zig, objcopy.zig, reduce.zig, libc.zig, util.zig, test_runner.zig, std-docs.zig
  - ソースコードを詳細に読み込み、テストケースを網羅的に生成
- **1（中リスク）**: aro/aro サブモジュール, translate-c サブモジュール
  - 先頭部分のみ確認、全体の網羅性は要確認
- **2（高リスク）**: resinator の一部ファイル
  - ファイル存在のみ確認、内容未確認

## 6) レビュアーチェックリスト（最小）
- [ ] objcopy.zig の既存テスト（L674-821）とテストケースの整合性確認
- [ ] resinator サブモジュールの各ファイル内容を確認し、テストケースの妥当性検証
- [ ] aro/backend サブモジュールの関数シグネチャを確認し、テストケースの網羅性検証
- [ ] translate-c の複雑な変換ロジック（構造体、共用体、関数ポインタ等）のテストケース追加検討
- [ ] 既存の単体テスト（test ブロック）との重複確認
- [ ] 優先度「高」のテストケースから実装着手の検討
