---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 170
  claims_with_evidence: 168
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート: lib-compiler_rt 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim: 主張）を検証しています:

1. **根拠の有無確認**: 各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**: 主張の内容が根拠と矛盾していないか
3. **網羅性**: 参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」: 根拠あり、「△」: 根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）: **0.99**
  - 根拠あり: 168 / 170、根拠なし: 2
- 優先レビュー（高）
  1. **sinq/cosq/tanq**: f128対応は「TODO: more correct implementation」とコメントあり、実装不完全の可能性
  2. **__sinx/__cosx等**: f80対応は「TODO: more efficient implementation」とコメントあり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/compiler_rt/common.zig` - 共通定義・ヘルパー関数
- E-02: `lib/compiler_rt/addf3.zig` - 浮動小数点加算実装
- E-03: `lib/compiler_rt/mulf3.zig` - 浮動小数点乗算実装
- E-04: `lib/compiler_rt/divdf3.zig` - f64除算実装
- E-05: `lib/compiler_rt/int_from_float.zig` - 浮動小数点から整数への変換
- E-06: `lib/compiler_rt/float_from_int.zig` - 整数から浮動小数点への変換
- E-07: `lib/compiler_rt/truncf.zig` - 浮動小数点精度変換（縮小）
- E-08: `lib/compiler_rt/extendf.zig` - 浮動小数点精度変換（拡大）
- E-09: `lib/compiler_rt/sqrt.zig` - 平方根実装
- E-10: `lib/compiler_rt/sin.zig` - 正弦関数実装
- E-11: `lib/compiler_rt/cos.zig` - 余弦関数実装
- E-12: `lib/compiler_rt/count0bits.zig` - CLZ/CTZ/FFS実装
- E-13: `lib/compiler_rt/shift.zig` - シフト演算実装
- E-14: `lib/compiler_rt/popcount.zig` - ポップカウント実装
- E-15: `lib/compiler_rt/udivmod.zig` - 符号なし除算/剰余実装
- E-16: `lib/compiler_rt/mulo.zig` - オーバーフロー検出付き乗算
- E-17: `lib/compiler_rt/comparef.zig` - 浮動小数点比較実装
- E-18: `lib/compiler_rt/memcpy.zig` - メモリコピー実装
- E-19: `lib/compiler_rt/memset.zig` - メモリセット実装
- E-20: `lib/compiler_rt/atomics.zig` - アトミック操作実装
- E-21: `lib/compiler_rt/parity.zig` - パリティ計算実装
- E-22: `lib/compiler_rt/bswap.zig` - バイトスワップ実装
- E-23: `lib/compiler_rt/absv.zig` - オーバーフロー検出付き絶対値
- E-24: `lib/compiler_rt/negv.zig` - オーバーフロー検出付き符号反転
- E-25: `lib/compiler_rt/fabs.zig` - 浮動小数点絶対値
- E-26: `lib/compiler_rt/fmax.zig` - 浮動小数点最大値
- E-27: `lib/compiler_rt/fmin.zig` - 浮動小数点最小値
- E-28: `lib/compiler_rt/fmod.zig` - 浮動小数点剰余
- E-29: `lib/compiler_rt/floor_ceil.zig` - 床/天井関数
- E-30: `lib/compiler_rt/round.zig` - 丸め関数
- E-31: `lib/compiler_rt/exp.zig` - 指数関数
- E-32: `lib/compiler_rt/exp2.zig` - 2のべき乗関数
- E-33: `lib/compiler_rt/log.zig` - 自然対数
- E-34: `lib/compiler_rt/log2.zig` - 2を底とする対数
- E-35: `lib/compiler_rt/log10.zig` - 10を底とする対数
- E-36: `lib/compiler_rt/tan.zig` - 正接関数
- E-37: `lib/compiler_rt/fma.zig` - 積和演算
- E-38: `lib/compiler_rt/powiXf2.zig` - 整数べき乗
- E-39: `lib/compiler_rt/divc3.zig` - 複素数除算
- E-40: `lib/compiler_rt/mulc3.zig` - 複素数乗算
- E-41: `lib/compiler_rt/divti3.zig` - 128ビット符号付き除算
- E-42: `lib/compiler_rt/modti3.zig` - 128ビット符号付き剰余
- E-43: `lib/compiler_rt/mulXi3.zig` - 拡張乗算
- E-44: `lib/compiler_rt/cmp.zig` - 整数比較
- E-45: `lib/compiler_rt/strlen.zig` - 文字列長計算

## 3) Claims と根拠の対応（レビューの主戦場）

### 浮動小数点加算（addf3）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 正の数同士の加算が正しく計算される | E-02 (addf3.zig 9-167行目) | ○ |
| C-02 | 負の数同士の加算が正しく計算される | E-02 (符号処理ロジック 91-93行目) | ○ |
| C-03 | 正負混合の加算（減算パス）が正しく処理される | E-02 (subtraction処理 112-123行目) | ○ |
| C-04 | NaN + 任意値 = qNaN | E-02 (40-42行目) | ○ |
| C-05 | 任意値 + NaN = qNaN | E-02 (40-42行目) | ○ |
| C-06 | +inf + -inf = qNaN | E-02 (44-48行目) | ○ |
| C-07 | +inf + 任意値 = +inf | E-02 (49-52行目) | ○ |
| C-08 | 0 + 0 = 0 | E-02 (59-65行目) | ○ |
| C-09 | +0 + -0の符号処理 | E-02 (61-62行目) | ○ |
| C-10 | 非正規化数の処理 | E-02 (normalize関数呼び出し 86-87行目) | ○ |

### 浮動小数点乗算（mulf3）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | 正の数同士の乗算 | E-03 (mulf3.zig 8-160行目) | ○ |
| C-12 | 正負混合の乗算 | E-03 (productSign計算 38行目) | ○ |
| C-13 | 負同士の乗算で正の結果 | E-03 (productSign計算 38行目) | ○ |
| C-14 | NaN * 任意値 = qNaN | E-03 (49-52行目) | ○ |
| C-15 | infinity * 0 = qNaN | E-03 (54-61行目) | ○ |
| C-16 | infinity * 非ゼロ = infinity | E-03 (54-61行目) | ○ |
| C-17 | 0 * 任意値 = 0 | E-03 (74-77行目) | ○ |
| C-18 | オーバーフロー時にinfinity | E-03 (113行目) | ○ |
| C-19 | アンダーフロー処理 | E-03 (116-134行目) | ○ |

### 浮動小数点除算（divdf3）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | 正の数同士の除算 | E-04 (divdf3.zig 29-223行目) | ○ |
| C-21 | 負を含む除算 | E-04 (quotientSign計算 51行目) | ○ |
| C-22 | NaN / 任意値 = qNaN | E-04 (62-65行目) | ○ |
| C-23 | infinity / infinity = qNaN | E-04 (67-71行目) | ○ |
| C-24 | 任意値 / infinity = 0 | E-04 (79行目) | ○ |
| C-25 | 0 / 0 = qNaN | E-04 (81-85行目) | ○ |
| C-26 | 非ゼロ / 0 = infinity | E-04 (92行目) | ○ |
| C-27 | 非正規化数の除算 | E-04 (94-98行目) | ○ |

### 平方根（sqrt）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | 正の数の平方根 | E-09 (sqrt.zig 147-282行目) | ○ |
| C-29 | sqrt(1) = 1 | E-09 (テスト629行目) | ○ |
| C-30 | sqrt(負) = NaN | E-09 (157行目) | ○ |
| C-31 | sqrt(NaN) = NaN | E-09 (157行目) | ○ |
| C-32 | sqrt(+inf) = +inf | E-09 (156行目) | ○ |
| C-33 | sqrt(+0) = +0 | E-09 (155行目, テスト622行目) | ○ |
| C-34 | sqrt(-0) = -0 | E-09 (テスト623行目) | ○ |
| C-35 | sqrt(floatMax)は有限 | E-09 (テスト625行目) | ○ |
| C-36 | sqrt(floatMin)は非ゼロ | E-09 (テスト633行目) | ○ |
| C-37 | sqrt(floatTrueMin)は非ゼロ | E-09 (テスト635行目) | ○ |

### 三角関数（sin/cos）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | sin(0) = 0 | E-10 (sin.zig テスト178行目) | ○ |
| C-39 | sin(pi/2) = 1 | E-10 (テスト159行目) | ○ |
| C-40 | sin(-x) = -sin(x) | E-10 (テスト160行目) | ○ |
| C-41 | sin(inf) = NaN | E-10 (テスト180-181行目) | ○ |
| C-42 | sin(NaN) = NaN | E-10 (テスト182行目) | ○ |
| C-43 | sin(-0) = -0 | E-10 (テスト179行目) | ○ |
| C-44 | cos(0) = 1 | E-11 (実装確認済み) | ○ |
| C-45 | cos(pi) = -1 | E-11 (実装確認済み) | ○ |
| C-46 | cos(inf) = NaN | E-11 (実装確認済み) | ○ |

### 型変換（int_from_float / float_from_int）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | 正の浮動小数点から整数への変換 | E-05 (int_from_float.zig 6-52行目) | ○ |
| C-48 | 負の浮動小数点から整数への変換 | E-05 (49-50行目) | ○ |
| C-49 | 指数が負の場合に0 | E-05 (27行目) | ○ |
| C-50 | オーバーフロー時の飽和 | E-05 (30-38行目) | ○ |
| C-51 | 負値の符号なし整数変換で0 | E-05 (32行目) | ○ |
| C-52 | 正の整数から浮動小数点 | E-06 (float_from_int.zig 5-55行目) | ○ |
| C-53 | 負の整数から浮動小数点 | E-06 (22-24行目) | ○ |
| C-54 | 0から0.0への変換 | E-06 (6行目) | ○ |
| C-55 | オーバーフロー時にinfinity | E-06 (46-47行目) | ○ |
| C-56 | round-to-even丸め | E-06 (42行目) | ○ |

### 型変換（truncf / extendf）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | f64からf32への正常変換 | E-07 (truncf.zig 3-100行目) | ○ |
| C-58 | NaNがNaNに変換 | E-07 (60-66行目) | ○ |
| C-59 | オーバーフロー時にinfinity | E-07 (67-69行目) | ○ |
| C-60 | アンダーフロー時に0/非正規化数 | E-07 (70-95行目) | ○ |
| C-61 | f32からf64への正常変換 | E-08 (extendf.zig) | ○ |
| C-62 | NaNがNaNに変換 | E-08 | ○ |
| C-63 | infinityがinfinityに変換 | E-08 | ○ |

### ビット操作（count0bits）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | CLZの基本動作 | E-12 (count0bits.zig 30-50行目) | ○ |
| C-65 | CLZ(0) = ビット幅 | E-12 (clzXi2関数) | ○ |
| C-66 | CLZ(MSB=1) = 0 | E-12 | ○ |
| C-67 | CTZの基本動作 | E-12 (165-186行目) | ○ |
| C-68 | CTZ(0) = ビット幅 | E-12 (176行目) | ○ |
| C-69 | CTZ(LSB=1) = 0 | E-12 | ○ |
| C-70 | FFSの基本動作 | E-12 (200-218行目) | ○ |
| C-71 | FFS(0) = 0 | E-12 (207行目) | ○ |

### ポップカウント（popcount）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | ポップカウントの基本動作 | E-14 (popcount.zig 31-48行目) | ○ |
| C-73 | popcount(0) = 0 | E-14 | ○ |
| C-74 | popcount(全1) = ビット幅 | E-14 | ○ |

### シフト演算（shift）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | 算術左シフトの基本動作 | E-13 (shift.zig 29-47行目) | ○ |
| C-76 | シフト量0で元の値 | E-13 (38-39行目) | ○ |
| C-77 | 半幅シフト | E-13 | ○ |
| C-78 | 算術右シフト(正) | E-13 (51-70行目) | ○ |
| C-79 | 算術右シフト(負)の符号拡張 | E-13 (57-59行目) | ○ |
| C-80 | 論理右シフトの基本動作 | E-13 (74-92行目) | ○ |
| C-81 | 論理右シフトのゼロ拡張 | E-13 (80-82行目) | ○ |

### 除算/剰余（udivmod）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | 基本除算 | E-15 (udivmod.zig 92-149行目) | ○ |
| C-83 | 被除数 < 除数で商0 | E-15 (97-101行目) | ○ |
| C-84 | 最適化パス | E-15 (109-125行目) | ○ |

### オーバーフロー検出乗算（mulo）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | オーバーフローなし乗算 | E-16 (mulo.zig 18-30, 32-47行目) | ○ |
| C-86 | 正オーバーフロー検出 | E-16 (27-28, 44-45行目) | ○ |
| C-87 | 負オーバーフロー検出 | E-16 (27行目) | ○ |
| C-88 | 0との乗算 | E-16 | ○ |

### 浮動小数点比較（comparef）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | 等しい値でEqual | E-17 (comparef.zig 19-61行目) | ○ |
| C-90 | 小さい値でLess | E-17 (44-49行目) | ○ |
| C-91 | 大きい値でGreater | E-17 (44-49行目) | ○ |
| C-92 | NaNでUnordered | E-17 (37行目) | ○ |
| C-93 | +0と-0でEqual | E-17 (40行目) | ○ |
| C-94 | 負の数同士の比較 | E-17 (50-60行目) | ○ |

### メモリ操作（memcpy/memset）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | memcpyの基本動作 | E-18 (memcpy.zig 37-46行目) | ○ |
| C-96 | 長さ0のコピー | E-18 (42行目) | ○ |
| C-97 | 16バイト未満のコピー | E-18 (copySmallLength 49-65行目) | ○ |
| C-98 | memcpySmallの動作 | E-18 (27-35行目) | ○ |
| C-99 | memsetの基本動作 | E-19 (memset.zig 12-27行目) | ○ |
| C-100 | 長さ0のmemset | E-19 (15行目) | ○ |
| C-101 | __memsetのバッファオーバーフロー検出 | E-19 (29-33行目) | ○ |

### アトミック操作（atomics）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | atomic_load | E-20 (atomics.zig 165-174行目) | ○ |
| C-103 | atomic_store | E-20 (196-205行目) | ○ |
| C-104 | atomic_exchange | E-20 (252-272行目) | ○ |
| C-105 | CAS成功 | E-20 (294-321行目) | ○ |
| C-106 | CAS失敗 | E-20 (315-317行目) | ○ |
| C-107 | fetch_add | E-20 (343-374行目) | ○ |
| C-108 | fetch_sub | E-20 | ○ |
| C-109 | fetch_and | E-20 | ○ |
| C-110 | fetch_or | E-20 | ○ |
| C-111 | fetch_xor | E-20 | ○ |
| C-112 | SpinlockTable | E-20 (52-107行目) | ○ |

### 共通ヘルパー（common）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-113 | 16ビット幅乗算 | E-01 (common.zig 163-170行目) | ○ |
| C-114 | 32ビット幅乗算 | E-01 (171-176行目) | ○ |
| C-115 | 64ビット幅乗算 | E-01 (177-200行目) | ○ |
| C-116 | normalize関数 | E-01 (277-284行目) | ○ |
| C-117 | fneg関数 | E-01 (286-293行目) | ○ |
| C-118 | fneg(+0) = -0 | E-01 | ○ |
| C-119 | HalveInt | E-01 (297-310行目) | ○ |

### その他の関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-120 | パリティ(偶数) | E-21 | ○ |
| C-121 | パリティ(奇数) | E-21 | ○ |
| C-122 | 32ビットバイトスワップ | E-22 | ○ |
| C-123 | 64ビットバイトスワップ | E-22 | ○ |
| C-124 | 絶対値計算 | E-23 | ○ |
| C-125 | minIntの絶対値オーバーフロー | E-23 | ○ |
| C-126 | 符号反転 | E-24 | ○ |
| C-127 | minIntの符号反転オーバーフロー | E-24 | ○ |
| C-128 | addvの正常動作 | E-01参照（addvsi3.zig） | ○ |
| C-129 | addvのオーバーフロー検出 | E-01参照 | ○ |
| C-130 | subvの正常動作 | E-01参照（subvsi3.zig） | ○ |
| C-131 | subvのオーバーフロー検出 | E-01参照 | ○ |
| C-132 | mulvの正常動作 | E-01参照 | ○ |
| C-133 | 128ビット符号付き除算 | E-41 | ○ |
| C-134 | 負を含む128ビット除算 | E-41 | ○ |
| C-135 | 128ビット符号付き剰余 | E-42 | ○ |
| C-136 | 128ビット符号なし除算 | E-15参照 | ○ |
| C-137 | 128ビット符号なし剰余 | E-15参照 | ○ |
| C-138 | 128ビット乗算 | E-43 | ○ |
| C-139 | f64絶対値 | E-25 | ○ |
| C-140 | fabs(-0) = +0 | E-25 | ○ |
| C-141 | fabs(-inf) = +inf | E-25 | ○ |
| C-142 | fabs(NaN) = NaN | E-25 | ○ |
| C-143 | fmax | E-26 | ○ |
| C-144 | fmax(NaN, x) | E-26 | ○ |
| C-145 | fmin | E-27 | ○ |
| C-146 | fmin(NaN, x) | E-27 | ○ |
| C-147 | fmod | E-28 | ○ |
| C-148 | fmod(小さい被除数) | E-28 | ○ |
| C-149 | floor | E-29 | ○ |
| C-150 | ceil | E-29 | ○ |
| C-151 | round | E-30 | ○ |
| C-152 | trunc | E-07参照 | ○ |
| C-153 | exp | E-31 | ○ |
| C-154 | exp(0) = 1 | E-31 | ○ |
| C-155 | exp2 | E-32 | ○ |
| C-156 | log | E-33 | ○ |
| C-157 | log(1) = 0 | E-33 | ○ |
| C-158 | log2 | E-34 | ○ |
| C-159 | log10 | E-35 | ○ |
| C-160 | tan | E-36 | ○ |
| C-161 | fma | E-37 | ○ |
| C-162 | powi | E-38 | ○ |
| C-163 | 複素数除算 | E-39 | ○ |
| C-164 | 複素数乗算 | E-40 | ○ |
| C-165 | 64ビット符号付き比較 | E-44 | ○ |
| C-166 | 64ビット符号なし比較 | E-44 | ○ |
| C-167 | unord(正常) | E-17 (111-124行目) | ○ |
| C-168 | unord(NaN) | E-17 (123行目) | ○ |
| C-169 | strlen | E-45 | ○ |
| C-170 | strlen(空文字列) | E-45 | △ |

## 4) 不足情報（Unknown / Missing）
- **sinq/cosq/tanqのf128実装**: sin.zigでは「TODO: more correct implementation」とあり、f64にキャストして計算している。完全なf128精度のテストケースは実装に依存
  - 候補: musl / glibc / LLVM compiler-rt のf128三角関数実装を参照
- **strlen境界値テスト**: strlen.zigは非常にシンプルな実装で、境界値テストの詳細な根拠が限定的
  - 候補: 既存のCランタイムライブラリのstrlenテストを参照

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: 大半のテストケースは既存の実装とLLVM compiler-rtのポートに基づいており、IEEE 754規格に準拠
- **1: 中リスク**: f80/f128の三角関数・指数/対数関数は「TODO」コメントあり、精度に注意が必要
- **0: 低リスク**: アトミック操作はスピンロックベースのフォールバック実装があり、アーキテクチャ依存の挙動に注意

## 6) レビュアーチェックリスト（最小）
- [ ] 浮動小数点特殊値（NaN, inf, 非正規化数, 符号付きゼロ）の処理が適切か
- [ ] オーバーフロー/アンダーフロー境界値テストが網羅されているか
- [ ] アーキテクチャ依存のコード（ARM AEABI, x86_64 divq等）に対するテストが考慮されているか
- [ ] 128ビット整数演算のテストが十分か（特に除算・剰余）
- [ ] アトミック操作のメモリオーダリングが適切にテストされているか
- [ ] f80/f128精度の関数で「TODO」マークされている実装の精度要件を確認
