---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 135
  claims_with_evidence: 135
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lib-docs単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：135 / 135、根拠なし：0
- 優先レビュー（高）
  1. **WASM Export関数**：WASM環境でのみ検証可能なため実機テスト必要
  2. **パース処理全般**：複雑なMarkdownケースの網羅性確認推奨
  3. **HTMLレンダリング**：エスケープ処理のセキュリティ観点レビュー推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/docs/wasm/main.zig` - メインWASMモジュール、エクスポート関数群
- E-02: `lib/docs/wasm/markdown.zig` - Markdownパーサー/レンダラーモジュール
- E-03: `lib/docs/wasm/markdown/Parser.zig` - Markdownパーサー実装
- E-04: `lib/docs/wasm/markdown/Document.zig` - Markdownドキュメントデータ構造
- E-05: `lib/docs/wasm/markdown/renderer.zig` - HTMLレンダラー実装
- E-06: `lib/docs/wasm/html_render.zig` - ZigソースコードHTMLレンダリング
- E-07: `lib/docs/wasm/Decl.zig` - 宣言（Declaration）データ構造
- E-08: `lib/docs/wasm/Walk.zig` - AST走査・スコープ管理

## 3) Claims と根拠の対応（レビューの主戦場）

### Parser関連（UT-DOC-001〜UT-DOC-045）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Parser.initがrootノードを含むParserを返す | E-03 L179-187 | ○ |
| C-02 | Parser.deinitがリソースを解放する | E-03 L189-197 | ○ |
| C-03 | Parser.feedLineが行をパースする | E-03 L199-298 | ○ |
| C-04 | 見出しレベル1-6が正しくパースされる | E-03 L764-784, E-02 L669-689 test | ○ |
| C-05 | コードブロックが正しくパースされる | E-03 L786-806, E-02 L705-745 test | ○ |
| C-06 | リストが正しくパースされる | E-03 L577-617, E-02 L174-299 test | ○ |
| C-07 | テーブルが正しくパースされる | E-03 L624-738, E-02 L479-667 test | ○ |
| C-08 | 引用ブロックが正しくパースされる | E-03 L808-813, E-02 L747-793 test | ○ |
| C-09 | isThematicBreakが区切り線を判定する | E-03 L815-830, E-02 L818-834 test | ○ |
| C-10 | parseTableHeaderDelimiterCellがテストで検証済み | E-03 L740-757 test | ○ |

### Document関連（UT-DOC-046〜UT-DOC-052）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | Document.deinitがリソースを解放する | E-04 L155-160 | ○ |
| C-12 | Document.renderがHTMLを生成する | E-04 L162-166 | ○ |
| C-13 | Document.extraDataが追加データを取得する | E-04 L172-184 | ○ |
| C-14 | Document.extraChildrenが子ノードを取得する | E-04 L186-189 | ○ |
| C-15 | Document.stringが文字列を取得する | E-04 L191-194 | ○ |
| C-16 | Node.ListStart.asNumberが番号を返す | E-04 L127-131 | ○ |

### Renderer関連（UT-DOC-053〜UT-DOC-060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | Renderer.renderがドキュメントをHTMLに変換する | E-05 L24-26 | ○ |
| C-18 | Renderer.renderDefaultが各ノードタイプを処理する | E-05 L28-184 | ○ |
| C-19 | renderInlineNodeTextがインラインテキストを抽出する | E-05 L189-232 | ○ |
| C-20 | fmtHtmlがHTMLエスケープを行う | E-05 L234-246, E-06 L337-348 | ○ |

### html_render関連（UT-DOC-061〜UT-DOC-067）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | fileSourceHtmlがZigソースをHTMLに変換する | E-06 L33-321 | ○ |
| C-22 | キーワードがtok-kwクラスでハイライトされる | E-06 L102-152 | ○ |
| C-23 | 文字列リテラルがtok-strクラスでハイライトされる | E-06 L154-161 | ○ |
| C-24 | 数値リテラルがtok-numberクラスでハイライトされる | E-06 L248-252 | ○ |
| C-25 | ビルトインがtok-builtinクラスでハイライトされる | E-06 L163-167 | ○ |
| C-26 | appendEscapedがHTMLエスケープを行う | E-06 L337-348 | ○ |
| C-27 | resolveDeclLinkが宣言リンクを解決する | E-06 L396-402 | ○ |

### Decl関連（UT-DOC-068〜UT-DOC-081）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | Decl.extra_infoが宣言情報を取得する | E-07 L35-86 | ○ |
| C-29 | Decl.is_pubが公開判定を行う | E-07 L31-33 | ○ |
| C-30 | Decl.value_nodeが値ノードを取得する | E-07 L88-113 | ○ |
| C-31 | Decl.categorizeがカテゴリを判定する | E-07 L115-117 | ○ |
| C-32 | Decl.get_childが子宣言を取得する | E-07 L119-141 | ○ |
| C-33 | Decl.lookupが名前でルックアップする | E-07 L181-190 | ○ |
| C-34 | Decl.fqnが完全修飾名を取得する | E-07 L192-201 | ○ |
| C-35 | Decl.findがパスで宣言を検索する | E-07 L255-268 | ○ |
| C-36 | Decl.findFirstDocCommentがドキュメントコメントを検索する | E-07 L244-253 | ○ |
| C-37 | Decl.Index.getがDeclポインタを取得する | E-07 L26-28 | ○ |

### Walk関連（UT-DOC-082〜UT-DOC-095）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | Walk.add_fileがファイルを追加する | E-08 L388-411 | ○ |
| C-39 | Walk.Fileのlookup_tokenがトークンから宣言を検索する | E-08 L57-60 | ○ |
| C-40 | Walk.File.Index.getがFileポインタを取得する | E-08 L76-78 | ○ |
| C-41 | Walk.File.Index.get_astがASTを取得する | E-08 L80-82 | ○ |
| C-42 | Walk.File.Index.pathがパスを取得する | E-08 L84-86 | ○ |
| C-43 | Walk.File.Index.findRootDeclがルート宣言を取得する | E-08 L88-90 | ○ |
| C-44 | Walk.File.Index.categorize_declが宣言をカテゴライズする | E-08 L92-135 | ○ |
| C-45 | Walk.Scope.lookupがスコープ内で名前を検索する | E-08 L498-520 | ○ |
| C-46 | Walk.Scope.get_childが子を取得する | E-08 L488-496 | ○ |
| C-47 | Walk.isPrimitiveNonTypeがプリミティブを判定する | E-08 L1074-1079 | ○ |

### main.zig WASM Export関連（UT-DOC-096〜UT-DOC-119）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | allocがメモリを割り当てる | E-01 L57-60 | ○ |
| C-49 | unpackがtarファイルを展開する | E-01 L62-69, L780-817 | ○ |
| C-50 | query_beginがクエリバッファを確保する | E-01 L76-79 | ○ |
| C-51 | query_execが検索を実行する | E-01 L86-94 | ○ |
| C-52 | decl_error_setがエラーセットを取得する | E-01 L268-270 | ○ |
| C-53 | decl_fieldsがフィールドを取得する | E-01 L378-380 | ○ |
| C-54 | decl_paramsがパラメータを取得する | E-01 L382-384 | ○ |
| C-55 | decl_fn_proto_htmlが関数プロトタイプHTMLを生成する | E-01 L519-544 | ○ |
| C-56 | decl_source_htmlがソースHTMLを生成する | E-01 L546-554 | ○ |
| C-57 | decl_fqnが完全修飾名を取得する | E-01 L568-573 | ○ |
| C-58 | decl_nameが宣言名を取得する | E-01 L630-642 | ○ |
| C-59 | decl_docs_htmlがドキュメントHTMLを生成する | E-01 L644-651 | ○ |
| C-60 | decl_type_htmlが型HTMLを生成する | E-01 L755-776 | ○ |
| C-61 | decl_category_nameがカテゴリ名を取得する | E-01 L599-628 | ○ |
| C-62 | find_module_rootがモジュールルートを取得する | E-01 L828-833 | ○ |
| C-63 | find_file_rootがファイルルートを取得する | E-01 L845-848 | ○ |
| C-64 | find_declが宣言を検索する | E-01 L853-870 | ○ |
| C-65 | categorize_declが宣言をカテゴライズする | E-01 L879-899 | ○ |
| C-66 | namespace_membersが名前空間メンバーを取得する | E-01 L912-928 | ○ |
| C-67 | render_docsがドキュメントをレンダリングする | E-01 L671-740 | ○ |
| C-68 | resolve_decl_pathがパスから宣言を解決する | E-01 L742-753 | ○ |
| C-69 | ascii_lowerが小文字化する | E-01 L819-821 | ○ |
| C-70 | count_scalarが文字をカウントする | E-01 L930-937 | ○ |

### InlineParser関連（UT-DOC-120〜UT-DOC-130）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | InlineParser.parseがインラインコンテンツをパースする | E-03 L984-1018 | ○ |
| C-72 | InlineParser.parseLinkがリンクをパースする | E-03 L1023-1076 | ○ |
| C-73 | InlineParser.parseAutolinkが自動リンクをパースする | E-03 L1099-1141 | ○ |
| C-74 | InlineParser.parseEmphasisが強調をパースする | E-03 L1255-1328 | ○ |
| C-75 | InlineParser.parseCodeSpanがコードスパンをパースする | E-03 L1387-1426 | ○ |
| C-76 | InlineParser.parseTextAutolinkがテキスト自動リンクをパースする | E-03 L1146-1233 | ○ |
| C-77 | InlineParser.isPreTextAutolinkが前条件を判定する | E-03 L1236-1241 | ○ |
| C-78 | InlineParser.isPostTextAutolinkが後条件を判定する | E-03 L1245-1250 | ○ |
| C-79 | TextIterator.nextがテキストを順次取得する | E-03 L1522-1539 | ○ |
| C-80 | TextIterator.nextがエスケープを処理する | E-03 L1524-1537 | ○ |
| C-81 | TextIterator.nextCodepointが無効UTF-8を置換する | E-03 L1542-1566 | ○ |

### Block関連（UT-DOC-131〜UT-DOC-133）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | Block.canAcceptがブロック種別に応じた受け入れ種別を返す | E-03 L119-138 | ○ |
| C-83 | Block.matchが継続行をマッチする | E-03 L144-176 | ○ |

### ErrorIdentifier関連（UT-DOC-134〜UT-DOC-135）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | ErrorIdentifier.hasDocsがドキュメント有無を判定する | E-01 L231-237 | ○ |
| C-85 | ErrorIdentifier.htmlがHTMLを生成する | E-01 L239-262 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - すべてのテストケースはソースコード内の関数・メソッド定義から導出されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テストケースの根拠はすべてソースコードに基づいている
- 1: 中リスク - WASM環境依存のテスト（UT-DOC-096〜119）は実行環境の準備が必要
- 1: 中リスク - Markdownパーステスト（既存のテストケースがmarkdown.zig内にある）との整合性確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] Parser関連テストケースがmarkdown.zig内の既存テストと整合しているか確認
- [ ] WASM Export関数のテストはWASM実行環境で検証可能か確認
- [ ] HTMLエスケープ処理のセキュリティ観点レビュー（XSS対策など）
- [ ] 境界値テストの網羅性確認（リスト番号上限、見出しレベル上限など）
- [ ] エラーハンドリングテストの網羅性確認（OutOfMemory以外のエラー）
