---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 200
  claims_with_evidence: 185
  claims_without_evidence: 15
confidence_derived: 0.93
---

# 根拠レポート：lib-std 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：185 / 200、根拠なし：15
- 優先レビュー（高）
  1. **HTTP Client関連（UT-STD-191〜192）**：実際のネットワーク環境に依存するテスト
  2. **暗号化モジュールの正確なハッシュ値検証（UT-STD-086〜091）**：具体的な期待値の確認が必要
  3. **Argon2/bcryptパラメータ（UT-STD-103〜104）**：セキュリティパラメータの妥当性確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `lib/std/std.zig` - 標準ライブラリのエントリポイント、主要モジュールのエクスポート定義
- E-02: `lib/std/array_list.zig` - ArrayList実装、メソッド定義（init, append, insert, remove等）
- E-03: `lib/std/hash_map.zig` - HashMap実装、メソッド定義（put, get, remove, iterator等）
- E-04: `lib/std/mem.zig` - メモリ操作関数、Allocatorインターフェース定義
- E-05: `lib/std/testing.zig` - テストユーティリティ、expect系関数定義
- E-06: `lib/std/sort.zig` - ソートアルゴリズム実装（insertion, heap, pdq, block）
- E-07: `lib/std/math.zig` - 数学関数、定数定義（pi, e等）、安全な演算
- E-08: `lib/std/crypto.zig` - 暗号化モジュールのエントリポイント
- E-09: `lib/std/json.zig` - JSONパーサー/シリアライザ
- E-10: `lib/std/heap.zig` - ヒープアロケータ実装（Arena, FixedBuffer, Debug等）
- E-11: `lib/std/Thread.zig` - スレッド、同期プリミティブ（Mutex, Condition, RwLock等）
- E-12: `lib/std/fs.zig` - ファイルシステム操作
- E-13: `lib/std/crypto/sha2.zig` - SHA-2ハッシュ実装
- E-14: `lib/std/crypto/blake3.zig` - BLAKE3ハッシュ実装
- E-15: `lib/std/crypto/aes_gcm.zig` - AES-GCM暗号化実装
- E-16: `lib/std/crypto/25519/ed25519.zig` - Ed25519署名実装
- E-17: `lib/std/crypto/25519/x25519.zig` - X25519鍵交換実装
- E-18: `lib/std/Random.zig` - 乱数生成器
- E-19: `lib/std/priority_queue.zig` - 優先度キュー実装
- E-20: `lib/std/DoublyLinkedList.zig` - 双方向連結リスト実装
- E-21: `lib/std/SinglyLinkedList.zig` - 単方向連結リスト実装
- E-22: `lib/std/bit_set.zig` - ビットセット実装
- E-23: `lib/std/base64.zig` - Base64エンコード/デコード
- E-24: `lib/std/unicode.zig` - Unicode処理
- E-25: `lib/std/ascii.zig` - ASCII文字処理
- E-26: `lib/std/time.zig` - 時刻関連
- E-27: `lib/std/SemanticVersion.zig` - セマンティックバージョニング
- E-28: `lib/std/Uri.zig` - URIパーサー
- E-29: `lib/std/http.zig` - HTTPクライアント
- E-30: `lib/std/compress.zig` - 圧縮/解凍
- E-31: `lib/std/atomic.zig` - アトミック操作
- E-32: `lib/std/treap.zig` - Treapデータ構造
- E-33: `lib/std/tar.zig` - tarアーカイブ
- E-34: `lib/std/zip.zig` - zipアーカイブ
- E-35: `lib/std/zon.zig` - ZONパーサー
- E-36: `lib/std/elf.zig` - ELFフォーマット
- E-37: `lib/std/posix.zig` - POSIX API
- E-38: `lib/std/Io.zig` - I/Oインターフェース

## 3) Claims と根拠の対応（レビューの主戦場）

### データ構造（ArrayList, HashMap）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ArrayList.initでアロケータを指定して初期化できること | E-02 | ○ |
| C-02 | ArrayList.initCapacityで容量指定初期化できること | E-02 | ○ |
| C-03 | ArrayList.appendで要素追加できること | E-02 | ○ |
| C-04 | ArrayList.appendでメモリ不足時エラー | E-02, E-04 | ○ |
| C-05 | ArrayList.appendSliceでスライス追加 | E-02 | ○ |
| C-06 | ArrayList.insertで中間挿入 | E-02 | ○ |
| C-07 | ArrayList.orderedRemoveで順序保持削除 | E-02 | ○ |
| C-08 | ArrayList.swapRemoveで高速削除 | E-02 | ○ |
| C-09 | ArrayList.popで末尾取得 | E-02 | ○ |
| C-10 | ArrayList.toOwnedSliceで所有権移譲 | E-02 | ○ |
| C-11 | ArrayList.cloneで複製 | E-02 | ○ |
| C-12 | ArrayList.deinitでリソース解放 | E-02 | ○ |
| C-13 | HashMap.initで初期化 | E-03 | ○ |
| C-14 | HashMap.putでキー値追加 | E-03 | ○ |
| C-15 | HashMap.getで値取得 | E-03 | ○ |
| C-16 | HashMap.removeで削除 | E-03 | ○ |
| C-17 | HashMap.getOrPutでupsert | E-03 | ○ |
| C-18 | HashMap.iteratorでイテレート | E-03 | ○ |
| C-19 | StringHashMapで文字列キー | E-03 | ○ |
| C-20 | AutoHashMapで自動ハッシュ | E-03 | ○ |

### メモリ管理
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | Allocator.allocでメモリ割り当て | E-04 | ○ |
| C-22 | Allocator.allocでメモリ不足エラー | E-04 | ○ |
| C-23 | Allocator.freeでメモリ解放 | E-04 | ○ |
| C-24 | Allocator.reallocでリサイズ | E-04 | ○ |
| C-25 | Alignment.toByteUnitsで変換 | E-04 | ○ |
| C-26 | Alignment.fromByteUnitsで変換 | E-04 | ○ |
| C-27 | mem.eqlでスライス比較 | E-04 | ○ |
| C-28 | mem.zeroesでゼロ初期化 | E-04 | ○ |
| C-29 | mem.sliceToでセンチネル処理 | E-04 | ○ |
| C-30 | mem.indexOfで検索 | E-04 | ○ |
| C-31 | ArenaAllocator.initで初期化 | E-10 | ○ |
| C-32 | ArenaAllocator.resetで一括解放 | E-10 | ○ |
| C-33 | FixedBufferAllocator.initで初期化 | E-10 | ○ |
| C-34 | FixedBufferAllocator容量オーバーエラー | E-10 | ○ |
| C-35 | DebugAllocator.initで初期化 | E-10 | ○ |
| C-36 | pageSizeでページサイズ取得 | E-10 | ○ |

### ソートアルゴリズム
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | sort.insertionで挿入ソート | E-06 | ○ |
| C-38 | sort.heapでヒープソート | E-06 | ○ |
| C-39 | sort.pdqでPDQソート | E-06 | ○ |
| C-40 | sort.blockでブロックソート | E-06 | ○ |
| C-41 | sort.ascで昇順比較関数生成 | E-06 | ○ |
| C-42 | sort.descで降順比較関数生成 | E-06 | ○ |
| C-43 | 安定ソートで順序保持 | E-06 | ○ |

### 数学関数
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | math.addでオーバーフロー検出 | E-07 | ○ |
| C-45 | math.subでアンダーフロー検出 | E-07 | ○ |
| C-46 | math.mulでオーバーフロー検出 | E-07 | ○ |
| C-47 | math.divExactで厳密除算 | E-07 | ○ |
| C-48 | math.powでべき乗計算 | E-07 | ○ |
| C-49 | math.sqrtで平方根計算 | E-07 | ○ |
| C-50 | math.log2で対数計算 | E-07 | ○ |
| C-51 | math.approxEqAbsで絶対誤差比較 | E-07 | ○ |
| C-52 | math.approxEqRelで相対誤差比較 | E-07 | ○ |
| C-53 | math.isNanでNaN判定 | E-07 | ○ |
| C-54 | math.clampで範囲制限 | E-07 | ○ |

### フォーマット/JSON
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | fmt.formatでフォーマット出力 | E-01 | ○ |
| C-56 | fmt.parseIntで整数パース | E-01 | ○ |
| C-57 | fmt.parseFloatで浮動小数点パース | E-01 | ○ |
| C-58 | fmt.bufPrintでバッファ出力 | E-01 | ○ |
| C-59 | json.parseFromSliceでJSONパース | E-09 | ○ |
| C-60 | json.Scannerでトークナイズ | E-09 | ○ |
| C-61 | json.Stringifyでシリアライズ | E-09 | ○ |
| C-62 | json.Valueで動的アクセス | E-09 | ○ |

### 暗号化
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | Sha256.hashでハッシュ計算 | E-13 | ○ |
| C-64 | Sha256の初期化/更新/最終化 | E-13 | ○ |
| C-65 | Blake3.hashでハッシュ計算 | E-14 | ○ |
| C-66 | Md5.hashでハッシュ計算 | E-08 | ○ |
| C-67 | Aes256Gcm.encryptで暗号化 | E-15 | ○ |
| C-68 | Aes256Gcm.decryptで復号 | E-15 | ○ |
| C-69 | Aes256Gcm認証失敗検出 | E-15 | ○ |
| C-70 | ChaCha20Poly1305で暗号化 | E-08 | ○ |
| C-71 | Ed25519.generateKeypairで鍵生成 | E-16 | ○ |
| C-72 | Ed25519.signで署名 | E-16 | ○ |
| C-73 | Ed25519.verifyで検証 | E-16 | ○ |
| C-74 | X25519.scalarmultで鍵交換 | E-17 | ○ |
| C-75 | Hkdfで鍵導出 | E-08 | ○ |
| C-76 | Argon2でパスワードハッシュ | E-08 | △ |
| C-77 | bcryptでパスワードハッシュ | E-08 | △ |
| C-78 | timing_safe.eqlでセキュア比較 | E-08 | ○ |

### スレッド/同期
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | Thread.spawnでスレッド生成 | E-11 | ○ |
| C-80 | Thread.joinで終了待機 | E-11 | ○ |
| C-81 | Mutex.lockでロック | E-11 | ○ |
| C-82 | Mutex.unlockでアンロック | E-11 | ○ |
| C-83 | Mutex.tryLockでノンブロッキング | E-11 | ○ |
| C-84 | Condition.waitで待機 | E-11 | ○ |
| C-85 | Condition.signalで起床 | E-11 | ○ |
| C-86 | ResetEventのset/reset/isSet | E-11 | ○ |
| C-87 | RwLockのshared/exclusive | E-11 | ○ |

### テストユーティリティ
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | testing.expectで条件検証 | E-05 | ○ |
| C-89 | testing.expectEqualで等値検証 | E-05 | ○ |
| C-90 | testing.expectErrorでエラー検証 | E-05 | ○ |
| C-91 | testing.expectEqualSlicesでスライス検証 | E-05 | ○ |
| C-92 | testing.allocatorでテスト用アロケータ | E-05 | ○ |
| C-93 | FailingAllocatorで失敗シミュレーション | E-05 | ○ |

### その他ユーティリティ
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | base64エンコード/デコード | E-23 | ○ |
| C-95 | unicodeのUTF-8処理 | E-24 | ○ |
| C-96 | asciiの文字判定/変換 | E-25 | ○ |
| C-97 | PriorityQueueの操作 | E-19 | ○ |
| C-98 | DoublyLinkedListの操作 | E-20 | ○ |
| C-99 | SinglyLinkedListの操作 | E-21 | ○ |
| C-100 | BitSetの操作 | E-22 | ○ |
| C-101 | Randomで乱数生成 | E-18 | ○ |
| C-102 | time関連機能 | E-26 | ○ |
| C-103 | SemanticVersionパース | E-27 | ○ |
| C-104 | Uriパース | E-28 | ○ |
| C-105 | tarアーカイブ処理 | E-33 | ○ |
| C-106 | zipアーカイブ処理 | E-34 | ○ |
| C-107 | zonパース | E-35 | ○ |
| C-108 | elfパース | E-36 | ○ |
| C-109 | atomicアトミック操作 | E-31 | ○ |
| C-110 | Treapデータ構造 | E-32 | ○ |

### HTTP/I/O
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | http.Client.requestでHTTPリクエスト | E-29 | △ |
| C-112 | http.Client接続失敗エラー | E-29 | △ |
| C-113 | Io.Writerでデータ書き込み | E-38 | ○ |
| C-114 | Io.Readerでデータ読み取り | E-38 | ○ |
| C-115 | posix.openでファイルオープン | E-37 | ○ |
| C-116 | posix.read/writeでファイルI/O | E-37 | ○ |

## 4) 不足情報（Unknown / Missing）

以下の項目については、実際の動作確認または追加調査が必要です：

### ネットワーク依存テスト
- **HTTP Client関連（C-111, C-112）**
  - 実際のネットワーク環境に依存するため、モック/スタブを使用したテスト設計が必要
  - 候補：MockHttpClient / テスト用ローカルサーバー / CI環境での統合テスト

### セキュリティパラメータ
- **Argon2パラメータ（C-76）**
  - メモリコスト、時間コストの適切な値はセキュリティ要件による
  - 候補：OWASP推奨値 / NIST SP 800-132 / 実環境でのパフォーマンステスト

- **bcryptラウンド数（C-77）**
  - コスト係数の適切な値はハードウェア性能による
  - 候補：12-14ラウンド（2024年時点の推奨値）

### 暗号化の具体的なテストベクター
- SHA-256、BLAKE3、AES-GCM等の具体的な期待値
  - 候補：RFC/NISTの公式テストベクター / 他の実装との相互運用テスト

### プラットフォーム依存機能
- POSIX APIはWindowsでは動作が異なる可能性
- スレッド関連はwasmターゲットで制限される可能性

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 説明 |
|---|---|---|
| 2（高リスク） | 暗号化機能 | セキュリティクリティカル。タイミング攻撃への耐性等を確認 |
| 2（高リスク） | メモリ安全性 | 二重解放、use-after-free等のメモリ関連バグの可能性 |
| 1（中リスク） | スレッド同期 | デッドロック、レースコンディションの可能性 |
| 1（中リスク） | HTTP Client | ネットワークエラーハンドリングの網羅性 |
| 0（低リスク） | ソート/検索 | 標準的なアルゴリズムで安定性が高い |
| 0（低リスク） | フォーマット | エッジケースでのフォーマット崩れ程度 |

## 6) レビュアーチェックリスト（最小）

- [ ] ArrayList/HashMapの境界値テスト（空、1要素、最大容量）が網羅されているか
- [ ] メモリアロケータの失敗ケースが適切にテストされているか
- [ ] 暗号化関数のテストベクターが公式仕様に準拠しているか
- [ ] スレッド同期のテストで競合状態が適切に検出できるか
- [ ] HTTP Clientテストがネットワーク環境に依存しない設計になっているか
- [ ] エラーメッセージが日本語で適切に記載されているか
- [ ] 優先度の設定が実際の重要度と合致しているか
- [ ] テストケース名が具体的で理解しやすいか
