---
generated_at: 2026-02-01 18:30:00
metrics:
  claims_total: 95
  claims_with_evidence: 92
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：src-Air単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：92 / 95、根拠なし：3
- 優先レビュー（高）
  1. **UT-AIR-074, 075**：Verify.verifyのテストケース - エラー条件の詳細確認が必要
  2. **UT-AIR-081, 082**：dump系関数 - 内部実装のstderr出力確認が必要
  3. **UT-AIR-062**：compilerRtCall - ランタイム呼び出しの詳細動作確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/zig/src/Air.zig` (行1-2553) - AIRの主要データ構造と関数
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/zig/src/Air/Legalize.zig` (行1-800+) - 命令合法化処理
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/zig/src/Air/Liveness.zig` (行1-800+) - 生存解析
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/zig/src/Air/Liveness/Verify.zig` (行1-600) - 生存情報検証
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/zig/src/Air/print.zig` (行1-600+) - デバッグ出力
- E-06: `/Users/tomokababa/Work/reverse-engineering/sample/zig/src/Air/types_resolved.zig` (行1-537) - 型解決チェック

## 3) Claims と根拠の対応（レビューの主戦場）

### Air.Inst.Tag関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | fromCmpOpが比較演算子からTagを返す | E-01 (行949-958) | ○ |
| C-02 | fromCmpOpが最適化フラグを考慮する | E-01 (行949-958) | ○ |
| C-03 | toCmpOpがTagから演算子を返す | E-01 (行960-970) | ○ |
| C-04 | toCmpOpが非該当でnullを返す | E-01 (行968) | ○ |

### Air.Inst.Index関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-05 | unwrapがref/targetを判別する | E-01 (行977-983) | ○ |
| C-06 | unwrapがMSBでタグ判定する | E-01 (行979) | ○ |
| C-07 | toRefが変換を行う | E-01 (行985-987) | ○ |
| C-08 | fromTargetIndexがMSBをセット | E-01 (行989-991) | ○ |
| C-09 | toTargetIndexが値を取得 | E-01 (行993-995) | ○ |

### Air.Inst.Ref関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | toInternedがIndex取得 | E-01 (行1148-1151) | ○ |
| C-11 | toInternedがnoneでアサート | E-01 (行1149) | ○ |
| C-12 | toInternedAllowNoneがnone許容 | E-01 (行1153-1161) | ○ |
| C-13 | toIndexが命令Index取得 | E-01 (行1163-1176) | ○ |
| C-14 | toIndexがInternPoolでnull | E-01 (行1171-1174) | ○ |
| C-15 | toTypeが型取得 | E-01 (行1178-1180) | ○ |
| C-16 | fromInternがRef生成 | E-01 (行1182-1190) | ○ |
| C-17 | fromValueがRef生成 | E-01 (行1192-1194) | ○ |
| C-18 | fromTypeがRef生成 | E-01 (行1196-1198) | ○ |

### Air構造体メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | getMainBodyが命令リスト取得 | E-01 (行1511-1515) | ○ |
| C-20 | typeOfが型解決 | E-01 (行1517-1523) | ○ |
| C-21 | typeOfIndexが型解決 | E-01 (行1525-1785) | ○ |
| C-22 | extraDataがデータ読取 | E-01 (行1789-1806) | ○ |
| C-23 | deinitがリソース解放 | E-01 (行1808-1812) | ○ |
| C-24 | internedToRefが変換 | E-01 (行1814-1816) | ○ |
| C-25 | valueが既知値取得 | E-01 (行1819-1825) | ○ |
| C-26 | valueがランタイムでnull | E-01 (行1823-1824) | ○ |

### NullTerminatedString
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | toSliceが文字列取得 | E-01 (行1831-1835) | ○ |
| C-28 | toSliceがnoneで空文字 | E-01 (行1832) | ○ |

### mustLower
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | mustLowerが副作用判定 | E-01 (行1842-2061) | ○ |
| C-30 | store命令がtrue | E-01 (行1874) | ○ |

### UnwrappedSwitch
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | getHintがヒント取得 | E-01 (行2073-2076) | ○ |
| C-32 | getElseHintがelse用 | E-01 (行2077-2079) | ○ |
| C-33 | iterateCasesがイテレータ | E-01 (行2086-2094) | ○ |
| C-34 | CaseIterator.nextがCase返却 | E-01 (行2102-2125) | ○ |
| C-35 | elseBodyがelse取得 | E-01 (行2127-2131) | ○ |

### Shuffle関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | unwrapSwitchがSwitch解析 | E-01 (行2141-2158) | ○ |
| C-37 | unwrapShuffleOneが解析 | E-01 (行2160-2178) | ○ |
| C-38 | unwrapShuffleTwoが解析 | E-01 (行2180-2200) | ○ |
| C-39-44 | Maskヘルパー関数群 | E-01 (行1387-1443) | ○ |

### VectorCmp・Atomic
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45-46 | VectorCmpメソッド | E-01 (行1378-1385) | ○ |
| C-47-48 | Cmpxchgメソッド | E-01 (行1482-1488) | ○ |
| C-49-50 | AtomicRmwメソッド | E-01 (行1497-1503) | ○ |

### CompilerRtFunc
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | nameが関数名取得 | E-01 (行2315-2406) | ○ |
| C-52 | GNU f16 ABI対応 | E-01 (行2348-2352) | ○ |
| C-53 | AEABI対応 | E-01 (行2354-2395) | ○ |
| C-54 | callconvが呼出規約 | E-01 (行2409-2461) | ○ |
| C-55 | returnTypeが戻り型 | E-01 (行2463-2551) | ○ |

### Legalize
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | legalizeが合法化処理 | E-02 (行278-289) | ○ |
| C-57 | Feature.scalarizeがマッピング | E-02 (行185-271) | ○ |
| C-58 | legalizeBodyが再帰処理 | E-02 (行310-800+) | ○ |
| C-59-62 | スカラ化・ソフトフロート変換 | E-02 (行338-800+) | ○ |

### Liveness
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | analyzeが生存解析 | E-03 (行141-187) | ○ |
| C-64 | getTombBitsがビット取得 | E-03 (行189-193) | ○ |
| C-65 | isUnusedが未使用判定 | E-03 (行195-200) | ○ |
| C-66 | operandDiesがオペランド判定 | E-03 (行202-208) | ○ |
| C-67 | getCondBrが条件分岐情報 | E-03 (行216-231) | ○ |
| C-68 | getSwitchBrがswitch情報 | E-03 (行240-260) | ○ |
| C-69 | getBlockがブロック情報 | E-03 (行268-277) | ○ |
| C-70 | deinitがリソース解放 | E-03 (行283-288) | ○ |
| C-71 | iterateBigTombがイテレータ | E-03 (行290-299) | ○ |
| C-72-73 | BigTomb.feedの動作 | E-03 (行316-339) | ○ |

### Verify
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | verifyが検証実行 | E-04 (行29-37) | ○ |
| C-75 | 不整合時のエラー | E-04 (行76, 169, 444, 494) | △ |
| C-76 | deinitがリソース解放 | E-04 (行14-27) | ○ |
| C-77 | verifyBodyが再帰検証 | E-04 (行41-600) | ○ |
| C-78 | verifyInstOperandsが検証 | E-04 (implicitly used) | ○ |

### print
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | writeがテキスト出力 | E-05 (行12-54) | ○ |
| C-80 | writeInstが命令出力 | E-05 (行56-73) | ○ |
| C-81 | dumpがstderr出力 | E-05 (行75-83) | △ |
| C-82 | dumpInstがstderr出力 | E-05 (行85-93) | △ |
| C-83-85 | Writerメソッド群 | E-05 (行354-600+) | ○ |

### types_resolved
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | typesFullyResolvedが全チェック | E-06 (行9-11) | ○ |
| C-87 | 未解決時にfalse | E-06 (行13-446) | ○ |
| C-88 | 基本型がtrue | E-06 (行478-496) | ○ |
| C-89 | struct解決チェック | E-06 (行515-533) | ○ |
| C-90 | union解決チェック | E-06 (行534) | ○ |
| C-91 | optional再帰チェック | E-06 (行502) | ○ |
| C-92-95 | checkVal/checkRef | E-06 (行448-473) | ○ |

## 4) 不足情報（Unknown / Missing）
- **エラーハンドリングの詳細**: Verify.verifyのエラー条件についてより詳細なテストケースが必要
  - 候補：無効なLivenessデータのパターン / 不整合なblock終了 / 不正なloop参照
- **stderr出力確認**: dump/dumpInstの実際の出力内容確認にはランタイムテストが必要
  - 候補：統合テスト / 出力キャプチャテスト

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分のテストケースはソースコードから直接導出可能
- **1（中リスク）**: Legalize/Livenessの複雑な相互作用についてはより詳細なテストが望ましい
- **1（中リスク）**: CompilerRtFuncのABI互換性はターゲットアーキテクチャに依存

## 6) レビュアーチェックリスト（最小）
- [ ] Air.Inst.Tag/Index/Refの変換メソッドが正しくカバーされているか
- [ ] mustLowerの副作用判定がすべてのタグをカバーしているか
- [ ] Legalizeのスカラ化/ソフトフロート変換が主要なパターンを網羅しているか
- [ ] Livenessの生存解析テストケースがエッジケースを含んでいるか
- [ ] types_resolvedの型チェックがすべての型種別を網羅しているか
- [ ] CompilerRtFuncのABI互換テストがターゲットアーキテクチャを考慮しているか
