---
generated_at: 2026-02-01 19:30:00
metrics:
  claims_total: 120
  claims_with_evidence: 118
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート: src-Compilation 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim: 主張）を検証しています：

1. **根拠の有無確認**: 各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**: 主張の内容が根拠と矛盾していないか
3. **網羅性**: 参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」: 根拠あり、「△」: 根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）: **0.98**
  - 根拠あり: 118 / 120、根拠なし: 2
- 優先レビュー（高）
  1. **UT-CMP-028 (hotCodeSwap)**: 実行時動作の詳細確認が必要
  2. **UT-CMP-056 (saveState)**: 状態保存形式の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Compilation.zig` (メインソースファイル、8350行)
- E-02: `src/Compilation/Config.zig` (設定解決ロジック、591行)
- E-03: `src/Compilation.zig:1925` (`create`関数定義)
- E-04: `src/Compilation.zig:2739` (`destroy`関数定義)
- E-05: `src/Compilation.zig:2910` (`update`関数定義)
- E-06: `src/Compilation.zig:3951` (`getAllErrorsAlloc`関数定義)
- E-07: `src/Compilation.zig:4332` (`anyErrors`関数定義)
- E-08: `src/Compilation.zig:5109` (`queueJob`関数定義)
- E-09: `src/Compilation.zig:7248` (`addCCArgs`関数定義)
- E-10: `src/Compilation.zig:7775` (`classifyFileExt`関数定義)
- E-11: `src/Compilation.zig:7821` (`classifyFileExt`テスト)
- E-12: `src/Compilation/Config.zig:160` (`resolve`関数定義)
- E-13: `src/Compilation/Config.zig:122-158` (`ResolveError`定義)
- E-14: `src/Compilation.zig:330` (`Timer`構造体定義)
- E-15: `src/Compilation.zig:401` (`Path`構造体定義)
- E-16: `src/Compilation.zig:713` (`Directories`構造体定義)
- E-17: `src/Compilation.zig:1027` (`CObject`構造体定義)
- E-18: `src/Compilation.zig:1346` (`Win32Resource`構造体定義)
- E-19: `src/Compilation.zig:1465` (`cache_helpers`定義)
- E-20: `src/Compilation.zig:7576` (`FileExt`enum定義)
- E-21: `src/Compilation.zig:8101` (`build_crt_file`関数定義)
- E-22: `src/Compilation.zig:8249` (`toCrtFile`関数定義)
- E-23: `src/Compilation.zig:8263` (`getCrtPaths`関数定義)
- E-24: `src/Compilation.zig:8296` (`addLinkLib`関数定義)
- E-25: `src/Compilation.zig:8319` (`compilerRtOptMode`関数定義)
- E-26: `src/Compilation.zig:8333` (`compilerRtStrip`関数定義)
- E-27: `src/Compilation.zig:8340` (`getTid`関数定義)
- E-28: `src/Compilation.zig:8344` (`setMainThread`関数定義)

## 3) Claims と根拠の対応（レビューの主戦場）

### Config.resolve関連 (UT-CMP-001 〜 UT-CMP-019)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Config.resolveが基本設定を正しく解決する | E-12 | ○ |
| C-02 | WASI exec modelのデフォルト設定 | E-12 (line 164-166) | ○ |
| C-03 | 非WASIでwasi_exec_model指定時エラー | E-12, E-13 (WasiExecModelRequiresWasi) | ○ |
| C-04 | 非Wasmでshared_memory指定時エラー | E-12 (line 169-170), E-13 | ○ |
| C-05 | Objモードでshared_memory指定時エラー | E-12 (line 173-175), E-13 | ○ |
| C-06 | atomics/bulk_memory不足時エラー | E-12 (line 177-180), E-13 | ○ |
| C-07 | スレッド使用時shared_memory強制 | E-12 (line 182-186), E-13 | ○ |
| C-08 | LLVM未サポート時エラー | E-12 (line 193-198), E-13 | ○ |
| C-09 | Clang未サポート時エラー | E-12 (line 203-212), E-13 | ○ |
| C-10 | TSAN時libcpp必須 | E-12 (line 214-225), E-13 | ○ |
| C-11 | libcpp時libc必須 | E-12 (line 227-235), E-13 | ○ |
| C-12 | 動的リンク不可ターゲット検証 | E-12 (line 258-261), E-13 | ○ |
| C-13 | LLVM出力時use_llvm必須 | E-12 (line 334-341), E-13 | ○ |
| C-14 | LLDインクリメンタル制限 | E-12 (line 406-409), E-13 | ○ |
| C-15 | LTO時LLD必須 | E-12 (line 401-404), E-13 | ○ |
| C-16 | PIE自動設定 | E-12 (line 456-481) | ○ |
| C-17 | 動的ライブラリPIE制限 | E-12 (line 464-467), E-13 | ○ |
| C-18 | TSAN時PIE必須 | E-12 (line 470-473), E-13 | ○ |
| C-19 | Windows DLL export検証 | E-12 (line 535-547), E-13 | ○ |

### Compilation コアAPI関連 (UT-CMP-020 〜 UT-CMP-059)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | create成功 | E-03 | ○ |
| C-21 | import/export table競合エラー | E-03 (line 1937-1939) | ○ |
| C-22 | ZCUなしemit_hエラー | E-03 (line 2245) | ○ |
| C-23 | destroy成功 | E-04 | ○ |
| C-24 | update成功 | E-05 | ○ |
| C-25 | キャッシュヒット判定 | E-05 (line 2993-3011) | ○ |
| C-26 | インクリメンタルコンパイル | E-05 (line 2949) | ○ |
| C-27 | getTarget | E-01 (line 2830-2832) | ○ |
| C-28 | hotCodeSwap | E-01 (line 2835-2845) | △ |
| C-29 | getAllErrorsAlloc成功 | E-06 | ○ |
| C-30 | getAllErrorsAlloc空Bundle | E-06 | ○ |
| C-31 | anyErrors true | E-07 | ○ |
| C-32 | anyErrors false | E-07 | ○ |
| C-33 | queueJob | E-08 | ○ |
| C-34 | queueJobs | E-01 (line 5113) | ○ |
| C-35 | clearMiscFailures | E-01 (line 2820-2828) | ○ |
| C-36 | setAllocFailure | E-01 (line 7863-7867) | ○ |
| C-37 | setMiscFailure | E-01 (line 7871-7884) | ○ |
| C-38 | lockAndSetMiscFailure | E-01 (line 7887-7897) | ○ |
| C-39 | addCCArgs Clang引数 | E-09 | ○ |
| C-40 | addCCArgs アセンブリ | E-09 (line 7276-7279) | ○ |
| C-41 | addCCArgs RISC-V | E-09 (line 7323-7367) | ○ |
| C-42 | translateC | E-01 (line 5739) | ○ |
| C-43 | cImport | E-01 (line 5887) | ○ |
| C-44 | compilerRtOptMode Debug | E-25 | ○ |
| C-45 | compilerRtOptMode ReleaseFast | E-25 (line 8326) | ○ |
| C-46 | compilerRtStrip | E-26 | ○ |
| C-47 | getZigBackend | E-01 (line 7920-7923) | ○ |
| C-48 | updateSubCompilation成功 | E-01 (line 7926-7956) | ○ |
| C-49 | updateSubCompilationエラー伝播 | E-01 (line 7945-7955) | ○ |
| C-50 | build_crt_file | E-21 | ○ |
| C-51 | toCrtFile | E-22 | ○ |
| C-52 | getCrtPaths | E-23 | ○ |
| C-53 | addLinkLib Windows | E-24 | ○ |
| C-54 | addLinkLib 非Windows | E-24 (line 8302-8303) | ○ |
| C-55 | queuePrelinkTasks | E-01 (line 8244-8247) | ○ |
| C-56 | saveState | E-01 (line 3709) | △ |
| C-57 | appendFileSystemInput | E-01 (line 3278) | ○ |
| C-58 | makeBinFileExecutable | E-01 (line 3666) | ○ |
| C-59 | makeBinFileWritable | E-01 (line 3672) | ○ |

### Path関連 (UT-CMP-060 〜 UT-CMP-070)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | Path.fromUnresolved | E-15 (line 514) | ○ |
| C-61 | Path.fromRoot | E-15 (line 587) | ○ |
| C-62 | Path.join | E-15 (line 609) | ○ |
| C-63 | Path.upJoin | E-15 (line 630) | ○ |
| C-64 | Path.openInfo | E-15 (line 454) | ○ |
| C-65 | Path.toAbsolute | E-15 (line 672) | ○ |
| C-66 | Path.isNested | E-15 (line 686) | ○ |
| C-67 | Path.isIllegalZigImport true | E-15 (line 703) | ○ |
| C-68 | Path.isIllegalZigImport false | E-15 (line 703) | ○ |
| C-69 | Path.addToHasher | E-15 (line 441) | ○ |
| C-70 | Path.digest | E-15 (line 447) | ○ |

### Directories関連 (UT-CMP-071 〜 UT-CMP-074)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | Directories.init | E-16 (line 751) | ○ |
| C-72 | Directories.init同一パス検証 | E-16 (line 803-808) | ○ |
| C-73 | Directories.deinit | E-16 (line 729-736) | ○ |
| C-74 | Directories.withoutLocalCache | E-16 (line 741-748) | ○ |

### Timer関連 (UT-CMP-075 〜 UT-CMP-080)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | Timer.pause | E-14 (line 339-353) | ○ |
| C-76 | Timer.resume | E-14 (line 354-364) | ○ |
| C-77 | Timer.finish active | E-14 (line 365-381) | ○ |
| C-78 | Timer.finish unused | E-14 (line 367) | ○ |
| C-79 | startTimer time_report存在 | E-01 (line 387-394) | ○ |
| C-80 | startTimer time_report=null | E-01 (line 388) | ○ |

### CObject/Win32Resource関連 (UT-CMP-081 〜 UT-CMP-088)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | CObject.clearStatus success | E-17 (line 1324-1338) | ○ |
| C-82 | CObject.clearStatus failure | E-17 (line 1327-1330) | ○ |
| C-83 | CObject.destroy | E-17 (line 1340-1343) | ○ |
| C-84 | CObject.Diag.count | E-17 (line 1079-1083) | ○ |
| C-85 | CObject.Diag.Bundle.parse | E-17 (line 1159) | ○ |
| C-86 | CObject.Diag.Bundle.addToErrorBundle | E-17 (line 1309) | ○ |
| C-87 | Win32Resource.clearStatus | E-18 (line 1371-1385) | ○ |
| C-88 | Win32Resource.destroy | E-18 (line 1387-1390) | ○ |

### その他構造体関連 (UT-CMP-089 〜 UT-CMP-120)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | TimeReport.deinit | E-01 (line 902-908) | ○ |
| C-90 | CrtFile.deinit | E-01 (line 926-931) | ○ |
| C-91 | MiscError.deinit | E-01 (line 1456-1462) | ○ |
| C-92 | classifyFileExt .c | E-10, E-11 | ○ |
| C-93 | classifyFileExt .cpp | E-10 (line 7780-7781) | ○ |
| C-94 | classifyFileExt .so版 | E-10 (line 7802-7803), E-11 | ○ |
| C-95 | classifyFileExt .zig | E-10 (line 7800-7801), E-11 | ○ |
| C-96 | classifyFileExt unknown | E-10 (line 7816-7818), E-11 | ○ |
| C-97 | hasObjectExt | E-01 (line 7694-7699) | ○ |
| C-98 | hasStaticLibraryExt | E-01 (line 7701-7705) | ○ |
| C-99 | hasSharedLibraryExt basic | E-01 (line 7748-7773) | ○ |
| C-100 | hasSharedLibraryExt versioned | E-01 (line 7756-7773), E-11 | ○ |
| C-101 | FileExt.clangNeedsLanguageOverride | E-20 (line 7599-7626) | ○ |
| C-102 | FileExt.clangSupportsDiagnostics | E-20 (line 7628-7645) | ○ |
| C-103 | FileExt.clangSupportsDepFile | E-20 (line 7647-7665) | ○ |
| C-104 | FileExt.canonicalName | E-20 (line 7667-7691) | ○ |
| C-105 | cache_helpers.addModule | E-19 (line 1466-1485) | ○ |
| C-106 | cache_helpers.addResolvedTarget | E-19 (line 1487-1502) | ○ |
| C-107 | cache_helpers.hashCSource | E-19 (line 1518-1534) | ○ |
| C-108 | CacheUse.deinit none | E-01 (line 1636-1649) | ○ |
| C-109 | CacheUse.deinit incremental | E-01 (line 1641-1643) | ○ |
| C-110 | CacheUse.deinit whole | E-01 (line 1644-1648) | ○ |
| C-111 | debugIncremental true | E-01 (line 862-865) | ○ |
| C-112 | debugIncremental false | E-01 (line 863) | ○ |
| C-113 | dumpArgv | E-01 (line 7899-7918) | ○ |
| C-114 | getTid | E-27 | ○ |
| C-115 | setMainThread | E-28 | ○ |
| C-116 | Emit.resolve no | E-01 (line 1824-1842) | ○ |
| C-117 | Emit.resolve yes_cache | E-01 (line 1827-1836) | ○ |
| C-118 | Emit.resolve yes_path | E-01 (line 1837-1840) | ○ |
| C-119 | Job.stage resolve_type_fully | E-01 (line 1013-1020) | ○ |
| C-120 | Job.stage analyze_mod | E-01 (line 1018) | ○ |

## 4) 不足情報（Unknown / Missing）

### UT-CMP-028 (hotCodeSwap)
- **理由**: 実行時の動作確認が必要。特にプロセスIDとの連携部分は実装依存
- **候補**: 実行環境でのE2Eテスト / デバッガでのステップ実行確認

### UT-CMP-056 (saveState)
- **理由**: `.zcs`ファイル形式の詳細仕様がコード内コメントのみ。永続化フォーマットの検証が必要
- **候補**: バイナリフォーマット仕様書 / 既存の`.zcs`ファイルサンプル解析

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 対象 | 説明 |
|---|---|---|
| 2 (高) | UT-CMP-028 | ホットコードスワップは実行時クリティカル機能 |
| 1 (中) | UT-CMP-001〜019 | Config.resolveは多くの条件分岐があり、境界条件の漏れリスク |
| 1 (中) | UT-CMP-039〜041 | Clang引数生成はターゲット依存が複雑 |
| 0 (低) | UT-CMP-092〜100 | ファイル拡張子分類は既存テストあり (E-11) |

## 6) レビュアーチェックリスト（最小）

- [ ] Config.resolveの全エラーケース(ResolveError)に対応するテストがあるか確認
- [ ] hotCodeSwap (UT-CMP-028) の実行時動作を手動確認
- [ ] saveState (UT-CMP-056) の出力フォーマットを既存ファイルと比較確認
- [ ] addCCArgsのターゲット固有フラグ（RISC-V, MIPS等）が網羅されているか確認
- [ ] classifyFileExtのテスト（E-11）でカバーされていない拡張子がないか確認
- [ ] CacheUseの3モード（none/incremental/whole）の遷移が正しくテストされているか確認
