---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 120
  claims_with_evidence: 118
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：src-Package 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 120、根拠なし：2
- 優先レビュー（高）
  1. **C-084 Module.getBuiltinOptions**：assertのみで検証ロジック不明
  2. **C-119 normalizePathAlloc**：Windows固有の動作確認が困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Package.zig` - Package構造体、Hash、Fingerprint定義
- E-02: `src/Package/Manifest.zig` - Manifest構造体、パース処理、依存関係定義
- E-03: `src/Package/Fetch.zig` - Fetch構造体、JobQueue、Filter、FileType、FileHeader
- E-04: `src/Package/Fetch/git.zig` - Git関連：Oid、Session、Repository、Odb、Packet
- E-05: `src/Package/Module.zig` - Module構造体、create関数、CreateOptions
- E-06: `src/Package.zig:89-93` - Hash.isOldテスト
- E-07: `src/Package.zig:190-197` - Hashテスト
- E-08: `src/Package.zig:199-202` - 空ハッシュテスト
- E-09: `src/Package/Manifest.zig:604-652` - basicテスト
- E-10: `src/Package/Manifest.zig:654-686` - minimum_zig_versionテスト
- E-11: `src/Package/Manifest.zig:688-714` - invalid versionテスト
- E-12: `src/Package/Fetch.zig:983-996` - fromContentDispositionテスト
- E-13: `src/Package/Fetch.zig:1812-1820` - includePathテスト
- E-14: `src/Package/Fetch.zig:1878-1900` - FileHeaderテスト
- E-15: `src/Package/Fetch/git.zig:123-142` - Oid.parseテスト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | Hash.fromSlice - スライスからHash生成 | E-01 (L59-65) | ○ |
| C-002 | Hash.fromSlice - 空スライス処理 | E-08 | ○ |
| C-003 | Hash.toSlice - 有効スライス返却 | E-01 (L67-74) | ○ |
| C-004 | Hash.toSlice - 空Hash処理 | E-08 | ○ |
| C-005 | Hash.eql - 同一Hash比較 | E-01 (L76-78) | ○ |
| C-006 | Hash.eql - 異なるHash比較 | E-01 (L76-78) | ○ |
| C-007 | Hash.isOld - レガシー形式検出 | E-06 | ○ |
| C-008 | Hash.isOld - 新形式識別 | E-01 (L81-87) | ○ |
| C-009 | Hash.init - ハッシュ生成 | E-07 | ○ |
| C-010 | Hash.initPath - パスベースハッシュ | E-01 (L124-139) | ○ |
| C-011 | Hash.initPath - グローバルパス | E-01 (L127-129) | ○ |
| C-012 | Hash.initPath - 長いパス処理 | E-01 (L131-138) | ○ |
| C-013 | Fingerprint.generate - 生成 | E-01 (L17-22) | ○ |
| C-014 | Fingerprint.validate - 有効検証 | E-01 (L24-29) | ○ |
| C-015 | Fingerprint.validate - 不正検証 | E-01 (L24-29) | ○ |
| C-016 | Fingerprint.validate - 予約ID 0 | E-01 (L26) | ○ |
| C-017 | Fingerprint.validate - 予約ID max | E-01 (L26) | ○ |
| C-018 | Fingerprint.int - 整数変換 | E-01 (L31-33) | ○ |
| C-019 | multiHashHexDigest - 16進変換 | E-01 (L165-181) | ○ |
| C-020 | Manifest.parse - 基本パース | E-09 | ○ |
| C-021 | Manifest.parse - 依存関係パース | E-09 (L640-649) | ○ |
| C-022 | Manifest.parse - minimum_zig_version | E-10 | ○ |
| C-023 | Manifest.parse - name必須検証 | E-02 (L214-215) | ○ |
| C-024 | Manifest.parse - version必須検証 | E-02 (L233-235) | ○ |
| C-025 | Manifest.parse - 不正バージョン | E-11 | ○ |
| C-026 | Manifest.parse - name長制限 | E-02 (L403-406) | ○ |
| C-027 | Manifest.parse - version長制限 | E-02 (L194-196) | ○ |
| C-028 | Manifest.parse - pathsパース | E-02 (L343-358) | ○ |
| C-029 | Manifest.parse - fingerprint検証 | E-02 (L217-223) | ○ |
| C-030 | Manifest.parse - 不正fingerprint | E-02 (L218-221) | ○ |
| C-031 | Dependency.parse - URL依存 | E-02 (L292-304) | ○ |
| C-032 | Dependency.parse - パス依存 | E-02 (L305-317) | ○ |
| C-033 | Dependency.parse - url/path両方エラー | E-02 (L293-295, L306-308) | ○ |
| C-034 | Dependency.parse - location必須 | E-02 (L336-338) | ○ |
| C-035 | Dependency.parse - lazy依存 | E-02 (L325-329) | ○ |
| C-036 | Manifest.deinit - メモリ解放 | E-02 (L109-112) | ○ |
| C-037 | Manifest.copyErrorsIntoBundle | E-02 (L114-137) | ○ |
| C-038 | Fetch.run - リモートフェッチ | E-03 (L328-477) | ○ |
| C-039 | Fetch.run - 相対パス解決 | E-03 (L343-384) | ○ |
| C-040 | Fetch.run - 絶対パスエラー | E-03 (L344-347) | ○ |
| C-041 | Fetch.run - ハッシュ付きパスエラー | E-03 (L348-351) | ○ |
| C-042 | Fetch.run - キャッシュ外参照エラー | E-03 (L353-379) | ○ |
| C-043 | Fetch.run - キャッシュヒット | E-03 (L423-432) | ○ |
| C-044 | Fetch.run - 無効URI | E-03 (L469-472) | ○ |
| C-045 | Fetch.run - ハッシュ不一致 | E-03 (L593-610) | ○ |
| C-046 | Fetch.run - lazy unavailable | E-03 (L435-439) | ○ |
| C-047 | Fetch.computedPackageHash - manifest付き | E-03 (L631-637) | ○ |
| C-048 | Fetch.computedPackageHash - 裸パッケージ | E-03 (L638-641) | ○ |
| C-049 | JobQueue.deinit - 逆順deinit | E-03 (L148-161) | ○ |
| C-050 | JobQueue.consolidateErrors | E-03 (L163-174) | ○ |
| C-051 | JobQueue.createDependenciesSource | E-03 (L178-288) | ○ |
| C-052 | JobQueue.createEmptyDependenciesSource | E-03 (L290-296) | ○ |
| C-053 | Filter.includePath - 指定パス | E-13 | ○ |
| C-054 | Filter.includePath - 親ディレクトリ | E-13 (L1818) | ○ |
| C-055 | Filter.includePath - 空paths | E-03 (L1797-1798) | ○ |
| C-056 | Filter.includePath - 除外判定 | E-13 (L1819) | ○ |
| C-057 | FileType.fromPath - tar.gz | E-03 (L951) | ○ |
| C-058 | FileType.fromPath - tgz | E-03 (L950) | ○ |
| C-059 | FileType.fromPath - zip | E-03 (L957) | ○ |
| C-060 | FileType.fromPath - jar | E-03 (L958) | ○ |
| C-061 | FileType.fromPath - 未知拡張子 | E-03 (L959) | ○ |
| C-062 | FileType.fromContentDisposition | E-12 | ○ |
| C-063 | FileType.fromContentDisposition - 無効 | E-12 (L991-996) | ○ |
| C-064 | FileHeader.isExecutable - ELF | E-14 (L1882-1886) | ○ |
| C-065 | FileHeader.isExecutable - Mach-O | E-14 (L1891-1898) | ○ |
| C-066 | FileHeader.isExecutable - シバン | E-03 (L1850-1853) | ○ |
| C-067 | FileHeader.isExecutable - 通常ファイル | E-14 (L1880) | ○ |
| C-068 | FileHeader.update | E-03 (L1843-1848) | ○ |
| C-069 | renameTmpIntoCache - 移動 | E-03 (L1466-1490) | ○ |
| C-070 | renameTmpIntoCache - 親ディレクトリ作成 | E-03 (L1471-1478) | ○ |
| C-071 | renameTmpIntoCache - 既存処理 | E-03 (L1479-1485) | ○ |
| C-072 | relativePathDigest | E-03 (L848-850) | ○ |
| C-073 | depDigest - ハッシュ付き | E-03 (L1824) | ○ |
| C-074 | depDigest - パス依存 | E-03 (L1826-1834) | ○ |
| C-075 | depDigest - URLのみ | E-03 (L1827) | ○ |
| C-076 | Module.create - 基本 | E-05 (L110-405) | ○ |
| C-077 | Module.create - Valgrindエラー | E-05 (L133-136) | ○ |
| C-078 | Module.create - シングルスレッドエラー | E-05 (L145-156) | ○ |
| C-079 | Module.create - PICエラー | E-05 (L171-185) | ○ |
| C-080 | Module.create - 設定継承 | E-05 (L118-161) | ○ |
| C-081 | Module.create - オーバーライド | E-05 (L118-161) | ○ |
| C-082 | Module.createLimited | E-05 (L416-444) | ○ |
| C-083 | Module.createBuiltin | E-05 (L447-483) | ○ |
| C-084 | Module.getBuiltinOptions | E-05 (L486-510) | △ |
| C-085 | git.Oid.parse - SHA1 | E-15 (L124-128) | ○ |
| C-086 | git.Oid.parse - SHA256 | E-15 (L131-135) | ○ |
| C-087 | git.Oid.parse - 不正長さ | E-15 (L129-130, L136-137) | ○ |
| C-088 | git.Oid.parse - 非16進文字 | E-15 (L138-141) | ○ |
| C-089 | git.Oid.parseAny | E-04 (L144-148) | ○ |
| C-090 | git.Oid.fromBytes | E-04 (L97-102) | ○ |
| C-091 | git.Oid.Format.byteLength - SHA1 | E-04 (L33-38) | ○ |
| C-092 | git.Oid.Format.byteLength - SHA256 | E-04 (L33-38) | ○ |
| C-093 | git.Session.init | E-04 (L668-704) | ○ |
| C-094 | git.Session.listRefs | E-04 (L862-919) | ○ |
| C-095 | git.Session.fetch | E-04 (L973-1070) | ○ |
| C-096 | git.Session.RefIterator.next | E-04 (L939-968) | ○ |
| C-097 | git.Session.RefIterator.next - 終端 | E-04 (L940-941) | ○ |
| C-098 | git.Packet.read | E-04 (L600-607) | ○ |
| C-099 | git.Packet.read - flush | E-04 (L614) | ○ |
| C-100 | git.Packet.read - delimiter | E-04 (L615) | ○ |
| C-101 | git.Packet.write | E-04 (L624-635) | ○ |
| C-102 | git.Packet.normalizeText | E-04 (L644-649) | ○ |
| C-103 | git.Repository.init | E-04 (L197-206) | ○ |
| C-104 | git.Repository.checkout | E-04 (L214-228) | ○ |
| C-105 | git.Repository.checkout - NotACommit | E-04 (L224) | ○ |
| C-106 | git.Odb.seekOid | E-04 (L450-481) | ○ |
| C-107 | git.Odb.seekOid - ObjectNotFound | E-04 (L464) | ○ |
| C-108 | git.Odb.readObject | E-04 (L407-447) | ○ |
| C-109 | git.ObjectCache.get | E-04 (L536-544) | ○ |
| C-110 | git.ObjectCache.get - miss | E-04 (L541-543) | ○ |
| C-111 | git.ObjectCache.put | E-04 (L551-582) | ○ |
| C-112 | git.ObjectCache.put - LRU | E-04 (L569-581) | ○ |
| C-113 | git.indexPack | E-04 (L1274-1368) | ○ |
| C-114 | git.Diagnostics.deinit | E-04 (L177-191) | ○ |
| C-115 | UnpackResult.validate - フィルタ除外 | E-03 (L1973-1982) | ○ |
| C-116 | UnpackResult.validate - エラー追加 | E-03 (L1984-2000) | ○ |
| C-117 | stripRoot | E-03 (L1766-1774) | ○ |
| C-118 | stripRoot - 空root | E-03 (L1767) | ○ |
| C-119 | normalizePathAlloc | E-03 (L1778-1783) | △ |
| C-120 | computeHash | E-03 (L1502-1665) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-084**: `getBuiltinOptions`のアサート(`have_zcu`)のみで、実際の動作検証ロジックがソースコードから明確でない
  - 候補：統合テスト / 実行時検証 / ドキュメント
- **C-119**: Windows環境でのパス区切り正規化は、クロスプラットフォーム環境での動作確認が必要
  - 候補：Windows CI環境でのテスト / プラットフォーム固有テスト

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 大部分のテストケースはソースコードの実装と既存テストに明確な根拠あり
- **1 (中リスク)**: Git関連機能（Session, Repository）はネットワーク依存のため、モック/スタブが必要
- **1 (中リスク)**: ファイルシステム操作（computeHash, renameTmpIntoCache）は環境依存の可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] Package.Hash の全メソッドが既存テスト（L89-202）と整合しているか確認
- [ ] Manifest パーサーのエラーハンドリングが全パターン網羅されているか確認
- [ ] Fetch.run の各エラーパスに対するテストケースが適切か確認
- [ ] Git プロトコル関連のテストケースがプロトコル仕様と整合しているか確認
- [ ] Module.create のターゲット依存オプション（valgrind, pic, single_threaded）の境界条件が正しいか確認
- [ ] キャッシュ関連（ObjectCache, JobQueue.table）の並行性テストが考慮されているか確認
