---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 120
  claims_with_evidence: 118
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：src-Sema 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 120、根拠なし：2
- 優先レビュー（高）
  1. **UT-SEM-006**：resolveInstの無効参照エラー処理 - 根拠不足
  2. **UT-SEM-088**：auto layout structのビットキャスト処理 - 詳細確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Sema.zig` (行1-500) - Sema構造体定義、フィールド、InstMap、Block定義
- E-02: `src/Sema.zig` (行500-1000) - Block.Merges、makeSubBlock、wantSafety、addInst等
- E-03: `src/Sema.zig` (行1000-) - analyzeFnBody、resolveInst、resolveType等のpublic関数
- E-04: `src/Sema/arith.zig` (行1-500) - 算術演算関数（add, sub, mul, div, overflow系）
- E-05: `src/Sema/arith.zig` (行500-1000) - 追加の算術演算（subWrap, subSat, mul, mulWrap, div, modRem, shl, shr）
- E-06: `src/Sema/bitcast.zig` - bitCast、bitCastSplice、UnpackValueBits、PackValueBits
- E-07: `src/Sema/LowerZon.zig` - ZON解析、lowerExprAnonResTy、checkType
- E-08: `src/Sema/comptime_ptr_access.zig` - loadComptimePtr、storeComptimePtr、ComptimeLoadResult、ComptimeStoreResult

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getComptimeAllocが有効なインデックスでComptimeAllocを返却 | E-01 (行191-193) | ○ |
| C-02 | getComptimeAllocの境界値テスト（idx=0） | E-01 (行191-193) | ○ |
| C-03 | deinitでリソースが解放される | E-03 (行994-) | ○ |
| C-04 | analyzeFnBodyで関数本体が解析される | E-03 (行1042-) | ○ |
| C-05 | resolveInstでZIR命令がAIR命令に解決される | E-03 (行2009-) | ○ |
| C-06 | resolveInstで無効参照時のエラー処理 | **根拠なし** | △ |
| C-07 | resolveTypeで型参照が解決される | E-03 (行2083-) | ○ |
| C-08 | coerceで型強制変換が行われる | E-03 (行28258-) | ○ |
| C-09 | coerceで非互換型エラー | E-03 (行28258-) | ○ |
| C-10 | coerceInMemoryAllowedでメモリ内変換可否判定 | E-03 (行29366-) | ○ |
| C-11 | failWithUseOfUndefでエラー報告 | E-03 (行2362-) | ○ |
| C-12 | failWithUseOfUndefでベクターインデックス付きエラー | E-03 (行2362-) | ○ |
| C-13 | failWithDivideByZeroでゼロ除算エラー | E-03 (行2371-) | ○ |
| C-14 | failWithIntegerOverflowでオーバーフローエラー | E-03 (行2462-) | ○ |
| C-15 | errMsgでエラーメッセージ生成 | E-03 (行2611-) | ○ |
| C-16 | errNoteでエラー注記追加 | E-03 (行2584-) | ○ |
| C-17 | failで汎用エラー生成 | E-03 (行2641-) | ○ |
| C-18 | typeHasOnePossibleValueで単一値型判定（void） | E-03 (行35788-) | ○ |
| C-19 | typeHasOnePossibleValueで複数値可能型はnull | E-03 (行35788-) | ○ |
| C-20 | declareDependencyで依存関係登録 | E-03 (行36725-) | ○ |
| C-21 | flushExportsでエクスポートフラッシュ | E-03 (行37081-) | ○ |
| C-22 | addExtraでデータ格納 | E-03 (行36179-) | ○ |
| C-23 | getTmpAirで一時AIR取得 | E-03 (行36172-) | ○ |
| C-24 | Block.srcでソース位置計算 | E-02 (行401-) | ○ |
| C-25 | Block.isComptimeでコンパイル時判定（true） | E-02 (行408-) | ○ |
| C-26 | Block.isComptimeでランタイム判定（false） | E-02 (行408-) | ○ |
| C-27 | Block.makeSubBlockでサブブロック作成 | E-02 (行507-) | ○ |
| C-28 | Block.wantSafetyで安全性チェック判定 | E-02 (行539-) | ○ |
| C-29 | Block.wantSafetyでコンパイル時は不要 | E-02 (行540-) | ○ |
| C-30 | Block.addInstでAIR命令追加 | E-02 (行813-) | ○ |
| C-31 | Block.addBinOpで二項演算命令追加 | E-02 (行625-) | ○ |
| C-32 | InstMap.getでマッピング値取得 | E-01 (行256-) | ○ |
| C-33 | InstMap.getで未登録キーはnull | E-01 (行256-) | ○ |
| C-34 | InstMap.putAssumeCapacityでマッピング登録 | E-01 (行261-) | ○ |
| C-35 | InstMap.containsでキー存在確認 | E-01 (行300-) | ○ |
| C-36 | InstMap.removeでマッピング削除 | E-01 (行294-) | ○ |
| C-37 | InferredErrorSet.addErrorSetでエラーセット追加 | E-01 (行215-) | ○ |
| C-38 | InferredErrorSet.addErrorSetでanyerror処理 | E-01 (行222-) | ○ |
| C-39 | incrementDefinedIntで整数インクリメント | E-04 (行14-25) | ○ |
| C-40 | incrementDefinedIntで最大値オーバーフロー | E-04 (行14-25) | ○ |
| C-41 | negateFloatで浮動小数点否定 | E-04 (行29-55) | ○ |
| C-42 | negateFloatでundefinedそのまま返却 | E-04 (行36-) | ○ |
| C-43 | negateFloatでベクター要素否定 | E-04 (行38-51) | ○ |
| C-44 | addMaybeWrapで整数ラップ加算 | E-04 (行60-74) | ○ |
| C-45 | addMaybeWrapで浮動小数点加算 | E-04 (行71-) | ○ |
| C-46 | subMaybeWrapで整数ラップ減算 | E-04 (行79-93) | ○ |
| C-47 | mulMaybeWrapで整数ラップ乗算 | E-04 (行98-112) | ○ |
| C-48 | addWithOverflowでオーバーフロー検出 | E-04 (行116-152) | ○ |
| C-49 | addWithOverflowでオーバーフローなし | E-04 (行116-152) | ○ |
| C-50 | addWithOverflowでベクター要素ごと検出 | E-04 (行126-149) | ○ |
| C-51 | subWithOverflowでオーバーフロー検出 | E-04 (行174-210) | ○ |
| C-52 | mulWithOverflowでオーバーフロー検出 | E-04 (行232-268) | ○ |
| C-53 | addで整数加算 | E-04 (行291-326) | ○ |
| C-54 | addでオーバーフローエラー | E-04 (行346-) | ○ |
| C-55 | addでundefinedエラー | E-04 (行343-344) | ○ |
| C-56 | addWrapでラップ加算 | E-04 (行358-389) | ○ |
| C-57 | addSatで飽和加算 | E-04 (行394-440) | ○ |
| C-58 | addSatでオーバーフローなし | E-04 (行394-440) | ○ |
| C-59 | subで整数減算 | E-04 (行445-480) | ○ |
| C-60 | subでアンダーフローエラー | E-05 (行500-) | ○ |
| C-61 | subWrapでラップ減算 | E-05 (行512-552) | ○ |
| C-62 | subSatで飽和減算 | E-05 (行557-603) | ○ |
| C-63 | mulで整数乗算 | E-05 (行608-670) | ○ |
| C-64 | mulでオーバーフローエラー | E-05 (行663-) | ○ |
| C-65 | mulWrapでラップ乗算 | E-05 (行675-715) | ○ |
| C-66 | mulSatで飽和乗算 | E-05 (行720-766) | ○ |
| C-67 | divで整数除算 | E-05 (行773-879) | ○ |
| C-68 | divでゼロ除算エラー | E-05 (行827-) | ○ |
| C-69 | divでexact除算余りエラー | E-05 (行843-844) | ○ |
| C-70 | divでtrunc除算 | E-05 (行833-836) | ○ |
| C-71 | divでfloor除算 | E-05 (行838-841) | ○ |
| C-72 | modRemで剰余演算 | E-05 (行886-954) | ○ |
| C-73 | modRemでモジュロ演算 | E-05 (行886-954) | ○ |
| C-74 | shlで左シフト | E-05 (行961-990) | ○ |
| C-75 | shlでシフト量過大エラー | E-05 (行961-) | ○ |
| C-76 | shlWithOverflowでオーバーフロー検出 | E-05 (行993-) | ○ |
| C-77 | shrで右シフト | E-05 (行1119-) | ○ |
| C-78 | truncateで値切り詰め | E-05 (行1186-) | ○ |
| C-79 | bitwiseNotでビット否定 | E-05 (行1226-) | ○ |
| C-80 | bitwiseBinでビットAND | E-05 (行1259-) | ○ |
| C-81 | bitwiseBinでビットOR | E-05 (行1259-) | ○ |
| C-82 | bitwiseBinでビットXOR | E-05 (行1259-) | ○ |
| C-83 | bitReverseでビット反転 | E-05 (行1327-) | ○ |
| C-84 | byteSwapでバイトスワップ | E-05 (行1356-) | ○ |
| C-85 | bitCastで同一型そのまま返却 | E-06 (行76-78) | ○ |
| C-86 | bitCastで整数間変換 | E-06 (行19-33) | ○ |
| C-87 | bitCastでfloat→int変換 | E-06 (行19-33) | ○ |
| C-88 | bitCastでレイアウト未定義型でnull | **推測** | △ |
| C-89 | bitCastSpliceで値スプライス | E-06 (行46-60) | ○ |
| C-90 | bitCastSpliceでオフセット付きスプライス | E-06 (行46-60) | ○ |
| C-91 | LowerZon.runでZON解析 | E-07 (行32-66) | ○ |
| C-92 | LowerZon.runで型推論付き解析 | E-07 (行59-65) | ○ |
| C-93 | lowerExprAnonResTyでtrue解析 | E-07 (行75-) | ○ |
| C-94 | lowerExprAnonResTyでfalse解析 | E-07 (行76-) | ○ |
| C-95 | lowerExprAnonResTyでnull解析 | E-07 (行77-) | ○ |
| C-96 | lowerExprAnonResTyで整数解析 | E-07 (行81-90) | ○ |
| C-97 | lowerExprAnonResTyで浮動小数点解析 | E-07 (行91-94) | ○ |
| C-98 | lowerExprAnonResTyで文字列解析 | E-07 (行108-112) | ○ |
| C-99 | lowerExprAnonResTyで配列解析 | E-07 (行114-126) | ○ |
| C-100 | lowerExprAnonResTyで構造体解析 | E-07 (行127-211) | ○ |
| C-101 | lowerExprAnonResTyでinfinityエラー | E-07 (行78-) | ○ |
| C-102 | checkTypeで有効な型検証 | E-07 (行217-220) | ○ |
| C-103 | checkTypeでエラー型拒否 | E-07 (行247-258) | ○ |
| C-104 | checkTypeでネストオプショナル拒否 | E-07 (行283-285) | ○ |
| C-105 | checkTypeで可変ポインタ拒否 | E-07 (行262-265) | ○ |
| C-106 | loadComptimePtrで読み込み成功 | E-08 (行14-38) | ○ |
| C-107 | loadComptimePtrでundef検出 | E-08 (行222-) | ○ |
| C-108 | loadComptimePtrで範囲外エラー | E-08 (行409-411) | ○ |
| C-109 | loadComptimePtrでランタイム変数検出 | E-08 (行232-) | ○ |
| C-110 | storeComptimePtrで書き込み成功 | E-08 (行56-201) | ○ |
| C-111 | storeComptimePtrで定数フィールド保護 | E-08 (行102-119) | ○ |
| C-112 | storeComptimePtrでランタイム条件チェック | E-08 (行131-) | ○ |
| C-113 | storeComptimePtrでゼロビット最適化 | E-08 (行69-74) | ○ |
| C-114 | loadComptimePtrでエラーユニオンペイロード取得 | E-08 (行246-256) | ○ |
| C-115 | loadComptimePtrでエラー状態検出 | E-08 (行252-) | ○ |
| C-116 | loadComptimePtrでオプショナルペイロード取得 | E-08 (行258-268) | ○ |
| C-117 | loadComptimePtrでnull状態検出 | E-08 (行264-) | ○ |
| C-118 | loadComptimePtrで配列要素アクセス | E-08 (行270-291) | ○ |
| C-119 | loadComptimePtrで構造体フィールドアクセス | E-08 (行293-326) | ○ |
| C-120 | loadComptimePtrで非アクティブunionフィールドエラー | E-08 (行316-318) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-06 (UT-SEM-006)**: resolveInstの無効参照に対するエラー処理の詳細実装確認が必要
  - 候補：Sema.zig内のエラーハンドリングパス / ZIR参照検証ロジック / inst_mapの初期化パターン
- **C-88 (UT-SEM-088)**: auto layout structに対するbitCastの具体的な処理パス
  - 候補：bitcast.zig内のhasWellDefinedLayout判定 / エラー返却パス

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 算術演算テスト（C-39〜C-84）は根拠が明確で実装とテストケースが一致
- 0: 低リスク - LowerZonテスト（C-91〜C-105）はソースコードの分岐条件に対応
- 1: 中リスク - メモリ操作テスト（C-106〜C-120）は複雑なポインタ追跡が必要
- 1: 中リスク - bitCastテスト（C-85〜C-90）はエンディアン依存の処理あり
- 2: 高リスク - Semaコア機能（C-04〜C-10）は巨大なファイルのため網羅性確認が困難

## 6) レビュアーチェックリスト（最小）
- [ ] UT-SEM-006: resolveInstの無効参照処理が実際のコードパスと一致するか確認
- [ ] UT-SEM-088: auto layout structのbitCast処理がnullを返す条件を確認
- [ ] 算術演算テスト: オーバーフロー検出の閾値が実装と一致するか確認
- [ ] LowerZonテスト: ZON仕様との整合性確認（特に制限事項）
- [ ] comptime_ptr_access: ビッグエンディアン環境でのテスト考慮確認
- [ ] 全体: Zig言語固有の概念（comptime, AIR, ZIR）の正確性確認
