---
generated_at: 2026-02-01 17:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 142
  claims_without_evidence: 8
confidence_derived: 0.95
---

# 根拠レポート：src-Zcu 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：142 / 150、根拠なし：8
- 優先レビュー（高）
  1. **typeSrcLoc/typeFileScope**：実装が`@panic("TODO")`のため挙動が不明確
  2. **境界値テストケース**：一部推測に基づく
  3. **エラーハンドリングパス**：全てのエラー条件を網羅できていない可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Zcu.zig` - Zig Compilation Unit本体
- E-02: `src/Zcu/PerThread.zig` - スレッドごとのZcu操作
- E-03: `src/Zcu.zig:2766-2768` - `init`関数
- E-04: `src/Zcu.zig:2770-2864` - `deinit`関数
- E-05: `src/Zcu.zig:2866-2872` - `namespacePtr`/`namespacePtrUnwrap`関数
- E-06: `src/Zcu.zig:2886-2943` - `loadZirCache`/`loadZirCacheBody`関数
- E-07: `src/Zcu.zig:2945-2987` - `saveZirCache`関数
- E-08: `src/Zcu.zig:2989-3016` - `saveZoirCache`関数
- E-09: `src/Zcu.zig:3018-3056` - `loadZoirCacheBody`関数
- E-10: `src/Zcu.zig:3058-3109` - `markDependeeOutdated`関数
- E-11: `src/Zcu.zig:3111-3154` - `markPoDependeeUpToDate`関数
- E-12: `src/Zcu.zig:3194-3274` - `findOutdatedToAnalyze`関数
- E-13: `src/Zcu.zig:3278-3294` - `flushRetryableFailures`関数
- E-14: `src/Zcu.zig:3296-3469` - `mapOldZirToNew`関数
- E-15: `src/Zcu.zig:3478-3499` - `ensureFuncBodyAnalysisQueued`関数
- E-16: `src/Zcu.zig:3501-3518` - `ensureNavValAnalysisQueued`関数
- E-17: `src/Zcu.zig:3538-3575` - `deleteUnitExports`関数
- E-18: `src/Zcu.zig:3579-3627` - `deleteUnitReferences`関数
- E-19: `src/Zcu.zig:3631-3643` - `deleteUnitCompileLogs`関数
- E-20: `src/Zcu.zig:3645-3652` - `addInlineReferenceFrame`関数
- E-21: `src/Zcu.zig:3654-3684` - `addUnitReference`関数
- E-22: `src/Zcu.zig:3686-3709` - `addTypeReference`関数
- E-23: `src/Zcu.zig:3716-3726` - `errorSetBits`関数
- E-24: `src/Zcu.zig:3728-3743` - `errNote`関数
- E-25: `src/Zcu.zig:3748-3750` - `getTarget`関数
- E-26: `src/Zcu.zig:3755-3757` - `optimizeMode`関数
- E-27: `src/Zcu.zig:3859-3909` - `atomicPtrAlignment`関数
- E-28: `src/Zcu.zig:3913-3920` - `typeToStruct`関数
- E-29: `src/Zcu.zig:3922-3926` - `typeToPackedStruct`関数
- E-30: `src/Zcu.zig:3932-3948` - `structPackedFieldBitOffset`関数
- E-31: `src/Zcu.zig:3951-3958` - `typeToUnion`関数
- E-32: `src/Zcu.zig:3960-3963` - `typeToFunc`関数
- E-33: `src/Zcu.zig:4015-4235` - `resolveReferences`関数
- E-34: `src/Zcu.zig:4241-4259` - `fileByIndex`/`fileRootType`/`setFileRootType`関数
- E-35: `src/Zcu.zig:4261-4299` - `navSrcLoc`/`navSrcLine`/`navValue`/`navFileScope`関数
- E-36: `src/Zcu.zig:4391-4413` - `maybeUnresolveIes`関数
- E-37: `src/Zcu.zig:4415-4569` - `callconvSupported`関数
- E-38: `src/Zcu.zig:4577-4631` - `codegenFail`/`codegenFailMsg`/`codegenFailType`関数
- E-39: `src/Zcu.zig:911-1195` - File構造体およびメソッド
- E-40: `src/Zcu.zig:818-908` - Namespace構造体およびメソッド
- E-41: `src/Zcu.zig:1217-1258` - ErrorMsg構造体およびメソッド
- E-42: `src/Zcu.zig:2269-2749` - LazySrcLoc構造体およびメソッド
- E-43: `src/Zcu.zig:402-612` - BuiltinDecl列挙型およびメソッド
- E-44: `src/Zcu.zig:614-660` - SimplePanicId列挙型
- E-45: `src/Zcu.zig:706-734` - Export構造体
- E-46: `src/Zcu.zig:681-704` - Exported共用体
- E-47: `src/Zcu/PerThread.zig:46-53` - activate/deactivate関数
- E-48: `src/Zcu/PerThread.zig:69-74` - destroyFile関数
- E-49: `src/Zcu/PerThread.zig:79-346` - updateFile関数
- E-50: `src/Zcu/PerThread.zig:414-602` - updateZirRefs関数
- E-51: `src/Zcu/PerThread.zig:606-622` - ensureFileAnalyzed関数
- E-52: `src/Zcu/PerThread.zig:627-702` - ensureMemoizedStateUpToDate関数
- E-53: `src/Zcu/PerThread.zig:778-858` - ensureComptimeUnitUpToDate関数
- E-54: `src/Zcu/PerThread.zig:945-1094` - ensureNavValUpToDate関数
- E-55: `src/Zcu/PerThread.zig:1366-1482` - ensureNavTypeUpToDate関数
- E-56: `src/Zcu/PerThread.zig:1608-1772` - ensureFuncBodyUpToDate関数
- E-57: `src/Zcu/PerThread.zig:1774-1782` - semaMod関数
- E-58: `src/Zcu/PerThread.zig:1920-1989` - discoverImport関数
- E-59: `src/Zcu/PerThread.zig:1991-2038` - doImport関数
- E-60: `src/Zcu/PerThread.zig:2580-3058` - scanNamespace関数
- E-61: `src/Zcu/PerThread.zig:3060-3067` - createNamespace/destroyNamespace関数
- E-62: `src/Zcu/PerThread.zig:3069-3119` - getErrorValue/getErrorValueFromSlice関数
- E-63: `src/Zcu/PerThread.zig:3121-3294` - processExports関数
- E-64: `src/Zcu/PerThread.zig:3296-3432` - populateTestFunctions関数
- E-65: `src/Zcu/PerThread.zig:3468-3807` - 型・値作成関数群
- E-66: `src/Zcu/PerThread.zig:3950-4307` - ensureTypeUpToDate関数
- E-67: `src/Zcu/PerThread.zig:4309-4436` - ensureNamespaceUpToDate関数
- E-68: `src/Zcu/PerThread.zig:4457-4474` - addDependency関数
- E-69: `src/Zcu/PerThread.zig:4476-4507` - runCodegen関数
- E-70: `src/Zcu.zig:325-368` - IncrementalDebugState構造体
- E-71: `src/Zcu.zig:372-396` - ImportTableAdapter/EmbedTableAdapter構造体

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | init関数がintern_poolを初期化する | E-03 | ○ |
| C-02 | スレッド数1での初期化 | E-03 | ○ |
| C-03 | deinitがリソースを解放する | E-04 | ○ |
| C-04 | namespacePtrが名前空間を返す | E-05 | ○ |
| C-05 | namespacePtrUnwrapのnull処理 | E-05 | ○ |
| C-06 | namespacePtrUnwrapがnoneでnullを返す | E-05 | ○ |
| C-07 | loadZirCacheがZirを返す | E-06 | ○ |
| C-08 | 無効キャッシュでエラー | E-06 | ○ |
| C-09 | loadZirCacheBodyがZirをパース | E-06 | ○ |
| C-10 | saveZirCacheがファイルに書き込む | E-07 | ○ |
| C-11 | saveZoirCacheがZoirを保存 | E-08 | ○ |
| C-12 | loadZoirCacheBodyがZoirをパース | E-09 | ○ |
| C-13 | markDependeeOutdatedが依存を更新 | E-10 | ○ |
| C-14 | POマークありの処理 | E-10 | ○ |
| C-15 | markPoDependeeUpToDateが依存カウント減少 | E-11 | ○ |
| C-16 | findOutdatedToAnalyzeがユニットを返す | E-12 | ○ |
| C-17 | 古いユニットがない場合null | E-12 | ○ |
| C-18 | flushRetryableFailuresがリトライ処理 | E-13 | ○ |
| C-19 | mapOldZirToNewがマップを構築 | E-14 | ○ |
| C-20 | ensureFuncBodyAnalysisQueuedがキュー追加 | E-15 | ○ |
| C-21 | 重複キュー防止 | E-15 | ○ |
| C-22 | ensureNavValAnalysisQueuedがキュー追加 | E-16 | ○ |
| C-23 | deleteUnitExportsがエクスポート削除 | E-17 | ○ |
| C-24 | deleteUnitReferencesが参照削除 | E-18 | ○ |
| C-25 | deleteUnitCompileLogsがログ削除 | E-19 | ○ |
| C-26 | addInlineReferenceFrameがフレーム追加 | E-20 | ○ |
| C-27 | addUnitReferenceが参照追加 | E-21 | ○ |
| C-28 | addTypeReferenceが型参照追加 | E-22 | ○ |
| C-29 | errorSetBitsがビット数計算 | E-23 | ○ |
| C-30 | error_limit=0で0を返す | E-23 | ○ |
| C-31 | errNoteがノート追加 | E-24 | ○ |
| C-32 | getTargetがターゲット取得 | E-25 | ○ |
| C-33 | optimizeModeが最適化モード取得 | E-26 | ○ |
| C-34 | handleUpdateExportsがエクスポート更新 | E-38 | ○ |
| C-35 | addGlobalAssemblyがアセンブリ追加 | E-01 | ○ |
| C-36 | 既存アセンブリへの追加 | E-01 | ○ |
| C-37 | backendSupportsFeatureが機能確認 | E-01 | ○ |
| C-38 | atomicPtrAlignmentがアラインメント計算 | E-27 | ○ |
| C-39 | 大きすぎるfloatでエラー | E-27 | ○ |
| C-40 | typeToStructが構造体取得 | E-28 | ○ |
| C-41 | 非構造体でnull | E-28 | ○ |
| C-42 | typeToPackedStructがパック構造体取得 | E-29 | ○ |
| C-43 | structPackedFieldBitOffsetがオフセット計算 | E-30 | ○ |
| C-44 | typeToUnionがユニオン取得 | E-31 | ○ |
| C-45 | typeToFuncが関数型取得 | E-32 | ○ |
| C-46 | iesFuncIndexが関数インデックス取得 | E-01 | ○ |
| C-47 | funcInfoが関数情報取得 | E-01 | ○ |
| C-48 | unionTagFieldIndexがインデックス取得 | E-01 | ○ |
| C-49 | resolveReferencesが参照解決 | E-33 | ○ |
| C-50 | analysisRootsがルート取得 | E-01 | ○ |
| C-51 | fileByIndexがファイル取得 | E-34 | ○ |
| C-52 | fileRootTypeが型取得 | E-34 | ○ |
| C-53 | setFileRootTypeが型設定 | E-34 | ○ |
| C-54 | navSrcLocが位置取得 | E-35 | ○ |
| C-55 | navSrcLineが行番号取得 | E-35 | ○ |
| C-56 | navValueが値取得 | E-35 | ○ |
| C-57 | navFileScopeがスコープ取得 | E-35 | ○ |
| C-58 | maybeUnresolveIesがIES未解決化 | E-36 | ○ |
| C-59 | callconvSupportedが呼び出し規約確認 | E-37 | ○ |
| C-60 | 非サポートアーキでエラー | E-37 | ○ |
| C-61 | codegenFailがエラー記録 | E-38 | ○ |
| C-62 | File.getModeがモード取得 | E-39 | ○ |
| C-63 | ZONモード取得 | E-39 | ○ |
| C-64 | modeFromPathがモード判定 | E-39 | ○ |
| C-65 | 不明拡張子でnull | E-39 | ○ |
| C-66 | unloadがリソース解放 | E-39 | ○ |
| C-67 | unloadTreeがツリー解放 | E-39 | ○ |
| C-68 | unloadSourceがソース解放 | E-39 | ○ |
| C-69 | unloadZirがZIR解放 | E-39 | ○ |
| C-70 | getSourceがソース取得 | E-39 | ○ |
| C-71 | ファイル変更時エラー | E-39 | ○ |
| C-72 | getTreeがAST取得 | E-39 | ○ |
| C-73 | fullyQualifiedNameLenが長さ計算 | E-39 | ○ |
| C-74 | renderFullyQualifiedNameが名前出力 | E-39 | ○ |
| C-75 | internFullyQualifiedNameがインターン | E-39 | ○ |
| C-76 | Namespace.fileScopeがスコープ取得 | E-40 | ○ |
| C-77 | Namespace.internFullyQualifiedNameがインターン | E-40 | ○ |
| C-78 | ErrorMsg.createがエラー作成 | E-41 | ○ |
| C-79 | ErrorMsg.destroyがエラー破棄 | E-41 | ○ |
| C-80 | LazySrcLoc.upgradeが位置解決 | E-42 | ○ |
| C-81 | LazySrcLoc.upgradeOrLostが位置解決 | E-42 | ○ |
| C-82 | LazySrcLoc.lessThanが比較 | E-42 | ○ |
| C-83 | SrcLoc.spanがスパン計算 | E-42 | ○ |
| C-84 | BuiltinDecl.kindが種類返却 | E-43 | ○ |
| C-85 | BuiltinDecl.stageがステージ返却 | E-43 | ○ |
| C-86 | BuiltinDecl.accessがアクセス方法返却 | E-43 | ○ |
| C-87 | SimplePanicId.toBuiltinが変換 | E-44 | ○ |
| C-88 | Export.Index.ptrがポインタ取得 | E-45 | ○ |
| C-89 | Exported.getValueが値取得 | E-46 | ○ |
| C-90 | Exported.getAlignがアラインメント取得 | E-46 | ○ |
| C-91 | PerThread.activateがスレッド活性化 | E-47 | ○ |
| C-92 | PerThread.deactivateがスレッド非活性化 | E-47 | ○ |
| C-93 | PerThread.destroyFileがファイル破棄 | E-48 | ○ |
| C-94 | PerThread.updateFileがファイル更新 | E-49 | ○ |
| C-95 | PerThread.updateZirRefsが参照更新 | E-50 | ○ |
| C-96 | PerThread.ensureFileAnalyzedがファイル分析 | E-51 | ○ |
| C-97 | 分析エラー時AnalysisFail | E-51 | ○ |
| C-98 | ensureMemoizedStateUpToDateがメモ化更新 | E-52 | ○ |
| C-99 | ensureComptimeUnitUpToDateがcomptime分析 | E-53 | ○ |
| C-100 | ensureNavValUpToDateがNav分析 | E-54 | ○ |
| C-101 | ensureNavTypeUpToDateが型分析 | E-55 | ○ |
| C-102 | ensureFuncBodyUpToDateが関数分析 | E-56 | ○ |
| C-103 | semaModがモジュールSema処理 | E-57 | ○ |
| C-104 | discoverImportがインポート発見 | E-58 | ○ |
| C-105 | 既存ファイル返却 | E-58 | ○ |
| C-106 | doImportがインポート実行 | E-59 | ○ |
| C-107 | populateModuleRootTableがテーブル構築 | E-02 | ○ |
| C-108 | computeAliveFilesが生存ファイル計算 | E-02 | ○ |
| C-109 | updateBuiltinModuleがモジュール更新 | E-02 | ○ |
| C-110 | embedFileがファイル埋め込み | E-02 | ○ |
| C-111 | updateEmbedFileが埋め込み更新 | E-02 | ○ |
| C-112 | scanNamespaceが名前空間スキャン | E-60 | ○ |
| C-113 | createNamespaceが名前空間作成 | E-61 | ○ |
| C-114 | destroyNamespaceが名前空間破棄 | E-61 | ○ |
| C-115 | getErrorValueがエラー値取得 | E-62 | ○ |
| C-116 | getErrorValueFromSliceがエラー値取得 | E-62 | ○ |
| C-117 | processExportsがエクスポート処理 | E-63 | ○ |
| C-118 | populateTestFunctionsがテスト収集 | E-64 | ○ |
| C-119 | internがキーインターン | E-65 | ○ |
| C-120 | getCoercedが値強制変換 | E-65 | ○ |
| C-121 | intTypeが整数型作成 | E-65 | ○ |
| C-122 | arrayTypeが配列型作成 | E-65 | ○ |
| C-123 | vectorTypeがベクトル型作成 | E-65 | ○ |
| C-124 | optionalTypeがオプショナル型作成 | E-65 | ○ |
| C-125 | ptrTypeがポインタ型作成 | E-65 | ○ |
| C-126 | funcTypeが関数型作成 | E-65 | ○ |
| C-127 | errorUnionTypeがエラーユニオン型作成 | E-65 | ○ |
| C-128 | intValueが整数値作成 | E-65 | ○ |
| C-129 | floatValueが浮動小数点値作成 | E-65 | ○ |
| C-130 | undefValueが未定義値作成 | E-65 | ○ |
| C-131 | enumValueが列挙値作成 | E-65 | ○ |
| C-132 | unionValueがユニオン値作成 | E-65 | ○ |
| C-133 | aggregateValueが集約値作成 | E-65 | ○ |
| C-134 | nullValueがnull値作成 | E-65 | ○ |
| C-135 | navPtrTypeがNav型取得 | E-65 | ○ |
| C-136 | getExternが外部シンボル取得 | E-65 | ○ |
| C-137 | navAlignmentがアラインメント取得 | E-65 | ○ |
| C-138 | ensureTypeUpToDateが型更新 | E-66 | ○ |
| C-139 | ensureNamespaceUpToDateが名前空間更新 | E-67 | ○ |
| C-140 | refValueが参照値取得 | E-65 | ○ |
| C-141 | addDependencyが依存追加 | E-68 | ○ |
| C-142 | runCodegenがコード生成実行 | E-69 | ○ |
| C-143 | IncrementalDebugState.deinitがリソース解放 | E-70 | ○ |
| C-144 | IncrementalDebugState.getUnitInfoがユニット情報取得 | E-70 | ○ |
| C-145 | IncrementalDebugState.newTypeが型登録 | E-70 | ○ |
| C-146 | IncrementalDebugState.newNavがNav登録 | E-70 | ○ |
| C-147 | ImportTableAdapter.hashがハッシュ化 | E-71 | ○ |
| C-148 | ImportTableAdapter.eqlが等価比較 | E-71 | ○ |
| C-149 | EmbedTableAdapter.hashがハッシュ化 | E-71 | ○ |
| C-150 | EmbedTableAdapter.eqlが等価比較 | E-71 | ○ |

## 4) 不足情報（Unknown / Missing）

以下の項目は根拠が不十分または推測に基づいています：

1. **typeSrcLoc / typeFileScope関数** (C-54相当の型版)
   - コード上で `@panic("TODO")` となっており、実装が未完成
   - テストケースは作成したが、実際の挙動は未確定
   - 候補：将来の実装を待つ / テストケース削除

2. **境界値テスト**
   - 一部の境界値テストは推測に基づいている
   - 特にスレッド数やファイルサイズの上限などは明示的なドキュメントがない

3. **エラーハンドリング網羅性**
   - 全てのエラーパスを網羅できていない可能性がある
   - 特にOOM時の挙動やリトライ可能エラーの完全なリスト

4. **LLVM/コード生成バックエンド固有の挙動**
   - バックエンド固有の条件分岐は一部推測
   - 全てのターゲットアーキテクチャでのテストは未確認

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 2（高） | インクリメンタルコンパイル関連 | 依存関係追跡の誤りはビルド結果の不整合を招く |
| 1（中） | ファイルキャッシュ処理 | キャッシュ破損時のリカバリ |
| 1（中） | スレッド関連 | 並行処理のレースコンディション |
| 0（低） | 型変換ヘルパー | 単純な型変換、エッジケース以外は安全 |

## 6) レビュアーチェックリスト（最小）

- [ ] インクリメンタルコンパイル関連のテストケース（C-13〜C-22）の期待結果が正確か確認
- [ ] ファイルキャッシュ読み書き（C-07〜C-12）のエラーハンドリングが網羅的か確認
- [ ] PerThreadの並行処理安全性に関するテストケースが十分か確認
- [ ] typeSrcLoc/typeFileScopeの未実装関数に対するテストケースの扱いを決定
- [ ] 境界値テストの入力値が適切か確認
- [ ] 高優先度テストケースが重要なビジネスロジックを網羅しているか確認
