---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 93
  claims_with_evidence: 93
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：src-codegen 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：93 / 93、根拠なし：0
- 優先レビュー（高）
  1. **legalizeFeatures関連テスト（UT-CDG-001, 018, 027, 045, 048, 053, 061）**：各バックエンドの法的化機能設定
  2. **ABI分類テスト（UT-CDG-039〜044）**：Windows/SystemV ABIの型分類ロジック
  3. **コード生成テスト（UT-CDG-046, 051）**：MIR/SPIR-V コード生成メイン処理

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/zig/src/codegen/c.zig`
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/zig/src/codegen/llvm.zig`
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/zig/src/codegen/aarch64.zig`
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/zig/src/codegen/x86_64/CodeGen.zig`
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/zig/src/codegen/x86_64/abi.zig`
- E-06: `/Users/tomokababa/Work/reverse-engineering/sample/zig/src/codegen/spirv/CodeGen.zig`
- E-07: `/Users/tomokababa/Work/reverse-engineering/sample/zig/src/codegen/wasm/CodeGen.zig`
- E-08: `/Users/tomokababa/Work/reverse-engineering/sample/zig/src/codegen/riscv64/CodeGen.zig`
- E-09: `/Users/tomokababa/Work/reverse-engineering/sample/zig/src/codegen/c/Type.zig`
- E-10: `/Users/tomokababa/Work/reverse-engineering/sample/zig/src/codegen/aarch64/encoding.zig`

## 3) Claims と根拠の対応（レビューの主戦場）

### Cバックエンド（c.zig）関連テスト
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | legalizeFeatures関数が法的化機能フラグを返却する | E-01 (行26-43) | ○ |
| C-02 | Mir.deinit関数がメモリを正しく解放する | E-01 (行66-73) | ○ |
| C-03 | CValue.eql関数が同一値でtrueを返す | E-01 (行106-158) | ○ |
| C-04 | CValue.eql関数が異なる値でfalseを返す | E-01 (行106-158) | ○ |
| C-05 | CValue.none型同士の比較が正しく動作する | E-01 (行108) | ○ |
| C-06 | isReservedIdent関数がC予約語を検出する | E-01 (行336-347) | ○ |
| C-07 | isReservedIdent関数が非予約語を正しく判定する | E-01 (行336-347) | ○ |
| C-08 | アンダースコア2つで始まる識別子が予約語と判定される | E-01 (行337-340) | ○ |
| C-09 | formatIdentSolo関数が予約語にプレフィックスを付ける | E-01 (行349-351, 358-360) | ○ |
| C-10 | formatIdentSolo関数が数字で始まる識別子をエスケープする | E-01 (行365-367) | ○ |
| C-11 | isMangledIdent関数がマングリング必要な識別子を検出する | E-01 (行408-418) | ○ |
| C-12 | ValueRenderLocation.isInitializer関数が正しく判定する | E-01 (行201-206) | ○ |
| C-13 | ValueRenderLocation.toCTypeKind関数が正しく変換する | E-01 (行208-215) | ○ |
| C-14 | Function.resolveInst関数がキャッシュから値を取得する | E-01 (行448-475) | ○ |
| C-15 | Function.wantSafety関数がDebugモードでtrueを返す | E-01 (行477-481) | ○ |
| C-16 | Function.wantSafety関数がReleaseFastモードでfalseを返す | E-01 (行477-481) | ○ |
| C-17 | Function.allocLocalValue関数が新規ローカル変数を割り当てる | E-01 (行487-494) | ○ |

### LLVMバックエンド（llvm.zig）関連テスト
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | legalizeFeatures関数が法的化機能フラグを返却する | E-02 (行43-48) | ○ |
| C-19 | targetTriple関数がx86_64トリプルを正しく生成する | E-02 (行58-324) | ○ |
| C-20 | targetTriple関数がaarch64トリプルを正しく生成する | E-02 (行58-324) | ○ |
| C-21 | targetTriple関数がWindows UEFIを正しく処理する | E-02 (行218) | ○ |
| C-22 | supportsTailCall関数がwasmでtail_call判定を行う | E-02 (行326-334) | ○ |
| C-23 | supportsTailCall関数がmipsでfalseを返す | E-02 (行330) | ○ |
| C-24 | dataLayout関数がx86_64用レイアウトを返す | E-02 (行336-493) | ○ |
| C-25 | dataLayout関数がaarch64用レイアウトを返す | E-02 (行343-354) | ○ |
| C-26 | dataLayout関数がmachoフォーマット用レイアウトを返す | E-02 (行343-354) | ○ |

### x86_64バックエンド関連テスト
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | legalizeFeatures関数が法的化機能フラグを返却する | E-04 (行36-77) | ○ |
| C-28 | MCValue.isModifiable関数がregister型でtrueを返す | E-04 (行232-266) | ○ |
| C-29 | MCValue.isModifiable関数がimmediate型でfalseを返す | E-04 (行232-266) | ○ |
| C-30 | MCValue.isMemory関数がmemory型でtrueを返す | E-04 (行276-288) | ○ |
| C-31 | MCValue.isMemory関数がregister型でfalseを返す | E-04 (行276-288) | ○ |
| C-32 | MCValue.isImmediate関数がimmediate型でtrueを返す | E-04 (行290-294) | ○ |
| C-33 | MCValue.isRegister関数がregister型でtrueを返す | E-04 (行297-300) | ○ |
| C-34 | Class.isX87関数がx87クラスでtrueを返す | E-05 (行81-86) | ○ |
| C-35 | Class.isX87関数がintegerクラスでfalseを返す | E-05 (行81-86) | ○ |
| C-36 | Class.combineSystemV関数が同一クラスを結合する | E-05 (行89-110) | ○ |
| C-37 | Class.combineSystemV関数がmemoryとの結合を処理する | E-05 (行99) | ○ |
| C-38 | Class.combineSystemV関数がnoneとの結合を処理する | E-05 (行96) | ○ |
| C-39 | classifyWindows関数がポインタ型をintegerに分類する | E-05 (行115-170) | ○ |
| C-40 | classifyWindows関数がfloat64型をsseに分類する | E-05 (行152-157) | ○ |
| C-41 | classifyWindows関数が大きな構造体をmemoryに分類する | E-05 (行142-150) | ○ |
| C-42 | classifySystemV関数がポインタ型をone_integerに分類する | E-05 (行174-200) | ○ |
| C-43 | classifySystemV関数がスライス型をtwo_integersに分類する | E-05 (行177) | ○ |
| C-44 | classifySystemV関数が128bit整数をtwo_integersに分類する | E-05 (行183) | ○ |

### aarch64バックエンド関連テスト
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | legalizeFeatures関数がnullを返却する | E-03 (行8-10) | ○ |
| C-46 | generate関数がMIRを正しく生成する | E-03 (行12-193) | ○ |
| C-47 | generate関数が無効な入力でエラーを返す | E-03 (行12-193) | ○ |

### SPIR-Vバックエンド関連テスト
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | legalizeFeatures関数が法的化機能フラグを返却する | E-06 (行31-40) | ○ |
| C-49 | deinit関数がメモリを正しく解放する | E-06 (行161-169) | ○ |
| C-50 | ControlFlow.deinit関数がメモリを正しく解放する | E-06 (行131-143) | ○ |
| C-51 | genNav関数がSPIR-Vコードを生成する | E-06 (行173-255) | ○ |
| C-52 | genNav関数がランタイムビットなし型で早期リターンする | E-06 (行183) | ○ |

### WASMバックエンド関連テスト
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | legalizeFeatures関数が法的化機能フラグを返却する | E-07 (行31-40) | ○ |
| C-54 | WValue.offset関数がstack_offsetで正しいオフセットを返す | E-07 (行195-201) | ○ |
| C-55 | WValue.offset関数が非stack_offsetで0を返す | E-07 (行199) | ○ |
| C-56 | WValue.offset関数がdead型でunreachableとなる | E-07 (行198) | ○ |
| C-57 | WValue.toLocal関数がstack型をlocal型に変換する | E-07 (行206-216) | ○ |
| C-58 | WValue.toLocal関数がlocal型をそのまま返す | E-07 (行213) | ○ |
| C-59 | WValue.free関数がローカル変数をfree_localsに追加する | E-07 (行221-238) | ○ |
| C-60 | WValue.free関数が予約済みローカルを解放しない | E-07 (行224-225) | ○ |

### RISC-V64バックエンド関連テスト
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | legalizeFeatures関数が法的化機能フラグを返却する | E-08 (行54-63) | ○ |
| C-62 | MCValue.isMemory関数がmemory型でtrueを返す | E-08 (行200) | ○ |
| C-63 | MCValue.isMemory関数がload_frame型でtrueを返す | E-08 (行200) | ○ |
| C-64 | Owner.getSymbolIndex関数がシンボルインデックスを取得する | E-08 (行141-155) | ○ |

### C型システム（c/Type.zig）関連テスト
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | fromPoolIndex関数がCTypeを生成する | E-09 (行23-25) | ○ |
| C-66 | toPoolIndex関数がプールインデックスを取得する | E-09 (行27-34) | ○ |
| C-67 | toPoolIndex関数がプリミティブ型でnullを返す | E-09 (行27-34) | ○ |
| C-68 | eql関数が同一CTypeでtrueを返す | E-09 (行36-38) | ○ |
| C-69 | eql関数が異なるCTypeでfalseを返す | E-09 (行36-38) | ○ |
| C-70 | isBool関数がbool型でtrueを返す | E-09 (行40-45) | ○ |
| C-71 | isBool関数がint型でfalseを返す | E-09 (行40-45) | ○ |
| C-72 | isInteger関数が整数型でtrueを返す | E-09 (行47-77) | ○ |
| C-73 | isInteger関数が浮動小数点型でfalseを返す | E-09 (行47-77) | ○ |
| C-74 | signedness関数が符号付き型で.signedを返す | E-09 (行79-110) | ○ |
| C-75 | signedness関数が符号なし型で.unsignedを返す | E-09 (行79-110) | ○ |
| C-76 | isFloat関数が浮動小数点型でtrueを返す | E-09 (行112-126) | ○ |
| C-77 | isFloat関数が整数型でfalseを返す | E-09 (行112-126) | ○ |
| C-78 | toSigned関数がunsigned charをsigned charに変換する | E-09 (行128-153) | ○ |
| C-79 | toUnsigned関数がsigned charをunsigned charに変換する | E-09 (行155-171) | ○ |
| C-80 | toSignedness関数が指定した符号に変換する | E-09 (行173-178) | ○ |
| C-81 | isAnyChar関数がchar型でtrueを返す | E-09 (行180-185) | ○ |
| C-82 | isAnyChar関数がint型でfalseを返す | E-09 (行180-185) | ○ |

### aarch64エンコーディング関連テスト
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | Register.GeneralSize.prefix関数がwordで'w'を返す | E-10 (行21-26) | ○ |
| C-84 | Register.GeneralSize.prefix関数がdoublewordで'x'を返す | E-10 (行21-26) | ○ |
| C-85 | Register.ScalarSize.prefix関数がbyteで'b'を返す | E-10 (行44-52) | ○ |
| C-86 | Register.ScalarSize.n関数がサイズを1段階小さくする | E-10 (行36-38) | ○ |
| C-87 | Register.ScalarSize.w関数がサイズを1段階大きくする | E-10 (行40-42) | ○ |
| C-88 | Register.Arrangement.len関数が2dで2を返す | E-10 (行77-85) | ○ |
| C-89 | Register.Arrangement.len関数が16bで16を返す | E-10 (行77-85) | ○ |
| C-90 | Register.Arrangement.size関数が配列サイズを取得する | E-10 (行87-89) | ○ |
| C-91 | Register.Arrangement.elemSize関数が要素サイズを取得する | E-10 (行90-92) | ○ |
| C-92 | Register.Arrangement.wrap関数がUnwrappedからArrangementに変換する | E-10 (行70-72) | ○ |
| C-93 | Register.Arrangement.unwrap関数がArrangementからUnwrappedに変換する | E-10 (行73-75) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全てのテストケースにソースコードの根拠が存在）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいて生成されている
- 注意点:
  - Zigコンパイラの内部実装に依存するため、バージョンアップ時に再検証が必要
  - 各バックエンド（x86_64, aarch64, RISC-V, WASM, SPIR-V）で異なる実装詳細がある

## 6) レビュアーチェックリスト（最小）
- [ ] legalizeFeatures関連テスト（UT-CDG-001, 018, 027, 045, 048, 053, 061）の入力値・期待結果が妥当か確認
- [ ] ABI分類テスト（UT-CDG-039〜044）がWindows/SystemV ABI仕様に準拠しているか確認
- [ ] MCValue/WValue/CValue関連テストの境界値が網羅されているか確認
- [ ] 各バックエンドのCodeGen.zig関連テストが主要な機能をカバーしているか確認
- [ ] 型変換テスト（toSigned, toUnsigned等）が全ての型組み合わせを網羅しているか確認
