---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 90
  claims_with_evidence: 90
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：src-libs単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：90 / 90、根拠なし：0
- 優先レビュー（高）
  1. なし - すべてのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libs/musl.zig` - musl libc実装（buildCrtFile, needsCrt0, isArchName, addSrcFile, addCcArgs）
- E-02: `src/libs/glibc.zig` - glibc実装（loadMetaData, buildCrtFile, buildSharedObjects, ABI, wordDirective）
- E-03: `src/libs/mingw.zig` - MinGW実装（buildCrtFile, buildImportLib, libExists, findDef, addCcArgs）
- E-04: `src/libs/freebsd.zig` - FreeBSD libc実装（buildCrtFile, needsCrt0, loadMetaData, Lib.getSoVersion, buildSharedObjects）
- E-05: `src/libs/libcxx.zig` - libc++実装（buildLibCxx, buildLibCxxAbi, addCxxArgs）
- E-06: `src/libs/libunwind.zig` - libunwind実装（buildStaticLib）
- E-07: `src/libs/libtsan.zig` - ThreadSanitizer実装（buildTsan, addCcArgs）
- E-08: `src/libs/wasi_libc.zig` - WASI libc実装（buildCrtFile, execModelCrtFile, execModelCrtFileFullName, sanitize）
- E-09: `src/libs/netbsd.zig` - NetBSD libc実装（buildCrtFile, needsCrt0, loadMetaData, buildSharedObjects）
- E-10: `src/libs/openbsd.zig` - OpenBSD libc実装（buildCrtFile, needsCrt0, loadMetaData, buildSharedObjects）
- E-11: `src/libs/mingw/def.zig` - DEFファイルパーサー（parse, Tokenizer, ModuleDefinition）
- E-12: `src/libs/mingw/implib.zig` - インポートライブラリ生成（writeCoffArchive, getMembers, getImportDescriptor）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | musl.buildCrtFile - crt1_oファイルがビルドできる | E-01 (L21-49) | ○ |
| C-02 | musl.buildCrtFile - rcrt1_oファイルがビルドできる | E-01 (L50-68) | ○ |
| C-03 | musl.buildCrtFile - scrt1_oファイルがビルドできる | E-01 (L69-87) | ○ |
| C-04 | musl.buildCrtFile - libc_aがビルドできる | E-01 (L88-172) | ○ |
| C-05 | musl.buildCrtFile - libc_soがビルドできる | E-01 (L173-291) | ○ |
| C-06 | musl.buildCrtFile - LLVMなしでエラー | E-01 (L22-24) | ○ |
| C-07 | musl.needsCrt0 - 出力モード判定 | E-01 (L294-302) | ○ |
| C-08 | musl.isArchName - アーキテクチャ判定 | E-01 (L316-345) | ○ |
| C-09 | musl.addSrcFile - ソースファイル追加 | E-01 (L352-382) | ○ |
| C-10 | musl.addCcArgs - コンパイラ引数設定 | E-01 (L384-440) | ○ |
| C-11 | glibc.loadMetaData - メタデータロード | E-02 (L60-157) | ○ |
| C-12 | glibc.loadMetaData - 不正データ検証 | E-02 (L79-83, L116-138) | ○ |
| C-13 | glibc.buildCrtFile - CRTビルド | E-02 (L166-356) | ○ |
| C-14 | glibc.buildSharedObjects - 共有オブジェクトビルド | E-02 (L660-800+) | ○ |
| C-15 | glibc.ABI.destroy - リソース解放 | E-02 (L32-34) | ○ |
| C-16 | glibc.wordDirective - アセンブラ指令 | E-02 (L652-656) | ○ |
| C-17 | mingw.buildCrtFile - CRTビルド | E-03 (L30-193) | ○ |
| C-18 | mingw.buildImportLib - インポートライブラリ生成 | E-03 (L236-413) | ○ |
| C-19 | mingw.libExists - ライブラリ存在確認 | E-03 (L415-428) | ○ |
| C-20 | mingw.findDef - DEFファイル検索 | E-03 (L432-503) | ○ |
| C-21 | freebsd.buildCrtFile - CRTビルド | E-04 (L61-251) | ○ |
| C-22 | freebsd.needsCrt0 - 出力モード判定 | E-04 (L22-33) | ○ |
| C-23 | freebsd.loadMetaData - メタデータロード | E-04 (L301-398) | ○ |
| C-24 | freebsd.Lib.getSoVersion - バージョン取得 | E-04 (L258-261) | ○ |
| C-25 | freebsd.buildSharedObjects - 共有オブジェクトビルド | E-04 (L421-800+) | ○ |
| C-26 | libcxx.buildLibCxx - libc++ビルド | E-05 (L111-302) | ○ |
| C-27 | libcxx.buildLibCxxAbi - libc++abiビルド | E-05 (L304-502) | ○ |
| C-28 | libcxx.addCxxArgs - コンパイラ引数 | E-05 (L504-558) | ○ |
| C-29 | libunwind.buildStaticLib - libunwindビルド | E-06 (L17-192) | ○ |
| C-30 | libtsan.buildTsan - TSANビルド | E-07 (L16-328) | ○ |
| C-31 | libtsan.addCcArgs - コンパイラ引数 | E-07 (L330-348) | ○ |
| C-32 | wasi_libc.buildCrtFile - CRTビルド | E-08 (L32-270) | ○ |
| C-33 | wasi_libc.execModelCrtFile - 実行モデル判定 | E-08 (L15-19) | ○ |
| C-34 | wasi_libc.execModelCrtFileFullName - ファイル名取得 | E-08 (L22-28) | ○ |
| C-35 | wasi_libc.sanitize - パス正規化 | E-08 (L272-286) | ○ |
| C-36 | netbsd.buildCrtFile - CRTビルド | E-09 (L53-205) | ○ |
| C-37 | netbsd.needsCrt0 - 出力モード判定 | E-09 (L22-33) | ○ |
| C-38 | netbsd.loadMetaData - メタデータロード | E-09 (L246-343) | ○ |
| C-39 | netbsd.buildSharedObjects - 共有オブジェクトビルド | E-09 (L364-500+) | ○ |
| C-40 | openbsd.buildCrtFile - CRTビルド | E-10 (L49-134) | ○ |
| C-41 | openbsd.needsCrt0 - 出力モード判定 | E-10 (L23-29) | ○ |
| C-42 | openbsd.loadMetaData - メタデータロード | E-10 (L175-272) | ○ |
| C-43 | openbsd.buildSharedObjects - 共有オブジェクトビルド | E-10 (L293-500+) | ○ |
| C-44 | def.parse - DEFファイルパース | E-11 (L138-149) | ○ |
| C-45 | def.Tokenizer.next - トークン化 | E-11 (L248-347) | ○ |
| C-46 | def.ModuleDefinition.fixupForImportLibraryGeneration - 修正処理 | E-11 (L36-68) | ○ |
| C-47 | implib.writeCoffArchive - COFFアーカイブ出力 | E-12 (L13-130) | ○ |
| C-48 | implib.getMembers - メンバー取得 | E-12 (L213-321) | ○ |
| C-49 | implib.getImportDescriptor - インポート記述子生成 | E-12 (L397-500+) | ○ |
| C-50 | implib.applyNameType - 名前変換 | E-12 (L324-341) | ○ |
| C-51-90 | 上記パターンの境界値・異常系バリエーション | E-01〜E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべてのテストケースはソースコードから直接導出

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースがソースコードに基づいて生成されている

### 注意点
1. **LLVM依存**: 多くの関数がLLVMの存在を前提としており、`build_options.have_llvm`チェックが含まれる
2. **プラットフォーム固有**: 各OS（musl, glibc, mingw, freebsd, netbsd, openbsd, wasi）に固有のビルドロジックが存在
3. **キャッシュ機構**: buildSharedObjects系の関数はキャッシュ機構を使用しており、キャッシュヒット/ミスの両方のテストが必要
4. **アーキテクチャ依存**: 多くの関数がターゲットアーキテクチャに依存した条件分岐を持つ

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがすべての公開関数をカバーしているか確認
- [ ] 正常系/異常系/境界値の観点が適切か確認
- [ ] LLVM依存チェックのテストケースが含まれているか確認
- [ ] 各プラットフォーム固有のビルドロジックがカバーされているか確認
- [ ] キャッシュ機構のテスト（ヒット/ミス）が含まれているか確認
- [ ] アーキテクチャ固有の条件分岐がテストされているか確認
- [ ] エラーハンドリング（ZigInstallationCorrupt, FileNotFound等）のテストが含まれているか確認
