---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 100
  claims_with_evidence: 95
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート：src-link単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：95 / 100、根拠なし：5
- 優先レビュー（高）
  1. **UT-LNK-096 (C.zig)**: ファイル内容の詳細確認が必要
  2. **UT-LNK-097 (aarch64.zig)**: アーキテクチャ固有処理の詳細確認が必要
  3. **UT-LNK-098 (riscv.zig)**: アーキテクチャ固有処理の詳細確認が必要
  4. **UT-LNK-099 (table_section.zig)**: テーブルセクション処理の詳細確認が必要
  5. **UT-LNK-100 (BinaryModule.zig)**: バイナリモジュール処理の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/link/Elf.zig` - ELFリンカー実装（約4000行）
- E-02: `src/link/MachO.zig` - Mach-Oリンカー実装（約5000行）
- E-03: `src/link/Coff.zig` - COFFリンカー実装（約2400行）
- E-04: `src/link/Wasm.zig` - WebAssemblyリンカー実装（約4300行）
- E-05: `src/link/Dwarf.zig` - DWARFデバッグ情報生成（約7100行）
- E-06: `src/link/SpirV.zig` - SPIR-Vリンカー実装（約260行）
- E-07: `src/link/Lld.zig` - LLD連携実装（約1700行）
- E-08: `src/link/MappedFile.zig` - メモリマップドファイル（約1000行）
- E-09: `src/link/LdScript.zig` - リンカースクリプトパーサー（約330行）
- E-10: `src/link/Queue.zig` - タスクキュー管理（約200行）
- E-11: `src/link/StringTable.zig` - 文字列テーブル（約50行）
- E-12: `src/link/Elf/Atom.zig` - ELF Atom実装（約2000行）
- E-13: `src/link/Elf/Symbol.zig` - ELFシンボル実装（約450行）
- E-14: `src/link/Elf/Object.zig` - ELFオブジェクトファイル（約1600行）
- E-15: `src/link/MachO/Atom.zig` - Mach-O Atom実装（約1200行）
- E-16: `src/link/MachO/Symbol.zig` - Mach-Oシンボル実装（約360行）
- E-17: `src/link/Wasm/Object.zig` - Wasmオブジェクト実装（約2500行）
- E-18: `src/link/tapi/Tokenizer.zig` - TAPIトークナイザ（約340行）
- E-19: `src/link/tapi/parse.zig` - TAPIパーサー（約600行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ELFリンカーがcreateEmptyで初期化される | E-01 (line 193-200) | ○ |
| C-02 | 非ELFターゲットでアサーションエラー | E-01 (line 200: assert) | ○ |
| C-03 | padToIdeal関数の容量計算 | E-01 (line 189) | ○ |
| C-04 | OptionalProgramHeaderIndex.unwrapの動作 | E-01 (line 136-145) | ○ |
| C-05 | ProgramHeaderIndex.toOptionalの動作 | E-01 (line 150-159) | ○ |
| C-07 | MachOリンカーがcreateEmptyで初期化される | E-02 (line 160-200) | ○ |
| C-08 | 非Mach-Oターゲットでアサーションエラー | E-02 (line 167: assert) | ○ |
| C-09 | hashAddFrameworksのハッシュ計算 | E-02 (line 152-158) | ○ |
| C-10 | Node.PseudoSectionMapIndex.nameの動作 | E-03 (line 145-147) | ○ |
| C-11 | Node.PseudoSectionMapIndex.symbolの動作 | E-03 (line 149-151) | ○ |
| C-14 | string_bytes_lockの並行処理安全性 | E-04 (line 60-61) | ○ |
| C-16 | Dwarf.UpdateErrorの定義 | E-05 (line 44-61) | ○ |
| C-17 | AddressSize列挙型の値 | E-05 (line 68-72) | ○ |
| C-19 | ModInfo.deinitのリソース解放 | E-05 (line 79-83) | ○ |
| C-20 | DebugAranges.headerBytesの計算 | E-05 (line 98-100) | ○ |
| C-21 | SpirV.createEmptyの初期化 | E-06 (line 29-88) | ○ |
| C-22 | SpirV LLD/LLVM使用時のアサーション | E-06 (line 39-40) | ○ |
| C-23 | SpirV.deinitのリソース解放 | E-06 (line 99-102) | ○ |
| C-24 | SpirV.generateのコード生成 | E-06 (line 104-150) | ○ |
| C-26 | Lld.Coff.initの初期化 | E-07 (line 32-72) | ○ |
| C-27 | x86_64のデフォルトimage_base | E-07 (line 38-39) | ○ |
| C-28 | x86のデフォルトimage_base | E-07 (line 40) | ○ |
| C-29 | Lld.Elf.initの初期化 | E-07 (line 105-150) | ○ |
| C-30 | MIPSのデフォルトentry_name | E-07 (line 115-118) | ○ |
| C-31 | MappedFile.initの初期化 | E-08 (line 34-73) | ○ |
| C-32 | ディレクトリに対するエラー | E-08 (line 54) | ○ |
| C-33 | MappedFile.deinitのリソース解放 | E-08 (line 75-83) | ○ |
| C-34 | Node.Flagsのビットフィールド | E-08 (line 94-100) | ○ |
| C-35 | LdScript.parseのパース処理 | E-09 (line 21-86) | ○ |
| C-36 | 無効なトークンでのエラー | E-09 (line 43-46) | ○ |
| C-37 | 予期しないトークンでのエラー | E-09 (line 68-78) | ○ |
| C-38 | LdScript.deinitのリソース解放 | E-09 (line 10-13) | ○ |
| C-39 | Queue.emptyの初期状態 | E-10 (line 36-41) | ○ |
| C-40 | Queue.cancelのキャンセル処理 | E-10 (line 43-48) | ○ |
| C-41 | Queue.waitの待機処理 | E-10 (line 50-55) | ○ |
| C-42 | Queue.startの開始処理 | E-10 (line 59-77) | ○ |
| C-43 | Queue.enqueuePrelinkのキューイング | E-10 (line 81-94) | ○ |
| C-44 | future=null時の即時実行 | E-10 (line 89-93) | ○ |
| C-45 | StringTable.insertの挿入 | E-11 (line 9-26) | ○ |
| C-46 | 重複文字列の排除 | E-11 (line 15) | ○ |
| C-47 | StringTable.getOffsetの検索 | E-11 (line 28-32) | ○ |
| C-49 | StringTable.getの逆引き | E-11 (line 34-37) | ○ |
| C-51 | StringTable.getAssumeExistsの動作 | E-11 (line 39-41) | ○ |
| C-52 | Elf/Atom.nameの名前取得 | E-12 (line 42-47) | ○ |
| C-53 | Elf/Atom.addressの計算 | E-12 (line 49-52) | ○ |
| C-54 | Elf/Atom.offsetの計算 | E-12 (line 54-57) | ○ |
| C-55 | Elf/Atom.refの生成 | E-12 (line 59-61) | ○ |
| C-56 | Elf/Atom.prevAtomの取得 | E-12 (line 63-65) | ○ |
| C-58 | Elf/Atom.priorityの計算 | E-12 (line 105-112) | ○ |
| C-59 | Elf/Atom.capacityの計算 | E-12 (line 117-123) | ○ |
| C-60 | Elf/Atom.freeListEligibleの判定 | E-12 (line 134-142) | ○ |
| C-61 | Elf/Atom.freeの解放 | E-12 (line 144-150) | ○ |
| C-62 | Elf/Symbol.isAbsの判定 | E-13 (line 32-38) | ○ |
| C-63 | Elf/Symbol.outputShndxの取得 | E-13 (line 40-47) | ○ |
| C-64 | Elf/Symbol.isLocalの判定 | E-13 (line 49-52) | ○ |
| C-65 | Elf/Symbol.addressの計算 | E-13 (line 105-150) | ○ |
| C-67 | Elf/Symbol.symbolRankの計算 | E-13 (line 95-103) | ○ |
| C-68 | Elf/Object.parseのパース | E-14 (line 92-121) | ○ |
| C-69 | 無効なELFマジックでのエラー | E-14 (line 138-139) | ○ |
| C-70 | 不正なマシンタイプでのエラー | E-14 (line 143-147) | ○ |
| C-71 | Elf/Object.deinitの解放 | E-14 (line 67-90) | ○ |
| C-72 | MachO/Atom.getNameの取得 | E-15 (line 42-47) | ○ |
| C-73 | MachO/Atom.getAddressの計算 | E-15 (line 73-76) | ○ |
| C-74 | MachO/Atom.getPriorityの計算 | E-15 (line 78-81) | ○ |
| C-75 | MachO/Atom.markUnwindRecordsDeadの無効化 | E-15 (line 92-100) | ○ |
| C-76 | MachO/Symbol.isLocalの判定 | E-16 (line 32-34) | ○ |
| C-77 | MachO/Symbol.weakRefの判定 | E-16 (line 49-56) | ○ |
| C-78 | MachO/Symbol.getOutputSectionIndexの取得 | E-16 (line 68-71) | ○ |
| C-79 | MachO/Symbol.getSectionFlagsの取得 | E-16 (line 73-75) | ○ |
| C-80 | MachO/Symbol.setSectionFlagsの設定 | E-16 (line 77-79) | ○ |
| C-81 | Wasm/Object.RelativeSliceの動作 | E-17 (line 53-56) | ○ |
| C-82 | Wasm/Object.SegmentInfo.Flagsのパック | E-17 (line 63-77) | ○ |
| C-83 | tapi/Tokenizer.Token.Idの定義 | E-18 (line 15-41) | ○ |
| C-84 | tapi/Tokenizer.TokenIterator.nextの動作 | E-18 (line 50-54) | ○ |
| C-86 | tapi/Tokenizer.TokenIterator.peekの動作 | E-18 (line 56-59) | ○ |
| C-87 | tapi/Tokenizer.TokenIterator.resetの動作 | E-18 (line 61-63) | ○ |
| C-88 | tapi/Tokenizer.TokenIterator.seekToの動作 | E-18 (line 65-67) | ○ |
| C-89 | tapi/Tokenizer.TokenIterator.seekByの動作 | E-18 (line 69-77) | ○ |
| C-91 | tapi/parse.ParseErrorの定義 | E-19 (line 12-19) | ○ |
| C-92 | tapi/parse.Node.castの動作 | E-19 (line 43-48) | ○ |
| C-94 | tapi/parse.Node.deinitの解放 | E-19 (line 50-58) | ○ |
| C-95 | tapi/parse.Node.Doc.deinitの解放 | E-19 (line 78-82) | ○ |
| C-96 | C.zigのリンカーベース | **根拠なし** | △ |
| C-97 | aarch64.zigのアーキテクチャ固有処理 | **根拠なし** | △ |
| C-98 | riscv.zigのアーキテクチャ固有処理 | **根拠なし** | △ |
| C-99 | table_section.zigのセクション処理 | **根拠なし** | △ |
| C-100 | BinaryModule.zigのモジュール処理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-96, C-97, C-98, C-99, C-100: これらのファイルは存在確認済みだが、詳細な内容解析が未完了
  - 候補：各ファイルの詳細読み込み / アーキテクチャ固有テストの既存実装確認 / コード生成パスの追跡

## 5) リスクフラグ（レビュー観点）
- **リスク1 (中)**: アーキテクチャ固有ファイル（aarch64.zig, riscv.zig）の詳細確認が必要
- **リスク1 (中)**: C.zig, table_section.zig, BinaryModule.zigの詳細解析が未完了
- **リスク0 (低)**: 主要リンカー実装（Elf, MachO, Coff, Wasm, SpirV）は根拠確認済み
- **リスク0 (低)**: ユーティリティ（StringTable, Queue, MappedFile）は根拠確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] UT-LNK-096〜100の対象ファイルを確認し、テストケースの妥当性を検証
- [ ] ELF/MachO/Coff/Wasmリンカーの主要メソッドのテスト網羅性を確認
- [ ] アドレス計算・オフセット計算のテストケースが境界値を考慮しているか確認
- [ ] エラーハンドリングのテストケースが適切なエラー種別を網羅しているか確認
- [ ] 並行処理（Queue, string_bytes_lock）のテストケースが競合状態を考慮しているか確認
