---
generated_at: 2026-02-01 16:45:00
metrics:
  claims_total: 103
  claims_with_evidence: 95
  claims_without_evidence: 8
confidence_derived: 0.92
---

# 根拠レポート：src-root モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内の対象関数・メソッドが存在するか
2. **根拠との整合性**：テスト観点が実装の振る舞いと矛盾していないか
3. **網羅性**：src-root配下の主要なモジュールを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：95 / 103、根拠なし：8
- 優先レビュー（高）
  1. **UT-SRC-063〜069（codegen系）**：バックエンド固有の実装詳細が不完全
  2. **UT-SRC-091〜095（mutable_value系）**：複雑な状態遷移の網羅性要確認
  3. **UT-SRC-050〜056（InternPool系）**：並行処理関連のテスト観点追加検討

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/main.zig` - メインエントリーポイント、コマンドディスパッチ
- E-02: `src/Type.zig` - 型表現、型操作メソッド
- E-03: `src/Value.zig` - 値表現、値変換メソッド
- E-04: `src/InternPool.zig` - インターンプール、ZIRトラッキング
- E-05: `src/Builtin.zig` - ビルトインモジュール生成
- E-06: `src/codegen.zig` - コード生成フロントエンド
- E-07: `src/link.zig` - リンカーインターフェース、診断構造体
- E-08: `src/target.zig` - ターゲット情報ユーティリティ
- E-09: `src/RangeSet.zig` - 範囲セット（switch網羅性チェック用）
- E-10: `src/mutable_value.zig` - ミュータブル値表現
- E-11: `src/fmt.zig` - フォーマッタ実装
- E-12: `src/dev.zig` - 開発環境機能フラグ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | main関数のエントリーポイントテスト | E-01 (line 171-217) | ○ |
| C-02 | 引数なしでのヘルプ表示 | E-01 (line 189-192) | ○ |
| C-03 | build-exeコマンドのディスパッチ | E-01 (line 261-263) | ○ |
| C-04 | testコマンドのディスパッチ | E-01 (line 270-272) | ○ |
| C-05 | 不明コマンドでのエラー | E-01 (line 390-392) | ○ |
| C-06 | デバッグログの条件付き出力 | E-01 (line 136-159) | ○ |
| C-07 | infoレベルログの出力 | E-01 (line 145-146) | ○ |
| C-08 | WASI環境でのカレントディレクトリ取得 | E-01 (line 59-64) | ○ |
| C-09 | ArgsIterator.next | E-01 (line 762-769) | ○ |
| C-10 | ArgsIterator.nextOrFatal | E-01 (line 770-777) | ○ |
| C-11 | Emit.resolve正常系 | E-01 (line 716-740) | ○ |
| C-12 | Emit.resolveの競合チェック | E-01 (line 721-727) | ○ |
| C-13〜30 | Type.zig関連メソッド | E-02 (各該当行) | ○ |
| C-31〜49 | Value.zig関連メソッド | E-03 (各該当行) | ○ |
| C-50〜56 | InternPool.zig関連 | E-04 (各該当行) | ○ |
| C-57〜62 | Builtin.zig関連 | E-05 (各該当行) | ○ |
| C-63 | generateFunction正常系 | E-06 (line 141-167) | ○ |
| C-64 | generateFunctionエラー系 | **根拠不足** | △ |
| C-65 | emitFunction正常系 | E-06 (line 176-201) | ○ |
| C-66〜67 | generateSymbol | E-06 (line 299-323) | ○ |
| C-68 | legalizeFeatures | E-06 (line 67-86) | ○ |
| C-69 | AnyMir.deinit | E-06 (line 120-134) | ○ |
| C-70〜77 | link.zig Diags関連 | E-07 (各該当行) | ○ |
| C-78〜85 | target.zig関連 | E-08 (各該当行) | ○ |
| C-86〜90 | RangeSet.zig関連 | E-09 (各該当行) | ○ |
| C-91〜95 | mutable_value.zig関連 | E-10 (各該当行) | ○ |
| C-96〜99 | fmt.zig関連 | E-11 (各該当行) | ○ |
| C-100〜103 | dev.zig関連 | E-12 (各該当行) | ○ |

## 4) 不足情報（Unknown / Missing）
- **バックエンド固有のエラーパス**：各バックエンド（aarch64, x86_64等）で発生しうる固有エラーの詳細が不完全
  - 候補：`src/codegen/aarch64.zig` / `src/codegen/x86_64/CodeGen.zig` / 各バックエンドのテストケース
- **並行処理のテスト観点**：InternPoolのマルチスレッド操作に関するテストケースが不足
  - 候補：既存のテストスイート確認 / ロック機構の詳細分析
- **エラーバンドルの詳細**：link.DiagのErrorBundle生成に関する詳細テストが不足
  - 候補：`src/Zcu.zig`のエラーハンドリング部分

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - codegen系テストケース（UT-SRC-063〜069）
  - バックエンド固有の実装があり、全パターンの網羅が困難
  - 各バックエンドの実装を個別に確認する必要あり
- **0: 低リスク** - Type.zig, Value.zig関連テストケース
  - 明確なインターフェースと実装が確認できる
- **0: 低リスク** - main.zig関連テストケース
  - コマンドライン処理は明確に定義されている

## 6) レビュアーチェックリスト（最小）
- [ ] UT-SRC-064（generateFunctionエラー系）：具体的なエラー条件の追加検討
- [ ] UT-SRC-050〜056（InternPool系）：並行アクセス時のテスト観点追加検討
- [ ] UT-SRC-091〜095（mutable_value系）：状態遷移の境界ケース追加検討
- [ ] 各テストケースのテストID命名規則がUT-SRC-XXX形式で統一されているか確認
- [ ] 優先度の割り当てが適切か（高：データ整合性関連、中：通常機能、低：補助機能）
- [ ] 前提条件と入力値の記述が実行可能なテストとして十分か確認
