---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 77
  claims_with_evidence: 77
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：test-c_abi単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：77 / 77、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全テストケースに根拠あり
  2. **アーキテクチャ依存テスト**：実際の動作は環境依存のため実機確認推奨
  3. **複素数ABI互換性**：C言語の_Complex型との互換性は未完全（issue #8465）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `test/c_abi/main.zig` - Zigテストファイル（5968行）
- E-02: `test/c_abi/cfuncs.c` - C言語対応関数ファイル
- E-03: `main.zig:27-29` - "C importing Zig ABI Tests"テスト定義
- E-04: `main.zig:53-68` - "C ABI integers"テスト定義
- E-05: `main.zig:123-127` - "C ABI floats"テスト定義
- E-06: `main.zig:129-133` - "C ABI long double"テスト定義
- E-07: `main.zig:148-150` - "C ABI pointer"テスト定義
- E-08: `main.zig:158-160` - "C ABI bool"テスト定義
- E-09: `main.zig:192-234` - 複素数ABIテスト定義
- E-10: `main.zig:339-357` - "C ABI struct u64 u64"テスト定義
- E-11: `main.zig:375-383` - "C ABI struct f32"テスト定義
- E-12: `main.zig:401-411` - "C ABI struct f64"テスト定義
- E-13: `main.zig:432-445` - ネスト構造体テスト定義
- E-14: `main.zig:505-517` - union含む構造体テスト定義
- E-15: `main.zig:526-543` - "C ABI struct i32 i32"テスト定義
- E-16: `main.zig:559-574` - "C ABI big struct"テスト定義
- E-17: `main.zig:589-605` - "C ABI big union"テスト定義
- E-18: `main.zig:624-641` - "C ABI medium struct of ints and floats"テスト定義
- E-19: `main.zig:658-679` - "C ABI small struct of ints"テスト定義
- E-20: `main.zig:696-713` - "C ABI medium struct of ints"テスト定義
- E-21: `main.zig:737-745` - "C ABI small packed struct"テスト定義
- E-22: `main.zig:759-767` - "C ABI big packed struct"テスト定義
- E-23: `main.zig:776-790` - "C ABI split struct of ints"テスト定義
- E-24: `main.zig:806-824` - "C ABI split struct of ints and floats"テスト定義
- E-25: `main.zig:837-857` - "C ABI sret and byval together"テスト定義
- E-26: `main.zig:892-915` - "C ABI structs of floats as parameter"テスト定義
- E-27: `main.zig:935-955` - "C ABI structs of ints as multiple parameters"テスト定義
- E-28: `main.zig:975-995` - "C ABI structs of floats as multiple parameters"テスト定義
- E-29: `main.zig:1068-1080` - "C ABI integer return types"テスト定義
- E-30: `main.zig:1090-1103` - "Struct with array as padding"テスト定義
- E-31: `main.zig:1119-1142` - "Float array like struct"テスト定義
- E-32: `main.zig:1149-1160` - "small simd vector"テスト定義
- E-33: `main.zig:1167-1180` - "medium simd vector"テスト定義
- E-34: `main.zig:1187-1207` - "big simd vector"テスト定義
- E-35: `main.zig:1218-1237` - "float simd vectors"テスト定義
- E-36: `main.zig:1269-1821` - "bool simd vector"テスト定義
- E-37: `main.zig:5503-5515` - "C ABI pointer sized float struct"テスト定義
- E-38: `main.zig:5527-5560` - DC構造体テスト群
- E-39: `main.zig:5580-5616` - CFF構造体テスト群
- E-40: `main.zig:5636-5665` - PD構造体テスト群
- E-41: `main.zig:5694-5701` - "C function modifies by ref param"テスト定義
- E-42: `main.zig:5717-5737` - "C function that takes byval struct"テスト定義
- E-43: `main.zig:5740-5745` - "f16 bare"テスト定義
- E-44: `main.zig:5751-5759` - "f16 struct"テスト定義
- E-45: `main.zig:5762-5767` - "f80 bare"テスト定義
- E-46: `main.zig:5773-5778` - "f80 struct"テスト定義
- E-47: `main.zig:5785-5791` - "f80 extra struct"テスト定義
- E-48: `main.zig:5798-5803` - "f128 bare"テスト定義
- E-49: `main.zig:5813-5822` - "f128 struct"テスト定義
- E-50: `main.zig:5834-5843` - "f128 f128 struct"テスト定義
- E-51: `main.zig:5849-5851` - "Stdcall ABI scalars"テスト定義
- E-52: `main.zig:5859-5874` - "Stdcall ABI structs"テスト定義
- E-53: `main.zig:5877-5893` - "Stdcall ABI big union"テスト定義
- E-54: `main.zig:5896-5901` - "explicit SysV calling convention"テスト定義
- E-55: `main.zig:5904-5909` - "explicit Win64 calling convention"テスト定義
- E-56: `main.zig:5951-5967` - "byval tail callsite attribute"テスト定義
- E-57: `main.zig:13-16` - have_i128定義
- E-58: `main.zig:18` - have_f128定義
- E-59: `main.zig:19` - have_f80定義
- E-60: `main.zig:187-190` - complex_abi_compatible定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | C言語からZig ABIテストがインポートできること | E-03 | ○ |
| C-02 | 符号なし整数がC ABIで正しく渡されること | E-04 | ○ |
| C-03 | 符号付き整数がC ABIで正しく渡されること | E-04 | ○ |
| C-04 | 128ビット整数構造体がC ABIで正しく渡されること | E-04, E-57 | ○ |
| C-05 | 5つの整数引数がC ABIで正しく渡されること | E-04 | ○ |
| C-06 | 浮動小数点数がC ABIで正しく渡されること | E-05 | ○ |
| C-07 | long doubleがC ABIで正しく渡されること | E-06 | ○ |
| C-08 | 5つの浮動小数点引数がC ABIで正しく渡されること | E-05 | ○ |
| C-09 | ポインタがC ABIで正しく渡されること | E-07 | ○ |
| C-10 | bool型がC ABIで正しく渡されること | E-08 | ○ |
| C-11 | 複素数float乗算がC ABIで正しく動作すること | E-09 | ○ |
| C-12 | 複素数floatのコンポーネント別乗算がC ABIで正しく動作すること | E-09 | ○ |
| C-13 | 複素数double乗算がC ABIで正しく動作すること | E-09 | ○ |
| C-14 | 複素数doubleのコンポーネント別乗算がC ABIで正しく動作すること | E-09 | ○ |
| C-15 | u64x2構造体の戻り値がC ABIで正しく返されること | E-10 | ○ |
| C-16 | u64x2構造体が異なる引数位置で正しく渡されること | E-10 | ○ |
| C-17 | f32構造体がC ABIで正しく渡されること | E-11 | ○ |
| C-18 | f64構造体がC ABIで正しく渡されること | E-12 | ○ |
| C-19 | ネストされたf32構造体がC ABIで正しく渡されること | E-13 | ○ |
| C-20 | f32とネストf32構造体がC ABIで正しく渡されること | E-13 | ○ |
| C-21 | union含む構造体がC ABIで正しく渡されること | E-14 | ○ |
| C-22 | i32x2構造体の変更がC ABIで正しく動作すること | E-15 | ○ |
| C-23 | 大きな構造体(u64x4+u8)がC ABIで正しく渡されること | E-16 | ○ |
| C-24 | 大きなunionがC ABIで正しく渡されること | E-17 | ○ |
| C-25 | 整数と浮動小数点混合の中サイズ構造体がC ABIで正しく渡されること | E-18 | ○ |
| C-26 | 小さな整数構造体(u8x4)がC ABIで正しく渡されること | E-19 | ○ |
| C-27 | 中サイズ整数構造体(i32x3)がC ABIで正しく渡されること | E-20 | ○ |
| C-28 | 小さなpacked構造体がC ABIで正しく渡されること | E-21 | ○ |
| C-29 | 大きなpacked構造体(u64x2=i128)がC ABIで正しく渡されること | E-22 | ○ |
| C-30 | 分割された整数構造体がC ABIで正しく渡されること | E-23 | ○ |
| C-31 | 分割された混合構造体がC ABIで正しく渡されること | E-24 | ○ |
| C-32 | sretとbyvalが同時に使用される場合のC ABI互換性 | E-25 | ○ |
| C-33 | 小さな浮動小数点構造体(Vector3)がC ABIで正しく渡されること | E-26 | ○ |
| C-34 | 大きな浮動小数点構造体(Vector5)がC ABIで正しく渡されること | E-26 | ○ |
| C-35 | 複数の整数構造体パラメータがC ABIで正しく渡されること | E-27 | ○ |
| C-36 | 複数の浮動小数点構造体パラメータがC ABIで正しく渡されること | E-28 | ○ |
| C-37 | 各整数型の戻り値がC ABIで正しく返されること | E-29 | ○ |
| C-38 | 配列パディングを含む構造体がC ABIで正しく渡されること | E-30 | ○ |
| C-39 | 浮動小数点配列のような構造体がC ABIで正しく渡されること | E-31 | ○ |
| C-40 | 小さなSIMDベクトル(u32x2)がC ABIで正しく渡されること | E-32 | ○ |
| C-41 | 中サイズSIMDベクトル(usizex4)がC ABIで正しく渡されること | E-33 | ○ |
| C-42 | 大きなSIMDベクトル(usizex8)がC ABIで正しく渡されること | E-34 | ○ |
| C-43 | floatベクトルがC ABIで正しく渡されること | E-35 | ○ |
| C-44 | boolベクトル(2〜512要素)がC ABIで正しく渡されること | E-36 | ○ |
| C-45 | ポインタサイズのfloat構造体(Vector2)がC ABIで正しく渡されること | E-37 | ○ |
| C-46 | Double+Char構造体(DC)がZig-C間で正しく渡されること | E-38 | ○ |
| C-47 | Char+Float+Float構造体(CFF)がZig-C間で正しく渡されること | E-39 | ○ |
| C-48 | Pointer+Double構造体(PD)がZig-C間で正しく渡されること | E-40 | ○ |
| C-49 | 参照渡しパラメータの変更がC ABIで正しく動作すること | E-41 | ○ |
| C-50 | byval構造体を取る関数ポインタ経由の呼び出しがC ABIで正しく動作すること | E-42 | ○ |
| C-51 | f16(半精度浮動小数点)がC ABIで正しく渡されること | E-43 | ○ |
| C-52 | f16構造体がC ABIで正しく渡されること | E-44 | ○ |
| C-53 | f80(拡張精度浮動小数点)がC ABIで正しく渡されること | E-45, E-59 | ○ |
| C-54 | f80構造体がC ABIで正しく渡されること | E-46 | ○ |
| C-55 | f80+int構造体がC ABIで正しく渡されること | E-47 | ○ |
| C-56 | f128(四倍精度浮動小数点)がC ABIで正しく渡されること | E-48, E-58 | ○ |
| C-57 | f128構造体がC ABIで正しく渡されること | E-49 | ○ |
| C-58 | f128x2構造体がC ABIで正しく渡されること | E-50 | ○ |
| C-59 | stdcall規約でスカラー値がC ABIで正しく渡されること | E-51 | ○ |
| C-60 | stdcall規約で構造体がC ABIで正しく渡されること | E-52 | ○ |
| C-61 | stdcall規約で大きなunionがC ABIで正しく渡されること | E-53 | ○ |
| C-62 | 明示的Win64呼び出し規約がC ABIで正しく動作すること | E-54 | ○ |
| C-63 | 明示的SysV呼び出し規約がC ABIで正しく動作すること | E-55 | ○ |
| C-64 | byval tail callsite属性がC ABIで正しく動作すること | E-56 | ○ |
| C-65 | Zigのexport関数がC側から正しく呼び出されること | E-01, E-02 | ○ |
| C-66 | Zigの構造体export関数がC側から正しく呼び出されること | E-01, E-02 | ○ |
| C-67 | Zigの戻り値export関数がC側から正しく呼び出されること | E-01, E-02 | ○ |
| C-68 | Zigの複素数乗算export関数がC側から正しく呼び出されること | E-09 | ○ |
| C-69 | Zigの大きな構造体変換export関数がC側から正しく呼び出されること | E-25 | ○ |
| C-70 | Zigの複数構造体パラメータexport関数がC側から正しく呼び出されること | E-27, E-28 | ○ |
| C-71 | zig_panicがC側から呼び出された場合にパニックすること | E-01:23-25 | ○ |
| C-72 | MIPS64でC ABI integersテストがスキップされること | E-04 | ○ |
| C-73 | PowerPCでC ABI long doubleテストがスキップされること | E-06 | ○ |
| C-74 | have_i128がアーキテクチャ依存で正しく判定されること | E-57 | ○ |
| C-75 | complex_abi_compatibleがアーキテクチャ依存で正しく判定されること | E-60 | ○ |
| C-76 | have_f80がx86アーキテクチャでのみtrueであること | E-59 | ○ |
| C-77 | have_f128がwasm/x86(非Darwin)でtrueであること | E-58 | ○ |

## 4) 不足情報（Unknown / Missing）
- **該当なし**：全てのテストケースに対応するソースコード根拠が存在

### 補足情報
- C言語の`_Complex`型との完全な互換性は未実装（コメント参照：issue #8465）
- 一部のアーキテクチャでは特定のテストがスキップされる（MIPS, PowerPC, ARM, RISCV, hexagon, s390x等）
- LLVMのバグにより一部のテストが制限されている（例：issue #168460）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースにソースコード根拠あり
- **1: 中リスク** - アーキテクチャ依存のスキップ条件が多数存在するため、全環境での動作確認が必要
- **1: 中リスク** - 複素数ABI互換性は未完全（Zig issue #8465）

## 6) レビュアーチェックリスト（最小）
- [ ] CSVのテストケースIDが連番かつユニークであることを確認
- [ ] 各テストケースの「前提条件」がソースコードのスキップ条件と一致していることを確認
- [ ] 「期待結果」がソースコードのexpect/assertと一致していることを確認
- [ ] アーキテクチャ依存のテストが適切に分類されていることを確認
- [ ] have_i128, have_f80, have_f128, complex_abi_compatibleの判定条件が正確であることを確認
- [ ] 優先度の設定（高/中/低）が適切であることを確認
- [ ] GitHub issueへの参照（#8465, #16290等）が正確であることを確認

#1
