---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 68
  claims_with_evidence: 68
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：test-cases モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成されたtest-casesモジュールの単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：68 / 68、根拠なし：0
- 優先レビュー（高）
  - すべてのテストケースがソースファイルから直接抽出されているため、特に優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `test/cases/README.md` - テストケースの形式説明
- E-02: `test/cases/hello_world.zig` - 基本実行テスト
- E-03: `test/cases/exit.zig` - 最小実行テスト
- E-04: `test/cases/recursive_fibonacci.zig` - 再帰関数テスト
- E-05: `test/cases/optionals.zig` - Optional型テスト
- E-06: `test/cases/blocks.zig` - ブロック式テスト
- E-07: `test/cases/rem.zig` - 剰余演算テスト
- E-08: `test/cases/compile_error.zig` - コンパイルエラーテスト
- E-09: `test/cases/compile_errors/@embedFile_with_empty_path.zig` - @embedFileエラーテスト
- E-10: `test/cases/compile_errors/*.zig` - コンパイルエラーテストケース群（965ファイル）
- E-11: `test/cases/safety/@alignCast misaligned.zig` - ランタイム安全性テスト
- E-12: `test/cases/safety/*.zig` - 安全性テストケース群（104ファイル）
- E-13: `test/cases/*.zig` - ルートレベルテストケース群（58ファイル）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Hello World出力テスト | E-02 | ○ |
| C-02 | 空main関数の実行テスト | E-03 | ○ |
| C-03 | フィボナッチ数列計算テスト | E-04 | ○ |
| C-04 | Optional型の操作テスト | E-05 | ○ |
| C-05 | ブロック式からの値返却テスト | E-06 | ○ |
| C-06 | 剰余演算子テスト | E-07 | ○ |
| C-07 | forループ実行テスト | E-13 | ○ |
| C-08 | ネストしたブロック式テスト | E-13 | ○ |
| C-09 | 大きな加算関数テスト | E-13 | ○ |
| C-10 | 大きなスライス処理テスト | E-13 | ○ |
| C-11 | 明示的コンパイルエラーテスト | E-08 | ○ |
| C-12 | 空パスの@embedFileテスト | E-09 | ○ |
| C-13 | 不正型への@errorCastテスト | E-10 | ○ |
| C-14 | ZONファイルの型不一致テスト | E-10 | ○ |
| C-15 | ZON構文エラーテスト | E-10 | ○ |
| C-16 | 非アクティブUnionフィールドアクセステスト | E-10 | ○ |
| C-17 | 非配列への配列アクセステスト | E-10 | ○ |
| C-18 | 非整数インデックスでの配列アクセステスト | E-10 | ○ |
| C-19 | 非数値型の加算テスト | E-10 | ○ |
| C-20 | アラインメント0の指定テスト | E-10 | ○ |
| C-21 | 不正型への@alignOfテスト | E-10 | ○ |
| C-22 | 曖昧な宣言参照テスト | E-10 | ○ |
| C-23 | anytypeパラメータのcomptime要件テスト | E-10 | ○ |
| C-24 | 関数評価中のオーバーフローテスト | E-10 | ○ |
| C-25 | 過大な集約型テスト | E-10 | ○ |
| C-26 | アラインメント不整合検出テスト | E-11 | ○ |
| C-27 | 無効な列挙値検出テスト | E-12 | ○ |
| C-28 | u0への@intCastテスト | E-12 | ○ |
| C-29 | 正の範囲外浮動小数点変換テスト | E-12 | ○ |
| C-30 | 負数の符号なし変換テスト | E-12 | ○ |
| C-31 | 不整合アドレスのポインタ変換テスト | E-12 | ○ |
| C-32 | ゼロアドレスのポインタ変換テスト | E-12 | ○ |
| C-33 | 破損した列挙値のタグ名取得テスト | E-12 | ○ |
| C-34 | 破損したユニオン値のタグ名取得テスト | E-12 | ○ |
| C-35 | スライスセンチネル不一致テスト | E-12 | ○ |
| C-36 | エラー値の不正キャストテスト | E-12 | ○ |
| C-37 | extern変数のアドレス取得テスト | E-13 | ○ |
| C-38 | アドレス空間付き配列ポインタチェインテスト | E-13 | ○ |
| C-39 | 複合アドレス空間ポインタチェインテスト | E-13 | ○ |
| C-40 | 曖昧な参照テスト | E-13 | ○ |
| C-41 | 匿名構造体内の配列テスト | E-13 | ○ |
| C-42 | コンパイル時集約型出力テスト | E-13 | ○ |
| C-43 | 宣言値アリーナ管理テスト | E-13 | ○ |
| C-44 | デフォルト値がcomptime変数を参照テスト | E-13 | ○ |
| C-45 | スタックトレース無効化テスト | E-13 | ○ |
| C-46 | ネスト宣言内のエラーテスト | E-13 | ○ |
| C-47 | エラーユニオン変種のランタイム判定テスト | E-13 | ○ |
| C-48 | 型変換関数本体からのエクスポートテスト | E-13 | ○ |
| C-49 | Fセグメントアドレス空間の読み書きテスト | E-13 | ○ |
| C-50 | 可変長引数へのf32渡しテスト | E-13 | ○ |
| C-51 | 最適化浮動小数点モードでのreduceテスト | E-13 | ○ |
| C-52 | 関数型情報のcomptime関数渡しテスト | E-13 | ○ |
| C-53 | 関数の再宣言テスト | E-13 | ○ |
| C-54 | グローバル変数の再宣言テスト | E-13 | ○ |
| C-55 | 安全性設定の継承テスト | E-13 | ○ |
| C-56 | 内部関数から外部変数アクセステスト | E-13 | ○ |
| C-57 | 最大サイズ整数リテラルテスト | E-13 | ○ |
| C-58 | 未チェック算術でのpanicなしテスト | E-13 | ○ |
| C-59 | 非リーフ関数呼び出しテスト | E-13 | ○ |
| C-60 | u0型の関数渡しテスト | E-13 | ○ |
| C-61 | ポインタのアドレス空間保持テスト | E-13 | ○ |
| C-62 | デリファレンスアドレス取得時のアドレス空間保持テスト | E-13 | ○ |
| C-63 | 明示的汎用アドレス空間の暗黙変換テスト | E-13 | ○ |
| C-64 | 未定義センチネル終端スライス返却テスト | E-13 | ○ |
| C-65 | try内でのreturnテスト | E-13 | ○ |
| C-66 | ランタイムビット論理積テスト | E-13 | ○ |
| C-67 | ランタイムビット論理和テスト | E-13 | ○ |
| C-68 | 複数アドレス空間ポインタのデリファレンステスト | E-13 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全テストケースが実際のソースファイルから抽出されているため、不足情報なし
- 注意点：test-casesは1127ファイルあり、本CSVでは代表的な68ケースを抽出
  - compile_errors: 965ファイル中、代表的なパターンを抽出
  - safety: 104ファイル中、代表的なパターンを抽出
  - ルートレベル: 58ファイルの大部分をカバー

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべてのテストケースが実際のソースファイルに基づいている
- 注意点：
  - テストケースの網羅性は完全ではない（1127ファイル中68ケースのサンプリング）
  - 各カテゴリの代表的なパターンを抽出したが、すべての変種をカバーしていない

## 6) レビュアーチェックリスト（最小）
- [ ] 抽出されたテストケースが実際のソースファイルの内容と一致しているか確認
- [ ] テストケースの分類（正常系/異常系/境界値）が適切か確認
- [ ] 優先度の設定が適切か確認（金額計算等はZigコンパイラでは該当しないため、安全性関連を高優先度に設定）
- [ ] compile_errorsとsafetyのカテゴリ分けが適切か確認
- [ ] 必要に応じて追加テストケースの抽出を検討
