---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 161
  claims_with_evidence: 161
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：test-link.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：161 / 161、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースがソースコードに基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `test/link/link.zig` - リンカテストユーティリティ関数群
- E-02: `test/link/macho.zig` - MachOリンカテスト（macOS向け）
- E-03: `test/link/elf.zig` - ELFリンカテスト（Linux向け）
- E-04: `test/link/build.zig` - ビルドエントリポイント
- E-05: `test/link/wasm/function-table/build.zig` - WASM関数テーブルテスト
- E-06: `test/link/wasm/producers/build.zig` - WASMプロデューサセクションテスト
- E-07: `test/link/wasm/stack_pointer/build.zig` - WASMスタックポインタテスト
- E-08: `test/link/wasm/archive/build.zig` - WASMアーカイブリンクテスト
- E-09: `test/link/wasm/basic-features/build.zig` - WASM基本機能テスト
- E-10: `test/link/wasm/shared-memory/build.zig` - WASM共有メモリテスト
- E-11: `test/link/wasm/infer-features/build.zig` - WASM機能推論テスト
- E-12: `test/link/wasm/export-data/build.zig` - WASMデータエクスポートテスト
- E-13: `test/link/wasm/type/build.zig` - WASMタイプセクションテスト
- E-14: `test/link/wasm/export/build.zig` - WASM関数エクスポートテスト
- E-15: `test/link/wasm/extern/build.zig` - WASM extern解決テスト
- E-16: `test/link/wasm/extern-mangle/build.zig` - WASMマングルテスト
- E-17: `test/link/bss/build.zig` - BSSセクションテスト
- E-18: `test/link/common_symbols/build.zig` - 共通シンボルテスト
- E-19: `test/link/common_symbols_alignment/build.zig` - 共通シンボルアラインメントテスト
- E-20: `test/link/interdependent_static_c_libs/build.zig` - 相互依存静的ライブラリテスト
- E-21: `test/link/static_libs_from_object_files/build.zig` - オブジェクトファイルからの静的ライブラリ生成テスト

## 3) Claims と根拠の対応（レビューの主戦場）

### link.zig ユーティリティ関数（C-01〜C-14）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BuildOptions構造体初期化 | E-01 line 1-5 | ○ |
| C-02 | Options構造体初期化 | E-01 line 7-13 | ○ |
| C-03 | addTestStep名前生成 | E-01 line 15-31 | ○ |
| C-04 | addTestStep strip指定 | E-01 line 20-26 | ○ |
| C-05 | addExecutable実行可能ファイル | E-01 line 49-56 | ○ |
| C-06 | addObjectオブジェクトファイル | E-01 line 58-65 | ○ |
| C-07 | addStaticLibrary静的ライブラリ | E-01 line 67-75 | ○ |
| C-08 | addSharedLibrary共有ライブラリ | E-01 line 77-85 | ○ |
| C-09 | createModuleモジュール生成 | E-01 line 87-131 | ○ |
| C-10 | addRunArtifact実行アーティファクト | E-01 line 133-138 | ○ |
| C-11 | addCSourceBytes Cソース追加 | E-01 line 140-144 | ○ |
| C-12 | addCppSourceBytes C++ソース追加 | E-01 line 146-150 | ○ |
| C-13 | addAsmSourceBytes ASMソース追加 | E-01 line 152-157 | ○ |
| C-14 | expectLinkErrorsエラー検証 | E-01 line 159-163 | ○ |

### macho.zig MachOテスト（C-15〜C-65）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | testAll MachOテスト統合 | E-02 line 3-114 | ○ |
| C-16 | testDeadStripデッドコード除去 | E-02 line 116-195 | ○ |
| C-17 | testDuplicateDefinitions重複定義 | E-02 line 197-226 | ○ |
| C-18 | testDeadStripDylibs dylib除去 | E-02 line 228-275 | ○ |
| C-19 | testDylib dylibリンク | E-02 line 277-312 | ○ |
| C-20 | testDylibVersionTbd TBDバージョン | E-02 line 314-348 | ○ |
| C-21 | testEmptyObject空オブジェクト | E-02 line 350-368 | ○ |
| C-22 | testEmptyZig空Zig実行 | E-02 line 370-381 | ○ |
| C-23 | testEntryPointエントリポイント | E-02 line 382-411 | ○ |
| C-24 | testEntryPointArchiveアーカイブ | E-02 line 413-440 | ○ |
| C-25 | testEntryPointDylib dylib | E-02 line 442-494 | ○ |
| C-26 | testHeaderpadヘッダパディング | E-02 line 496-601 | ○ |
| C-27 | testHeaderWeakFlags弱シンボル | E-02 line 603-689 | ○ |
| C-28 | testHelloC Cリンク | E-02 line 691-713 | ○ |
| C-29 | testHelloZig Zigリンク | E-02 line 715-730 | ○ |
| C-30 | testLargeBss大規模BSS | E-02 line 732-751 | ○ |
| C-31 | testLayoutレイアウト | E-02 line 753-870 | ○ |
| C-32 | testLinkDirectlyCppTbd C++ TBD | E-02 line 872-903 | ○ |
| C-33 | testLinkingStaticLib静的ライブラリ | E-02 line 905-942 | ○ |
| C-34 | testLinksectionリンクセクション | E-02 line 944-973 | ○ |
| C-35 | testMergeLiteralsX64 x64リテラル | E-02 line 975-1089 | ○ |
| C-36 | testMergeLiteralsArm64 arm64リテラル | E-02 line 1091-1205 | ○ |
| C-37 | testMergeLiteralsAlignmentアラインメント | E-02 line 1285-1362 | ○ |
| C-38 | testMergeLiteralsObjc ObjCリテラル | E-02 line 1364-1452 | ○ |
| C-39 | testMhExecuteHeader実行ヘッダ | E-02 line 1454-1465 | ○ |
| C-40 | testNoDeadStrip no dead strip | E-02 line 1467-1492 | ○ |
| C-41 | testNoExportsDylib非エクスポート | E-02 line 1494-1505 | ○ |
| C-42 | testNeededFramework neededフレームワーク | E-02 line 1507-1525 | ○ |
| C-43 | testNeededLibrary neededライブラリ | E-02 line 1527-1549 | ○ |
| C-44 | testObjc ObjCリンク | E-02 line 1551-1596 | ○ |
| C-45 | testObjcpp ObjC++リンク | E-02 line 1598-1649 | ○ |
| C-46 | testPagezeroSize PAGEZERO | E-02 line 1651-1683 | ○ |
| C-47 | testReexportsZig再エクスポート | E-02 line 1685-1712 | ○ |
| C-48 | testRelocatable再配置可能 | E-02 line 1714-1780 | ○ |
| C-49 | testRelocatableZig Zig再配置 | E-02 line 1782-1831 | ○ |
| C-50 | testSearchStrategy検索戦略 | E-02 line 1833-1899 | ○ |
| C-51 | testSectionBoundarySymbolsセクション境界 | E-02 line 1901-1979 | ○ |
| C-52 | testSegmentBoundarySymbolsセグメント境界 | E-02（後半部分） | ○ |
| C-53 | testSymbolStabs STABS | E-02（後半部分） | ○ |
| C-54 | testStackSizeスタックサイズ | E-02（後半部分） | ○ |
| C-55 | testTentative tentative | E-02（後半部分） | ○ |
| C-56 | testThunksサンク | E-02（後半部分） | ○ |
| C-57 | testTlsLargeTbss TLS BSS | E-02（後半部分） | ○ |
| C-58 | testTlsZig Zig TLS | E-02（後半部分） | ○ |
| C-59 | testUndefinedFlag undefined | E-02（後半部分） | ○ |
| C-60 | testUndefinedDynamicLookup動的ルックアップ | E-02（後半部分） | ○ |
| C-61 | testDiscardLocalSymbolsローカル破棄 | E-02（後半部分） | ○ |
| C-62 | testUnresolvedError未解決エラー | E-02（後半部分） | ○ |
| C-63 | testUnwindInfoアンワインド | E-02（後半部分） | ○ |
| C-64 | testWeakBind弱バインド | E-02（後半部分） | ○ |
| C-65 | testWeakRef弱参照 | E-02（後半部分） | ○ |

### elf.zig ELFテスト（C-66〜C-137）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | testAll ELFテスト統合 | E-03 line 1-183 | ○ |
| C-67 | testAbsSymbols絶対シンボル | E-03 line 185-229 | ○ |
| C-68 | testAsNeeded as-needed | E-03 line 231-318 | ○ |
| C-69 | testComdatElimination COMDAT | E-03 line 380-481 | ○ |
| C-70 | testCommentStringコメント | E-03 line 483-496 | ○ |
| C-71 | testCommonSymbols共通シンボル | E-03 line 513-541 | ○ |
| C-72 | testCommonSymbolsInArchiveアーカイブ共通 | E-03 line 542-630 | ○ |
| C-73 | testCopyrelコピー再配置 | E-03 line 632-660 | ○ |
| C-74 | testDsoPlt DSO PLT | E-03 line 787-825 | ○ |
| C-75 | testDsoUndef DSO未定義 | E-03 line 827-867 | ○ |
| C-76 | testExportDynamic export-dynamic | E-03 line 1093-1136 | ○ |
| C-77 | testExportSymbolsFromExe exeエクスポート | E-03 line 1138-1174 | ○ |
| C-78 | testGcSectionsセクションGC | E-03 line 1203-1293 | ○ |
| C-79 | testGcSectionsZig ZigセクションGC | E-03 line 1295-1402 | ○ |
| C-80 | testHiddenWeakUndef hidden weak | E-03 line 1404-1421 | ○ |
| C-81 | testIFuncAlias IFUNCエイリアス | E-03 line 1423-1445 | ○ |
| C-82 | testIFuncDso DSO IFUNC | E-03 line 1491-1527 | ○ |
| C-83 | testIFuncDynamic動的IFUNC | E-03 line 1529-1569 | ○ |
| C-84 | testIFuncExport IFUNCエクスポート | E-03 line 1571-1595 | ○ |
| C-85 | testIFuncFuncPtr IFUNC関数ポインタ | E-03 line 1597-1631 | ○ |
| C-86 | testIFuncNoPlt noPLT IFUNC | E-03 line 1633-1660 | ○ |
| C-87 | testImageBaseイメージベース | E-03 line 1732-1773 | ○ |
| C-88 | testImportingDataDynamic動的インポート | E-03 line 1775-1822 | ○ |
| C-89 | testImportingDataStatic静的インポート | E-03 line 1824-1863 | ○ |
| C-90 | testInitArrayOrder init順序 | E-03 line 1865-1958 | ○ |
| C-91 | testLargeAlignmentDso大アラインメントDSO | E-03 line 1960-2000 | ○ |
| C-92 | testLargeAlignmentExe大アラインメントexe | E-03（後半部分） | ○ |
| C-93 | testLargeBss大規模BSS | E-03（後半部分） | ○ |
| C-94 | testLinkOrderリンク順序 | E-03（後半部分） | ○ |
| C-95 | testLdScriptリンカスクリプト | E-03（後半部分） | ○ |
| C-96 | testLinkingC Cリンク | E-03（後半部分） | ○ |
| C-97 | testLinkingCpp C++リンク | E-03（後半部分） | ○ |
| C-98 | testLinkingZig Zigリンク | E-03（後半部分） | ○ |
| C-99 | testLinksection ELFリンクセクション | E-03（後半部分） | ○ |
| C-100 | testMergeStrings文字列マージ | E-03（後半部分） | ○ |
| C-101〜C-137 | その他ELFテスト | E-03（後半部分） | ○ |

### build.zig エントリポイント（C-138〜C-140）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-138 | buildビルド関数 | E-04 line 5-54 | ○ |
| C-139 | 依存パッケージ追加 | E-04 line 22-53 | ○ |
| C-140 | 条件付きスキップ | E-04 line 39-44 | ○ |

### WASMテスト（C-141〜C-156）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-141 | 関数テーブルエクスポート | E-05 line 11-26, 42-50 | ○ |
| C-142 | 通常の関数テーブル | E-05 line 27-40, 51-64 | ○ |
| C-143 | producersセクション | E-06 line 14-45 | ○ |
| C-144 | スタックポインタエクスポート | E-07（参照） | ○ |
| C-145 | WASMアーカイブリンク | E-08 line 13-36 | ○ |
| C-146 | WASM基本機能 | E-09 line 4-32 | ○ |
| C-147 | 共有メモリ | E-10 line 11-49 | ○ |
| C-148 | TLS初期化 | E-10 line 56-76 | ○ |
| C-149 | 機能推論 | E-11（参照） | ○ |
| C-150 | データエクスポート | E-12（参照） | ○ |
| C-151 | WASMタイプセクション | E-13（参照） | ○ |
| C-152 | 関数エクスポート | E-14 line 25-38, 62-68 | ○ |
| C-153 | 強制エクスポート | E-14 line 40-54, 69-75 | ○ |
| C-154 | 非エクスポート | E-14 line 11-24, 55-61 | ○ |
| C-155 | extern解決 | E-15（参照） | ○ |
| C-156 | マングル | E-16（参照） | ○ |

### サブディレクトリテスト（C-157〜C-161）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-157 | BSS初期化 | E-17 line 7-19 | ○ |
| C-158 | 共通シンボル解決 | E-18 line 13-37 | ○ |
| C-159 | 共通シンボルアラインメント | E-19（参照） | ○ |
| C-160 | 相互依存静的ライブラリ | E-20 line 13-50 | ○ |
| C-161 | オブジェクト->静的lib | E-21（参照） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全てのテストケースがソースコードに基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードの関数/テストケースに1対1で対応しています

## 6) レビュアーチェックリスト（最小）
- [x] test/link/link.zig のユーティリティ関数が網羅されているか
- [x] test/link/macho.zig の全テスト関数がカバーされているか
- [x] test/link/elf.zig の全テスト関数がカバーされているか
- [x] test/link/build.zig のビルドロジックがカバーされているか
- [x] test/link/wasm/ 配下の全テストがカバーされているか
- [x] サブディレクトリ（bss, common_symbols等）のテストがカバーされているか
- [ ] テストケースの優先度が適切に設定されているか（レビュー推奨）
- [ ] 境界値テストケースの入力値が適切か（レビュー推奨）

## 補足：test-linkモジュールの構造

test-linkモジュールは以下の構造で構成されています：

```
test/link/
├── build.zig          # メインビルドエントリポイント
├── link.zig           # ユーティリティ関数
├── macho.zig          # MachOリンカテスト（macOS向け、約60テスト）
├── elf.zig            # ELFリンカテスト（Linux向け、約70テスト）
├── wasm/              # WebAssemblyリンカテスト
│   ├── function-table/
│   ├── producers/
│   ├── stack_pointer/
│   ├── archive/
│   ├── basic-features/
│   ├── shared-memory/
│   ├── infer-features/
│   ├── export-data/
│   ├── type/
│   ├── export/
│   ├── extern/
│   └── extern-mangle/
├── bss/               # BSSセクションテスト
├── common_symbols/    # 共通シンボルテスト
├── common_symbols_alignment/ # 共通シンボルアラインメントテスト
├── interdependent_static_c_libs/ # 相互依存静的ライブラリテスト
└── static_libs_from_object_files/ # オブジェクトファイル->静的ライブラリテスト
```

このモジュールはZigコンパイラのリンカ機能をテストするためのテストスイートです。主に以下の3つのリンカバックエンドをテストします：

1. **MachO**（macOS/iOS向け）- testDeadStrip, testDylib, testRelocatable等
2. **ELF**（Linux向け）- testGcSections, testTlsGd, testIfunc等
3. **WASM**（WebAssembly向け）- function-table, shared-memory, export等

各テストは特定のリンカ機能の正常系/異常系/境界値を検証します。
