---
generated_at: 2026-02-01 16:45:00
metrics:
  claims_total: 100
  claims_with_evidence: 95
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート：test-root 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：95 / 100、根拠なし：5
- 優先レビュー（高）
  1. **UT-TRT-029**: `compilerHasPackageManager`の内部動作詳細が不明確
  2. **UT-TRT-030**: `wouldUseLlvm`関数の定義箇所が特定できず
  3. **UT-TRT-085**: `max_rss`の具体的な動作（エミュレータ環境での2倍化ロジック）の根拠が限定的
  4. **UT-TRT-086**: `no_builtin`オプションの詳細な効果が不明確
  5. **UT-TRT-099/100**: LLVMオプショナルアーキテクチャサポートの詳細実装

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/zig/test/tests.zig` (L1-2500+)
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/zig/test/behavior.zig` (L1-146)
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/zig/test/cases.zig` (L1-16)
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/zig/test/compile_errors.zig` (L1-255)
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/zig/test/error_traces.zig` (L1-451)
- E-06: `/Users/tomokababa/Work/reverse-engineering/sample/zig/test/gen_h.zig` (L1-149)
- E-07: `/Users/tomokababa/Work/reverse-engineering/sample/zig/test/libc.zig` (L1-344)
- E-08: `/Users/tomokababa/Work/reverse-engineering/sample/zig/test/llvm_ir.zig` (L1-123)
- E-09: `/Users/tomokababa/Work/reverse-engineering/sample/zig/test/llvm_targets.zig` (L1-362)
- E-10: `/Users/tomokababa/Work/reverse-engineering/sample/zig/test/stack_traces.zig` (L1-225)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TestTargetのtargetフィールドでネイティブターゲット設定 | E-01 (L21-39, L46-49) | ○ |
| C-02 | link_libcフィールドでlibc連携設定 | E-01 (L22, L51-52) | ○ |
| C-03 | optimize_modeフィールドで最適化モード設定 | E-01 (L24, L57-66) | ○ |
| C-04 | single_threadedフィールドでシングルスレッドモード設定 | E-01 (L26, L53-55) | ○ |
| C-05 | use_llvmフィールドでLLVMバックエンド設定 | E-01 (L27) | ○ |
| C-06 | use_lldフィールドでLLDリンカ設定 | E-01 (L28) | ○ |
| C-07 | picフィールドでPIE/PIC設定 | E-01 (L29) | ○ |
| C-08 | stripフィールドでシンボルストリップ設定 | E-01 (L30) | ○ |
| C-09 | extra_targetフィールドで拡張ターゲットフラグ | E-01 (L38) | ○ |
| C-10 | skip_modulesフィールドでモジュールスキップ設定 | E-01 (L33) | ○ |
| C-11 | addStackTraceTests関数の実装 | E-01 (L2006-2033) | ○ |
| C-12 | skip_non_nativeパラメータの動作 | E-01 (L2009, L2026-2027) | ○ |
| C-13 | addErrorTraceTests関数の実装 | E-01 (L2035-2063) | ○ |
| C-14 | optimize_modesパラメータの動作 | E-01 (L2038, L2056) | ○ |
| C-15 | addStandaloneTests関数の実装 | E-01 (L2071-2095) | ○ |
| C-16 | enable_macos_sdkオプション | E-01 (L2074, L2083) | ○ |
| C-17 | enable_ios_sdkオプション | E-01 (L2075, L2082) | ○ |
| C-18 | addLinkTests関数の実装 | E-01 (L2097-2116) | ○ |
| C-19 | addCliTests関数の実装 | E-01 (L2118-2310) | ○ |
| C-20 | zig initコマンドのテスト | E-01 (L2122-2133) | ○ |
| C-21 | zig fmtコマンドのテスト | E-01 (L2211-2287) | ○ |
| C-22 | zig build testのテスト | E-01 (L2146-2151) | ○ |
| C-23 | 不正出力パスエラーテスト | E-01 (L2136-2143) | ○ |
| C-24 | addModuleTests関数の実装 | E-01 (L2339-2422) | ○ |
| C-25 | test_filtersの適用 | E-01 (L2313, L2456) | ○ |
| C-26 | test_target_filtersの適用 | E-01 (L2314, L2391-2394) | ○ |
| C-27 | nativeAndCompatible32bit関数の実装 | E-01 (L1976-2004) | ○ |
| C-28 | skip_non_nativeでネイティブのみ返却 | E-01 (L1979) | ○ |
| C-29 | compilerHasPackageManager関数 | E-01 (L2065-2069) | △ |
| C-30 | wouldUseLlvm関数 | **根拠なし** | △ |
| C-31 | @embedFileテスト | E-02 (L138-145) | ○ |
| C-32 | SkipZigTestの条件 | E-02 (L139-140) | ○ |
| C-33 | BuildOptions.enable_llvm | E-03 (L5) | ○ |
| C-34 | BuildOptions.llvm_has_m68k | E-03 (L6) | ○ |
| C-35 | cases.addCases実装 | E-03 (L12-15) | ○ |
| C-36 | セミコロン欠落エラーテスト | E-04 (L47-54) | ○ |
| C-37 | 型エラーテスト | E-04 (L139-171) | ○ |
| C-38 | コンパイル時専用型エラー | E-04 (L185-221) | ○ |
| C-39 | 無効バイトエラーテスト | E-04 (L223-237) | ○ |
| C-40 | ファイル重複モジュールエラー | E-04 (L119-137) | ○ |
| C-41 | return文エラートレース | E-05 (L2-15) | ○ |
| C-42 | try-returnエラートレース | E-05 (L17-43) | ○ |
| C-43 | 非エラーreturnでトレースポップ | E-05 (L44-68) | ○ |
| C-44 | whileループcontinue | E-05 (L70-91) | ○ |
| C-45 | catch内エラー再スロー | E-05 (L150-176) | ○ |
| C-46 | 変数格納でトレースポップ | E-05 (L178-200) | ○ |
| C-47 | const格納でトレース保持 | E-05 (L202-248) | ○ |
| C-48 | try-try-return-returnチェーン | E-05 (L366-406) | ○ |
| C-49 | extern enum変換 | E-06 (L4-15) | ○ |
| C-50 | extern struct変換 | E-06 (L17-39) | ○ |
| C-51 | extern union変換 | E-06 (L41-74) | ○ |
| C-52 | opaque型変換 | E-06 (L76-84) | ○ |
| C-53 | 配列フィールド変換 | E-06 (L86-100) | ○ |
| C-54 | Zig構造体ポインタ変換 | E-06 (L102-115) | ○ |
| C-55 | basename関数テスト | E-07 (L5) | ○ |
| C-56 | clock_gettime関数テスト | E-07 (L7) | ○ |
| C-57 | pthread_mutex関数テスト | E-07 (L28) | ○ |
| C-58 | 数学関数テスト | E-07 (L141-339) | ○ |
| C-59 | 回帰テスト | E-07 (L74-139) | ○ |
| C-60 | nonnullポインタロードIR | E-08 (L2-9) | ○ |
| C-61 | nonnullポインタストアIR | E-08 (L11-18) | ○ |
| C-62 | atomicロードIR | E-08 (L20-26) | ○ |
| C-63 | volatileロードIR | E-08 (L36-42) | ○ |
| C-64 | allowzeroポインタ属性 | E-08 (L78-94) | ○ |
| C-65 | aarch64-linuxターゲット | E-09 (L14-17) | ○ |
| C-66 | x86_64-windowsターゲット | E-09 (L335-336) | ○ |
| C-67 | wasm32-wasiターゲット | E-09 (L278-281) | ○ |
| C-68 | LLVM無効時スキップ | E-09 (L349) | ○ |
| C-69 | M68Kサポート無効時スキップ | E-09 (L352) | ○ |
| C-70 | シンプルパニックトレース | E-10 (L2-31) | ○ |
| C-71 | アンワインドなしパニック | E-10 (L33-48) | ○ |
| C-72 | dumpCurrentStackTrace | E-10 (L50-87) | ○ |
| C-73 | captureCurrentStackTrace | E-10 (L114-153) | ○ |
| C-74 | スレッド上トレースキャプチャ | E-10 (L180-223) | ○ |
| C-75 | stripビルドトレース | E-10 (L25-29, L81-86) | ○ |
| C-76 | CAbiTarget.target | E-01 (L1652) | ○ |
| C-77 | CAbiTarget.use_llvm | E-01 (L1653) | ○ |
| C-78 | CAbiTarget.c_defines | E-01 (L1657) | ○ |
| C-79 | ModuleTestOptions.test_default_only | E-01 (L2321, L2342-2347) | ○ |
| C-80 | ModuleTestOptions.skip_spirv | E-01 (L2324, L2376) | ○ |
| C-81 | ModuleTestOptions.skip_wasm | E-01 (L2325, L2377) | ○ |
| C-82 | ModuleTestOptions.skip_windows | E-01 (L2329, L2382) | ○ |
| C-83 | ModuleTestOptions.skip_darwin | E-01 (L2330, L2383) | ○ |
| C-84 | ModuleTestOptions.skip_linux | E-01 (L2331, L2384) | ○ |
| C-85 | ModuleTestOptions.max_rss | E-01 (L2334, L2437-2443) | △ |
| C-86 | ModuleTestOptions.no_builtin | E-01 (L2335, L2462) | △ |
| C-87 | addOneModuleTest関数 | E-01 (L2424-2500+) | ○ |
| C-88 | libcサフィックス生成 | E-01 (L2433) | ○ |
| C-89 | バックエンドサフィックス生成 | E-01 (L2469-2476) | ○ |
| C-90 | test_targets[0]がデフォルト | E-01 (L49, L2343) | ○ |
| C-91 | FreeBSDターゲット | E-01 (L100-155) | ○ |
| C-92 | Linuxターゲット | E-01 (L156-1199) | ○ |
| C-93 | Windowsターゲット | E-01 (L1497-1647) | ○ |
| C-94 | Darwin（macOS）ターゲット | E-01 (L1192-1246) | ○ |
| C-95 | WASIターゲット | E-01 (L1469-1495) | ○ |
| C-96 | c_abi_targets配列 | E-01 (L1660-1971) | ○ |
| C-97 | x86_64-linux-musl C ABI | E-01 (L1897-1942) | ○ |
| C-98 | Windows C ABIターゲット | E-01 (L1956-1969) | ○ |
| C-99 | BuildOptions.llvm_has_xtensa | E-03 (L9) | △ |
| C-100 | BuildOptions.llvm_has_arc | E-03 (L8) | △ |

## 4) 不足情報（Unknown / Missing）
- **wouldUseLlvm関数の定義箇所**: tests.zigファイル内で参照されているが、読み込んだ範囲では定義が確認できなかった
  - 候補：tests.zig後半部分 / 別ファイルからのインポート / ビルドシステム内部関数
- **max_rssの詳細動作**: エミュレータ環境での2倍化ロジックの具体的な理由と実装詳細
  - 候補：ビルドシステムドキュメント / Zigフォーラム / GitHub Issues
- **no_builtinオプションの詳細効果**: コンパイラビルトイン関数の具体的な無効化範囲
  - 候補：Zig言語仕様 / コンパイラソースコード
- **オプショナルアーキテクチャ（xtensa, arc）の詳細**: LLVMビルド時オプション依存の詳細
  - 候補：LLVMビルドスクリプト / CMakeLists.txt

## 5) リスクフラグ（レビュー観点）
- **0 - 低リスク**: 大部分のテストケースはソースコードから直接確認可能
- **1 - 中リスク**: 一部の内部ヘルパー関数（wouldUseLlvm等）の動作詳細が未確認
- **0 - 低リスク**: ターゲット構成は網羅的に定義されており、高い信頼性

## 6) レビュアーチェックリスト（最小）
- [ ] C-29: `compilerHasPackageManager`の動作が`b.available_deps.len != 0`で正しいか確認
- [ ] C-30: `wouldUseLlvm`関数の定義と動作を確認
- [ ] C-85: `max_rss`の2倍化ロジックの妥当性確認
- [ ] C-86: `no_builtin`オプションの実際の効果確認
- [ ] テストケースの優先度設定が適切か確認（特に「高」優先度のビジネスクリティカル性）
- [ ] プラットフォーム依存テスト（skip_*オプション）の網羅性確認
