---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 85
  claims_with_evidence: 85
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：test-src モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：85 / 85、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースがソースコードに基づいて生成されている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `test/src/Debugger.zig` - デバッガテストフレームワーク（Options, Target, addTestsForTarget, addLldbTest）
- E-02: `test/src/LlvmIr.zig` - LLVM IR検証フレームワーク（Options, TestCase, Params, addMatches, addExact, addCase）
- E-03: `test/src/ErrorTrace.zig` - エラートレーステストフレームワーク（Case, addCase, shouldTestNonLlvm, addCaseConfig）
- E-04: `test/src/RunTranslatedC.zig` - C変換実行テストフレームワーク（TestCase, create, add, addAllowWarnings, addCase）
- E-05: `test/src/TranslateC.zig` - C変換テストフレームワーク（TestCase, create, add, addWithTarget, addAllowWarnings, addCase）
- E-06: `test/src/Cases.zig` - 汎用テストケースフレームワーク（Case, init, addExe, addObj, addObjLlvm, addTest, addC, addFromDir, lowerToBuildSteps, TestManifest）
- E-07: `test/src/Libc.zig` - libcテストフレームワーク（Options, TestCase, addLibcTestCase, addTarget）
- E-08: `test/src/convert-stack-trace.zig` - スタックトレース変換ユーティリティ（main関数）
- E-09: `test/src/StackTrace.zig` - スタックトレーステストフレームワーク（Config, addCase, addCaseTarget, addCaseInstance）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Debugger.addTestsForTarget - 基本型のデバッグ情報テスト | E-01 (line 24-184, "basic"テスト) | ○ |
| C-02 | Debugger.addTestsForTarget - ポインタ型のデバッグ情報テスト | E-01 (line 185-307, "pointers"テスト) | ○ |
| C-03 | Debugger.addTestsForTarget - 文字列型のデバッグ情報テスト | E-01 (line 308-383, "strings"テスト) | ○ |
| C-04 | Debugger.addTestsForTarget - 列挙型のデバッグ情報テスト | E-01 (line 384-445, "enums"テスト) | ○ |
| C-05 | Debugger.addTestsForTarget - エラー型のデバッグ情報テスト | E-01 (line 446-515, "errors"テスト) | ○ |
| C-06 | Debugger.addTestsForTarget - オプショナル型のデバッグ情報テスト | E-01 (line 516-566, "optionals"テスト) | ○ |
| C-07 | Debugger.addTestsForTarget - 共用体型のデバッグ情報テスト | E-01 (line 567-651, "unions"テスト) | ○ |
| C-08 | Debugger.addTestsForTarget - 変数ストレージのデバッグ情報テスト | E-01 (line 652-750, "storage"テスト) | ○ |
| C-09 | Debugger.addLldbTest - if/switchブロックスコープテスト | E-01 (line 751-837, "if_blocks"/"switch_blocks"テスト) | ○ |
| C-10 | Debugger.addLldbTest - ループステップ実行テスト | E-01 (line 838-999, "step_single_stmt_loops"テスト) | ○ |
| C-11 | Debugger.Options構造体 | E-01 (line 5-13, Options定義) | ○ |
| C-12 | Debugger.Target構造体 | E-01 (line 15-22, Target定義) | ○ |
| C-13 | LlvmIr.addMatches - パターンマッチテスト | E-02 (line 45-58, addMatches関数) | ○ |
| C-14 | LlvmIr.addExact - 完全一致テスト | E-02 (line 60-73, addExact関数) | ○ |
| C-15 | LlvmIr.addCase - ビルドステップ追加 | E-02 (line 75-131, addCase関数) | ○ |
| C-16 | LlvmIr.addCase - ターゲットフィルタ | E-02 (line 77-81, test_target_filters処理) | ○ |
| C-17 | LlvmIr.Options構造体 | E-02 (line 5-9, Options定義) | ○ |
| C-18 | LlvmIr.TestCase.Params構造体 | E-02 (line 20-42, Params定義) | ○ |
| C-19 | ErrorTrace.addCase - ターゲット追加 | E-03 (line 25-39, addCase関数) | ○ |
| C-20 | ErrorTrace.shouldTestNonLlvm - バックエンド判定 | E-03 (line 41-50, shouldTestNonLlvm関数) | ○ |
| C-21 | ErrorTrace.shouldTestNonLlvm - BSD制限 | E-03 (line 45, isBSD()チェック) | ○ |
| C-22 | ErrorTrace.addCaseConfig - エラートレース設定 | E-03 (line 52-124, addCaseConfig関数) | ○ |
| C-23 | ErrorTrace.addCaseConfig - disable_trace_optimized | E-03 (line 66-72, disable_trace_optimized処理) | ○ |
| C-24 | ErrorTrace.Case構造体 | E-03 (line 8-23, Case定義) | ○ |
| C-25 | RunTranslatedC.create | E-04 (line 26-44, create関数) | ○ |
| C-26 | RunTranslatedC.add | E-04 (line 46-54, add関数) | ○ |
| C-27 | RunTranslatedC.addAllowWarnings | E-04 (line 56-64, addAllowWarnings関数) | ○ |
| C-28 | RunTranslatedC.addCase - パイプライン構築 | E-04 (line 66-102, addCase関数) | ○ |
| C-29 | RunTranslatedC.addCase - フィルタ処理 | E-04 (line 70-72, test_filters処理) | ○ |
| C-30 | RunTranslatedC.TestCase.addSourceFile | E-04 (line 18-23, addSourceFile関数) | ○ |
| C-31 | TranslateC.create | E-05 (line 31-53, create関数) | ○ |
| C-32 | TranslateC.add | E-05 (line 55-63, add関数) | ○ |
| C-33 | TranslateC.addWithTarget | E-05 (line 65-75, addWithTarget関数) | ○ |
| C-34 | TranslateC.addAllowWarnings | E-05 (line 77-85, addAllowWarnings関数) | ○ |
| C-35 | TranslateC.addCase - パイプライン構築 | E-05 (line 87-124, addCase関数) | ○ |
| C-36 | TranslateC.addCase - ターゲットフィルタ | E-05 (line 98-104, test_target_filters処理) | ○ |
| C-37 | TranslateC.TestCase.addExpectedLine | E-05 (line 26-28, addExpectedLine関数) | ○ |
| C-38 | Cases.init | E-06 (line 440-447, init関数) | ○ |
| C-39 | Cases.addExe | E-06 (line 132-146, addExe関数) | ○ |
| C-40 | Cases.addObj | E-06 (line 200-214, addObj関数) | ○ |
| C-41 | Cases.addObjLlvm | E-06 (line 168-198, addObjLlvm関数) | ○ |
| C-42 | Cases.addObjLlvm - アーキテクチャ制限 | E-06 (line 169-184, can_emit_asm/can_emit_bin判定) | ○ |
| C-43 | Cases.addTest | E-06 (line 216-231, addTest関数) | ○ |
| C-44 | Cases.exeFromCompiledC | E-06 (line 153-166, exeFromCompiledC関数) | ○ |
| C-45 | Cases.addC | E-06 (line 244-256, addC関数) | ○ |
| C-46 | Cases.addFromDir | E-06 (line 319-328, addFromDir関数) | ○ |
| C-47 | Cases.addFromDir - 拡張子フィルタ | E-06 (line 346, knownFileExtension呼び出し) | ○ |
| C-48 | Cases.lowerToBuildSteps | E-06 (line 466-641, lowerToBuildSteps関数) | ○ |
| C-49 | Cases.lowerToBuildSteps - skip_compile_errors | E-06 (line 481, skip_compile_errorsチェック) | ○ |
| C-50 | Cases.lowerToBuildSteps - skip_non_native | E-06 (line 483-484, skip_non_nativeチェック) | ○ |
| C-51 | Cases.Case.addSourceFile | E-06 (line 93-95, addSourceFile関数) | ○ |
| C-52 | Cases.Case.addDepModule | E-06 (line 97-102, addDepModule関数) | ○ |
| C-53 | Cases.Case.addCompareOutput | E-06 (line 106-110, addCompareOutput関数) | ○ |
| C-54 | Cases.Case.addError | E-06 (line 116-121, addError関数) | ○ |
| C-55 | Cases.Case.addCompile | E-06 (line 125-129, addCompile関数) | ○ |
| C-56 | TestManifest.parse | E-06 (line 772-850, parse関数) | ○ |
| C-57 | TestManifest.parse - MissingTestManifest | E-06 (line 800, error.MissingTestManifest) | ○ |
| C-58 | TestManifest.parse - UnknownTestCaseType | E-06 (line 823, error.UnknownTestCaseType) | ○ |
| C-59 | TestManifest.parse - InvalidKey | E-06 (line 841, error.InvalidKey) | ○ |
| C-60 | TestManifest.getConfigForKey | E-06 (line 852-861, getConfigForKey関数) | ○ |
| C-61 | TestManifest.getConfigForKeyAlloc | E-06 (line 863-876, getConfigForKeyAlloc関数) | ○ |
| C-62 | TestManifest.getConfigForKeyAssertSingle | E-06 (line 878-883, getConfigForKeyAssertSingle関数) | ○ |
| C-63 | TestManifest.trailing | E-06 (line 885-889, trailing関数) | ○ |
| C-64 | TestManifest.trailingSplit | E-06 (line 891-903, trailingSplit関数) | ○ |
| C-65 | TestManifest.trailingLines | E-06 (line 905-913, trailingLines関数) | ○ |
| C-66 | TestManifestConfigDefaults.get | E-06 (line 649-703, get関数) | ○ |
| C-67 | TestManifestConfigDefaults.get - errorタイプ | E-06 (line 655-657, errorタイプの特殊処理) | ○ |
| C-68 | Libc.addLibcTestCase | E-07 (line 28-42, addLibcTestCase関数) | ○ |
| C-69 | Libc.addTarget | E-07 (line 44-121, addTarget関数) | ○ |
| C-70 | Libc.addTarget - skip_wasm | E-07 (line 45, skip_wasmチェック) | ○ |
| C-71 | Libc.addTarget - WASI互換性 | E-07 (line 76-77, isWasiLibC()チェック) | ○ |
| C-72 | Libc.Options構造体 | E-07 (line 9-15, Options定義) | ○ |
| C-73 | convert-stack-trace.main - 正規化 | E-08 (line 27-104, main関数) | ○ |
| C-74 | convert-stack-trace.main - パス正規化 | E-08 (line 91-97, basename抽出とフォーマット) | ○ |
| C-75 | convert-stack-trace.main - Unwindエラー除去 | E-08 (line 49, Unwind error行スキップ) | ○ |
| C-76 | convert-stack-trace.main - Cannot print除去 | E-08 (line 48, Cannot print行スキップ) | ○ |
| C-77 | convert-stack-trace.main - 引数バリデーション | E-08 (line 32, args.len != 2チェック) | ○ |
| C-78 | StackTrace.addCase | E-09 (line 29-40, addCase関数) | ○ |
| C-79 | StackTrace.addCaseTarget | E-09 (line 41-120, addCaseTarget関数) | ○ |
| C-80 | StackTrace.addCaseTarget - fp_unwind_is_safe | E-09 (line 67, aarch64-darwin判定) | ○ |
| C-81 | StackTrace.addCaseTarget - supports_unwind_tables | E-09 (line 68-73, windows x86判定) | ○ |
| C-82 | StackTrace.addCaseInstance | E-09 (line 122-208, addCaseInstance関数) | ○ |
| C-83 | StackTrace.addCaseInstance - フィルタ | E-09 (line 167-170, test_filtersチェック) | ○ |
| C-84 | StackTrace.Config構造体 | E-09 (line 7-27, Config定義) | ○ |
| C-85 | StackTrace.Config.unwind列挙型 | E-09 (line 11-20, unwind enum定義) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースがソースコードから直接抽出されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコード解析に基づいており、根拠が明確

## 6) レビュアーチェックリスト（最小）
- [ ] Debugger.zigのテストケース（UT-TST-001〜012）がデバッガ連携テストの主要機能をカバーしていることを確認
- [ ] LlvmIr.zigのテストケース（UT-TST-013〜018）がLLVM IR検証の基本パターンをカバーしていることを確認
- [ ] ErrorTrace.zigのテストケース（UT-TST-019〜024）がエラートレース機能のバックエンド・最適化モード組み合わせをカバーしていることを確認
- [ ] RunTranslatedC.zig/TranslateC.zigのテストケース（UT-TST-025〜037）がC言語変換テストのパイプラインをカバーしていることを確認
- [ ] Cases.zigのテストケース（UT-TST-038〜067）が汎用テストフレームワークの全機能をカバーしていることを確認
- [ ] Libc.zigのテストケース（UT-TST-068〜072）がlibcテストの基本機能をカバーしていることを確認
- [ ] convert-stack-trace.zig/StackTrace.zigのテストケース（UT-TST-073〜085）がスタックトレース変換・テスト機能をカバーしていることを確認
- [ ] 優先度「高」のテストケースが重要な機能（パイプライン構築、基本機能、ビルドステップ統合）をカバーしていることを確認
