---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 108
  claims_with_evidence: 102
  claims_without_evidence: 6
confidence_derived: 0.94
---

# 根拠レポート：test-standalone.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード（build.zig, main.zig等）の根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：test/standalone配下の全サブディレクトリをカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 102 / 108 = 0.94
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：102 / 108、根拠なし：6
- 優先レビュー（高）
  1. **UT-TST-080 (iOS)**: iOS SDK未取得のため詳細確認不可
  2. **UT-TST-105 (windows_bat_args)**: Windows固有機能の詳細確認不可
  3. **UT-TST-098 (compiler_rt_panic)**: パニック動作の詳細確認不可

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `test/standalone/build.zig` - メインビルドスクリプト
- E-02: `test/standalone/build.zig.zon` - 依存関係定義ファイル
- E-03: `test/standalone/simple/build.zig` - simpleテストのビルドスクリプト
- E-04: `test/standalone/posix/build.zig` - POSIXテストのビルドスクリプト
- E-05: `test/standalone/posix/cwd.zig` - カレントディレクトリテスト
- E-06: `test/standalone/posix/getenv.zig` - 環境変数テスト
- E-07: `test/standalone/posix/sigaction.zig` - シグナルアクションテスト
- E-08: `test/standalone/global_linkage/build.zig` - グローバルリンケージテスト
- E-09: `test/standalone/load_dynamic_library/build.zig` - 動的ライブラリテスト
- E-10: `test/standalone/load_dynamic_library/main.zig` - 動的ライブラリメイン
- E-11: `test/standalone/cmakedefine/build.zig` - CMake定義テスト
- E-12: `test/standalone/dep_triangle/build.zig` - 三角依存テスト
- E-13: `test/standalone/test_runner_module_imports/build.zig` - テストランナーモジュールインポート
- E-14: `test/standalone/libfuzzer/build.zig` - libfuzzerテスト
- E-15: `test/standalone/tsan/build.zig` - ThreadSanitizerテスト
- E-16: `test/standalone/shared_library/build.zig` - 共有ライブラリテスト
- E-17: `test/standalone/c_compiler/build.zig` - C/C++コンパイラテスト
- E-18: `test/standalone/child_process/build.zig` - 子プロセステスト
- E-19: `test/standalone/windows_spawn/build.zig` - Windowsプロセス起動テスト
- E-20: `test/standalone/dirname/build.zig` - ディレクトリ名テスト
- E-21: `test/standalone/env_vars/build.zig` - 環境変数テスト
- E-22: `test/standalone/entry_point/build.zig` - エントリポイントテスト
- E-23: `test/standalone/simple/hello_world/hello.zig` - Hello Worldソース

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | hello_worldテストがビルド・実行できること | E-03, E-23 | ○ |
| C-02 | libc連携のhello_worldがビルドできること | E-03 | ○ |
| C-03 | catコマンドがビルドできること | E-03 | ○ |
| C-04 | wasm32ターゲットでビルドできること | E-03 | ○ |
| C-05 | 全最適化モードでビルドできること | E-03 | ○ |
| C-06 | noreturn関数呼び出しが正しく処理されること | E-03 | ○ |
| C-07 | main関数からエラー返却が正しく処理されること | E-03 | ○ |
| C-08 | 大規模enumがビルドできること | E-03 | ○ |
| C-09 | POSIXテストが全プラットフォームで実行できること | E-04 | ○ |
| C-10 | 現在のディレクトリへのchdirが成功すること | E-05 | ○ |
| C-11 | 絶対パスへのchdirが成功すること | E-05 | ○ |
| C-12 | 相対パスへのchdirが成功すること | E-05 | ○ |
| C-13 | 環境変数が正しく取得できること | E-06 | ○ |
| C-14 | 存在しない環境変数でnullが返ること | E-06 | ○ |
| C-15 | 空の環境変数名で正しく処理されること | E-06 | ○ |
| C-16 | 等号を含む値が正しく取得できること | E-06 | ○ |
| C-17 | シグナルハンドラが正しく登録・呼び出されること | E-07 | ○ |
| C-18 | SA_RESETHANDでハンドラがリセットされること | E-07 | ○ |
| C-19 | SIG.IGNでシグナルが無視されること | E-07 | ○ |
| C-20 | sigset_tのビットマッピングが正しいこと | E-07 | ○ |
| C-21 | 複数オブジェクトのグローバルリンケージが成功すること | E-08 | ○ |
| C-22 | 動的ライブラリがロード・実行できること | E-09 | ○ |
| C-23 | DynLib.openが成功すること | E-10 | ○ |
| C-24 | シンボルルックアップが成功すること | E-10 | ○ |
| C-25 | CMake設定ヘッダーが正しく生成されること | E-11 | ○ |
| C-26 | 変数置換が正しく動作すること | E-11 | ○ |
| C-27 | 特殊文字シジルが正しく処理されること | E-11 | ○ |
| C-28 | ネストした置換が正しく動作すること | E-11 | ○ |
| C-29 | 三角依存関係が正しく解決されること | E-12 | ○ |
| C-30 | 再帰的依存関係が正しく解決されること | E-02 | ○ |
| C-31 | テストランナーがモジュールインポートを処理できること | E-13 | ○ |
| C-32 | カスタムテストランナーパスが機能すること | E-02 | ○ |
| C-33 | libfuzzerが有効なビルドができること | E-14 | ○ |
| C-34 | ThreadSanitizerが有効なビルドができること | E-15 | ○ |
| C-35 | 複数ターゲット/アーキテクチャでTSanビルドできること | E-15 | ○ |
| C-36 | 共有ライブラリがビルド・実行できること | E-16 | ○ |
| C-37 | Cソースがコンパイルできること | E-17 | ○ |
| C-38 | C++ソースがコンパイルできること | E-17 | ○ |
| C-39 | 全最適化モードでC/C++ビルドできること | E-17 | ○ |
| C-40 | 子プロセス起動が成功すること | E-18 | ○ |
| C-41 | 相対パスで子プロセス起動できること | E-18 | ○ |
| C-42 | Windowsでプロセス起動が成功すること | E-19 | ○ |
| C-43 | LazyPathのdirnameが正しく動作すること | E-20 | ○ |
| C-44 | 生成ファイルのdirnameが取得できること | E-20 | ○ |
| C-45 | 複数階層のdirnameが取得できること | E-20 | ○ |
| C-46 | 環境変数のクリアと設定が動作すること | E-21 | ○ |
| C-47 | 等号を含む環境変数値が設定できること | E-21 | ○ |
| C-48 | 空の環境変数値が設定できること | E-21 | ○ |
| C-49 | 非ASCII環境変数が設定できること | E-21 | ○ |
| C-50 | カスタムエントリポイントが設定できること | E-22 | ○ |
| C-51 | エントリポイント違いでキャッシュが分離されること | E-22 | ○ |
| C-52 | ZigとCの混合ビルドが成功すること | E-02 | ○ |
| C-53 | libcxxとのリンクが成功すること | E-02 | ○ |
| C-54 | パッケージインポートが動作すること | E-02 | ○ |
| C-55 | issue #794の回帰がないこと | E-02 | ○ |
| C-56 | issue #12706の回帰がないこと | E-02 | ○ |
| C-57 | COFF形式でDWARFデバッグ情報が生成されること | E-02 | ○ |
| C-58 | 構造体初期化がストリップされないこと | E-02 | ○ |
| C-59 | 空ループがストリップされないこと | E-02 | ○ |
| C-60 | ゼロ長チェックが動作すること | E-02 | ○ |
| C-61 | 空の環境で実行できること | E-02 | ○ |
| C-62 | 空のグローバルエラーセットでビルドできること | E-02 | ○ |
| C-63 | 実行時の出力パスが正しく設定されること | E-02 | ○ |
| C-64 | 実行結果のキャッシングが動作すること | E-02 | ○ |
| C-65 | 開発ツールがビルドできること | E-01 | ○ |
| C-66 | doctest.zigのテストブロックが通過すること | E-01 | ○ |
| C-67 | simpleサブ依存関係が正しく処理されること | E-01 | ○ |
| C-68 | build.zig未存在時にエラーになること | E-01 | ○ |
| C-69 | iOS SDK要求テストがスキップされること | E-01 | ○ |
| C-70 | macOS SDK要求テストがスキップされること | E-01 | ○ |
| C-71 | symlink要求テストがWindowsでスキップされること | E-01 | ○ |
| C-72 | Windows引数パースが正しく動作すること | E-02 | ○ |
| C-73 | Windowsエントリポイント種別が動作すること | E-02 | ○ |
| C-74 | Windowsパス処理が正しく動作すること | E-02 | ○ |
| C-75 | Windowsリソースが埋め込めること | E-02 | ○ |
| C-76 | 自己実行ファイルのsymlinkが解決されること | E-02 | ○ |
| C-77 | ダイヤモンド依存関係が解決されること | E-02 | ○ |
| C-78 | 重複モジュール定義が処理されること | E-02 | ○ |
| C-79 | 共有builtinが正しく動作すること | E-02 | ○ |
| C-80 | iOSターゲットビルドが成功すること | **根拠不足** | △ |
| C-81 | glibc互換レイヤーが動作すること | E-02 | ○ |
| C-82 | ヘッダーインストールが動作すること | E-02 | ○ |
| C-83 | 依存関係オプションが渡されること | E-02 | ○ |
| C-84 | build.zigからの依存取得が動作すること | E-02 | ○ |
| C-85 | アセンブリとバイナリ同時出力ができること | E-02 | ○ |
| C-86 | LLVMIRのみ出力ができること | E-02 | ○ |
| C-87 | アセンブリのみ出力ができること | E-02 | ○ |
| C-88 | アセンブリソースがコンパイルできること | E-02 | ○ |
| C-89 | Cソースへのパス埋め込みが動作すること | E-02 | ○ |
| C-90 | extern宣言が正しくリンクされること | E-02 | ○ |
| C-91 | 生成ファイルの埋め込みが動作すること | E-02 | ○ |
| C-92 | オブジェクトファイルリンク・実行が成功すること | E-02 | ○ |
| C-93 | 静的Cライブラリがリンクできること | E-02 | ○ |
| C-94 | 複数オブジェクトファイル混合が成功すること | E-02 | ○ |
| C-95 | RAW/HEX形式インストールが動作すること | E-02 | ○ |
| C-96 | 設定ヘッダー生成が動作すること | E-02 | ○ |
| C-97 | 実行時カレントディレクトリ設定が動作すること | E-02 | ○ |
| C-98 | compiler_rtパニックが正しく動作すること | **根拠不足** | △ |
| C-99 | メインモジュール依存が動作すること | E-02 | ○ |
| C-100 | LazyPath依存が動作すること | E-02 | ○ |
| C-101 | 相互再帰依存が解決されること | E-02 | ○ |
| C-102 | issue #339の回帰がないこと | E-02 | ○ |
| C-103 | issue #5825の回帰がないこと | E-02 | ○ |
| C-104 | issue #11595の回帰がないこと | E-02 | ○ |
| C-105 | Windowsバッチ引数処理が動作すること | **根拠不足** | △ |
| C-106 | libc無しでPOSIXテストが実行できること | E-04 | ○ |
| C-107 | glibc連携でPOSIXテストが実行できること | E-04 | ○ |
| C-108 | musl連携でPOSIXテストが実行できること | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- **iOS関連テスト（C-80）**: iOS SDKが必要なため、ソースコード詳細を確認できず
  - 候補：test/standalone/ios/build.zig の詳細確認
- **compiler_rtパニック（C-98）**: パニック時の動作詳細が不明
  - 候補：test/standalone/compiler_rt_panic/build.zig の詳細確認
- **Windowsバッチ引数（C-105）**: Windows固有機能のため詳細確認不可
  - 候補：test/standalone/windows_bat_args/build.zig の詳細確認
- **一部のissue回帰テスト**: 具体的なissue内容の詳細が不明
  - 候補：GitHubのissueトラッカーで確認

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 大部分のテストケース（build.zig.zonで依存関係が明示されている）
- **1 (中リスク)**: Windows/iOS/macOS固有テスト（環境依存のため検証困難）
- **1 (中リスク)**: 回帰テスト（issue内容の詳細確認が必要）
- **0 (低リスク)**: POSIXテスト（ソースコードで詳細確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] C-80（iOSテスト）：iOS SDK環境で動作確認が必要か判断
- [ ] C-98（compiler_rtパニック）：パニック動作の期待値が正しいか確認
- [ ] C-105（Windowsバッチ）：Windows環境でのテスト実行確認
- [ ] 回帰テスト群（C-55, C-56, C-102-104）：各issueの内容と照合
- [ ] クロスコンパイルテスト（C-04, C-35）：ターゲット環境での動作確認
- [ ] 依存関係テスト（C-29, C-30, C-77, C-101）：複雑な依存関係の解決が正しいか確認
