---
generated_at: 2026-02-01 18:30:00
metrics:
  claims_total: 50
  claims_with_evidence: 47
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート：受入テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で△の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：47 / 50、根拠なし：3
- 優先レビュー（高）
  1. **UAT-043（LLVM IR出力）**：LLVMバックエンドの有効化条件が環境依存
  2. **UAT-044（LLVMバックエンド強制）**：LLVMが有効でない環境での挙動
  3. **UAT-032（バグレポート最小化）**：reduceコマンドの詳細な動作仕様

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/main.zig` - メインエントリポイント、コマンド一覧定義
- E-02: `build.zig` - ビルドシステム設定、テストステップ定義
- E-03: `README.md` - インストール手順、ビルド方法、使用方法
- E-04: `test/tests.zig` - テストターゲット定義、テスト構成
- E-05: `test/behavior.zig` - 動作テスト定義
- E-06: `src/fmt.zig` - フォーマットコマンド実装
- E-07: `src/codegen.zig` - コード生成バックエンド
- E-08: `tools/docgen.zig` - ドキュメント生成ツール
- E-09: `lib/std/std.zig` - 標準ライブラリルート

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | build-exeコマンドで実行ファイル生成 | E-01 (line 261-263) | ○ |
| C-02 | build-libコマンドでライブラリ生成 | E-01 (line 264-266) | ○ |
| C-03 | build-objコマンドでオブジェクト生成 | E-01 (line 267-269) | ○ |
| C-04 | buildコマンドでbuild.zig実行 | E-01 (line 286-288), E-02 | ○ |
| C-05 | build.zigでカスタムステップ定義可能 | E-02 (line 31, 76-84) | ○ |
| C-06 | testコマンドで単体テスト実行 | E-01 (line 270-272) | ○ |
| C-07 | ビルドシステム経由でテスト実行可能 | E-02 (line 31, 425-448) | ○ |
| C-08 | runコマンドで即時実行 | E-01 (line 276-278) | ○ |
| C-09 | runコマンドで引数渡し可能 | E-01 (line 400) | ○ |
| C-10 | fmtコマンドでフォーマット | E-01 (line 318-320), E-06 | ○ |
| C-11 | fmt --checkでフォーマットチェック | E-02 (line 417-422) | ○ |
| C-12 | ast-checkで構文チェック | E-01 (line 379-380) | ○ |
| C-13 | translate-cでC言語変換 | E-01 (line 306-308) | ○ |
| C-14 | zig ccでCコンパイル | E-01 (line 300-302) | ○ |
| C-15 | zig c++でC++コンパイル | E-01 (line 303-305) | ○ |
| C-16 | -targetオプションでクロスコンパイル | E-01 (line 487) | ○ |
| C-17 | targetsコマンドでターゲット一覧表示 | E-01 (line 344-349) | ○ |
| C-18 | -O ReleaseFastで最適化ビルド | E-01 (line 488-492) | ○ |
| C-19 | -O ReleaseSmallでサイズ最適化 | E-01 (line 492) | ○ |
| C-20 | -O ReleaseSafeで安全性優先最適化 | E-01 (line 491) | ○ |
| C-21 | initコマンドでプロジェクト初期化 | E-01 (line 342-343) | ○ |
| C-22 | fetchコマンドでパッケージ取得 | E-01 (line 326-327) | ○ |
| C-23 | stdコマンドでドキュメント表示 | E-01 (line 334-341) | ○ |
| C-24 | -femit-docsでドキュメント生成 | E-01 (line 441-442), E-08 | ○ |
| C-25 | envコマンドで環境情報表示 | E-01 (line 354-367) | ○ |
| C-26 | versionコマンドでバージョン表示 | E-01 (line 350-352) | ○ |
| C-27 | helpコマンドでヘルプ表示 | E-01 (line 376-378) | ○ |
| C-28 | zig arでアーカイブ作成 | E-01 (line 279-285) | ○ |
| C-29 | zig objcopyでオブジェクト変換 | E-01 (line 321-325) | ○ |
| C-30 | zig rcでリソースコンパイル | E-01 (line 309-317) | ○ |
| C-31 | デフォルトでデバッグ情報付きビルド | E-01 (line 489) | ○ |
| C-32 | reduceコマンドでバグ最小化 | E-01 (line 368-372) | △ |
| C-33 | libcコマンドでパス情報表示 | E-01 (line 328-333) | ○ |
| C-34 | -fincrementalでインクリメンタルビルド | E-01 (line 429-430) | ○ |
| C-35 | Windows DLLビルド対応 | E-04 (test_targets) | ○ |
| C-36 | macOS動的ライブラリビルド対応 | E-04 (test_targets) | ○ |
| C-37 | WebAssemblyビルド対応 | E-02 (line 729-734), E-04 | ○ |
| C-38 | コンパイルエラーの分かりやすい表示 | E-01, E-05 | ○ |
| C-39 | -freference-traceでエラートレース | E-01 (line 472-474) | ○ |
| C-40 | -jオプションで並列数制限 | E-01 (line 428) | ○ |
| C-41 | -femit-asmでアセンブリ出力 | E-01 (line 433-434) | ○ |
| C-42 | -femit-hでCヘッダー出力 | E-01 (line 439-440) | ○ |
| C-43 | -femit-llvm-irでLLVM IR出力 | E-01 (line 435-436) | △ |
| C-44 | -fllvmでLLVMバックエンド強制 | E-01 (line 460-461) | △ |
| C-45 | -fPIEでPIE生成 | E-01 (line 466-467) | ○ |
| C-46 | -Dstripでデバッグ情報除去 | E-02 (build options) | ○ |
| C-47 | --global-cache-dirでキャッシュ指定 | E-01 (line 447) | ○ |
| C-48 | --cache-dirでローカルキャッシュ指定 | E-01 (line 446) | ○ |
| C-49 | -Mオプションで複数モジュール指定 | E-01 (line 455-458) | ○ |
| C-50 | 完全な開発フロー対応 | E-01, E-02, E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UAT-032（reduceコマンド）**：reduceコマンドはJITで実行されるツールであり、詳細な動作仕様がソースコード内に明示的に記載されていない
  - 候補：tools/reduce.zig / 外部ドキュメント / ユーザーマニュアル
- **UAT-043/044（LLVM連携）**：LLVMバックエンドが有効かどうかはビルド時のオプションに依存し、すべての環境で利用可能とは限らない
  - 候補：config.h / CMakeLists.txt / ビルドオプションドキュメント

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：基本的なコンパイル機能（UAT-001〜UAT-003, UAT-006〜UAT-008）
- **0（低リスク）**：情報表示機能（UAT-025〜UAT-027）
- **1（中リスク）**：クロスコンパイル機能（UAT-016, UAT-035〜UAT-037）- ターゲット環境での実機テスト推奨
- **1（中リスク）**：C言語連携機能（UAT-013〜UAT-015）- LLVMバックエンド依存
- **2（高リスク）**：LLVM固有機能（UAT-043〜UAT-044）- 環境依存、LLVMなしビルドでは利用不可

## 6) レビュアーチェックリスト（最小）
- [ ] UAT-001〜UAT-003：基本的なコンパイルコマンドがドキュメント通りに動作するか
- [ ] UAT-004〜UAT-005：build.zigを使用したビルドフローが正しく機能するか
- [ ] UAT-006〜UAT-007：テスト実行機能がすべてのテストを正しく実行するか
- [ ] UAT-016〜UAT-017：クロスコンパイル機能がサポートされているターゲットで動作するか
- [ ] UAT-021〜UAT-022：パッケージ管理機能（init/fetch）が期待通りに動作するか
- [ ] UAT-037：WebAssemblyターゲットへのコンパイルが正しく動作するか
- [ ] UAT-043〜UAT-044：LLVM連携機能がLLVM有効ビルドで正しく動作するか（LLVM無効環境では適切なエラーメッセージが表示されるか）
- [ ] UAT-050：エンドツーエンドのワークフローが一貫して動作するか
