---
generated_at: 2026-02-01 16:45:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  1. 該当なし - すべての項目に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/crash_report.zig` - クラッシュレポート実装ファイル（189行）
- E-02: `src/print_zir.zig` - ZIRデバッグ出力実装ファイル
- E-03: `src/Air/print.zig` - AIRデバッグ出力実装ファイル（100行以上）
- E-04: `src/print_zoir.zig` - ZOIRデバッグ出力実装ファイル
- E-05: `tools/dump-cov.zig` - カバレッジダンプツール実装ファイル
- E-06: `tools/docgen.zig` - HTMLドキュメント生成ツール（100行以上）
- E-07: `src/Compilation.zig` - コンパイル処理メイン実装（compile_log, ErrorBundle含む）
- E-08: `src/InternPool.zig` - InternPool実装（dump, dumpStatsFallible, dumpGenericInstances関数含む）
- E-09: `src/main.zig` - メインエントリポイント（コマンドライン引数処理含む）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | クラッシュレポート - パニック/セグフォルト時のコンテキスト情報出力 | E-01 | ○ |
| C-02 | ZIRデバッグ出力 - ast-check -t コマンドで使用可能 | E-02, E-09 | ○ |
| C-03 | AIRデバッグ出力 - Liveness情報を含む詳細なダンプ | E-03 | ○ |
| C-04 | ZOIRデバッグ出力 - ノード数・メモリサイズ統計 | E-04 | ○ |
| C-05 | カバレッジレポート - PC毎のソース位置表示 | E-05 | ○ |
| C-06 | HTMLドキュメント生成 - docgenテンプレート使用 | E-06 | ○ |
| C-07 | コンパイルログ - @compileLog出力の集約 | E-07 | ○ |
| C-08 | エラーバンドル - 参照トレース・ソース位置情報含む | E-07 | ○ |
| C-09 | リンカマップ - linker_print_mapオプションで有効化 | E-07 | ○ |
| C-10 | InternPoolダンプ - 統計情報およびジェネリックインスタンス一覧 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - すべての帳票項目について実装ソースコードを確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての項目がソースコードで確認済み
- 注意事項: 本プロジェクトはZigコンパイラのソースコードであり、一般的な業務システムの「帳票」（PDF/Excel出力等）とは性質が異なる。コンパイラのデバッグ/診断機能として出力されるテキスト形式のレポートを「帳票」として抽出している

## 6) レビュアーチェックリスト（最小）
- [ ] 各帳票の説明がソースコードの実装内容と一致しているか確認
- [ ] 帳票のカテゴリ分類が適切か確認
- [ ] 他に見落としている帳票機能がないか、src/tools ディレクトリを追加確認
- [ ] 本プロジェクトが業務システムではなくコンパイラであることを踏まえ、帳票の定義が適切か確認
