# 帳票設計書 1-クラッシュレポート

## 概要

本ドキュメントは、Zigコンパイラにおけるクラッシュレポート帳票の設計仕様を記述するものである。コンパイラがパニックやセグメンテーションフォルトを発生させた際に、デバッグに必要なコンテキスト情報を標準エラー出力に出力する機能について定義する。

### 本帳票の処理概要

クラッシュレポートは、Zigコンパイラの内部エラー（パニック・セグメンテーションフォルト）発生時に、開発者がエラー原因を特定するために必要な情報を自動的に収集・出力する帳票である。

**業務上の目的・背景**：コンパイラの開発・保守において、クラッシュの原因特定は最も重要かつ困難な作業の一つである。この帳票は、クラッシュ発生時点でのコンパイラ内部状態（解析中の関数、ZIR命令など）を自動的に記録することで、開発者が迅速にデバッグを開始できる環境を提供する。これにより、バグ修正の効率が大幅に向上し、コンパイラの品質向上に貢献する。

**帳票の利用シーン**：
1. コンパイラ開発者がユーザーから報告されたクラッシュを再現・調査する際
2. CIパイプラインでコンパイラのリグレッションを検出した際
3. 新機能開発中に発生した予期しないクラッシュの原因調査時
4. ユーザーがバグレポートを作成する際の情報収集

**主要な出力内容**：
1. クラッシュコンテキストのヘッダー情報（"Compiler crash context:"）
2. コード生成中の場合：生成対象関数の完全修飾名
3. セマンティック解析中の場合：解析対象ファイル名、ZIR命令のコンテキスト情報
4. 親ブロックの呼び出しチェーン情報
5. デバッグコマンドの提案（`zig ast-check -t` コマンド）

**帳票の出力タイミング**：コンパイラプロセスがパニック関数を呼び出した時、またはセグメンテーションフォルトシグナルを受信した時に自動的に出力される。

**帳票の利用者**：Zigコンパイラ開発者、コントリビュータ、高度なデバッグを行うユーザー

## 帳票種別

デバッグ/診断レポート

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | コマンドライン | `zig build`, `zig build-exe` など | コンパイラクラッシュ時に自動出力 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準エラー出力） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（標準エラー出力） |
| 出力方法 | 標準エラー出力への直接書き込み |
| 文字コード | UTF-8 |

### PDF固有設定

N/A（テキスト出力のみ）

### Excel固有設定

N/A（テキスト出力のみ）

## 帳票レイアウト

### レイアウト概要

クラッシュレポートは以下の構成で標準エラー出力に出力される。

```
┌─────────────────────────────────────────────────────────────┐
│ Compiler crash context:                                     │
├─────────────────────────────────────────────────────────────┤
│ [コード生成/セマンティック解析のコンテキスト情報]              │
│   - 関数名 / ファイル名                                      │
│   - ZIR命令の詳細                                           │
├─────────────────────────────────────────────────────────────┤
│ [親ブロック情報（再帰的）]                                    │
│   in ファイル名                                              │
│   > ZIR命令                                                 │
├─────────────────────────────────────────────────────────────┤
│ For full context, use the command                           │
│   zig ast-check -t ファイル名                               │
└─────────────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | コンテキストヘッダー | "Compiler crash context:" | 固定文字列 | テキスト |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | 関数名 | コード生成中の関数の完全修飾名 | `CodegenFunc.current.func_index` | "Generating function '{name}'" | 可変 |
| 2 | ファイル名 | 解析中のファイルパス | `Zcu.File.path` | "Analyzing '{path}'" | 可変 |
| 3 | ZIR命令 | 現在解析中のZIR命令の詳細 | `print_zir.renderInstructionContext` | インデント付きテキスト | 可変 |
| 4 | 親ブロック情報 | 呼び出し元のブロック情報 | `AnalyzeBody.parent` | "in {file}\n  > {instruction}" | 可変 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | デバッグコマンド提案 | ZIRダンプ用コマンド | `zig_argv0`, `file.path` | "For full context, use the command\n  {cmd} ast-check -t {path}" |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| パニック発生 | `panicImpl`関数が呼び出された場合 | Yes |
| セグメンテーションフォルト | `handleSegfaultImpl`関数が呼び出された場合 | Yes |
| デバッグ拡張有効 | `build_options.enable_debug_extensions == true` | Yes |

### ソート順

N/A（発生順に出力）

### 改ページ条件

N/A（テキスト出力のため改ページなし）

## データベース参照仕様

### 参照テーブル一覧

N/A（データベースを使用しない。コンパイラ内部のメモリ構造を参照）

### テーブル別参照項目詳細

#### 内部データ構造

| 参照項目 | 帳票項目との対応 | 取得条件 | 備考 |
|---------|----------------|---------|------|
| `CodegenFunc.current` | コード生成中関数情報 | `CodegenFunc.current != null` | スレッドローカル変数 |
| `AnalyzeBody.current` | セマンティック解析情報 | `AnalyzeBody.current != null` | スレッドローカル変数 |
| `Sema.Block` | ブロック情報 | `AnalyzeBody`から取得 | ソース位置解決に使用 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| N/A | - | - | 計算項目なし |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[パニック/セグフォルト発生] --> B{already_dumped?}
    B -->|Yes| C[出力スキップ]
    B -->|No| D[already_dumped = true]
    D --> E[stderrロック取得]
    E --> F["Compiler crash context:" 出力]
    F --> G{CodegenFunc.current?}
    G -->|Yes| H[関数名出力]
    G -->|No| I{AnalyzeBody.current?}
    I -->|Yes| J[dumpCrashContextSema呼び出し]
    I -->|No| K["(no context)" 出力]
    H --> L[stderrロック解放]
    J --> L
    K --> L
    L --> M[デフォルトパニック/セグフォルトハンドラ呼び出し]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| メモリ不足 | ZIRダンプ中にアロケータ枯渇 | "<out of memory dumping zir>" | 64KBの固定バッファを使用して影響を最小化 |
| 書き込みエラー | stderr書き込み失敗 | なし（静かに失敗） | エラーを無視して続行 |
| ロスト命令 | ZIR命令のマッピング失敗 | "[lost instruction; this should not happen]" | 親ブロックの処理を継続 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1件（クラッシュ1回につき1レポート） |
| 目標出力時間 | 即時（クラッシュ時の遅延は許容されない） |
| 同時出力数上限 | 1件（再帰的クラッシュは`already_dumped`フラグで防止） |

## セキュリティ考慮事項

- クラッシュレポートにはソースコードのパス情報が含まれる可能性がある
- 機密性の高いプロジェクトでは、クラッシュレポートの共有時にパス情報の削除を検討
- `enable_debug_extensions`が無効の場合、詳細なコンテキスト情報は出力されない

## 備考

- クラッシュレポートは`build_options.enable_debug_extensions`が有効な場合のみ詳細情報を出力
- 再帰的パニック防止のため、`already_dumped`フラグをスレッドローカルで管理
- ZIRダンプには64KBの固定サイズヒープを使用し、アロケーション失敗の影響を最小化

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

クラッシュレポートで使用されるデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | crash_report.zig | `src/crash_report.zig` | `AnalyzeBody`構造体（行31-64）：セマンティック解析のコンテキスト情報を保持 |
| 1-2 | crash_report.zig | `src/crash_report.zig` | `CodegenFunc`構造体（行66-83）：コード生成のコンテキスト情報を保持 |

**読解のコツ**: `build_options.enable_debug_extensions`による条件コンパイルに注意。デバッグ拡張が無効の場合、これらの構造体はダミー実装となる。

#### Step 2: エントリーポイントを理解する

パニック/セグフォルト時の処理起点を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | crash_report.zig | `src/crash_report.zig` | `panic`定数（行3-6）：標準ライブラリのパニックハンドラをオーバーライド |
| 2-2 | crash_report.zig | `src/crash_report.zig` | `handleSegfaultImpl`関数（行20-24）：セグフォルトハンドラ |
| 2-3 | crash_report.zig | `src/crash_report.zig` | `panicImpl`関数（行25-29）：パニックハンドラ |

**主要処理フロー**:
1. **行22**: `dumpCrashContext()`を呼び出してコンテキスト情報を出力
2. **行23/28**: デフォルトのパニック/セグフォルトハンドラに処理を委譲

#### Step 3: コンテキストダンプ処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | crash_report.zig | `src/crash_report.zig` | `dumpCrashContext`関数（行85-113）：メインのダンプ処理 |
| 3-2 | crash_report.zig | `src/crash_report.zig` | `dumpCrashContextSema`関数（行114-176）：セマンティック解析コンテキストの詳細ダンプ |

**主要処理フロー**:
- **行86-94**: 再帰的パニック防止の`already_dumped`チェック
- **行98-100**: stderrのロック取得
- **行104-112**: コンテキスト種別に応じた出力分岐
- **行129-146**: ZIR命令コンテキストの出力
- **行148-173**: 親ブロックチェーンの走査と出力

#### Step 4: ZIR出力処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | print_zir.zig | `src/print_zir.zig` | `renderInstructionContext`関数（行53-84）：ZIR命令コンテキストのレンダリング |
| 4-2 | print_zir.zig | `src/print_zir.zig` | `renderSingleInstruction`関数（行86-110）：単一ZIR命令のレンダリング |

### プログラム呼び出し階層図

```
panicImpl / handleSegfaultImpl
    |
    +-- dumpCrashContext
           |
           +-- [CodegenFunc.current != null]
           |       +-- 関数名出力
           |
           +-- [AnalyzeBody.current != null]
                   +-- dumpCrashContextSema
                           |
                           +-- print_zir.renderInstructionContext
                           |
                           +-- [親ブロックループ]
                                   +-- print_zir.renderSingleInstruction
```

### データフロー図

```
[入力]                      [処理]                           [出力]

CodegenFunc.current  ─────> dumpCrashContext ─────────────> stderr
(スレッドローカル)           (コンテキスト判定)               "Generating function '...'"

AnalyzeBody.current  ─────> dumpCrashContextSema ─────────> stderr
(スレッドローカル)           (Sema情報抽出)                   "Analyzing '...'"
        |                          |
        v                          v
Sema.Block           ─────> print_zir.render* ────────────> stderr
(ブロック情報)               (ZIR命令整形)                    ZIR命令テキスト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| crash_report.zig | `src/crash_report.zig` | ソース | クラッシュレポートのメイン実装 |
| print_zir.zig | `src/print_zir.zig` | ソース | ZIR命令のテキスト出力 |
| Sema.zig | `src/Sema.zig` | ソース | セマンティック解析器（Block定義） |
| Zcu.zig | `src/Zcu.zig` | ソース | Zigコンパイルユニット（LazySrcLoc定義） |
| build_options | `build_options` | 設定 | `enable_debug_extensions`フラグ定義 |
