# 帳票設計書 10-InternPoolダンプ

## 概要

本ドキュメントは、Zigコンパイラにおける InternPoolダンプ帳票の設計仕様を記述するものである。InternPool（型・値の内部データ構造）の統計情報およびジェネリックインスタンス一覧を出力し、メモリ使用量の詳細分析を可能にする機能を定義する。

### 本帳票の処理概要

InternPoolダンプは、Zigコンパイラ内部で使用されるInternPool（型・値のインターン化データ構造）の状態を詳細に出力するための帳票である。メモリ使用量の統計、タグごとのカウント、および全エントリの詳細ダンプを提供する。

**業務上の目的・背景**：コンパイラの性能とメモリ効率は、大規模プロジェクトのビルド時間に直接影響する。InternPoolはZigコンパイラのメモリ管理の中核であり、型・値・関数などすべての重要なコンパイル時データを格納する。本帳票により、開発者はInternPoolのメモリ使用状況を詳細に分析でき、メモリリークの検出、最適化の効果検証、パフォーマンスボトルネックの特定に活用できる。

**帳票の利用シーン**：
1. コンパイラのメモリ使用量分析
2. InternPool実装の最適化検証
3. 大規模プロジェクトでのメモリボトルネック調査
4. ジェネリックインスタンス数の確認
5. タグ別のエントリ分布分析
6. コンパイラ開発時のデバッグ

**主要な出力内容**：
1. 総メモリ使用量（items, extra, limbs）
2. タグ別エントリカウントとバイト数
3. 各エントリの詳細ダンプ（オプション）
4. ジェネリックインスタンス一覧（verbose_generic_instances有効時）

**帳票の出力タイミング**：`verbose_intern_pool`オプション有効時、またはdump関数の明示的呼び出し時に出力される。

**帳票の利用者**：Zigコンパイラ開発者、パフォーマンスエンジニア、メモリ最適化担当者

## 帳票種別

デバッグ/診断レポート

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | コマンドライン | コンパイル時オプション | `verbose_intern_pool`オプション有効時 |
| - | デバッグAPI | `InternPool.dump()` | プログラムからの呼び出し |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準エラー出力） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（標準エラー出力） |
| 出力方法 | stderr直接書き込み（4096バイトバッファ） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

InternPoolダンプは統計サマリーとオプションの詳細ダンプで構成される。

```
┌─────────────────────────────────────────────────────────────┐
│ InternPool size: XXXX bytes                                 │
│   XXXX items: XXXX bytes                                    │
│   XXXX extra: XXXX bytes                                    │
│   XXXX limbs: XXXX bytes                                    │
├─────────────────────────────────────────────────────────────┤
│ [タグ別統計]                                                 │
│ Tag                  Count    Bytes                         │
│ type_int_signed      XXX      XXX                           │
│ type_pointer         XXX      XXX                           │
│ ...                                                         │
├─────────────────────────────────────────────────────────────┤
│ [詳細ダンプ（オプション）]                                    │
│ [0] tag_name: data...                                       │
│ [1] tag_name: data...                                       │
│ ...                                                         │
└─────────────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 総サイズ | InternPool総バイト数 | 計算値 | `{d} bytes` |
| 2 | items | アイテム数とサイズ | `local.mutate.items.len` | `{d} items: {d} bytes` |
| 3 | extra | Extra配列のサイズ | `local.mutate.extra.len` | `{d} extra: {d} bytes` |
| 4 | limbs | Limbs配列のサイズ | `local.mutate.limbs.len` | `{d} limbs: {d} bytes` |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | タグ名 | InternPool.Tag | `items.items(.tag)` | 文字列 | 可変 |
| 2 | カウント | タグごとのエントリ数 | 集計値 | 整数 | 8 |
| 3 | バイト数 | タグごとの使用バイト数 | 計算値 | 整数 | 12 |

### フッター部

N/A

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| verbose_intern_pool | コンパイルオプション有効 | Yes（自動出力時） |
| dump呼び出し | 明示的なAPI呼び出し | Yes（手動出力時） |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | タグ値 | タグ定義順 |

### 改ページ条件

N/A（連続テキスト出力）

## データベース参照仕様

N/A（データベースを使用しない。コンパイラ内部のInternPool構造を参照）

### 内部データ構造参照

| 参照項目 | 帳票項目との対応 | 取得条件 | 備考 |
|---------|----------------|---------|------|
| `ip.locals` | 統計情報 | 全ローカル走査 | スレッドローカルデータ |
| `local.mutate.items` | アイテム数・サイズ | `.len`アクセス | MultiArrayList |
| `local.mutate.extra` | Extra配列サイズ | `.len`アクセス | 追加データ |
| `local.mutate.limbs` | Limbs配列サイズ | `.len`アクセス | 大整数リム |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| items_size | `(1 + 4) * items_len` | なし | タグ1バイト + データ4バイト |
| extra_size | `4 * extra_len` | なし | 4バイト/項目 |
| limbs_size | `8 * limbs_len` | なし | 8バイト/リム |
| total_size | `@sizeOf(InternPool) + items_size + extra_size + limbs_size` | なし | 構造体オーバーヘッド含む |
| tag_bytes | タグ固有の計算式 | なし | タグごとに異なる |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[dump呼び出し] --> B[stderrロック取得]
    B --> C[dumpStatsFallible呼び出し]
    C --> D[items/extra/limbs長の集計]
    D --> E[サイズ計算]
    E --> F[統計ヘッダー出力]
    F --> G[TagStats初期化]
    G --> H[全ローカルのタグ走査]
    H --> I[タグごとのカウント・バイト数集計]
    I --> J[タグ別統計出力]
    J --> K{dumpAllFallible呼び出し?}
    K -->|Yes| L[全エントリ詳細ダンプ]
    K -->|No| M[終了]
    L --> M
    M --> N[stderrロック解放]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 書き込みエラー | stderr書き込み失敗 | なし | `catch return`で静かに終了 |
| OutOfMemory | 統計用HashMap割り当て失敗 | なし | `catch return`で静かに終了 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数千〜数百万エントリ（プロジェクトサイズに依存） |
| 目標出力時間 | O(N)（エントリ数に比例） |
| 同時出力数上限 | 1件 |

## セキュリティ考慮事項

- InternPoolダンプにはコンパイル中のすべての型・値情報が含まれる
- 機密性の高いコード構造が露出する可能性

## 備考

- `verbose_intern_pool`は`Compilation.zig`で定義
- タグごとのバイト数計算は`dumpStatsFallible`内で詳細に実装
- マップオーバーヘッドは現在計算に含まれていない（TODOコメントあり）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

InternPoolの基本構造を理解することが前提となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | InternPool.zig | `src/InternPool.zig` | InternPool構造体：locals, shards等 |
| 1-2 | InternPool.zig | `src/InternPool.zig` | `Tag`列挙型：エントリ種別の定義 |
| 1-3 | InternPool.zig | `src/InternPool.zig` | `Local`構造体：スレッドローカルデータ |

**読解のコツ**: InternPoolはマルチスレッド対応で、`locals`配列でスレッドごとのデータを管理。

#### Step 2: エントリーポイントを理解する

ダンプ処理の起点を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | InternPool.zig | `src/InternPool.zig` | `dump`関数（行11192-11199）：エントリーポイント |

**主要処理フロー**:
1. **行11193**: 4096バイトバッファの準備
2. **行11194-11195**: stderrのロック取得
3. **行11197**: `dumpStatsFallible`呼び出し
4. **行11198**: `dumpAllFallible`呼び出し

#### Step 3: 統計ダンプを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | InternPool.zig | `src/InternPool.zig` | `dumpStatsFallible`関数（行11201-11400+）：統計出力 |

**主要処理フロー**:
- **行11202-11208**: locals走査でlen集計
- **行11210-11215**: サイズ計算
- **行11217-11231**: 統計ヘッダー出力（std.debug.print使用）
- **行11233-11400+**: タグ別統計の計算と出力

#### Step 4: タグ別バイト数計算を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | InternPool.zig | `src/InternPool.zig` | `dumpStatsFallible`内のswitch文（行11249-11400+）：タグごとのバイト数計算 |

**読解のコツ**: 各タグには固定サイズと可変サイズ部分があり、`extraData`等で追加データサイズを取得。

### プログラム呼び出し階層図

```
dump
    |
    +-- stderrロック取得
    |
    +-- dumpStatsFallible
    |       |
    |       +-- locals走査
    |       |       +-- items.len集計
    |       |       +-- extra.len集計
    |       |       +-- limbs.len集計
    |       |
    |       +-- サイズ計算
    |       +-- 統計ヘッダー出力
    |       |
    |       +-- TagStats HashMap初期化
    |       +-- locals再走査
    |       |       +-- タグ走査
    |       |       +-- タグ別カウント
    |       |       +-- タグ別バイト数計算
    |       |
    |       +-- タグ別統計出力
    |
    +-- dumpAllFallible
    |       +-- 全エントリ詳細ダンプ
    |
    +-- stderrロック解放
```

### データフロー図

```
[入力]                      [処理]                           [出力]

InternPool構造体     ─────> dump ─────────────────────────> stderr
  |                         |
  +-- locals         ─────> dumpStatsFallible ────────────> 統計ヘッダー
        |                   |
        +-- items    ─────> サイズ計算 ───────────────────> items_size
        +-- extra    ─────> サイズ計算 ───────────────────> extra_size
        +-- limbs    ─────> サイズ計算 ───────────────────> limbs_size
                            |
                            +-- タグ走査 ─────────────────> TagStats
                            |
                            +-- タグ別出力 ───────────────> タグ統計
                            |
                            v
                       dumpAllFallible ───────────────────> エントリ詳細
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| InternPool.zig | `src/InternPool.zig` | ソース | InternPool定義・ダンプ実装 |
| Compilation.zig | `src/Compilation.zig` | ソース | verbose_intern_poolオプション定義 |
| Zcu.zig | `src/Zcu.zig` | ソース | InternPool使用元 |
