# 帳票設計書 5-カバレッジレポート

## 概要

本ドキュメントは、Zigコンパイラツールにおけるカバレッジレポート帳票の設計仕様を記述するものである。実行カバレッジファイルを読み込み、プログラムカウンタ（PC）ごとのソース位置情報を人間が読みやすい形式で標準出力に出力する機能を定義する。

### 本帳票の処理概要

カバレッジレポートは、Zigプログラムの実行カバレッジ情報を解析し、各プログラムカウンタ（PC）アドレスとソースコード位置（ファイル:行:列）の対応を可視化するための帳票である。ファジングテストやコードカバレッジ分析に活用される。

**業務上の目的・背景**：ソフトウェアテストにおいて、コードカバレッジの測定は品質保証の重要な指標である。特にファジングテストでは、どのコードパスが実行されたかを把握することが、テストの有効性評価やバグ発見に不可欠である。本帳票により、開発者はカバレッジファイルの内容を人間が読める形式で確認でき、未実行コードの特定やテスト戦略の改善に活用できる。

**帳票の利用シーン**：
1. ファジングテスト結果の分析
2. コードカバレッジの詳細確認
3. 未カバーコード領域の特定
4. テストケース追加の優先順位決定
5. デバッグ時のPC-ソース位置対応確認

**主要な出力内容**：
1. SeenPcsHeaderの内容（カバレッジファイルヘッダー情報）
2. 各PCアドレスに対応するソース位置（ディレクトリ/ファイル:行:列）
3. ヒット/未ヒットマーク（+/-）
4. 無効なソース位置の場合は"invalid"表示

**帳票の出力タイミング**：`dump-cov`ツール実行時に出力される。

**帳票の利用者**：テストエンジニア、品質保証担当者、ファジングテスト実施者、開発者

## 帳票種別

デバッグ/診断レポート

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | コマンドライン | `dump-cov <exe> <coverage> [target]` | コマンド実行時 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | バッファリングされたストリーム書き込み（4000バイトバッファ） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

カバレッジレポートはヘッダー情報とPC-ソース位置マッピングで構成される。

```
┌─────────────────────────────────────────────────────────────┐
│ SeenPcsHeader { ... }                                       │
├─────────────────────────────────────────────────────────────┤
│ +0x12345678: /path/to/dir/file.zig:10:5                     │
│ -0x12345680: /path/to/dir/file.zig:15:1                     │
│ +0x12345690: invalid                                        │
│ ...                                                         │
└─────────────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | SeenPcsHeader | カバレッジファイルヘッダー | `header.*` | `{any}` |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | ヒットマーク | 実行されたかどうか | `seen_pcs`ビットマップ | `+`（ヒット）/`-`（未ヒット） | 1 |
| 2 | PCアドレス | プログラムカウンタ値 | `pcs` | `{x}` | 可変 |
| 3 | ディレクトリ | ソースファイルのディレクトリ | `debug_info.coverage.directories` | パス文字列 | 可変 |
| 4 | ファイル名 | ソースファイル名 | `debug_info.coverage.fileAt()` | ファイル名 | 可変 |
| 5 | 行番号 | ソース行番号 | `sl.line` | 整数 | 可変 |
| 6 | 列番号 | ソース列番号 | `sl.column` | 整数 | 可変 |

### フッター部

N/A

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 実行ファイル存在 | 解析対象の実行ファイルが存在 | Yes |
| カバレッジファイル存在 | カバレッジデータファイルが存在 | Yes |
| デバッグ情報存在 | 実行ファイルにデバッグ情報が含まれる | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | PCアドレス | 昇順 |

### 改ページ条件

N/A（連続テキスト出力）

## データベース参照仕様

N/A（データベースを使用しない。カバレッジファイルとデバッグ情報を参照）

### ファイル参照仕様

| 参照ファイル | 用途 | 取得条件 | 備考 |
|-------------|------|---------|------|
| 実行ファイル | デバッグ情報取得 | コマンドライン引数 | ELF/MachO/PEなど |
| カバレッジファイル | PC一覧・ヒット情報 | コマンドライン引数 | SeenPcsHeader形式 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| ヒット判定 | `seen_pcs[seen_i / @bitSizeOf(usize)] >> @intCast(seen_i % @bitSizeOf(usize))` | 切り捨て（ビット演算） | ビットマップから抽出 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[dump-cov実行] --> B[引数解析]
    B --> C{引数数チェック}
    C -->|不正| D[使用方法表示・終了]
    C -->|正常| E[ターゲット解決]
    E --> F[デバッグ情報ロード]
    F --> G[カバレッジファイル読み込み]
    G --> H[SeenPcsHeader出力]
    H --> I[PCインデックス作成]
    I --> J[PCソート]
    J --> K[ソース位置解決]
    K --> L[各PCの出力ループ]
    L --> M{有効な位置?}
    M -->|Yes| N[ヒットマーク+位置出力]
    M -->|No| O["invalid"出力]
    N --> P{次のPC?}
    O --> P
    P -->|Yes| L
    P -->|No| Q[flush・終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 引数不足 | 引数が2-3個でない | 使用方法表示 | `fatal()`で終了 |
| デバッグ情報ロード失敗 | 実行ファイル読み込みエラー | `failed to load debug info for {path}: {err}` | `fatal()`で終了 |
| カバレッジファイル読み込み失敗 | カバレッジファイルエラー | `failed to load coverage file {path}: {err}` | `fatal()`で終了 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数千〜数万PC（プログラムサイズに依存） |
| 目標出力時間 | O(N log N)（ソート+線形走査） |
| 同時出力数上限 | 1件 |

## セキュリティ考慮事項

- カバレッジレポートにはソースファイルのパス情報が含まれる
- バイナリの内部構造（アドレス情報）が露出する

## 備考

- ターゲットはオプション。省略時は"native"
- PCアドレスはソートされて出力される
- 無効なソース位置（デバッグ情報なし）は"invalid"と表示
- 4000バイトのstdoutバッファでストリーミング出力

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

カバレッジデータの構造を理解することが前提となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | dump-cov.zig | `tools/dump-cov.zig` | `SeenPcsHeader`インポート（行9） |
| 1-2 | std.Build.abi.fuzz | 標準ライブラリ | `SeenPcsHeader`構造体定義 |

**読解のコツ**: `SeenPcsHeader`はファジングテスト用のカバレッジデータ形式。`pcAddrs()`でPCアドレス配列、`seenBits()`でヒットビットマップを取得。

#### Step 2: エントリーポイントを理解する

main関数の処理フローを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | dump-cov.zig | `tools/dump-cov.zig` | `main`関数（行11-98）：全体の処理フロー |

**主要処理フロー**:
1. **行16-24**: 引数解析と使用方法表示
2. **行27-29**: ターゲットクエリ解決
3. **行31-41**: パス構造体の作成
4. **行43-48**: デバッグ情報のロード
5. **行51-60**: カバレッジファイルの読み込み
6. **行62-64**: stdout出力の準備
7. **行66-68**: SeenPcsHeaderの出力
8. **行70-76**: PCインデックス作成とソート
9. **行78-79**: ソース位置解決
10. **行83-96**: メインの出力ループ

#### Step 3: デバッグ情報処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | dump-cov.zig | `tools/dump-cov.zig` | `debug_info.resolveAddresses`（行79）：PC→ソース位置変換 |
| 3-2 | std.debug | 標準ライブラリ | `Coverage`構造体：カバレッジデータ管理 |
| 3-3 | std.debug | 標準ライブラリ | `Info.load`：デバッグ情報ロード |

#### Step 4: 出力処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | dump-cov.zig | `tools/dump-cov.zig` | 出力ループ（行83-96）：ヒット判定と位置出力 |

**主要処理フロー**:
- **行84-86**: 無効な位置の処理
- **行88-91**: ファイル・ディレクトリ情報取得
- **行92**: ヒット判定（ビットマップから抽出）
- **行93-95**: フォーマット出力

### プログラム呼び出し階層図

```
main
    |
    +-- 引数解析
    |       +-- resolveTargetQueryOrFatal
    |
    +-- std.debug.Info.load
    |       +-- デバッグ情報パース
    |
    +-- readFileAllocOptions
    |       +-- カバレッジファイル読み込み
    |
    +-- SeenPcsHeader.pcAddrs
    |
    +-- std.mem.sortUnstable (PCソート)
    |
    +-- debug_info.resolveAddresses
    |       +-- PC→ソース位置変換
    |
    +-- 出力ループ
            +-- coverage.fileAt
            +-- coverage.stringAt
            +-- stdout.print
```

### データフロー図

```
[入力]                      [処理]                           [出力]

実行ファイル         ─────> Info.load ────────────────────> デバッグ情報
                                    |
                                    v
カバレッジファイル   ─────> SeenPcsHeader解析 ─────────────> PC配列, ヒットビット
                                    |
                                    v
                            resolveAddresses ─────────────> ソース位置配列
                                    |
                                    v
                            出力ループ ───────────────────> stdout
                                                            "+0x...: path:line:col"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| dump-cov.zig | `tools/dump-cov.zig` | ソース | カバレッジダンプのメイン実装 |
| std.debug | 標準ライブラリ | ソース | デバッグ情報・カバレッジ処理 |
| std.Build.abi.fuzz | 標準ライブラリ | ソース | SeenPcsHeader定義 |
