# 帳票設計書 6-HTMLドキュメント

## 概要

本ドキュメントは、Zigコンパイラツールにおける HTMLドキュメント生成帳票の設計仕様を記述するものである。docgenテンプレートからHTMLドキュメントを生成し、コード例の出力ディレクトリを指定可能な機能を定義する。

### 本帳票の処理概要

HTMLドキュメント生成は、Zigプロジェクトのドキュメンテーション用テンプレートファイルを処理し、構造化されたHTMLドキュメントを出力するための帳票である。目次の自動生成、コード例の埋め込み、クロスリファレンスリンクの生成を行う。

**業務上の目的・背景**：プログラミング言語やライブラリのドキュメンテーションは、ユーザーの学習効率とプロジェクトの普及に直結する重要な要素である。本帳票により、Zigの公式ドキュメント（言語リファレンス、標準ライブラリドキュメント等）を一貫した形式で生成でき、ドキュメントのメンテナンスコストを削減しながら高品質なドキュメンテーションを提供できる。

**帳票の利用シーン**：
1. Zig公式ドキュメントのビルド
2. 言語リファレンスの更新・公開
3. チュートリアルページの生成
4. API ドキュメントの生成
5. プロジェクトのWebサイト更新

**主要な出力内容**：
1. HTML形式のドキュメントファイル
2. 自動生成された目次（Table of Contents）
3. 埋め込まれたコード例
4. セクション間のクロスリファレンスリンク
5. シンタックスハイライトされたコードブロック

**帳票の出力タイミング**：`docgen`ツール実行時に出力される。

**帳票の利用者**：ドキュメント管理者、Zigプロジェクトメンテナ、Webサイト管理者

## 帳票種別

ドキュメント生成レポート

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | コマンドライン | `docgen [options] input output` | コマンド実行時 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTML |
| 用紙サイズ | N/A（Webページ） |
| 向き | N/A |
| ファイル名 | コマンドライン引数で指定 |
| 出力方法 | ファイル書き込み（4096バイトバッファ） |
| 文字コード | UTF-8 |

### オプション

| オプション | 説明 | 必須 |
|-----------|------|-----|
| `--code-dir dir` | コード例出力ディレクトリ | Yes |
| `-h, --help` | ヘルプ表示 | No |

## 帳票レイアウト

### レイアウト概要

生成されるHTMLドキュメントは以下の構造を持つ。

```
┌─────────────────────────────────────────────────────────────┐
│ [HTMLヘッダー]                                               │
├─────────────────────────────────────────────────────────────┤
│ [ナビゲーション（目次）]                                      │
│   <ul>                                                      │
│     <li><a href="#section">Section Title</a>                │
│       <ul>...</ul>                                          │
│     </li>                                                   │
│   </ul>                                                     │
├─────────────────────────────────────────────────────────────┤
│ [本文コンテンツ]                                             │
│   <h2 id="section">Section Title</h2>                       │
│   <p>Content...</p>                                         │
│   [コード例ブロック]                                         │
│   [See Also リンク]                                         │
├─────────────────────────────────────────────────────────────┤
│ [フッター]                                                   │
└─────────────────────────────────────────────────────────────┘
```

### 入力テンプレート構文

| タグ | 説明 | 使用例 |
|-----|------|-------|
| `{#nav#}` | ナビゲーション挿入位置 | 目次が挿入される |
| `{#header_open\|title#}` | セクション開始 | `{#header_open\|Introduction#}` |
| `{#header_close#}` | セクション終了 | - |
| `{#see_also\|name\|name#}` | 関連セクションリンク | `{#see_also\|Arrays\|Slices#}` |
| `{#code\|name#}` | コード例埋め込み | `{#code\|hello_world#}` |
| `{#link\|name#}` | 内部リンク | `{#link\|Pointers#}` |
| `{#syntax\|zig\|...\|#}` | シンタックスブロック | インラインコード |
| `{#shell\|command#}` | シェルコマンド | `{#shell\|zig build#}` |
| `{#builtin#}` | 組み込み関数リスト | 自動生成 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 入力ファイル存在 | テンプレートファイルが存在 | Yes |
| code-dirオプション | コード例ディレクトリの指定 | Yes |
| ヘッダーバランス | header_open/closeが対応 | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | テンプレート内の出現順 | 順序維持 |

### 改ページ条件

N/A（HTML出力のため）

## データベース参照仕様

N/A（データベースを使用しない。テンプレートファイルとコード例ファイルを参照）

### ファイル参照仕様

| 参照ファイル | 用途 | 取得条件 | 備考 |
|-------------|------|---------|------|
| 入力テンプレート | ドキュメント構造定義 | コマンドライン引数 | 最大10MBまで |
| code-dirディレクトリ | コード例ファイル | --code-dirオプション | - |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| header_stack_size | `+1`（open時）/ `-1`（close時） | なし | ネストレベル管理 |
| urlized | `urlize(content)` | なし | URLセーフな文字列に変換 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[docgen実行] --> B[引数解析]
    B --> C{必須引数あり?}
    C -->|No| D[エラー終了]
    C -->|Yes| E[入力ファイル読み込み]
    E --> F[Tokenizer初期化]
    F --> G[genToc - 目次生成]
    G --> H{ヘッダーバランス?}
    H -->|No| I[ParseError]
    H -->|Yes| J[genHtml - HTML生成]
    J --> K[ノード走査]
    K --> L{ノードタイプ?}
    L -->|Content| M[テキスト出力]
    L -->|Nav| N[目次挿入]
    L -->|HeaderOpen| O[セクション開始タグ]
    L -->|Code| P[コード例埋め込み]
    L -->|SeeAlso| Q[関連リンク生成]
    M --> R[次のノード]
    N --> R
    O --> R
    P --> R
    Q --> R
    R --> S{完了?}
    S -->|No| K
    S -->|Yes| T[ファイル出力・終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 引数不足 | 必須引数なし | `missing input file` / `missing output file` / `missing --code-dir argument` | `fatal()`で終了 |
| 不正オプション | 未知のオプション | `unrecognized option: '{s}'` | `fatal()`で終了 |
| パースエラー | テンプレート構文エラー | `{file}:{line}:{col}: error: {msg}` | エラー位置表示 |
| ヘッダー不均衡 | open/closeの不一致 | `unbalanced headers` / `unbalanced close header` | `parseError()`で終了 |
| 重複URL | 同一URLのヘッダー | `duplicate header url: #{url}` | `parseError()`で終了 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1テンプレート（最大10MB） |
| 目標出力時間 | O(N)（入力サイズに比例） |
| 同時出力数上限 | 1件 |

## セキュリティ考慮事項

- 生成されるHTMLにはユーザー指定のコンテンツが含まれる
- XSS対策として、適切なエスケープ処理が必要
- コード例の実行結果は信頼できるソースから取得すること

## 備考

- テンプレート構文は`{#tag|param|param#}`形式
- 目次は2カラムレイアウトに対応（`2col`パラメータ）
- URL生成は`urlize`関数でスペースをハイフンに変換

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テンプレート処理のデータ構造を理解することが前提となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | docgen.zig | `tools/docgen.zig` | `Token`構造体（行89-103）：トークン種別 |
| 1-2 | docgen.zig | `tools/docgen.zig` | `Node`共用体（行316-328）：パース結果ノード |
| 1-3 | docgen.zig | `tools/docgen.zig` | `Toc`構造体（行329-333）：目次データ |

**読解のコツ**: テンプレートは2段階で処理される。1段階目でトークン化・パース、2段階目でHTML生成。

#### Step 2: エントリーポイントを理解する

main関数の処理フローを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | docgen.zig | `tools/docgen.zig` | `main`関数（行31-87）：全体の処理フロー |

**主要処理フロー**:
1. **行35-36**: コマンドライン引数のイテレータ取得
2. **行38-63**: オプション・引数解析
3. **行68-80**: ファイルのオープンと読み込み
4. **行82-83**: Tokenizer初期化とgenToc呼び出し
5. **行85-86**: genHtml呼び出しと出力完了

#### Step 3: Tokenizerを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | docgen.zig | `tools/docgen.zig` | `Tokenizer`構造体（行105-243）：テンプレートのトークン化 |
| 3-2 | docgen.zig | `tools/docgen.zig` | `next`関数（行128-211）：次のトークン取得 |

**主要処理フロー**:
- `{#`で開始、`#}`で終了するタグを認識
- `|`でパラメータを区切り
- 状態機械による字句解析

#### Step 4: 目次生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | docgen.zig | `tools/docgen.zig` | `genToc`関数（行340-500+）：目次生成とパース |

**主要処理フロー**:
- `header_open`/`header_close`でヘッダースタック管理
- URLの重複チェック
- 目次HTMLの生成

#### Step 5: HTML生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | docgen.zig | `tools/docgen.zig` | `genHtml`関数：最終HTML出力 |

### プログラム呼び出し階層図

```
main
    |
    +-- 引数解析
    |
    +-- ファイル読み込み
    |
    +-- Tokenizer.init
    |
    +-- genToc
    |       +-- Tokenizer.next (ループ)
    |       +-- eatToken
    |       +-- assertToken
    |       +-- urlize
    |       +-- 目次HTML構築
    |
    +-- genHtml
            +-- ノード走査
            |       +-- Content出力
            |       +-- Nav（目次挿入）
            |       +-- HeaderOpen（セクション開始）
            |       +-- Code（コード例読み込み・埋め込み）
            |       +-- SeeAlso（関連リンク）
            |       +-- Link（内部リンク）
            |       +-- SyntaxBlock（シンタックスハイライト）
            |
            +-- ファイル書き込み
```

### データフロー図

```
[入力]                      [処理]                           [出力]

テンプレートファイル ─────> Tokenizer ─────────────────────> Token列
                                |
                                v
                           genToc ──────────────────────────> Toc構造体
                                |                              (nodes, toc, urls)
                                v
code-dirディレクトリ  ─────> genHtml ─────────────────────> HTMLファイル
                                |
                                +-- Node.Content ────────────> テキスト出力
                                +-- Node.Nav ────────────────> 目次挿入
                                +-- Node.Code ───────────────> コード例埋め込み
                                +-- Node.HeaderOpen ─────────> <h2>タグ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| docgen.zig | `tools/docgen.zig` | ソース | HTMLドキュメント生成のメイン実装 |
| テンプレートファイル | 任意 | 入力 | ドキュメント構造定義 |
| code-dir | ディレクトリ | 入力 | コード例ファイル格納 |
| 出力HTML | 任意 | 出力 | 生成されるHTMLドキュメント |
