# 帳票設計書 7-コンパイルログ

## 概要

本ドキュメントは、Zigコンパイラにおけるコンパイルログ帳票の設計仕様を記述するものである。`@compileLog`組み込み関数の出力を集約し、テキストレポートとして出力する機能を定義する。

### 本帳票の処理概要

コンパイルログは、Zigソースコード内で使用された`@compileLog`組み込み関数の出力を収集・統合し、開発者にコンパイル時の値情報を提供するための帳票である。デバッグ用のログ出力をコンパイル時に行う際に使用される。

**業務上の目的・背景**：Zigはコンパイル時計算（comptime）を強力にサポートする言語であり、コンパイル時の値を確認することはデバッグにおいて重要である。`@compileLog`はコンパイル時の値を出力する組み込み関数であり、本帳票によりこれらの出力が統合され、開発者が効率的にコンパイル時の状態を把握できる。他のコンパイルエラーがない場合は、`@compileLog`の存在自体がエラーとして報告される。

**帳票の利用シーン**：
1. comptimeコードのデバッグ
2. 型情報の確認（`@typeName`等と組み合わせ）
3. コンパイル時計算結果の検証
4. ジェネリックコードのインスタンス化確認
5. 条件付きコンパイルのデバッグ

**主要な出力内容**：
1. `@compileLog`呼び出しのソース位置
2. 出力された値（各引数を改行区切りで表示）
3. 複数の呼び出しがある場合は統合表示
4. エラーメッセージ（他エラーがない場合）

**帳票の出力タイミング**：コンパイル時に`@compileLog`が実行された場合、エラーバンドルの一部として出力される。

**帳票の利用者**：Zigプログラマ、コンパイル時計算を使用する開発者

## 帳票種別

デバッグ/診断レポート

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | コマンドライン | `zig build`, `zig build-exe` など | `@compileLog`使用時に自動出力 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（エラーバンドルの一部） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（標準エラー出力） |
| 出力方法 | ErrorBundleを通じた出力 |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

コンパイルログは通常、エラーメッセージと共に出力される。

```
┌─────────────────────────────────────────────────────────────┐
│ [コンパイルログの集約出力]                                    │
│ value1                                                      │
│ value2                                                      │
│ ...                                                         │
├─────────────────────────────────────────────────────────────┤
│ [エラーメッセージ（他エラーがない場合のみ）]                   │
│ file.zig:line:col: error: found compile log statement       │
│ note: also here（複数箇所の場合）                            │
└─────────────────────────────────────────────────────────────┘
```

### ヘッダー部

N/A（コンパイルログ本文のみ）

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | ログ値 | @compileLogの各引数値 | `compile_logs` | テキスト行 | 可変 |
| 2 | ソース位置 | 呼び出し箇所 | `compile_log.src()` | `file:line:col` | 可変 |

### フッター部

N/A

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| @compileLog使用 | ソースコード内で@compileLogが呼び出されている | Yes |
| 参照されている | 該当コードが実際に参照されている（dead code除外） | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | ソース位置 | ファイル名→行番号→列番号の昇順 |

### 改ページ条件

N/A（連続テキスト出力）

## データベース参照仕様

N/A（データベースを使用しない。コンパイラ内部のcompile_logsを参照）

### 内部データ構造参照

| 参照項目 | 帳票項目との対応 | 取得条件 | 備考 |
|---------|----------------|---------|------|
| `zcu.compile_logs` | ログ一覧 | keys()でAnalUnit、values()でログ情報 | ハッシュマップ |
| `compile_log.first_line` | ログ行の先頭 | リンクリストで連結 | 複数行対応 |
| `compile_log.src()` | ソース位置 | LazySrcLoc形式 | 位置解決に使用 |

## 計算仕様

### 計算項目一覧

N/A（直接的な計算処理なし）

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[getAllErrorsAlloc呼び出し] --> B{compile_logs.count() > 0?}
    B -->|No| C[compile_log_text = ""]
    B -->|Yes| D{skip_analysis_this_update?}
    D -->|Yes| C
    D -->|No| E{他のエラーあり?}
    E -->|Yes| F[include_compile_log_sources = false]
    E -->|No| G[include_compile_log_sources = true]
    F --> H[参照解決]
    G --> H
    H --> I[参照されているログをフィルタ]
    I --> J{フィルタ後のログあり?}
    J -->|No| C
    J -->|Yes| K[ソース位置でソート]
    K --> L[appendCompileLogLines呼び出し]
    L --> M[ログ行をlog_textに追加]
    M --> N{include_compile_log_sources?}
    N -->|Yes| O[エラーメッセージ追加]
    N -->|No| P[ログテキストのみ]
    O --> Q[bundle.toOwnedBundle返却]
    P --> Q
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| @compileLog検出 | 他エラーがなく@compileLogが存在 | `found compile log statement` | @compileLogを削除 |
| 複数箇所 | 複数の@compileLog呼び出し | `also here`（note） | 各箇所を確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数十件（デバッグ用途のため） |
| 目標出力時間 | O(N log N)（ソート処理） |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- @compileLogはコンパイル時の値を出力するため、機密情報が含まれる可能性
- リリースビルド前に@compileLogを削除することを推奨

## 備考

- `@compileLog`は他のコンパイルエラーがない場合のみエラーとして報告される
- 参照されていないコードの`@compileLog`は出力されない
- 複数のAnalUnitからの出力がソート・統合される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

compile_logsの構造を理解することが前提となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Zcu.zig | `src/Zcu.zig` | `compile_logs`フィールド：AnalUnit→ログ情報のマップ |
| 1-2 | Compilation.zig | `src/Compilation.zig` | エラーバンドル生成でのcompile_logs参照 |

**読解のコツ**: `compile_logs`はAnalUnit（解析単位）をキーとし、ログ情報（first_line、src等）を値として持つ。

#### Step 2: エントリーポイントを理解する

コンパイルログ出力の起点を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Compilation.zig | `src/Compilation.zig` | `getAllErrorsAlloc`関数（行3951付近）：エラー収集のエントリーポイント |

**主要処理フロー**:
1. **行4206-4209**: compile_logs存在チェック
2. **行4213**: include_compile_log_sourcesの判定
3. **行4215**: 参照解決（resolveReferences）
4. **行4219**: compile_logsの走査
5. **行4257**: ソース位置でソート
6. **行4284**: compile_log_textの返却

#### Step 3: ログ行追加処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Compilation.zig | `src/Compilation.zig` | `appendCompileLogLines`関数（行4318付近）：ログ行の追加 |

**主要処理フロー**:
- **行4321**: first_lineからリンクリストを走査
- **行4322-4324**: 各行をlog_textに追加

#### Step 4: 参照解決を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Zcu.zig | `src/Zcu.zig` | `resolveReferences`：どのコードが実際に参照されているかを判定 |

### プログラム呼び出し階層図

```
getAllErrorsAlloc
    |
    +-- compile_logs.count()チェック
    |
    +-- resolveReferences
    |       +-- 参照グラフ構築
    |       +-- 到達可能性判定
    |
    +-- compile_logsフィルタリング
    |       +-- refs.contains(logging_unit)
    |
    +-- ソース位置ソート
    |       +-- SortContext.lessThan
    |
    +-- appendCompileLogLines（各ログに対して）
    |       +-- line.next走査
    |       +-- log_text.appendSlice
    |
    +-- addModuleErrorMsg（エラーメッセージ追加）
    |
    +-- bundle.toOwnedBundle
```

### データフロー図

```
[入力]                      [処理]                           [出力]

@compileLog呼び出し  ─────> Sema解析 ─────────────────────> compile_logs登録
                                |
                                v
compile_logs         ─────> getAllErrorsAlloc ────────────> ErrorBundle
  |                         |
  +-- AnalUnit       ─────> 参照チェック ─────────────────> フィルタ済みログ
  |                         |
  +-- first_line     ─────> appendCompileLogLines ────────> compile_log_text
        |
        +-- line.next ────> 行連結 ─────────────────────────> テキスト出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Compilation.zig | `src/Compilation.zig` | ソース | コンパイルログ収集・出力のメイン実装 |
| Zcu.zig | `src/Zcu.zig` | ソース | compile_logsデータ構造、参照解決 |
| Sema.zig | `src/Sema.zig` | ソース | @compileLog実行時のログ登録 |
| ErrorBundle | `lib/std/zig/ErrorBundle.zig` | ソース | エラー出力形式 |
