# 帳票設計書 8-エラーバンドル

## 概要

本ドキュメントは、Zigコンパイラにおけるエラーバンドル帳票の設計仕様を記述するものである。コンパイルエラーを構造化した形式で出力し、参照トレース・ソース位置情報を含む包括的なエラーレポートを提供する機能を定義する。

### 本帳票の処理概要

エラーバンドルは、Zigコンパイラが検出したすべてのコンパイルエラーを統合し、構造化された形式で出力するための帳票である。複数のエラーソース（Zigコード解析、Cオブジェクトコンパイル、Win32リソース、リンカなど）からのエラーを統一的に管理・出力する。

**業務上の目的・背景**：コンパイラのエラー報告は、開発者体験において最も重要な要素の一つである。エラーメッセージの質と量は、デバッグ効率に直接影響する。本帳票により、Zigコンパイラは複数のエラーを一貫した形式で報告でき、参照トレース機能により、エラーの根本原因を追跡しやすくなる。これにより、開発者は効率的にコードの問題を特定・修正できる。

**帳票の利用シーン**：
1. 通常のコンパイルエラー発生時
2. 型エラーやセマンティックエラーの報告
3. 参照トレースによるエラー原因追跡
4. 複数エラーの一括表示
5. IDE/エディタ統合でのエラー表示

**主要な出力内容**：
1. エラーメッセージ（メイン）
2. ソース位置（ファイル:行:列）
3. ソースコードスニペット
4. ノート（補足情報）
5. 参照トレース（エラーに至るまでの呼び出し履歴）
6. コンパイルログテキスト（@compileLog出力）

**帳票の出力タイミング**：コンパイル完了時、`getAllErrorsAlloc`関数により収集・出力される。

**帳票の利用者**：すべてのZigプログラマ、IDE/エディタ開発者

## 帳票種別

診断レポート / エラーレポート

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | コマンドライン | `zig build`, `zig build-exe` など | コンパイルエラー時に自動出力 |
| - | IDE統合 | LSP | エラー発生時に自動提供 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準エラー出力）またはErrorBundle構造体 |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（標準エラー出力） |
| 出力方法 | ErrorBundle.Wip → ErrorBundle変換 |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

エラーバンドルは複数のエラーメッセージを含み、各エラーは以下の構造を持つ。

```
┌─────────────────────────────────────────────────────────────┐
│ file.zig:line:col: error: エラーメッセージ                   │
├─────────────────────────────────────────────────────────────┤
│ [ソースコードスニペット]                                     │
│     const x = undefined_symbol;                             │
│               ^^^^^^^^^^^^^^^^                               │
├─────────────────────────────────────────────────────────────┤
│ note: 補足情報1                                              │
│ note: 補足情報2                                              │
├─────────────────────────────────────────────────────────────┤
│ referenced by:                                              │
│     呼び出し元1: file1.zig:10:5                              │
│     呼び出し元2: file2.zig:20:10                             │
└─────────────────────────────────────────────────────────────┘
```

### ヘッダー部

N/A（各エラーが独立したメッセージ）

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | ソース位置 | エラー発生箇所 | `src_loc` | `file:line:col` | 可変 |
| 2 | エラー種別 | error/note/warning | メッセージタイプ | 固定文字列 | 可変 |
| 3 | メッセージ | エラーの説明 | `msg` | テキスト | 可変 |
| 4 | ソーススニペット | 該当コード行 | ソースファイル | コード+下線 | 可変 |
| 5 | ノート | 補足情報 | `notes` | `note: ...` | 可変 |
| 6 | 参照トレース | 呼び出し履歴 | `reference_trace` | `referenced by: ...` | 可変 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | コンパイルログ | @compileLog出力 | `compile_log_text` | テキスト |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| エラー存在 | コンパイルエラーが1つ以上存在 | Yes |
| 参照トレース有効 | `-freference-trace`オプション有効時 | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | エラー発生順 | 発生順 |

### 改ページ条件

N/A（連続テキスト出力）

## データベース参照仕様

N/A（データベースを使用しない。コンパイラ内部のエラー情報を参照）

### 内部データ構造参照

| 参照項目 | 帳票項目との対応 | 取得条件 | 備考 |
|---------|----------------|---------|------|
| `failed_c_objects` | Cオブジェクトエラー | values()で走査 | Diag.Bundle形式 |
| `failed_win32_resources` | Win32リソースエラー | values()で走査 | ErrorBundle形式 |
| `link_diags` | リンカエラー | lld.items | LLDエラー |
| `zcu.compile_logs` | コンパイルログ | values()で走査 | @compileLog出力 |
| `misc_failures` | その他エラー | values()で走査 | MiscError形式 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| reference_trace_len | `comp.reference_trace orelse default_reference_trace_len` | なし | デフォルト2 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[getAllErrorsAlloc呼び出し] --> B[ErrorBundle.Wip初期化]
    B --> C[failed_c_objectsエラー追加]
    C --> D[failed_win32_resourcesエラー追加]
    D --> E[link_diagsエラー追加]
    E --> F[compile_log_text取得]
    F --> G{Zcuエラーあり?}
    G -->|Yes| H[Zcuエラー処理]
    G -->|No| I[終了処理]
    H --> J[ソート]
    J --> K[addModuleErrorMsg（各エラー）]
    K --> L[参照トレース追加]
    L --> M[ノート追加]
    M --> I
    I --> N[bundle.toOwnedBundle返却]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| OutOfMemory | バンドル構築中のメモリ不足 | なし | エラー返却 |
| ファイル読み込み失敗 | ソースファイルが読めない | 位置情報なしで出力 | 代替メッセージ表示 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数十件 |
| 目標出力時間 | O(N)（エラー数に比例） |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- エラーメッセージにソースコードのスニペットが含まれる
- 参照トレースにファイルパス情報が含まれる

## 備考

- ErrorBundle.Wipは構築中の一時構造体
- 参照トレースのデフォルト長は2（-freference-traceで変更可能）
- ノートの重複は自動的に排除される（ErrorNoteHashContextで管理）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ErrorBundleの構造を理解することが前提となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ErrorBundle.zig | `lib/std/zig/ErrorBundle.zig` | ErrorBundle構造体：エラーの格納形式 |
| 1-2 | Compilation.zig | `src/Compilation.zig` | `MiscError`構造体（行1451-1458）：その他エラー |
| 1-3 | Compilation.zig | `src/Compilation.zig` | `CObject.Diag.Bundle`：Cオブジェクトエラー |

**読解のコツ**: ErrorBundleは最終出力形式、ErrorBundle.Wipは構築用の一時形式。

#### Step 2: エントリーポイントを理解する

エラー収集の起点を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Compilation.zig | `src/Compilation.zig` | `getAllErrorsAlloc`関数（行3951付近）：エラー収集のエントリーポイント |

**主要処理フロー**:
1. **行3955-3956**: ErrorBundle.Wip初期化
2. **行3959-3960**: failed_c_objectsのエラー追加
3. **行3963-3964**: failed_win32_resourcesのエラー追加
4. **行3967**: link_diagsのエラー追加
5. **行4206-4314**: compile_log_text処理

#### Step 3: モジュールエラーメッセージ追加を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Compilation.zig | `src/Compilation.zig` | `addModuleErrorMsg`関数（行4385付近）：Zcuエラーの追加 |

**主要処理フロー**:
- **行4401-4402**: ソース位置の解決
- **行4404**: 参照トレースリストの初期化
- **行4483-4534**: ノートの重複排除と追加

#### Step 4: 参照トレースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Compilation.zig | `src/Compilation.zig` | `addReferenceTraceFrame`関数（行4535付近）：参照トレースフレームの追加 |

### プログラム呼び出し階層図

```
getAllErrorsAlloc
    |
    +-- ErrorBundle.Wip.init
    |
    +-- failed_c_objects走査
    |       +-- Diag.Bundle.addToErrorBundle
    |
    +-- failed_win32_resources走査
    |       +-- bundle.addBundleAsRoots
    |
    +-- link_diags.addMessagesToBundle
    |
    +-- compile_log_text取得
    |       +-- appendCompileLogLines
    |
    +-- Zcuエラー処理
    |       +-- ソート
    |       +-- addModuleErrorMsg（各エラー）
    |               +-- err_loc計算
    |               +-- 参照トレース構築
    |               +-- ノート追加
    |
    +-- bundle.toOwnedBundle
```

### データフロー図

```
[入力]                      [処理]                           [出力]

failed_c_objects     ─────> addToErrorBundle ─────────────> ErrorBundle.Wip
                                    |
failed_win32_resources ───> addBundleAsRoots ─────────────> ErrorBundle.Wip
                                    |
link_diags           ─────> addMessagesToBundle ──────────> ErrorBundle.Wip
                                    |
zcu.compile_logs     ─────> appendCompileLogLines ────────> compile_log_text
                                    |
zcu errors           ─────> addModuleErrorMsg ────────────> ErrorBundle.Wip
        |                          |
        +-- src_loc      ─────> findLineColumn ───────────> 位置情報
        +-- notes        ─────> 重複排除 ─────────────────> ノート
        +-- ref_trace    ─────> addReferenceTraceFrame ───> 参照トレース
                                    |
                                    v
                            toOwnedBundle ────────────────> ErrorBundle（最終）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Compilation.zig | `src/Compilation.zig` | ソース | エラーバンドル構築のメイン実装 |
| ErrorBundle.zig | `lib/std/zig/ErrorBundle.zig` | ソース | ErrorBundle構造体定義 |
| Zcu.zig | `src/Zcu.zig` | ソース | Zcuエラー情報 |
| link/Diags.zig | `src/link/Diags.zig` | ソース | リンカエラー |
