# 帳票設計書 9-リンカマップ

## 概要

本ドキュメントは、Zigコンパイラにおけるリンカマップ帳票の設計仕様を記述するものである。リンカの出力マップ情報を生成し、GCセクション・ICFセクションの出力も選択可能な機能を定義する。

### 本帳票の処理概要

リンカマップは、リンク処理の結果を詳細に出力するための帳票である。最終的な実行ファイルのメモリレイアウト、シンボル配置、セクション情報などを可視化し、リンク結果の検証やデバッグに活用される。

**業務上の目的・背景**：リンク処理は実行ファイル生成の最終段階であり、メモリレイアウトやシンボル解決の正確性がプログラムの動作に直接影響する。本帳票により、開発者はリンク結果を詳細に確認でき、サイズ最適化やメモリ配置の問題を特定できる。また、GC（Garbage Collection）やICF（Identical Code Folding）などの最適化の効果も確認可能である。

**帳票の利用シーン**：
1. 実行ファイルサイズの分析・最適化
2. シンボル配置の確認
3. GCされたセクションの確認
4. ICF（同一コード折りたたみ）の効果確認
5. リンクエラーのデバッグ
6. メモリレイアウトの検証

**主要な出力内容**：
1. セクション一覧とアドレス情報
2. シンボル一覧と配置先アドレス
3. GCされたセクション一覧（オプション）
4. ICFで折りたたまれたセクション一覧（オプション）
5. 入力ファイル情報

**帳票の出力タイミング**：`linker_print_map`オプション有効時、リンク完了時に出力される。

**帳票の利用者**：リンカ開発者、最適化エンジニア、組み込みシステム開発者

## 帳票種別

リンカレポート / ビルドレポート

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | コマンドライン | コンパイル時オプション | `-fprint-map`（または関連オプション） |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力またはファイル） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | コマンドラインオプションで指定 |
| 出力方法 | リンカからの直接出力 |
| 文字コード | UTF-8 |

### オプション

| オプション | 説明 | 必須 |
|-----------|------|-----|
| `linker_print_map` | マップ出力を有効化 | Yes |
| `linker_print_gc_sections` | GCセクション出力を有効化 | No |
| `linker_print_icf_sections` | ICFセクション出力を有効化 | No |

## 帳票レイアウト

### レイアウト概要

リンカマップは複数のセクションに分かれた詳細情報を出力する。

```
┌─────────────────────────────────────────────────────────────┐
│ [セクションヘッダー]                                         │
│ Sections:                                                   │
│ Address         Size         Align   Flags   Name           │
│ 0x00001000      0x00005000   16      R X     .text          │
│ 0x00006000      0x00001000   8       R       .rodata        │
├─────────────────────────────────────────────────────────────┤
│ [シンボル一覧]                                               │
│ Address         Size         Name                           │
│ 0x00001000      0x00000100   _start                         │
│ 0x00001100      0x00000200   main                           │
├─────────────────────────────────────────────────────────────┤
│ [GCセクション（オプション）]                                  │
│ Discarded sections:                                         │
│   .text.unused_function                                     │
├─────────────────────────────────────────────────────────────┤
│ [ICFセクション（オプション）]                                 │
│ Identical code folding:                                     │
│   .text.func_a -> .text.func_b                              │
└─────────────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | セクションテーブルヘッダー | "Sections:" | 固定文字列 | テキスト |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | アドレス | セクション/シンボルの配置アドレス | リンカ内部データ | `0x%08x` | 16 |
| 2 | サイズ | セクション/シンボルのサイズ | リンカ内部データ | `0x%08x` | 12 |
| 3 | アライメント | アライメント要件 | リンカ内部データ | 整数 | 8 |
| 4 | フラグ | セクションフラグ（R/W/X） | リンカ内部データ | 文字列 | 8 |
| 5 | 名前 | セクション/シンボル名 | リンカ内部データ | 文字列 | 可変 |

### フッター部

N/A

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| linker_print_map | マップ出力オプション有効 | Yes |
| リンク成功 | リンク処理が正常完了 | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | アドレス | 昇順 |

### 改ページ条件

N/A（連続テキスト出力）

## データベース参照仕様

N/A（データベースを使用しない。リンカ内部のデータ構造を参照）

### 内部データ構造参照

| 参照項目 | 帳票項目との対応 | 取得条件 | 備考 |
|---------|----------------|---------|------|
| セクションテーブル | セクション一覧 | 全セクション | アドレス、サイズ、フラグ |
| シンボルテーブル | シンボル一覧 | 全シンボル | 名前、アドレス、サイズ |
| GC情報 | GCセクション | print_gc_sections有効時 | 削除されたセクション |
| ICF情報 | ICFセクション | print_icf_sections有効時 | 折りたたまれたセクション |

## 計算仕様

N/A（リンカからの直接出力）

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[リンク処理開始] --> B{linker_print_map有効?}
    B -->|No| C[通常リンク処理のみ]
    B -->|Yes| D[リンク処理実行]
    D --> E{linker_print_gc_sections?}
    E -->|Yes| F[GCセクション情報収集]
    E -->|No| G{linker_print_icf_sections?}
    F --> G
    G -->|Yes| H[ICFセクション情報収集]
    G -->|No| I[マップ出力]
    H --> I
    I --> J[セクションテーブル出力]
    J --> K[シンボルテーブル出力]
    K --> L{GC情報あり?}
    L -->|Yes| M[GCセクション出力]
    L -->|No| N{ICF情報あり?}
    M --> N
    N -->|Yes| O[ICFセクション出力]
    N -->|No| P[終了]
    O --> P
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| リンクエラー | リンク処理失敗 | リンカエラーメッセージ | マップ出力なし |
| 書き込みエラー | 出力先書き込み失敗 | I/Oエラー | エラー返却 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数百〜数万セクション/シンボル |
| 目標出力時間 | O(N)（セクション/シンボル数に比例） |
| 同時出力数上限 | 1件 |

## セキュリティ考慮事項

- リンカマップにはシンボル名とアドレス情報が含まれる
- リバースエンジニアリングに有用な情報が含まれるため、リリースビルドでは無効化を検討

## 備考

- オプションは`Compilation.zig`で`linker_print_map`等として定義
- 実際の出力フォーマットはリンカバックエンド（ELF、COFF、MachO等）に依存
- GC/ICF出力は最適化効果の検証に有用

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: オプション定義を理解する

リンカマップ関連オプションの定義を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Compilation.zig | `src/Compilation.zig` | `linker_print_map`オプション（行1723付近） |
| 1-2 | Compilation.zig | `src/Compilation.zig` | `linker_print_gc_sections`オプション（行1721付近） |
| 1-3 | Compilation.zig | `src/Compilation.zig` | `linker_print_icf_sections`オプション（行1722付近） |

**読解のコツ**: これらのオプションは`create`関数の引数として受け取られ、リンカに渡される。

#### Step 2: オプション伝播を理解する

オプションがリンカに渡される流れを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Compilation.zig | `src/Compilation.zig` | リンカオプション設定（行2377-2380付近） |

**主要処理フロー**:
1. `linker_print_gc_sections` → `.print_gc_sections`
2. `linker_print_icf_sections` → `.print_icf_sections`
3. `linker_print_map` → `.print_map`

#### Step 3: リンカ実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | link.zig | `src/link.zig` | リンカインターフェース |
| 3-2 | Elf.zig | `src/link/Elf.zig` | ELFリンカでのマップ出力（実装詳細） |

**読解のコツ**: 実際のマップ出力フォーマットはリンカバックエンドごとに異なる。

### プログラム呼び出し階層図

```
Compilation.create
    |
    +-- オプション解析
    |       +-- linker_print_map
    |       +-- linker_print_gc_sections
    |       +-- linker_print_icf_sections
    |
    +-- リンカ初期化
            |
            +-- オプション設定
            |       +-- .print_map = options.linker_print_map
            |       +-- .print_gc_sections = options.linker_print_gc_sections
            |       +-- .print_icf_sections = options.linker_print_icf_sections
            |
            +-- リンク実行時
                    +-- セクション情報収集
                    +-- シンボル情報収集
                    +-- [GC有効時] GC情報収集
                    +-- [ICF有効時] ICF情報収集
                    +-- マップ出力
```

### データフロー図

```
[入力]                      [処理]                           [出力]

コマンドラインオプション ─> Compilation.create ────────────> リンカオプション
                                |
オブジェクトファイル   ─────> リンカ ──────────────────────> 実行ファイル
                                |
                                +-- セクション解析 ──────────> セクションテーブル
                                +-- シンボル解決 ───────────> シンボルテーブル
                                +-- [GC] 未使用セクション削除 > GCセクション一覧
                                +-- [ICF] 同一コード検出 ────> ICFセクション一覧
                                |
                                v
                           マップ出力 ───────────────────────> リンカマップ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Compilation.zig | `src/Compilation.zig` | ソース | オプション定義・伝播 |
| link.zig | `src/link.zig` | ソース | リンカインターフェース |
| Elf.zig | `src/link/Elf.zig` | ソース | ELFリンカ実装 |
| MachO.zig | `src/link/MachO.zig` | ソース | Mach-Oリンカ実装 |
| Coff.zig | `src/link/Coff.zig` | ソース | COFFリンカ実装 |
