---
generated_at: 2026-02-01 17:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：1-クラッシュレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **C-18**: 64KBヒープサイズの妥当性確認（根拠はあるが設計意図の確認推奨）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/crash_report.zig` 行3-6（panic定数定義）
- E-02: `src/crash_report.zig` 行20-24（handleSegfaultImpl関数）
- E-03: `src/crash_report.zig` 行25-29（panicImpl関数）
- E-04: `src/crash_report.zig` 行31-64（AnalyzeBody構造体）
- E-05: `src/crash_report.zig` 行66-83（CodegenFunc構造体）
- E-06: `src/crash_report.zig` 行85-113（dumpCrashContext関数）
- E-07: `src/crash_report.zig` 行86-94（already_dumped処理）
- E-08: `src/crash_report.zig` 行91（crash_heap定義: 64*1024バイト）
- E-09: `src/crash_report.zig` 行102（"Compiler crash context:" 出力）
- E-10: `src/crash_report.zig` 行107（関数名出力フォーマット）
- E-11: `src/crash_report.zig` 行114-176（dumpCrashContextSema関数）
- E-12: `src/crash_report.zig` 行129-140（ZIR出力処理）
- E-13: `src/crash_report.zig` 行138（OutOfMemoryエラーメッセージ）
- E-14: `src/crash_report.zig` 行141-146（デバッグコマンド提案）
- E-15: `src/crash_report.zig` 行148-173（親ブロック処理）
- E-16: `src/print_zir.zig` 行53-84（renderInstructionContext関数）
- E-17: `src/print_zir.zig` 行86-110（renderSingleInstruction関数）
- E-18: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行2（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パニック発生時にdumpCrashContextが呼び出される | E-03 | ○ |
| C-02 | セグフォルト発生時にdumpCrashContextが呼び出される | E-02 | ○ |
| C-03 | "Compiler crash context:"がヘッダーとして出力される | E-09 | ○ |
| C-04 | CodegenFunc.currentが非nullの場合、関数名が出力される | E-06, E-10 | ○ |
| C-05 | AnalyzeBody.currentが非nullの場合、dumpCrashContextSemaが呼び出される | E-06 | ○ |
| C-06 | already_dumpedフラグで再帰的パニックを防止 | E-07 | ○ |
| C-07 | 64KBの固定バッファをZIRダンプに使用 | E-08 | ○ |
| C-08 | メモリ不足時に"<out of memory dumping zir>"が出力される | E-13 | ○ |
| C-09 | デバッグコマンド"zig ast-check -t"が提案される | E-14 | ○ |
| C-10 | 親ブロック情報が再帰的に出力される | E-15 | ○ |
| C-11 | AnalyzeBody構造体はスレッドローカルで管理される | E-04 | ○ |
| C-12 | CodegenFunc構造体はスレッドローカルで管理される | E-05 | ○ |
| C-13 | build_options.enable_debug_extensionsで機能が制御される | E-04, E-05 | ○ |
| C-14 | print_zir.renderInstructionContextがZIR出力に使用される | E-12, E-16 | ○ |
| C-15 | print_zir.renderSingleInstructionが単一命令出力に使用される | E-15, E-17 | ○ |
| C-16 | stderrへの直接書き込みで出力される | E-06 | ○ |
| C-17 | ロスト命令の場合、警告メッセージが出力される | E-11, E-15 | ○ |
| C-18 | 64KBのヒープサイズが適切である | E-08 | △ |

## 4) 不足情報（Unknown / Missing）

- C-18について：64KBという値の設計根拠（なぜこの値が選ばれたか）はコード中のTODOコメントで言及されているが、具体的な設計意図は不明
  - 候補：設計ドキュメント / コミット履歴 / 開発者へのヒアリング

## 5) リスクフラグ（レビュー観点）

- リスク0（低）：全体的に信頼度が高く、主要な主張はすべてソースコードで裏付けられている
- リスク1（中）：64KBヒープサイズの妥当性については、実際の使用状況との照合を推奨

## 6) レビュアーチェックリスト（最小）

- [ ] パニック/セグフォルトハンドラの呼び出しフローが正確か確認
- [ ] ZIR出力フォーマットが実際の出力と一致するか確認
- [ ] 64KBヒープサイズが実際の使用ケースで十分か確認
- [ ] スレッドセーフティの記述が正確か確認
