---
generated_at: 2026-02-01 17:44:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：10-InternPoolダンプ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **C-15**: dumpAllFallible関数の詳細実装

## 2) 参照した情報（Evidence一覧）

- E-01: `src/InternPool.zig` 行11192-11199（dump関数）
- E-02: `src/InternPool.zig` 行11193（4096バイトバッファ）
- E-03: `src/InternPool.zig` 行11197（dumpStatsFallible呼び出し）
- E-04: `src/InternPool.zig` 行11198（dumpAllFallible呼び出し）
- E-05: `src/InternPool.zig` 行11201-11231（dumpStatsFallible関数開始部）
- E-06: `src/InternPool.zig` 行11202-11208（locals走査）
- E-07: `src/InternPool.zig` 行11210-11215（サイズ計算）
- E-08: `src/InternPool.zig` 行11217-11231（統計ヘッダー出力フォーマット）
- E-09: `src/InternPool.zig` 行11233-11237（TagStats構造体）
- E-10: `src/InternPool.zig` 行11249-11400+（タグ別バイト数計算switch文）
- E-11: `src/InternPool.zig` 行11214（TODOコメント：map overhead）
- E-12: `src/Compilation.zig` 行177（verbose_intern_pool定義）
- E-13: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行11（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | dump関数がエントリーポイントである | E-01 | ○ |
| C-02 | 4096バイトバッファが使用される | E-02 | ○ |
| C-03 | dumpStatsFallibleが統計出力を行う | E-03, E-05 | ○ |
| C-04 | dumpAllFallibleが詳細ダンプを行う | E-04 | ○ |
| C-05 | locals走査でitems/extra/limbs長を集計する | E-06 | ○ |
| C-06 | items_sizeは(1+4)*items_lenで計算される | E-07 | ○ |
| C-07 | extra_sizeは4*extra_lenで計算される | E-07 | ○ |
| C-08 | limbs_sizeは8*limbs_lenで計算される | E-07 | ○ |
| C-09 | 統計ヘッダーにInternPool size、items、extra、limbsが出力される | E-08 | ○ |
| C-10 | TagStats構造体でタグ別カウント・バイト数を管理する | E-09 | ○ |
| C-11 | タグごとに固有のバイト数計算が行われる | E-10 | ○ |
| C-12 | マップオーバーヘッドは計算に含まれない（TODO） | E-11 | ○ |
| C-13 | verbose_intern_poolオプションがCompilation.zigで定義されている | E-12 | ○ |
| C-14 | エラー時はcatch returnで静かに終了する | E-01 | ○ |
| C-15 | dumpAllFallibleの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- C-15について：dumpAllFallible関数の詳細実装（全エントリダンプの具体的処理）が未確認
  - 候補：`src/InternPool.zig`のdumpAllFallible関数実装部分

## 5) リスクフラグ（レビュー観点）

- リスク0（低）：統計ダンプ部分（dumpStatsFallible）は明確に確認できる
- リスク1（中）：詳細ダンプ部分（dumpAllFallible）は追加確認を推奨

## 6) レビュアーチェックリスト（最小）

- [ ] dumpAllFallible関数の実装詳細を確認
- [ ] タグ別バイト数計算の全ケースを確認
- [ ] verbose_intern_poolオプションの有効化方法を確認
- [ ] 出力フォーマットが実際と一致するか確認
