---
generated_at: 2026-02-01 17:36:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：2-ZIRデバッグ出力

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **C-15**: `zig ast-check -t`コマンドの実行パス確認（ソースコード未確認）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/print_zir.zig` 行13-51（renderAsText関数）
- E-02: `src/print_zir.zig` 行53-84（renderInstructionContext関数）
- E-03: `src/print_zir.zig` 行86-110（renderSingleInstruction関数）
- E-04: `src/print_zir.zig` 行112-121（Writer構造体）
- E-05: `src/print_zir.zig` 行126-177（line_col_cursor実装）
- E-06: `src/print_zir.zig` 行181-500+（writeInstToStream関数）
- E-07: `src/print_zir.zig` 行28-31（メイン構造体命令出力）
- E-08: `src/print_zir.zig` 行32-50（インポート情報出力）
- E-09: `src/print_zir.zig` 行17-26（Writer初期化）
- E-10: `src/crash_report.zig` 行129-146（クラッシュ時ZIR出力呼び出し）
- E-11: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行3（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | renderAsTextが完全なZIRダンプのエントリーポイントである | E-01 | ○ |
| C-02 | renderInstructionContextがコンテキスト限定ダンプに使用される | E-02 | ○ |
| C-03 | renderSingleInstructionが単一命令出力に使用される | E-03 | ○ |
| C-04 | Writer構造体が出力状態を管理する | E-04 | ○ |
| C-05 | line_col_cursorでソース位置解決が最適化されている | E-05 | ○ |
| C-06 | メイン構造体命令（main_struct_inst）が最初に出力される | E-07 | ○ |
| C-07 | インポート情報が"Imports:"セクションで出力される | E-08 | ○ |
| C-08 | 命令タグに応じてwriteInstToStreamで分岐処理される | E-06 | ○ |
| C-09 | recurse_declsとrecurse_blocksで出力範囲を制御できる | E-09 | ○ |
| C-10 | クラッシュレポート生成時にZIR出力が呼び出される | E-10 | ○ |
| C-11 | Arena Allocatorで一括メモリ管理される | E-01 | ○ |
| C-12 | 命令番号は"%N"形式で出力される | E-07 | ○ |
| C-13 | ソース位置は行:列形式で出力される | E-05 | ○ |
| C-14 | ブロック命令は再帰的に処理される | E-06 | ○ |
| C-15 | `zig ast-check -t`コマンドでZIRダンプが出力される | E-11 | △ |

## 4) 不足情報（Unknown / Missing）

- C-15について：`zig ast-check -t`コマンドの実装箇所（main.zigまたはdriver）の直接確認が未完了
  - 候補：`src/main.zig` / `zig build`のドライバ実装 / ドキュメント

## 5) リスクフラグ（レビュー観点）

- リスク0（低）：コア機能の実装は明確にソースコードで確認できる
- リスク1（中）：コマンドラインインターフェースの詳細は追加確認を推奨

## 6) レビュアーチェックリスト（最小）

- [ ] renderAsText/renderInstructionContext/renderSingleInstructionの使い分けが正確か確認
- [ ] line_col_cursorの最適化効果（O(N)）が実際に有効か確認
- [ ] `zig ast-check -t`コマンドの実装パスを確認
- [ ] 出力フォーマットが実際の出力と一致するか確認
