---
generated_at: 2026-02-01 17:37:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：3-AIRデバッグ出力

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **C-16**: verbose_airオプションの有効化方法の詳細確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Air/print.zig` 行12-54（write関数）
- E-02: `src/Air/print.zig` 行56-73（writeInst関数）
- E-03: `src/Air/print.zig` 行75-83（dump関数）
- E-04: `src/Air/print.zig` 行95-101（Writer構造体）
- E-05: `src/Air/print.zig` 行105-110（writeBody関数）
- E-06: `src/Air/print.zig` 行112-352（writeInst命令分岐）
- E-07: `src/Air/print.zig` 行13（enable_debug_extensions確認）
- E-08: `src/Air/print.zig` 行14-24（メモリ使用量計算）
- E-09: `src/Air/print.zig` 行27-42（統計ヘッダー出力フォーマット）
- E-10: `src/Air/print.zig` 行115-118（未使用マーク出力）
- E-11: `src/Air/print.zig` 行395-434（writeBlock関数）
- E-12: `src/Air/print.zig` 行354-359（writeBinOp関数）
- E-13: `src/Compilation.zig` 行176（verbose_air定義）
- E-14: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行4（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | write関数がAIRダンプのエントリーポイントである | E-01 | ○ |
| C-02 | writeInst関数が単一命令出力に使用される | E-02 | ○ |
| C-03 | dump関数がstderr直接出力のヘルパーである | E-03 | ○ |
| C-04 | 統計情報がヘッダーとして出力される | E-09 | ○ |
| C-05 | 命令数・メモリ使用量が計算・出力される | E-08 | ○ |
| C-06 | Liveness情報がオプションで出力される | E-01, E-10 | ○ |
| C-07 | 未使用命令に"!"マークが付与される | E-10 | ○ |
| C-08 | enable_debug_extensionsでビルド時チェックされる | E-07 | ○ |
| C-09 | ブロック命令が再帰的に処理される | E-11 | ○ |
| C-10 | Writer構造体が出力状態を管理する | E-04 | ○ |
| C-11 | skip_bodyフラグでブロック内容スキップ可能 | E-04 | ○ |
| C-12 | 命令タグに応じてswitch文で分岐処理される | E-06 | ○ |
| C-13 | tomb_bitsでLivenessのブロック終端情報が出力される | E-11 | ○ |
| C-14 | 二項演算はwriteBinOpで出力される | E-12 | ○ |
| C-15 | verbose_airオプションがCompilation.zigで定義されている | E-13 | ○ |
| C-16 | verbose_airオプションの有効化方法 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- C-16について：verbose_airオプションをコマンドラインから有効化する具体的な方法（フラグ名など）が未確認
  - 候補：`src/main.zig` / ビルドシステムのオプション定義 / ドキュメント

## 5) リスクフラグ（レビュー観点）

- リスク0（低）：コア機能の実装は明確にソースコードで確認できる
- リスク1（中）：ユーザー向けオプションの詳細は追加確認を推奨

## 6) レビュアーチェックリスト（最小）

- [ ] write/writeInst/dumpの使い分けが正確か確認
- [ ] 統計情報の計算式が実装と一致するか確認
- [ ] Liveness情報の出力フォーマットが実際と一致するか確認
- [ ] verbose_airオプションの有効化コマンドを確認
