---
generated_at: 2026-02-01 17:38:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-ZOIRデバッグ出力

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/print_zoir.zig` 行1-2（Error型定義）
- E-02: `src/print_zoir.zig` 行3-43（renderToWriter関数）
- E-03: `src/print_zoir.zig` 行4（hasCompileErrorsアサーション）
- E-04: `src/print_zoir.zig` 行6-12（bytes_per_node計算）
- E-05: `src/print_zoir.zig` 行14-17（サイズ計算）
- E-06: `src/print_zoir.zig` 行19-33（統計ヘッダー出力）
- E-07: `src/print_zoir.zig` 行45-50（PrintZon構造体）
- E-08: `src/print_zoir.zig` 行51-54（renderRoot関数）
- E-09: `src/print_zoir.zig` 行56-104（renderNode関数）
- E-10: `src/print_zoir.zig` 行66-71（int_literal出力）
- E-11: `src/print_zoir.zig` 行78-89（array_literal出力）
- E-12: `src/print_zoir.zig` 行90-102（struct_literal出力）
- E-13: `src/print_zoir.zig` 行106-109（newline関数）
- E-14: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行5（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | renderToWriterがエントリーポイントである | E-02 | ○ |
| C-02 | hasCompileErrors()がtrueの場合assertで失敗する | E-03 | ○ |
| C-03 | bytes_per_nodeがcomptimeで計算される | E-04 | ○ |
| C-04 | 統計ヘッダーがノード数・バイト数を含む | E-06 | ○ |
| C-05 | PrintZon構造体が出力状態を管理する | E-07 | ○ |
| C-06 | renderRootがルートノードから出力を開始する | E-08 | ○ |
| C-07 | renderNodeがノードタイプに応じて分岐する | E-09 | ○ |
| C-08 | 大整数はtoStringAllocで10進数変換される | E-10 | ○ |
| C-09 | 配列リテラルは要素を再帰的に出力する | E-11 | ○ |
| C-10 | 構造体リテラルはフィールドを再帰的に出力する | E-12 | ○ |
| C-11 | newline関数がインデント付き改行を出力する | E-13 | ○ |
| C-12 | Error型はWriteFailedとOutOfMemoryを含む | E-01 | ○ |
| C-13 | arenaアロケータが一時メモリに使用される | E-07 | ○ |
| C-14 | indentフィールドでインデントレベルを管理する | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- リスク0（低）：全主張がソースコードで明確に裏付けられている
- print_zoir.zigは117行と小規模なため、全体の把握が容易

## 6) レビュアーチェックリスト（最小）

- [ ] 統計ヘッダーの出力フォーマットが実際と一致するか確認
- [ ] 各ノードタイプの出力形式が正確か確認
- [ ] hasCompileErrors()の事前チェックが適切に行われているか確認
