---
generated_at: 2026-02-01 17:39:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-カバレッジレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `tools/dump-cov.zig` 行1-9（インポート）
- E-02: `tools/dump-cov.zig` 行11-98（main関数）
- E-03: `tools/dump-cov.zig` 行16-24（引数解析・使用方法）
- E-04: `tools/dump-cov.zig` 行27-29（ターゲット解決）
- E-05: `tools/dump-cov.zig` 行46-49（デバッグ情報ロード）
- E-06: `tools/dump-cov.zig` 行51-60（カバレッジファイル読み込み）
- E-07: `tools/dump-cov.zig` 行62-64（stdout準備、4000バイトバッファ）
- E-08: `tools/dump-cov.zig` 行66-68（SeenPcsHeader出力）
- E-09: `tools/dump-cov.zig` 行70-76（PCインデックス・ソート）
- E-10: `tools/dump-cov.zig` 行78-79（ソース位置解決）
- E-11: `tools/dump-cov.zig` 行83-96（出力ループ）
- E-12: `tools/dump-cov.zig` 行84-86（invalid出力）
- E-13: `tools/dump-cov.zig` 行92（ヒット判定）
- E-14: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行6（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | main関数がエントリーポイントである | E-02 | ○ |
| C-02 | 引数が2-3個でない場合、使用方法が表示される | E-03 | ○ |
| C-03 | ターゲット省略時は"native"が使用される | E-03, E-04 | ○ |
| C-04 | デバッグ情報がInfo.loadでロードされる | E-05 | ○ |
| C-05 | カバレッジファイルがreadFileAllocOptionsで読み込まれる | E-06 | ○ |
| C-06 | stdoutに4000バイトバッファが使用される | E-07 | ○ |
| C-07 | SeenPcsHeaderが最初に出力される | E-08 | ○ |
| C-08 | PCがソートされて出力される | E-09 | ○ |
| C-09 | resolveAddressesでソース位置が解決される | E-10 | ○ |
| C-10 | 無効なソース位置は"invalid"と出力される | E-12 | ○ |
| C-11 | ヒット判定はビットマップから抽出される | E-13 | ○ |
| C-12 | ヒットは"+"、未ヒットは"-"で表示される | E-11 | ○ |
| C-13 | 出力形式は"マーク+PC: ディレクトリ/ファイル:行:列" | E-11 | ○ |
| C-14 | エラー時はfatal()で終了する | E-05, E-06 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- リスク0（低）：全主張がソースコードで明確に裏付けられている
- dump-cov.zigは99行と小規模なため、全体の把握が容易

## 6) レビュアーチェックリスト（最小）

- [ ] コマンドライン引数の解析が正確か確認
- [ ] SeenPcsHeader構造体の形式が標準ライブラリと一致するか確認
- [ ] ヒット判定のビット演算が正確か確認
- [ ] 出力フォーマットが実際と一致するか確認
