---
generated_at: 2026-02-01 17:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：6-HTMLドキュメント

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **C-16**: genHtml関数の詳細実装（ファイルが大きく全体読み込み未完了）

## 2) 参照した情報（Evidence一覧）

- E-01: `tools/docgen.zig` 行20-29（usage文字列）
- E-02: `tools/docgen.zig` 行31-87（main関数）
- E-03: `tools/docgen.zig` 行89-103（Token構造体）
- E-04: `tools/docgen.zig` 行105-243（Tokenizer構造体）
- E-05: `tools/docgen.zig` 行128-211（Tokenizer.next関数）
- E-06: `tools/docgen.zig` 行245-267（parseError関数）
- E-07: `tools/docgen.zig` 行281-285（HeaderOpen構造体）
- E-08: `tools/docgen.zig` 行303-314（SyntaxBlock構造体）
- E-09: `tools/docgen.zig` 行316-328（Node共用体）
- E-10: `tools/docgen.zig` 行329-333（Toc構造体）
- E-11: `tools/docgen.zig` 行340-500+（genToc関数）
- E-12: `tools/docgen.zig` 行16（max_doc_file_size = 10MB）
- E-13: `tools/docgen.zig` 行73-74（4096バイト出力バッファ）
- E-14: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行7（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | main関数がエントリーポイントである | E-02 | ○ |
| C-02 | --code-dirオプションが必須である | E-01, E-02 | ○ |
| C-03 | -h/--helpでヘルプが表示される | E-01, E-02 | ○ |
| C-04 | Token構造体がトークン種別を定義する | E-03 | ○ |
| C-05 | Tokenizerが状態機械でトークン化を行う | E-04, E-05 | ○ |
| C-06 | {#tag\|param#}形式のテンプレート構文を処理する | E-05 | ○ |
| C-07 | parseErrorがエラー位置を表示する | E-06 | ○ |
| C-08 | HeaderOpen構造体がセクション情報を保持する | E-07 | ○ |
| C-09 | SyntaxBlock構造体がコードブロック情報を保持する | E-08 | ○ |
| C-10 | Node共用体がパース結果を表現する | E-09 | ○ |
| C-11 | Toc構造体が目次データを保持する | E-10 | ○ |
| C-12 | genTocが目次生成とパースを行う | E-11 | ○ |
| C-13 | 最大入力ファイルサイズは10MBである | E-12 | ○ |
| C-14 | 出力バッファは4096バイトである | E-13 | ○ |
| C-15 | header_open/closeのバランスがチェックされる | E-11 | ○ |
| C-16 | genHtml関数がHTML出力を行う | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）

- C-16について：genHtml関数の詳細実装がファイルサイズ制限により完全に確認できていない
  - 候補：`tools/docgen.zig`の残り部分の確認

## 5) リスクフラグ（レビュー観点）

- リスク0（低）：テンプレート解析・目次生成部分は明確に確認できる
- リスク1（中）：HTML出力部分の詳細実装は追加確認を推奨

## 6) レビュアーチェックリスト（最小）

- [ ] テンプレート構文のすべてのタグが正確に記載されているか確認
- [ ] genHtml関数の実装詳細を確認
- [ ] 出力されるHTMLの構造が実際と一致するか確認
- [ ] エラー処理が網羅されているか確認
