---
generated_at: 2026-02-01 17:41:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：7-コンパイルログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **C-14**: Sema.zigでの@compileLog登録処理の詳細確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Compilation.zig` 行4206-4209（compile_log_text取得開始）
- E-02: `src/Compilation.zig` 行4213（include_compile_log_sources判定）
- E-03: `src/Compilation.zig` 行4215（resolveReferences呼び出し）
- E-04: `src/Compilation.zig` 行4219（compile_logs走査）
- E-05: `src/Compilation.zig` 行4220（refs.contains判定）
- E-06: `src/Compilation.zig` 行4222（src_loc取得）
- E-07: `src/Compilation.zig` 行4257（ソート処理）
- E-08: `src/Compilation.zig` 行4280-4282（include_compile_log_sources判定）
- E-09: `src/Compilation.zig` 行4284（compile_log_text返却）
- E-10: `src/Compilation.zig` 行4314（bundle.toOwnedBundle）
- E-11: `src/Compilation.zig` 行4318-4324（appendCompileLogLines関数）
- E-12: `src/Compilation.zig` 行4321（first_line走査）
- E-13: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行8（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getAllErrorsAllocがエントリーポイントである | E-01 | ○ |
| C-02 | compile_logs.count()でログ存在をチェックする | E-01 | ○ |
| C-03 | 他エラーがない場合のみinclude_compile_log_sourcesがtrue | E-02, E-08 | ○ |
| C-04 | resolveReferencesで参照解決を行う | E-03 | ○ |
| C-05 | 参照されていないログは除外される | E-05 | ○ |
| C-06 | ソース位置でソートされる | E-07 | ○ |
| C-07 | appendCompileLogLinesでログ行が追加される | E-11 | ○ |
| C-08 | first_lineからリンクリストを走査する | E-12 | ○ |
| C-09 | compile_log_textがbundle.toOwnedBundleに渡される | E-10 | ○ |
| C-10 | src()でソース位置を取得する | E-06 | ○ |
| C-11 | include_compile_log_sourcesがfalseならエラーメッセージなし | E-08 | ○ |
| C-12 | skip_analysis_this_updateで早期リターン | E-01 | ○ |
| C-13 | 複数のAnalUnitからのログが統合される | E-04 | ○ |
| C-14 | Sema.zigで@compileLog実行時にログ登録される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- C-14について：Sema.zigでの@compileLog登録処理の詳細実装が未確認
  - 候補：`src/Sema.zig`の@compileLog関連コード

## 5) リスクフラグ（レビュー観点）

- リスク0（低）：Compilation.zigでの処理フローは明確に確認できる
- リスク1（中）：ログ登録側（Sema.zig）の詳細は追加確認を推奨

## 6) レビュアーチェックリスト（最小）

- [ ] compile_logsのデータ構造がZcu.zigで正確に定義されているか確認
- [ ] Sema.zigでの@compileLog登録処理を確認
- [ ] ソート処理の比較関数が正確か確認
- [ ] 参照解決のロジックが正確か確認
