---
generated_at: 2026-02-01 17:43:00
metrics:
  claims_total: 12
  claims_with_evidence: 10
  claims_without_evidence: 2
confidence_derived: 0.83
---

# 根拠レポート：9-リンカマップ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：10 / 12、根拠なし：2
- 優先レビュー（高）
  1. **C-11**: 出力フォーマットの詳細（リンカバックエンド実装未確認）
  2. **C-12**: コマンドラインオプション名の正確な形式

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Compilation.zig` 行1721（linker_print_gc_sections定義）
- E-02: `src/Compilation.zig` 行1722（linker_print_icf_sections定義）
- E-03: `src/Compilation.zig` 行1723（linker_print_map定義）
- E-04: `src/Compilation.zig` 行2378（print_gc_sections設定）
- E-05: `src/Compilation.zig` 行2379（print_icf_sections設定）
- E-06: `src/Compilation.zig` 行2380（print_map設定）
- E-07: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行10（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | linker_print_mapオプションでマップ出力を有効化できる | E-03 | ○ |
| C-02 | linker_print_gc_sectionsオプションでGCセクション出力を有効化できる | E-01 | ○ |
| C-03 | linker_print_icf_sectionsオプションでICFセクション出力を有効化できる | E-02 | ○ |
| C-04 | オプションはリンカに.print_mapとして渡される | E-06 | ○ |
| C-05 | オプションはリンカに.print_gc_sectionsとして渡される | E-04 | ○ |
| C-06 | オプションはリンカに.print_icf_sectionsとして渡される | E-05 | ○ |
| C-07 | セクションテーブルにはアドレス、サイズ、フラグ、名前が含まれる | E-07 | ○ |
| C-08 | シンボルテーブルには名前、アドレス、サイズが含まれる | E-07 | ○ |
| C-09 | GCセクションは削除されたセクションの一覧を示す | E-07 | ○ |
| C-10 | ICFセクションは折りたたまれたセクションの一覧を示す | E-07 | ○ |
| C-11 | 出力フォーマットはリンカバックエンド固有である | **根拠なし** | △ |
| C-12 | コマンドラインオプションは`-fprint-map`形式である | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- C-11について：リンカバックエンド（Elf.zig、MachO.zig等）でのマップ出力実装詳細が未確認
  - 候補：`src/link/Elf.zig`、`src/link/MachO.zig`の読み込み
- C-12について：コマンドラインからの有効化方法の詳細が未確認
  - 候補：`src/main.zig`またはビルドシステムのオプション解析部分

## 5) リスクフラグ（レビュー観点）

- リスク1（中）：オプション定義と伝播は確認できるが、実際の出力フォーマットは追加確認が必要
- リスク1（中）：コマンドラインインターフェースの詳細は追加確認を推奨

## 6) レビュアーチェックリスト（最小）

- [ ] リンカバックエンド（Elf.zig等）でのマップ出力実装を確認
- [ ] コマンドラインオプションの正確な形式を確認
- [ ] 出力フォーマットの各バックエンドでの違いを確認
- [ ] GC/ICF情報の具体的な出力内容を確認
