---
generated_at: 2026-02-01 17:50:00
metrics:
  claims_total: 50
  claims_with_evidence: 48
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：業務要件一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：48 / 50、根拠なし：2
- 優先レビュー（高）
  1. **BR-024 バグ最小化**：reduce機能の詳細仕様が不明
  2. **BR-049 LLVM IR出力**：LLVM連携の詳細条件

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/main.zig:77-133` - CLIコマンド定義（usage文字列）
- E-02: `src/main.zig:259-393` - コマンドディスパッチ処理
- E-03: `build.zig:1-200` - ビルドシステム設定
- E-04: `src/Compilation.zig:1-200` - コンパイルパイプライン
- E-05: `src/Sema.zig:1-100` - セマンティック解析
- E-06: `src/codegen.zig:1-100` - コード生成モジュール
- E-07: `src/codegen/llvm.zig` - LLVMバックエンド
- E-08: `src/codegen/x86_64/` - x86_64バックエンド
- E-09: `src/codegen/aarch64.zig` - AArch64バックエンド
- E-10: `src/codegen/riscv64/` - RISC-Vバックエンド
- E-11: `src/codegen/wasm/` - WebAssemblyバックエンド
- E-12: `src/codegen/c.zig` - Cバックエンド
- E-13: `src/codegen/spirv/` - SPIR-Vバックエンド
- E-14: `src/link/Elf.zig` - ELFリンカ
- E-15: `src/link/MachO.zig` - Mach-Oリンカ
- E-16: `src/link/Coff.zig` - COFFリンカ
- E-17: `src/link/Wasm.zig` - WebAssemblyリンカ
- E-18: `src/link/SpirV.zig` - SPIR-Vリンカ
- E-19: `src/fmt.zig` - フォーマッタ
- E-20: `src/libs/glibc.zig` - glibc連携
- E-21: `src/libs/musl.zig` - musl連携
- E-22: `src/libs/mingw.zig` - MinGW連携
- E-23: `README.md` - プロジェクト概要
- E-24: `build.zig:395-500` - コンパイルオプション定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BR-001 Zigソースコードのコンパイル | E-01, E-02 | ○ |
| C-02 | BR-002 実行形式ファイルの生成 | E-01, E-02 | ○ |
| C-03 | BR-003 ライブラリファイルの生成 | E-01, E-02 | ○ |
| C-04 | BR-004 オブジェクトファイルの生成 | E-01, E-02 | ○ |
| C-05 | BR-005 ユニットテストの実行 | E-01, E-02 | ○ |
| C-06 | BR-006 テストオブジェクトの生成 | E-01, E-02 | ○ |
| C-07 | BR-007 即時実行 | E-01, E-02 | ○ |
| C-08 | BR-008 プロジェクトビルド | E-01, E-02, E-03 | ○ |
| C-09 | BR-009 パッケージフェッチ | E-01, E-02 | ○ |
| C-10 | BR-010 プロジェクト初期化 | E-01, E-02 | ○ |
| C-11 | BR-011 構文チェック | E-01, E-02 | ○ |
| C-12 | BR-012 コードフォーマット | E-01, E-02, E-19 | ○ |
| C-13 | BR-013 C言語からの変換 | E-01, E-02 | ○ |
| C-14 | BR-014 Cコンパイラとしての利用 | E-01, E-02 | ○ |
| C-15 | BR-015 アーカイバ機能 | E-01, E-02 | ○ |
| C-16 | BR-016 オブジェクトコピー | E-01, E-02 | ○ |
| C-17 | BR-017 リソースコンパイル | E-01, E-02 | ○ |
| C-18 | BR-018 DLLツール | E-01, E-02 | ○ |
| C-19 | BR-019 環境情報表示 | E-01, E-02 | ○ |
| C-20 | BR-020 ターゲット一覧表示 | E-01, E-02 | ○ |
| C-21 | BR-021 バージョン表示 | E-01, E-02 | ○ |
| C-22 | BR-022 標準ライブラリドキュメント表示 | E-01, E-02 | ○ |
| C-23 | BR-023 libcパス表示 | E-01, E-02 | ○ |
| C-24 | BR-024 バグ最小化 | E-01, E-02 | △ |
| C-25 | BR-025 マルチターゲットコンパイル | E-24 | ○ |
| C-26 | BR-026 最適化モード選択 | E-24 | ○ |
| C-27 | BR-027 インクリメンタルコンパイル | E-24 | ○ |
| C-28 | BR-028 ELF形式リンク | E-14 | ○ |
| C-29 | BR-029 Mach-O形式リンク | E-15 | ○ |
| C-30 | BR-030 COFF/PE形式リンク | E-16 | ○ |
| C-31 | BR-031 WebAssemblyリンク | E-17 | ○ |
| C-32 | BR-032 SPIR-V生成 | E-18 | ○ |
| C-33 | BR-033 LLVMバックエンド | E-06, E-07 | ○ |
| C-34 | BR-034 x86_64バックエンド | E-06, E-08 | ○ |
| C-35 | BR-035 AArch64バックエンド | E-06, E-09 | ○ |
| C-36 | BR-036 RISC-Vバックエンド | E-06, E-10 | ○ |
| C-37 | BR-037 WebAssemblyバックエンド | E-06, E-11 | ○ |
| C-38 | BR-038 Cバックエンド | E-06, E-12 | ○ |
| C-39 | BR-039 SPIR-Vバックエンド | E-06, E-13 | ○ |
| C-40 | BR-040 型チェック | E-05 | ○ |
| C-41 | BR-041 コンパイル時評価 | E-05 | ○ |
| C-42 | BR-042 安全性チェック生成 | E-05 | ○ |
| C-43 | BR-043 libc統合 | E-20, E-21, E-22 | ○ |
| C-44 | BR-044 クロスプラットフォームAPI | E-23 | ○ |
| C-45 | BR-045 ビルドキャッシュ管理 | E-04 | ○ |
| C-46 | BR-046 エラーメッセージ表示 | E-04 | ○ |
| C-47 | BR-047 参照トレース表示 | E-24 | ○ |
| C-48 | BR-048 アセンブリ出力 | E-24 | ○ |
| C-49 | BR-049 LLVM IR出力 | E-24 | △ |
| C-50 | BR-050 Cヘッダ出力 | E-24 | ○ |

## 4) 不足情報（Unknown / Missing）
- **BR-024 バグ最小化（reduce）機能**：reduceコマンドの詳細な動作仕様・アルゴリズムについて、ソースコード内のドキュメントが不足している
  - 候補：reduce.zig の実装詳細 / ユーザードキュメント / テストケース
- **BR-049 LLVM IR出力**：LLVM拡張機能が必要な条件・制約についての明示的な定義が限定的
  - 候補：LLVM統合ドキュメント / build_options.zig

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大多数の業務要件（48/50）は直接的なソースコード根拠あり
- 1: 中リスク - reduce機能およびLLVM連携の一部詳細は追加調査推奨

## 6) レビュアーチェックリスト（最小）
- [ ] CLIコマンド一覧（E-01）が最新のソースコードと一致しているか確認
- [ ] 各バックエンド（E-07〜E-13）の対応状況が正確か確認
- [ ] リンカ実装（E-14〜E-18）の機能範囲が適切に記載されているか確認
- [ ] △マークの項目（BR-024, BR-049）について追加情報を収集
- [ ] 優先度（高/中/低）の設定がプロジェクトの実態と一致しているか確認
