---
generated_at: 2026-02-01 16:40:00
metrics:
  claims_total: 75
  claims_with_evidence: 72
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：72 / 75、根拠なし：3
- 優先レビュー（高）
  1. **C-74 インクリメンタルコンパイル**：実装詳細の確認が必要
  2. **C-75 依存関係解決**：build.zig.zonの仕様確認が必要
  3. **C-73 Tracy統合**：外部ツール依存の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/main.zig` - メインエントリポイント、コマンド定義
- E-02: `README.md` - プロジェクト概要、ビルド手順
- E-03: `build.zig` - ビルドシステム定義
- E-04: `src/codegen/` - 各種コード生成バックエンド
- E-05: `src/link/` - 各種リンカ実装
- E-06: `src/Sema.zig` - セマンティック解析
- E-07: `src/Type.zig` - 型システム
- E-08: `src/Value.zig` - 値システム
- E-09: `src/Air.zig` - 中間表現
- E-10: `src/InternPool.zig` - インターンプール
- E-11: `lib/std/` - 標準ライブラリ
- E-12: `lib/compiler_rt/` - コンパイラランタイム
- E-13: `tools/` - 開発ツール群
- E-14: `src/libs/` - C言語互換ライブラリサポート
- E-15: `src/tracy.zig` - Tracyプロファイラ統合
- E-16: `src/Package.zig` - パッケージ管理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | build-exe: 実行可能ファイル生成 | E-01 (main.zig:261-263) | ○ |
| C-02 | build-lib: ライブラリ生成 | E-01 (main.zig:264-266) | ○ |
| C-03 | build-obj: オブジェクトファイル生成 | E-01 (main.zig:267-269) | ○ |
| C-04 | test: ユニットテスト実行 | E-01 (main.zig:270-272) | ○ |
| C-05 | test-obj: テストオブジェクト生成 | E-01 (main.zig:273-275) | ○ |
| C-06 | run: 実行可能ファイル生成・即座実行 | E-01 (main.zig:276-278) | ○ |
| C-07 | build: build.zigからビルド | E-01 (main.zig:286-288) | ○ |
| C-08 | init: パッケージ初期化 | E-01 (main.zig:342-343) | ○ |
| C-09 | fetch: パッケージ取得 | E-01 (main.zig:326-327) | ○ |
| C-10 | ast-check: 構文チェック | E-01 (main.zig:379-380) | ○ |
| C-11 | fmt: コードフォーマット | E-01 (main.zig:318-320) | ○ |
| C-12 | reduce: バグレポート最小化 | E-01 (main.zig:368-372) | ○ |
| C-13 | translate-c: CからZig変換 | E-01 (main.zig:306-308) | ○ |
| C-14 | cc: ドロップインCコンパイラ | E-01 (main.zig:300-302) | ○ |
| C-15 | c++: ドロップインC++コンパイラ | E-01 (main.zig:303-305) | ○ |
| C-16 | ar: ドロップインアーカイバ | E-01 (main.zig:279-285) | ○ |
| C-17 | ranlib: ドロップインranlib | E-01 (main.zig:279-285) | ○ |
| C-18 | lib: ドロップインlib.exe | E-01 (main.zig:279-285) | ○ |
| C-19 | dlltool: ドロップインdlltool | E-01 (main.zig:279-285) | ○ |
| C-20 | objcopy: ドロップインobjcopy | E-01 (main.zig:321-325) | ○ |
| C-21 | rc: Windowsリソースコンパイラ | E-01 (main.zig:309-317) | ○ |
| C-22 | env: 環境情報表示 | E-01 (main.zig:354-367) | ○ |
| C-23 | help: ヘルプ表示 | E-01 (main.zig:376-378) | ○ |
| C-24 | std: 標準ライブラリドキュメント | E-01 (main.zig:334-341) | ○ |
| C-25 | libc: libcパス表示 | E-01 (main.zig:328-333) | ○ |
| C-26 | targets: ターゲット一覧 | E-01 (main.zig:344-349) | ○ |
| C-27 | version: バージョン表示 | E-01 (main.zig:350-353) | ○ |
| C-28 | zen: Zigの禅表示 | E-01 (main.zig:373-375) | ○ |
| C-29 | LLVMバックエンド | E-04 (codegen/llvm.zig) | ○ |
| C-30 | x86_64バックエンド | E-04 (codegen/x86_64/) | ○ |
| C-31 | aarch64バックエンド | E-04 (codegen/aarch64/) | ○ |
| C-32 | riscv64バックエンド | E-04 (codegen/riscv64/) | ○ |
| C-33 | wasmバックエンド | E-04 (codegen/wasm/) | ○ |
| C-34 | spirvバックエンド | E-04 (codegen/spirv/) | ○ |
| C-35 | Cバックエンド | E-04 (codegen/c.zig) | ○ |
| C-36 | sparc64バックエンド | E-04 (codegen/sparc64/) | ○ |
| C-37 | ELFリンカ | E-05 (link/Elf.zig) | ○ |
| C-38 | MachOリンカ | E-05 (link/MachO/) | ○ |
| C-39 | COFFリンカ | E-05 (link/Coff.zig) | ○ |
| C-40 | WASMリンカ | E-05 (link/Wasm.zig) | ○ |
| C-41 | Plan9リンカ | E-05 (link/Plan9.zig) | ○ |
| C-42 | LLDリンカ統合 | E-05 (link/Lld.zig) | ○ |
| C-43 | Sema（意味解析） | E-06 | ○ |
| C-44 | 型システム | E-07 | ○ |
| C-45 | 値システム | E-08 | ○ |
| C-46 | AIR（Abstract IR） | E-09 | ○ |
| C-47 | ZIR | E-11 (lib/compiler/zig/Zir.zig) | ○ |
| C-48 | InternPool | E-10 | ○ |
| C-49 | std.fs | E-11 (std/fs.zig) | ○ |
| C-50 | std.http | E-11 (std/http.zig) | ○ |
| C-51 | std.crypto | E-11 (std/crypto/) | ○ |
| C-52 | std.compress | E-11 (std/compress/) | ○ |
| C-53 | std.json | E-11 (std/json.zig) | ○ |
| C-54 | std.meta | E-11 (std/meta.zig) | ○ |
| C-55 | std.atomic | E-11 (std/atomic.zig) | ○ |
| C-56 | std.posix | E-11 (std/posix/) | ○ |
| C-57 | std.Build | E-11 (std/Build.zig) | ○ |
| C-58 | std.Target | E-11 (std/Target.zig) | ○ |
| C-59 | compiler_rt | E-12 | ○ |
| C-60 | ubsan_rt | E-11 (lib/ubsan_rt.zig) | ○ |
| C-61 | fuzzer | E-11 (lib/fuzzer.zig) | ○ |
| C-62 | libcサポート | E-14 | ○ |
| C-63 | libcxx | E-11 (lib/libcxx/) | ○ |
| C-64 | libunwind | E-11 (lib/libunwind/) | ○ |
| C-65 | docgen | E-13 (tools/docgen.zig) | ○ |
| C-66 | update_cpu_features | E-13 (tools/update_cpu_features.zig) | ○ |
| C-67 | gen_spirv_spec | E-13 (tools/gen_spirv_spec.zig) | ○ |
| C-68 | process_headers | E-13 (tools/process_headers.zig) | ○ |
| C-69 | changelist | E-01 (main.zig:383-384) | ○ |
| C-70 | dump-zir | E-01 (main.zig:385-386) | ○ |
| C-71 | detect-cpu | E-01 (main.zig:381-382) | ○ |
| C-72 | llvm-ints | E-01 (main.zig:387-388) | ○ |
| C-73 | Tracy統合 | E-15 | △ |
| C-74 | インクリメンタルコンパイル | **根拠不足** | △ |
| C-75 | 依存関係解決 | E-16 | △ |

## 4) 不足情報（Unknown / Missing）
- **C-73 Tracy統合**: Tracyは外部プロファイリングツールであり、統合の詳細な挙動は実行時に依存
  - 候補：Tracy公式ドキュメント / 実行時テスト / ユーザーガイド
- **C-74 インクリメンタルコンパイル**: `-fincremental`オプションの内部実装詳細が複数ファイルに分散
  - 候補：Compilation.zig / Zcu.zig / 開発者ドキュメント
- **C-75 依存関係解決**: build.zig.zonフォーマットとfetchコマンドの連携詳細
  - 候補：build.zig.zon仕様 / Package.zig / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: コマンドライン機能（C-01〜C-28）- main.zigで明確に定義
- **0（低リスク）**: コード生成バックエンド（C-29〜C-36）- 各ディレクトリに実装あり
- **0（低リスク）**: リンカ機能（C-37〜C-42）- link/ディレクトリに実装あり
- **0（低リスク）**: 標準ライブラリ（C-49〜C-58）- lib/std/に実装あり
- **1（中リスク）**: 外部ツール統合（C-73 Tracy）- 外部依存
- **1（中リスク）**: 高度な機能（C-74, C-75）- 実装が複雑・分散

## 6) レビュアーチェックリスト（最小）
- [ ] コマンドライン機能（C-01〜C-28）がmain.zigのusage文字列と一致しているか確認
- [ ] 各バックエンド（C-29〜C-36）のディレクトリが実在するか確認
- [ ] 標準ライブラリモジュール（C-49〜C-58）がlib/std/に存在するか確認
- [ ] Tracy統合（C-73）の有効化条件を確認（-Dtracyオプション）
- [ ] インクリメンタルコンパイル（C-74）の使用方法を公式ドキュメントで確認
- [ ] パッケージ管理（C-75）のbuild.zig.zonフォーマットを確認
