# 機能設計書 1-build-exe

## 概要

本ドキュメントは、Zigコンパイラの`build-exe`コマンドの機能設計について記述する。このコマンドはZigソースコードまたはオブジェクトファイルから実行可能ファイルを生成する中核的なコンパイル機能である。

### 本機能の処理概要

`zig build-exe`コマンドは、Zigソースコード（.zig）、Cソースコード（.c, .cpp等）、オブジェクトファイル（.o, .obj）、静的ライブラリ（.a, .lib）などの入力ファイルから、ターゲットプラットフォーム向けの実行可能バイナリを生成する。

**業務上の目的・背景**：Zigプログラミング言語でアプリケーションを開発する際、最終的な成果物として実行可能ファイルを生成する必要がある。`build-exe`はその中核となる機能であり、単一のコマンドでコンパイル、最適化、リンクまでの全工程を一括して処理する。クロスコンパイルにも対応しており、開発マシンとは異なるターゲット（Linux、Windows、macOS、組み込み等）向けのバイナリを生成できる。

**機能の利用シーン**：
- 単一のZigソースファイルから実行可能ファイルを生成する場合
- 複数のモジュールやC言語ライブラリを含む複合的なプロジェクトをビルドする場合
- クロスコンパイルにより他プラットフォーム向けバイナリを生成する場合
- デバッグビルドやリリースビルドなど最適化レベルを切り替えてビルドする場合

**主要な処理内容**：
1. コマンドライン引数の解析とオプション設定
2. ターゲットプラットフォームの解決とコンフィグ生成
3. Zigソースコードの構文解析とZIR（Zig中間表現）生成
4. セマンティック解析（Sema）による型チェックと意味解析
5. AIR（Abstract IR）への変換
6. バックエンド（LLVM、ネイティブ等）によるコード生成
7. リンカによる実行可能ファイルの生成

**関連システム・外部連携**：
- LLVM：最適化とコード生成に使用（オプション）
- システムリンカまたはLLD：オブジェクトファイルのリンク
- libc：C言語標準ライブラリとのリンク（必要に応じて）

**権限による制御**：特になし。ファイルシステムへの読み書き権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | 実行ファイルビルド画面 | 主機能 | Zigソースコードから実行可能ファイルを生成する処理 |

## 機能種別

コンパイル処理 / コード生成 / リンク処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| files | []const u8 | Yes | ソースファイルまたはオブジェクトファイルのパス | 有効なファイルパスであること |
| -target | []const u8 | No | ターゲットアーキテクチャ（例：x86_64-linux-gnu） | サポートされているターゲットであること |
| -O | OptimizeMode | No | 最適化モード（Debug/ReleaseFast/ReleaseSafe/ReleaseSmall） | 有効な最適化モードであること |
| --name | []const u8 | No | 出力ファイル名 | 有効なファイル名であること |
| -femit-bin | EmitOption | No | バイナリ出力の制御 | - |
| -fincremental | bool | No | インクリメンタルコンパイルの有効化 | - |
| -fllvm | bool | No | LLVMバックエンドの使用を強制 | - |
| -flld | bool | No | LLDリンカの使用を強制 | - |
| --libc | []const u8 | No | libcパスファイルの指定 | 有効なファイルパスであること |
| -l | []const u8 | No | リンクするライブラリ名 | - |
| -L | []const u8 | No | ライブラリ検索パス | 有効なディレクトリパスであること |

### 入力データソース

- コマンドライン引数
- Zigソースファイル（.zig）
- Cソースファイル（.c, .cpp, .m, .mm等）
- オブジェクトファイル（.o, .obj）
- 静的ライブラリ（.a, .lib）
- 動的ライブラリ（.so, .dll, .dylib）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 実行可能ファイル | バイナリ | ターゲットプラットフォーム向けの実行可能バイナリ |
| アセンブリ出力 | テキスト | -femit-asm指定時のアセンブリコード |
| LLVM IR | テキスト | -femit-llvm-ir指定時のLLVM中間表現 |
| デバッグ情報 | バイナリ | -fstrip未指定時のデバッグシンボル |

### 出力先

- ファイルシステム（現在のディレクトリまたは指定されたパス）
- デフォルト出力名はソースファイル名から拡張子を除いたもの

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ buildOutputType関数でArgModeに基づきオプションを解析
2. ターゲット解決
   └─ target_arch_os_abi文字列からTarget構造体を構築
3. モジュール作成
   └─ Package.Module.create()でルートモジュールを作成
4. Compilation作成
   └─ Compilation.create()でコンパイルコンテキストを初期化
5. ソースファイル処理
   └─ 各ソースファイルに対してコンパイルジョブを生成
6. セマンティック解析
   └─ Sema.zigで型チェックと意味解析を実行
7. コード生成
   └─ 選択されたバックエンド（LLVM/ネイティブ）でマシンコード生成
8. リンク処理
   └─ ELF/MachO/COFF形式に応じたリンカで実行ファイル生成
9. 結果出力
   └─ 生成されたバイナリをファイルシステムに書き出し
```

### フローチャート

```mermaid
flowchart TD
    A[zig build-exe 開始] --> B[コマンドライン引数解析]
    B --> C{ターゲット指定あり?}
    C -->|Yes| D[指定ターゲット解決]
    C -->|No| E[ネイティブターゲット検出]
    D --> F[Compilation作成]
    E --> F
    F --> G[ソースファイル処理]
    G --> H{Zigソース?}
    H -->|Yes| I[ZIR生成 + Sema]
    H -->|No| J{Cソース?}
    J -->|Yes| K[Clang呼び出し]
    J -->|No| L[オブジェクトとして追加]
    I --> M[AIR生成]
    K --> L
    M --> N{LLVMバックエンド?}
    N -->|Yes| O[LLVM IR生成]
    N -->|No| P[ネイティブコード生成]
    O --> Q[LLVM最適化]
    Q --> R[オブジェクト生成]
    P --> R
    L --> S[リンク処理]
    R --> S
    S --> T{成功?}
    T -->|Yes| U[実行ファイル出力]
    T -->|No| V[エラー報告]
    U --> W[終了]
    V --> W
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | デフォルト最適化モード | 最適化モード未指定時はDebugモードを使用 | -O オプション未指定時 |
| BR-02 | デフォルト出力形式 | ターゲットOSに応じた適切なオブジェクト形式を自動選択 | -ofmt未指定時 |
| BR-03 | LLVM自動選択 | ネイティブバックエンドが未対応の場合はLLVMを使用 | ターゲットアーキテクチャによる |
| BR-04 | リンカ自動選択 | ターゲットとオプションに基づいてシステムリンカまたはLLDを選択 | リンカ未指定時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベースは使用しない |

### テーブル別操作詳細

データベースは使用しない。キャッシュはファイルシステムベースで管理される。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | FileNotFound | 指定されたソースファイルが存在しない | ファイルパスを確認 |
| - | CompileError | Zigソースコードに構文エラーまたは型エラー | エラーメッセージに従いコードを修正 |
| - | LinkError | リンク時にシンボル未解決などのエラー | 必要なライブラリを追加 |
| - | OutOfMemory | コンパイル時のメモリ不足 | メモリを増やすか最適化レベルを下げる |

### リトライ仕様

- コンパイルエラーは自動リトライなし
- ファイルシステムの一時的なエラーについてはリトライする場合あり

## トランザクション仕様

- アトミックなファイル書き込み：出力ファイルは一時ファイルに書き込んだ後、リネームで置換
- キャッシュシステム：中間生成物はキャッシュディレクトリに保存され、再利用される

## パフォーマンス要件

- インクリメンタルコンパイル（-fincremental）により変更部分のみ再コンパイル
- 並列コンパイル（-jN）によるマルチスレッド処理
- キャッシュヒット時は即座に結果を返却

## セキュリティ考慮事項

- 入力ファイルのパス検証
- 出力先ディレクトリへの書き込み権限チェック
- サンドボックス環境での実行をサポート

## 備考

- LLVMバックエンドはオプションであり、Zigネイティブバックエンドのみでもコンパイル可能
- クロスコンパイルはZigの主要な特徴の一つであり、追加設定なしで利用可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、コンパイルに関連する主要なデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Compilation.zig | `src/Compilation.zig` | Compilationの状態管理、CreateOptionsの構造 |
| 1-2 | Package.zig | `src/Package.zig` | Moduleの構造、依存関係管理 |

**読解のコツ**: `Compilation`構造体はコンパイラの中心的な状態を保持する。`zcu`（Zig Compilation Unit）フィールドがnullでないときにZigコードのコンパイルが行われる。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | main.zig | `src/main.zig` | mainArgs関数からbuildOutputTypeへの分岐 |

**主要処理フロー**:
1. **261-263行目**: `mem.eql(u8, cmd, "build-exe")`でコマンドを判定し、`buildOutputType`を呼び出す
2. **809-816行目**: `buildOutputType`関数のシグネチャとパラメータ
3. **1019-1036行目**: arg_modeに応じたoutput_modeの設定（.build => .Exe）

#### Step 3: コマンドライン引数解析

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.zig | `src/main.zig` | ArgsIteratorによる引数の逐次処理 |

**主要処理フロー**:
- **1040-1043行目**: ArgsIteratorの初期化
- **1045行目以降**: args_loopでの各引数の解析

#### Step 4: Compilation作成処理

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Compilation.zig | `src/Compilation.zig` | create関数の実装 |

**主要処理フロー**:
- **1925行目**: `pub fn create`の開始
- **1926-1935行目**: output_modeとis_exe_or_dyn_libの判定
- **1969-1984行目**: libcディレクトリの検出

#### Step 5: コード生成とリンク

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | codegen/llvm.zig | `src/codegen/llvm.zig` | LLVMバックエンドの実装 |
| 5-2 | link/Elf.zig | `src/link/Elf.zig` | ELFリンカの実装 |
| 5-3 | link/MachO.zig | `src/link/MachO.zig` | Mach-Oリンカの実装 |
| 5-4 | link/Coff.zig | `src/link/Coff.zig` | COFFリンカの実装 |

### プログラム呼び出し階層図

```
main (src/main.zig)
    │
    ├─ mainArgs
    │      └─ buildOutputType (build-exeコマンド処理)
    │              │
    │              ├─ ArgsIterator (引数解析)
    │              │
    │              ├─ Compilation.create (src/Compilation.zig)
    │              │      ├─ Config解決
    │              │      ├─ Module作成
    │              │      └─ リンカ初期化
    │              │
    │              └─ Compilation.update
    │                     ├─ Sema (src/Sema.zig) - セマンティック解析
    │                     ├─ codegen (src/codegen/) - コード生成
    │                     │      └─ llvm.zig / x86_64/ 等
    │                     └─ link (src/link/) - リンク処理
    │                            └─ Elf.zig / MachO.zig / Coff.zig
```

### データフロー図

```
[入力]                     [処理]                           [出力]

.zig ソースファイル ──┐
                      ├──▶ AST解析 ──▶ ZIR生成 ──┐
.c ソースファイル ───┤                           │
                      ├──▶ Clang処理 ──▶ .o ────┤
.o オブジェクト ─────┤                           ├──▶ リンカ ──▶ 実行可能ファイル
                      ├────────────────────────┤
.a 静的ライブラリ ────┤                           │
                      │                           │
コマンドライン引数 ───┴──▶ 設定解析 ──▶ Config ──┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| main.zig | `src/main.zig` | ソース | エントリーポイント、コマンド分岐 |
| Compilation.zig | `src/Compilation.zig` | ソース | コンパイル処理の中核、状態管理 |
| Sema.zig | `src/Sema.zig` | ソース | セマンティック解析 |
| Type.zig | `src/Type.zig` | ソース | 型システム |
| Value.zig | `src/Value.zig` | ソース | コンパイル時の値管理 |
| Air.zig | `src/Air.zig` | ソース | Abstract IR（中間表現） |
| codegen.zig | `src/codegen.zig` | ソース | コード生成ディスパッチャ |
| llvm.zig | `src/codegen/llvm.zig` | ソース | LLVMバックエンド |
| link.zig | `src/link.zig` | ソース | リンカディスパッチャ |
| Elf.zig | `src/link/Elf.zig` | ソース | ELFリンカ |
| MachO.zig | `src/link/MachO.zig` | ソース | Mach-Oリンカ |
| Coff.zig | `src/link/Coff.zig` | ソース | COFFリンカ |
| Package.zig | `src/Package.zig` | ソース | パッケージ・モジュール管理 |
